/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.jsc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.tools.ToolErrorReporter;

public class Main {
    private static boolean hasOutOption = false;
    private static ToolErrorReporter reporter;

    public static void main(String[] stringArray) {
        Context context = Context.enter();
        reporter = new ToolErrorReporter(true);
        context.setErrorReporter(reporter);
        stringArray = Main.processOptions(context, stringArray);
        if (!reporter.hasReportedError()) {
            Main.processSource(context, stringArray);
        }
        Context.exit();
    }

    public static String[] processOptions(Context context, String[] stringArray) {
        context.setTargetPackage("");
        context.setGeneratingDebug(false);
        int n = 0;
        while (n < stringArray.length) {
            block32: {
                String string;
                block33: {
                    string = stringArray[n];
                    if (!string.startsWith("-")) {
                        String[] stringArray2 = new String[stringArray.length - n];
                        int n2 = n;
                        while (n2 < stringArray.length) {
                            stringArray2[n2 - n] = stringArray[n2];
                            ++n2;
                        }
                        return stringArray2;
                    }
                    try {
                        if (string.equals("-version") && ++n < stringArray.length) {
                            int n3 = Integer.parseInt(stringArray[n]);
                            context.setLanguageVersion(n3);
                            break block32;
                        }
                        if ((string.equals("-opt") || string.equals("-O")) && ++n < stringArray.length) {
                            int n4 = Integer.parseInt(stringArray[n]);
                            context.setOptimizationLevel(n4);
                        }
                        break block33;
                    }
                    catch (NumberFormatException numberFormatException) {
                        Context.reportError(ToolErrorReporter.getMessage("msg.jsc.usage", stringArray[n]));
                    }
                    break block32;
                }
                if (string.equals("-nosource")) {
                    context.setGeneratingSource(false);
                } else if (string.equals("-debug") || string.equals("-g")) {
                    context.setGeneratingDebug(true);
                } else if (string.equals("-o") && ++n < stringArray.length) {
                    String string2 = stringArray[n];
                    if (!Character.isJavaIdentifierStart(string2.charAt(0))) {
                        Context.reportError(ToolErrorReporter.getMessage("msg.invalid.classfile.name", string2));
                    } else {
                        int n5 = 1;
                        while (n5 < string2.length()) {
                            if (!Character.isJavaIdentifierPart(string2.charAt(n5)) && string2.charAt(n5) != '.' || string2.charAt(n5) == '.' && (!string2.endsWith(".class") || n5 != string2.length() - 6)) {
                                Context.reportError(ToolErrorReporter.getMessage("msg.invalid.classfile.name", string2));
                                break;
                            }
                            ++n5;
                        }
                        context.setTargetClassFileName(string2);
                        hasOutOption = true;
                    }
                } else if (string.equals("-package") && ++n < stringArray.length) {
                    String string3 = stringArray[n];
                    int n6 = 0;
                    while (n6 < string3.length()) {
                        if (!Character.isJavaIdentifierStart(string3.charAt(n6))) {
                            Context.reportError(ToolErrorReporter.getMessage("msg.package.name", string3));
                        } else {
                            int n7 = ++n6;
                            while (n7 < string3.length()) {
                                if (!(string3.charAt(n7) == '.' && string3.charAt(n7 - 1) != '.' && n7 != string3.length() - 1 || Character.isJavaIdentifierPart(string3.charAt(n7)))) {
                                    Context.reportError(ToolErrorReporter.getMessage("msg.package.name", string3));
                                }
                                ++n7;
                                ++n6;
                            }
                        }
                        ++n6;
                    }
                    context.setTargetPackage(string3);
                } else if (string.equals("-extends") && ++n < stringArray.length) {
                    String string4 = stringArray[n];
                    try {
                        context.setTargetExtends(Class.forName(string4));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new Error(classNotFoundException.toString());
                    }
                } else if (string.equals("-implements") && ++n < stringArray.length) {
                    String string5 = stringArray[n];
                    try {
                        Class[] classArray = new Class[]{Class.forName(string5)};
                        context.setTargetImplements(classArray);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new Error(classNotFoundException.toString());
                    }
                } else {
                    Main.usage(string);
                }
            }
            ++n;
        }
        Main.p(ToolErrorReporter.getMessage("msg.no.file"));
        System.exit(1);
        return null;
    }

    public static void usage(String string) {
        Main.p(ToolErrorReporter.getMessage("msg.jsc.usage", string));
        System.exit(1);
    }

    public static void processSource(Context context, String[] stringArray) {
        if (hasOutOption && stringArray.length > 1) {
            Context.reportError(ToolErrorReporter.getMessage("msg.multiple.js.to.file", context.getTargetClassFileName()));
        }
        int n = 0;
        while (n < stringArray.length) {
            Object object;
            String string = stringArray[n];
            File file = new File(string);
            if (!file.exists()) {
                Context.reportError(ToolErrorReporter.getMessage("msg.jsfile.not.found", string));
                return;
            }
            if (!string.endsWith(".js")) {
                Context.reportError(ToolErrorReporter.getMessage("msg.extension.not.js", string));
                return;
            }
            if (!hasOutOption) {
                object = file.getName();
                String string2 = ((String)object).substring(0, ((String)object).length() - 3);
                String string3 = Main.getClassName(string2) + ".class";
                String string4 = file.getParent() == null ? string3 : file.getParent() + File.separator + string3;
                context.setTargetClassFileName(string4);
            }
            if (context.getTargetClassFileName() == null) {
                Context.reportError(ToolErrorReporter.getMessage("msg.no-opt"));
            }
            try {
                object = new FileReader(string);
                context.compileReader(null, (Reader)object, string, 1, null);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Context.reportError(ToolErrorReporter.getMessage("msg.couldnt.open", string));
                return;
            }
            catch (IOException iOException) {
                Context.reportError(iOException.toString());
            }
            ++n;
        }
    }

    static String getClassName(String string) {
        char[] cArray = new char[string.length() + 1];
        int n = 0;
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            cArray[n++] = 95;
        }
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.charAt(n2);
            cArray[n] = Character.isJavaIdentifierPart((char)n3) ? n3 : 95;
            ++n2;
            ++n;
        }
        return new String(cArray).trim();
    }

    private static void p(String string) {
        System.out.println(string);
    }
}

