/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaMethod
extends NativeFunction
implements Function {
    static final int PREFERENCE_EQUAL = 0;
    static final int PREFERENCE_FIRST_ARG = 1;
    static final int PREFERENCE_SECOND_ARG = 2;
    static final int PREFERENCE_AMBIGUOUS = 3;
    private static final boolean debug = false;
    Method[] methods;
    private static final Method method_setAccessible = NativeJavaMethod.getMethod(class$java$lang$reflect$Method == null ? (class$java$lang$reflect$Method = NativeJavaMethod.class$("java.lang.reflect.Method")) : class$java$lang$reflect$Method, "setAccessible", new Class[]{Boolean.TYPE});
    static /* synthetic */ Class class$java$lang$reflect$Method;

    public NativeJavaMethod() {
        this.functionName = null;
    }

    public NativeJavaMethod(Method[] methodArray) {
        this.methods = methodArray;
        this.functionName = methodArray[0].getName();
    }

    public NativeJavaMethod(Method method, String string) {
        this.methods = new Method[1];
        this.methods[0] = method;
        this.functionName = string;
    }

    public void add(Method method) {
        if (this.functionName == null) {
            this.functionName = method.getName();
        } else if (!this.functionName.equals(method.getName())) {
            throw new RuntimeException("internal method name mismatch");
        }
        int n = this.methods == null ? 0 : this.methods.length;
        Method[] methodArray = new Method[n + 1];
        int n2 = 0;
        while (n2 < n) {
            methodArray[n2] = this.methods[n2];
            ++n2;
        }
        methodArray[n] = method;
        this.methods = methodArray;
    }

    static String scriptSignature(Object object) {
        if (object == null) {
            return "null";
        }
        Class<?> clazz = object.getClass();
        if (clazz == ScriptRuntime.UndefinedClass) {
            return "undefined";
        }
        if (clazz == ScriptRuntime.BooleanClass) {
            return "boolean";
        }
        if (clazz == ScriptRuntime.StringClass) {
            return "string";
        }
        if (ScriptRuntime.NumberClass.isAssignableFrom(clazz)) {
            return "number";
        }
        if (object instanceof Wrapper) {
            return ((Wrapper)object).unwrap().getClass().getName();
        }
        if (object instanceof Scriptable) {
            if (object instanceof Function) {
                return "function";
            }
            return "object";
        }
        return NativeJavaMethod.javaSignature(clazz);
    }

    static String scriptSignature(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < objectArray.length) {
            if (n != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(NativeJavaMethod.scriptSignature(objectArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    static String javaSignature(Class clazz) {
        if (clazz == null) {
            return "null";
        }
        if (clazz.isArray()) {
            return NativeJavaMethod.javaSignature(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    static String javaSignature(Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < classArray.length) {
            if (n != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(NativeJavaMethod.javaSignature(classArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    static String signature(Member member) {
        if (member instanceof Method) {
            Class[] classArray = ((Method)member).getParameterTypes();
            return member.getName() + "(" + NativeJavaMethod.javaSignature(classArray) + ")";
        }
        Class[] classArray = ((Constructor)member).getParameterTypes();
        return "(" + NativeJavaMethod.javaSignature(classArray) + ")";
    }

    public String decompile(Context context, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl) {
            stringBuffer.append("function ");
            stringBuffer.append(this.getFunctionName());
            stringBuffer.append("() {");
        }
        stringBuffer.append("/*\n");
        this.toString(stringBuffer);
        stringBuffer.append(bl ? "*/\n" : "*/}\n");
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer);
        return stringBuffer.toString();
    }

    private void toString(StringBuffer stringBuffer) {
        int n = 0;
        while (n < this.methods.length) {
            stringBuffer.append(NativeJavaMethod.javaSignature(this.methods[n].getReturnType()));
            stringBuffer.append(' ');
            stringBuffer.append(NativeJavaMethod.signature(this.methods[n]));
            stringBuffer.append('\n');
            ++n;
        }
    }

    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        Object object;
        Object object2;
        if (this.methods.length == 0) {
            throw new RuntimeException("No methods defined for call");
        }
        Method method = (Method)NativeJavaMethod.findFunction(this.methods, objectArray);
        if (method == null) {
            Class<?> clazz = this.methods[0].getDeclaringClass();
            String string = clazz.getName() + "." + this.functionName + "(" + NativeJavaMethod.scriptSignature(objectArray) + ")";
            throw Context.reportRuntimeError1("msg.java.no_such_method", string);
        }
        Class<?>[] classArray = method.getParameterTypes();
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = NativeJavaObject.coerceType(classArray[n], objectArray[n]);
            ++n;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            object2 = null;
        } else {
            object = scriptable2;
            while (!(object instanceof Wrapper)) {
                if ((object = object.getPrototype()) != null) continue;
                throw Context.reportRuntimeError1("msg.nonjava.method", this.functionName);
            }
            object2 = ((Wrapper)object).unwrap();
        }
        try {
            try {
                object = method.invoke(object2, objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                object = NativeJavaMethod.retryIllegalAccessInvoke(method, object2, objectArray, illegalAccessException);
            }
            Class<?> clazz = method.getReturnType();
            Object object3 = NativeJavaObject.wrap(scriptable, object, clazz);
            if (object3 == Undefined.instance) {
                return object3;
            }
            if (object3 == null && clazz == Void.TYPE) {
                return Undefined.instance;
            }
            return object3;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Context.reportRuntimeError("While attempting to call \"" + method.getName() + "\" in class \"" + method.getDeclaringClass().getName() + "\" receieved " + illegalAccessException.toString());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw JavaScriptException.wrapException(scriptable, invocationTargetException);
        }
    }

    static Object retryIllegalAccessInvoke(Method method, Object object, Object[] objectArray, IllegalAccessException illegalAccessException) throws IllegalAccessException, InvocationTargetException {
        Object[] objectArray2;
        if (Modifier.isPublic(method.getModifiers())) {
            objectArray2 = method.getName();
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> clazz = method.getDeclaringClass();
            Class<?>[] classArray2 = clazz.getInterfaces();
            int n = 0;
            while (n < classArray2.length) {
                clazz = classArray2[n];
                try {
                    Method method2 = clazz.getMethod((String)objectArray2, classArray);
                    return method2.invoke(object, objectArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalAccessException illegalAccessException2) {
                    // empty catch block
                }
                ++n;
            }
        }
        if (method_setAccessible != null) {
            objectArray2 = new Object[]{Boolean.TRUE};
            try {
                method_setAccessible.invoke((Object)method, objectArray2);
            }
            catch (IllegalAccessException illegalAccessException3) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            return method.invoke(object, objectArray);
        }
        throw illegalAccessException;
    }

    static Member findFunction(Member[] memberArray, Object[] objectArray) {
        int n;
        Class[] classArray;
        if (memberArray.length == 0) {
            return null;
        }
        boolean bl = memberArray[0] instanceof Method;
        Class[] classArray2 = null;
        Class[] classArray3 = null;
        Vector<Class[]> vector = null;
        int n2 = 0;
        while (n2 < memberArray.length) {
            Class[] classArray4 = memberArray[n2];
            Class<?>[] classArray5 = classArray = bl ? ((Method)classArray4).getParameterTypes() : ((Constructor)classArray4).getParameterTypes();
            if (classArray.length == objectArray.length) {
                int n3;
                if (classArray3 == null) {
                    n3 = 0;
                    while (n3 < classArray.length) {
                        if (!NativeJavaObject.canConvert(objectArray[n3], classArray[n3])) break;
                        ++n3;
                    }
                    if (n3 == classArray.length) {
                        classArray2 = classArray4;
                        classArray3 = classArray;
                    }
                } else {
                    n3 = NativeJavaMethod.preferSignature(objectArray, classArray, classArray3);
                    if (n3 == 3) {
                        if (vector == null) {
                            vector = new Vector<Class[]>();
                        }
                        vector.addElement(classArray4);
                    } else if (n3 == 1) {
                        classArray2 = classArray4;
                        classArray3 = classArray;
                    } else if (n3 == 0 && Modifier.isStatic(classArray2.getModifiers()) && classArray2.getDeclaringClass().isAssignableFrom(classArray4.getDeclaringClass())) {
                        classArray2 = classArray4;
                        classArray3 = classArray;
                    }
                }
            }
            ++n2;
        }
        if (vector == null) {
            return classArray2;
        }
        int n4 = vector.size() - 1;
        while (n4 >= 0) {
            classArray = (Member)vector.elementAt(n4);
            Class[] classArray6 = bl ? ((Method)classArray).getParameterTypes() : ((Constructor)classArray).getParameterTypes();
            n = NativeJavaMethod.preferSignature(objectArray, classArray6, classArray3);
            if (n == 1) {
                classArray2 = classArray;
                classArray3 = classArray6;
                vector.removeElementAt(n4);
            } else if (n == 2) {
                vector.removeElementAt(n4);
            }
            --n4;
        }
        if (vector.size() > 0) {
            Object[] objectArray2;
            Object object;
            classArray = new StringBuffer();
            boolean bl2 = classArray2 instanceof Constructor;
            vector.addElement(classArray2);
            n = 0;
            while (n < vector.size()) {
                if (n != 0) {
                    classArray.append(", ");
                }
                object = (Member)vector.elementAt(n);
                if (!bl2) {
                    objectArray2 = ((Method)object).getReturnType();
                    classArray.append(objectArray2);
                    classArray.append(' ');
                }
                classArray.append(NativeJavaMethod.signature((Member)object));
                ++n;
            }
            if (bl2) {
                objectArray2 = new Object[]{classArray2.getName(), NativeJavaMethod.scriptSignature(objectArray), classArray.toString()};
                object = Context.getMessage("msg.constructor.ambiguous", objectArray2);
            } else {
                objectArray2 = new Object[]{classArray2.getDeclaringClass().getName(), classArray2.getName(), NativeJavaMethod.scriptSignature(objectArray), classArray.toString()};
                object = Context.getMessage("msg.method.ambiguous", objectArray2);
            }
            throw Context.reportRuntimeError((String)object);
        }
        return classArray2;
    }

    public static int preferSignature(Object[] objectArray, Class[] classArray, Class[] classArray2) {
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            Class clazz = classArray[n2];
            Class clazz2 = classArray2[n2];
            if (clazz != clazz2 && (n |= NativeJavaMethod.preferConversion(objectArray[n2], clazz, clazz2)) == 3) break;
            ++n2;
        }
        return n;
    }

    public static int preferConversion(Object object, Class clazz, Class clazz2) {
        int n = NativeJavaObject.getConversionWeight(object, clazz);
        int n2 = NativeJavaObject.getConversionWeight(object, clazz2);
        if (n == 0 && n2 == 0) {
            if (clazz.isAssignableFrom(clazz2)) {
                return 2;
            }
            if (clazz2.isAssignableFrom(clazz)) {
                return 1;
            }
        } else {
            if (n < n2) {
                return 1;
            }
            if (n > n2) {
                return 2;
            }
        }
        return 3;
    }

    Method[] getMethods() {
        return this.methods;
    }

    private static Method getMethod(Class clazz, String string, Class[] classArray) {
        try {
            return clazz.getMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    private static void printDebug(String string, Member member, Object[] objectArray) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

