/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2000
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Sylvain Pasche <sylvain.pasche@gmail.com>
 *   L. David Baron <dbaron@dbaron.org>, Mozilla Corporation
 *   Chris Lord <chris@linux.intel.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "nsScreenManagerHeadless.h"
#include "nsScreenHeadless.h"
#include "nsIComponentManager.h"
#include "nsRect.h"
#include "nsAutoPtr.h"
#include "moz-drawing-area.h"

nsScreenManagerHeadless :: nsScreenManagerHeadless ()
{
  mDefaultScreen = nsnull;
}

nsScreenManagerHeadless :: ~nsScreenManagerHeadless()
{
  if (mDefaultScreen) {
    NS_RELEASE (mDefaultScreen);
    mDefaultScreen = nsnull;
  }
}


// addref, release, QI
NS_IMPL_ISUPPORTS1(nsScreenManagerHeadless, nsIScreenManager)


// this function will make sure that everything has been initialized.
nsresult
nsScreenManagerHeadless :: EnsureInit()
{
  if (mDefaultScreen)
    return NS_OK;

  return Init();
}

nsresult
nsScreenManagerHeadless :: Init()
{
    mDefaultScreen = new nsScreenHeadless ();

    if (mDefaultScreen) {
      NS_ADDREF (mDefaultScreen);
      mDefaultScreen->Init();
    }

    return NS_OK;
}


//
// ScreenForRect 
//
// Returns the screen that contains the rectangle. If the rect overlaps
// multiple screens, it picks the screen with the greatest area of intersection.
//
// The coordinates are in pixels (not twips) and in screen coordinates.
//
NS_IMETHODIMP
nsScreenManagerHeadless :: ScreenForRect ( PRInt32 aX, PRInt32 aY,
                                           PRInt32 aWidth, PRInt32 aHeight,
                                           nsIScreen **aOutScreen )
{
  nsresult rv;

  rv = EnsureInit();
  if (NS_FAILED(rv)) {
    NS_ERROR("nsScreenManagerHeadless::EnsureInit() failed from ScreenForRect\n");
    return rv;
  }

  *aOutScreen = static_cast<nsIScreen *>(mDefaultScreen);
  NS_IF_ADDREF(*aOutScreen);

  return NS_OK;
}


//
// GetPrimaryScreen
//
// The screen with the menubar/taskbar. This shouldn't be needed very
// often.
//
NS_IMETHODIMP 
nsScreenManagerHeadless :: GetPrimaryScreen(nsIScreen * *aPrimaryScreen) 
{
  nsresult rv;
  rv =  EnsureInit();
  if (NS_FAILED(rv)) {
    NS_ERROR("nsScreenManagerHeadless::EnsureInit() failed from GetPrimaryScreen\n");
    return rv;
  }

  *aPrimaryScreen = static_cast<nsIScreen *>(mDefaultScreen);
  NS_IF_ADDREF(*aPrimaryScreen);

  return NS_OK;
}


//
// GetNumberOfScreens
//
// Returns how many physical screens are available.
//
NS_IMETHODIMP
nsScreenManagerHeadless :: GetNumberOfScreens(PRUint32 *aNumberOfScreens)
{
  nsresult rv;
  rv = EnsureInit();
  if (NS_FAILED(rv)) {
    NS_ERROR("nsScreenManagerHeadless::EnsureInit() failed from GetNumberOfScreens\n");
    return rv;
  }
  *aNumberOfScreens = 1;

  return NS_OK;
}

NS_IMETHODIMP
nsScreenManagerHeadless :: ScreenForNativeWidget (void *aWidget, nsIScreen **outScreen)
{
  return GetPrimaryScreen (outScreen);
}

