/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Christopher Blizzard.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Christopher Blizzard <blizzard@mozilla.org>
 *   Chris Lord <chris@linux.intel.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef __HeadlessPrivate_h
#define __HeadlessPrivate_h

#include "nsCOMPtr.h"
#include "nsStringGlue.h"
#include "nsIWebNavigation.h"
#include "nsISHistory.h"
// for our one function that gets the HeadlessPrivate via the chrome
// object.
#include "nsIWebBrowserChrome.h"
#include "nsIAppShell.h"
#include "nsPIDOMEventTarget.h"
#include "nsVoidArray.h"
// app component registration
#include "nsIGenericFactory.h"
#include "nsIComponentRegistrar.h"

#include "moz-headless-private.h"

class HeadlessProgress;
class HeadlessHistory;
class HeadlessWindow;
class HeadlessContentListener;
class HeadlessEventListener;

class nsPIDOMWindow;
class nsIDirectoryServiceProvider;

class HeadlessPrivate {

 public:

  HeadlessPrivate();
  ~HeadlessPrivate();

  nsresult    Init            (MozHeadless *aOwningObject, PRUint32 chromeMask);
  void        Show            (void);
  void        Hide            (void);
  void        Resize          (PRUint32 aWidth, PRUint32 aHeight);
  void        Destroy         (void);
  void        SetURI          (const char *aURI);
  void        SetIcon         (const char *aURI);
  void        LoadCurrentURI  (void);
  void        Reload          (PRUint32 reloadFlags);

  void        SetChromeMask   (PRUint32 chromeMask);
  void        ApplyChromeMask ();

  static void PushStartup     (void);
  static void PopStartup      (void);
  static void SetPath         (const char *aPath);
  static void SetCompPath     (const char *aPath);
  static void AddCompPath     (const char *aPath);
  static void AddChromePath   (const char *aPath);
  static void SetProfilePath  (const char *aDir, const char *aName);
  static void SetDirectoryServiceProvider (nsIDirectoryServiceProvider * appFileLocProvider);
  static void SetDirectory    (const gchar *aKey, const gchar *aPath);

  static nsresult RegisterAppComponent(const nsModuleComponentInfo *aComponentInfo);

  nsresult OpenStream         (const char *aBaseURI, const char *aContentType);
  nsresult AppendToStream     (const PRUint8 *aData, PRUint32 aLen);
  nsresult CloseStream        (void);

  // This function will find the specific HeadlessPrivate object for a
  // given nsIWebBrowserChrome.
  static HeadlessPrivate *FindPrivateForBrowser(nsIWebBrowserChrome *aBrowser);

  // This is an upcall that will come from the progress listener
  // whenever there is a content state change.  We need this so we can
  // attach event listeners.
  void        ContentStateChange    (void);

  // This is an upcall from the progress listener when content is
  // finished loading.  We have this so that if it's chrome content
  // that we can size to content properly and show ourselves if
  // visibility is set.
  void        ContentFinishedLoading(void);

  // these are when the widget itself gets focus in and focus out
  // events
  void        ChildFocusIn (void);
  void        ChildFocusOut(void);

  MozHeadless                   *mOwningObject;

  // all of the objects that we own
  HeadlessWindow                *mWindow;
  nsCOMPtr<nsISupports>          mWindowGuard;
  HeadlessProgress              *mProgress;
  nsCOMPtr<nsISupports>          mProgressGuard;
  HeadlessHistory               *mHistory;
  nsCOMPtr<nsISupports>          mHistoryGuard;
  HeadlessContentListener       *mContentListener;
  nsCOMPtr<nsISupports>          mContentListenerGuard;
  HeadlessEventListener         *mEventListener;
  nsCOMPtr<nsISupports>          mEventListenerGuard;

  nsCOMPtr<nsIWebNavigation>     mNavigation;
  nsCOMPtr<nsISHistory>          mSessionHistory;

  // our event receiver
  nsCOMPtr<nsPIDOMEventTarget>   mEventTarget;

  // the currently loaded uri
  nsCString                      mURI;
  // a URI to the icon for this page
  nsCString                      mIcon;

  // the number of widgets that have been created
  static PRUint32                sWidgetCount;
  // the path to the GRE
  static char                   *sPath;
  // the path to components
  static char                   *sCompPath;
  // the appshell we have created
  static nsIAppShell            *sAppShell;
  // the list of all open windows
  static nsVoidArray            *sWindowList;
  // what is our profile path?
  static nsILocalFile           *sProfileDir;
  static nsISupports            *sProfileLock;
  // extra paths for components and chrome
  static GSList                 *sCompPaths;
  static GSList                 *sChromePaths;

  static nsIDirectoryServiceProvider *sAppFileLocProvider;
  static GHashTable             *sDirectoryHash;

  // chrome mask
  PRUint32                       mChromeMask;
  // is this a chrome window?
  PRBool                         mIsChrome;
  // has the chrome finished loading?
  PRBool                         mChromeLoaded;
  // has someone called Destroy() on us?
  PRBool                         mIsDestroyed;

 private:

  // is the chrome listener attached yet?
  PRBool                         mListenersAttached;

  void GetListener    (void);
  void AttachListeners(void);
  void DetachListeners(void);

  // this will get the PIDOMWindow for this widget
  nsresult        GetPIDOMWindow   (nsPIDOMWindow **aPIWin);

  static nsresult RegisterAppComponents();
};

#endif /* __HeadlessPrivate_h */

