/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Intel code.
 *
 * The Initial Developer of the Original Code is Chris Lord
 * <chris@linux.intel.com>.  Portions created by the Initial Developer
 * are Copyright (C) 2008 Intel. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef _MOZ_DRAWING_AREA
#define _MOZ_DRAWING_AREA

#include <glib-object.h>
#include "cairo.h"

G_BEGIN_DECLS

#define MOZ_TYPE_DRAWING_AREA moz_drawing_area_get_type()

#define MOZ_DRAWING_AREA(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  MOZ_TYPE_DRAWING_AREA, MozDrawingArea))

#define MOZ_DRAWING_AREA_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  MOZ_TYPE_DRAWING_AREA, MozDrawingAreaClass))

#define MOZ_IS_DRAWING_AREA(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  MOZ_TYPE_DRAWING_AREA))

#define MOZ_IS_DRAWING_AREA_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  MOZ_TYPE_DRAWING_AREA))

#define MOZ_DRAWING_AREA_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  MOZ_TYPE_DRAWING_AREA, MozDrawingAreaClass))

typedef struct _MozDrawingAreaPrivate MozDrawingAreaPrivate;

typedef struct {
  GObject parent;

  MozDrawingAreaPrivate *priv;
} MozDrawingArea;

typedef struct {
  gint x;
  gint y;
  gint width;
  gint height;
} MozDrawingAreaRect;

typedef enum {
  MOZ_DA_SHIFT_MASK   = 1 << 0,
  MOZ_DA_CONTROL_MASK = 1 << 1,
  MOZ_DA_ALT_MASK     = 1 << 2,
  MOZ_DA_META_MASK    = 1 << 3,
  MOZ_DA_LOCK_MASK    = 1 << 4
} MozDrawingAreaModifier;

typedef enum {
  /* Special cursors which have MozHeadlessCursor descriptions: */
  /* NB: These must come first since they are used internally to
   * index into an array: */
  MOZ_HEADLESS_CURSOR_TYPE_HAND_GRAB,
  MOZ_HEADLESS_CURSOR_TYPE_HAND_GRABBING,
  MOZ_HEADLESS_CURSOR_TYPE_COPY,
  MOZ_HEADLESS_CURSOR_TYPE_ALIAS,
  MOZ_HEADLESS_CURSOR_TYPE_CONTEXT_MENU,
  MOZ_HEADLESS_CURSOR_TYPE_SPINNING,
  MOZ_HEADLESS_CURSOR_TYPE_ZOOM_IN,
  MOZ_HEADLESS_CURSOR_TYPE_ZOOM_OUT,
  MOZ_HEADLESS_CURSOR_TYPE_NOT_ALLOWED,
  MOZ_HEADLESS_CURSOR_TYPE_COL_RESIZE,
  MOZ_HEADLESS_CURSOR_TYPE_ROW_RESIZE,
  MOZ_HEADLESS_CURSOR_TYPE_VERTICAL_TEXT,
  MOZ_HEADLESS_CURSOR_TYPE_NESW_RESIZE,
  MOZ_HEADLESS_CURSOR_TYPE_NWSE_RESIZE,
  MOZ_HEADLESS_CURSOR_TYPE_NONE,

  MOZ_HEADLESS_CURSOR_TYPE_N_SPECIAL,

  /* Cursors which we expect the embedder to handle without
   * explicit bitmap + hotspot data: */
  MOZ_HEADLESS_CURSOR_TYPE_LEFT_PTR,
  MOZ_HEADLESS_CURSOR_TYPE_WATCH,
  MOZ_HEADLESS_CURSOR_TYPE_XTERM,
  MOZ_HEADLESS_CURSOR_TYPE_HAND2,
  MOZ_HEADLESS_CURSOR_TYPE_TOP_SIDE,
  MOZ_HEADLESS_CURSOR_TYPE_BOTTOM_SIDE,
  MOZ_HEADLESS_CURSOR_TYPE_LEFT_SIDE,
  MOZ_HEADLESS_CURSOR_TYPE_RIGHT_SIDE,
  MOZ_HEADLESS_CURSOR_TYPE_TOP_LEFT_CORNER,
  MOZ_HEADLESS_CURSOR_TYPE_BOTTOM_RIGHT_CORNER,
  MOZ_HEADLESS_CURSOR_TYPE_TOP_RIGHT_CORNER,
  MOZ_HEADLESS_CURSOR_TYPE_BOTTOM_LEFT_CORNER,
  MOZ_HEADLESS_CURSOR_TYPE_CROSSHAIR,
  MOZ_HEADLESS_CURSOR_TYPE_FLEUR,
  MOZ_HEADLESS_CURSOR_TYPE_QUESTION_ARROW,
  MOZ_HEADLESS_CURSOR_TYPE_PLUS,
  MOZ_HEADLESS_CURSOR_TYPE_SB_V_DOUBLE_ARROW,
  MOZ_HEADLESS_CURSOR_TYPE_SB_H_DOUBLE_ARROW,

  MOZ_HEADLESS_CURSOR_TYPE_N_TYPES
} MozHeadlessCursorType;

typedef struct {
  const unsigned char *bits;
  const unsigned char *mask_bits;
  int hot_x;
  int hot_y;
} MozHeadlessCursor;

typedef struct {
  GObjectClass parent_class;

  /* Signals */
  void (* updated)        (MozDrawingArea *area,
                           const MozDrawingAreaRect *bounds);
  void (* pre_expose)     (MozDrawingArea *area);
  void (* expose)         (MozDrawingArea *area);
  gboolean (* scroll)     (MozDrawingArea *area, MozDrawingAreaRect *rect, gint dx, gint dy);
  void (* child_bounds)   (MozDrawingArea *area);

  void (* motion)         (MozDrawingArea *area, gint x, gint y, MozDrawingAreaModifier modifiers);
  void (* button_press)   (MozDrawingArea *area, gint x, gint y, gint button, gint click_count, MozDrawingAreaModifier modifiers);
  void (* button_release) (MozDrawingArea *area, gint x, gint y, gint button, MozDrawingAreaModifier modifiers);
  void (* key_press)      (MozDrawingArea *area, guint key, gunichar unicode_value, MozDrawingAreaModifier modifiers);
  void (* key_release)    (MozDrawingArea *area, guint key, MozDrawingAreaModifier modifiers);
#ifdef SUPPORT_IM
  void (* ime_commit)   (MozDrawingArea *area, gchar *commit_str);
  void (* ime_preedit_changed) (MozDrawingArea *area, gchar *preedit_str, gint cursor_pos);
  void (* ime_reset)    (MozDrawingArea *area);
  void (* ime_enable)   (MozDrawingArea *area, gboolean enabled);
  void (* ime_focus_change) (MozDrawingArea *area, gboolean in);
  void (* ime_set_cursor) (MozDrawingArea *area, gint x, gint y, gint width, gint height);
#endif
#ifdef MOZ_ENABLE_GTK2_PLUGINS
  void (* plugin_added) (MozDrawingArea *area, guint plug_id, gint x, gint y, gint width, gint height);
  void (* plugin_updated) (MozDrawingArea *area, guint plug_id, gint x, gint y, gint width, gint height);
  void (* plugin_visibility) (MozDrawingArea *area, guint plug_id, gboolean visible);
#endif
} MozDrawingAreaClass;

#ifdef SUPPORT_IM
void moz_drawing_area_ime_reset (MozDrawingArea *area);
void moz_drawing_area_ime_enable (MozDrawingArea *area, gboolean enabled);
void moz_drawing_area_ime_focus_change (MozDrawingArea *area, gboolean in);
void moz_drawing_area_ime_set_cursor (MozDrawingArea *area,
                                      gint            x,
                                      gint            y,
                                      gint            width,
                                      gint            height);
#endif

GType moz_drawing_area_get_type (void);

MozDrawingArea* moz_drawing_area_new (MozDrawingArea *parent, gboolean popup);

cairo_surface_t *moz_drawing_area_get_surface (MozDrawingArea *area,
                                               gint           *x,
                                               gint           *y);

MozDrawingArea  *moz_drawing_area_get_parent   (MozDrawingArea *area);

MozDrawingArea  *moz_drawing_area_get_toplevel (MozDrawingArea *area);

void             moz_drawing_area_set_parent  (MozDrawingArea *area,
                                               MozDrawingArea *parent);

void             moz_drawing_area_set_size    (MozDrawingArea *area,
                                               gint            width,
                                               gint            height);

void             moz_drawing_area_set_position (MozDrawingArea *area,
                                                gint            x,
                                                gint            y);

void             moz_drawing_area_set_bounds  (MozDrawingArea *area,
                                               gint            x,
                                               gint            y,
                                               gint            width,
                                               gint            height);

void             moz_drawing_area_get_bounds  (MozDrawingArea *area,
                                               gint           *x,
                                               gint           *y,
                                               gint           *width,
                                               gint           *height);

void             moz_drawing_area_get_abs_bounds  (MozDrawingArea *area,
                                                   gint           *x,
                                                   gint           *y,
                                                   gint           *width,
                                                   gint           *height);

void             moz_drawing_area_get_child_bounds (MozDrawingArea *area,
                                                    gint           *width,
                                                    gint           *height);

void             moz_drawing_area_set_visible (MozDrawingArea *area,
                                               gboolean        visible);

gboolean         moz_drawing_area_get_visible (MozDrawingArea *area);

gboolean         moz_drawing_area_get_is_visible (MozDrawingArea *area);

gboolean         moz_drawing_area_get_popup (MozDrawingArea *area);

gboolean         moz_drawing_area_get_is_popup (MozDrawingArea *area);

void             moz_drawing_area_print_tree (MozDrawingArea *area);

void             moz_drawing_area_set_z (MozDrawingArea *area,
                                         gint            z);

gint             moz_drawing_area_get_z (MozDrawingArea *area);

void             moz_drawing_area_redraw (MozDrawingArea *area, gboolean now);

void             moz_drawing_area_set_damage (MozDrawingArea     *area,
                                              MozDrawingAreaRect *rect);

const MozDrawingAreaRect *
                 moz_drawing_area_get_damage (MozDrawingArea     *area);

gboolean         moz_drawing_area_is_damaged (MozDrawingArea   *area);

void             moz_drawing_area_reset_damage (MozDrawingArea   *area);

MozDrawingArea * moz_drawing_area_get_area_at_point (MozDrawingArea *area,
                                                     gint           *x,
                                                     gint           *y);

void             moz_drawing_area_scroll (MozDrawingArea *area,
                                          gint            dx,
                                          gint            dy);

void             moz_drawing_area_set_surface (MozDrawingArea *area,
                                               gpointer        target,
                                               gint            width,
                                               gint            height,
                                               gint            stride);

void             moz_drawing_area_freeze_updates (MozDrawingArea *area,
                                                  gboolean        frozen);

#ifdef MOZ_ENABLE_GTK2_PLUGINS
void moz_drawing_area_add_plugin (MozDrawingArea *area,
                                  guint           plug_id,
                                  gint            x,
                                  gint            y,
                                  gint            width,
                                  gint            height);
void moz_drawing_area_update_plugin_bounds (MozDrawingArea *area,
                                            guint           plug_id,
                                            gint            x,
                                            gint            y,
                                            gint            width,
                                            gint            height);
void moz_drawing_area_update_plugin_visibility (MozDrawingArea *area,
                                                guint           plug_id,
                                                gboolean        visible);
#endif

void             moz_drawing_area_set_cursor (MozDrawingArea *area,
                                              MozHeadlessCursorType type);

MozHeadlessCursorType moz_drawing_area_get_cursor (MozDrawingArea *area);

const GList     *moz_drawing_area_get_children (MozDrawingArea *area);

gboolean         moz_drawing_area_has_visible_children (MozDrawingArea *area);

MozDrawingArea  *moz_drawing_area_get_focus (MozDrawingArea *area);

void             moz_drawing_area_set_focus (MozDrawingArea *area);

gboolean         moz_drawing_area_get_transparent (MozDrawingArea *area);

void             moz_drawing_area_set_transparent (MozDrawingArea *area,
                                                   gboolean        transparent);

G_END_DECLS

#endif /* _MOZ_DRAWING_AREA */

