/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.util.Enumeration;
import writer2latex.office.OfficeReader;
import writer2latex.office.OfficeStyleFamily;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.CSVList;
import writer2latex.util.Config;
import writer2latex.util.SimpleInputBuffer;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.StyleWithPropertiesConverterHelper;

public class FrameStyleConverter
extends StyleWithPropertiesConverterHelper {
    public FrameStyleConverter(OfficeReader ofr, Config config, Converter converter, int nType) {
        super(ofr, config, converter, nType);
        this.styleMap = config.getXFrameStyleMap();
        this.bConvertStyles = config.xhtmlFrameFormatting() == 4 || config.xhtmlFrameFormatting() == 7;
        this.bConvertHard = config.xhtmlFrameFormatting() == 4 || config.xhtmlFrameFormatting() == 6;
    }

    public String getStyleDeclarations(String sIndent) {
        if (this.bConvertStyles) {
            StringBuffer buf = new StringBuffer();
            buf.append(super.getStyleDeclarations(sIndent));
            Enumeration names = this.styleNames.keys();
            while (names.hasMoreElements()) {
                String sDisplayName = (String)names.nextElement();
                StyleWithProperties style = (StyleWithProperties)this.getStyles().getStyleByDisplayName(sDisplayName);
                if (style.isAutomatic()) continue;
                CSVList props = new CSVList(";");
                this.getFrameSc().cssMargins(style, props, true);
                this.getParSc().cssPar(style, props, true);
                this.getTextSc().cssTextCommon(style, props, true);
                if (props.isEmpty()) continue;
                buf.append(sIndent).append(this.getDefaultTagName(null)).append(".").append(this.getClassNamePrefix()).append(this.styleNames.getExportName(sDisplayName)).append(" p {").append(props.toString()).append("}\n");
            }
            return buf.toString();
        }
        return "";
    }

    public String getClassNamePrefix() {
        return "frame";
    }

    public OfficeStyleFamily getStyles() {
        return this.ofr.getFrameStyles();
    }

    public String getDefaultTagName(StyleWithProperties style) {
        return "";
    }

    public void applyProperties(StyleWithProperties style, CSVList props, boolean bInherit) {
        this.cssBox(style, props, bInherit);
        this.getTextSc().cssTextCommon(style, props, bInherit);
    }

    public void cssBox(StyleWithProperties style, CSVList props, boolean bInherit) {
        this.cssMargins(style, props, bInherit);
        this.cssBorder(style, props, bInherit);
        this.cssPadding(style, props, bInherit);
        this.cssBackground(style, props, bInherit);
    }

    public void cssMargins(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s;
        if (bInherit || style.getProperty("fo:margin-left", false) != null) {
            s = style.getAbsoluteProperty("fo:margin-left");
            if (s != null) {
                props.addValue("margin-left", this.scale(s));
            } else {
                props.addValue("margin-left", "0");
            }
        }
        if (bInherit || style.getProperty("fo:margin-right", false) != null) {
            s = style.getAbsoluteProperty("fo:margin-right");
            if (s != null) {
                props.addValue("margin-right", this.scale(s));
            } else {
                props.addValue("margin-right", "0");
            }
        }
        if (bInherit || style.getProperty("fo:margin-top", false) != null) {
            s = style.getAbsoluteProperty("fo:margin-top");
            if (s != null) {
                props.addValue("margin-top", this.scale(s));
            } else {
                props.addValue("margin-top", "0");
            }
        }
        if (bInherit || style.getProperty("fo:margin-bottom", false) != null) {
            s = style.getAbsoluteProperty("fo:margin-bottom");
            if (s != null) {
                props.addValue("margin-bottom", this.scale(s));
            } else {
                props.addValue("margin-bottom", "0");
            }
        }
    }

    public void cssBorder(StyleWithProperties style, CSVList props, boolean bInherit) {
        boolean bHasBorder = false;
        String s = null;
        if (bInherit || style.getProperty("fo:border", false) != null) {
            s = style.getProperty("fo:border");
        }
        if (s != null) {
            props.addValue("border", this.borderScale(s));
            bHasBorder = true;
        } else {
            if ((bInherit || style.getProperty("fo:border-top", false) != null) && (s = style.getProperty("fo:border-top")) != null) {
                props.addValue("border-top", this.borderScale(s));
                bHasBorder = true;
            }
            if ((bInherit || style.getProperty("fo:border-bottom", false) != null) && (s = style.getProperty("fo:border-bottom")) != null) {
                props.addValue("border-bottom", this.borderScale(s));
                bHasBorder = true;
            }
            if ((bInherit || style.getProperty("fo:border-left", false) != null) && (s = style.getProperty("fo:border-left")) != null) {
                props.addValue("border-left", this.borderScale(s));
                bHasBorder = true;
            }
            if ((bInherit || style.getProperty("fo:border-right", false) != null) && (s = style.getProperty("fo:border-right")) != null) {
                props.addValue("border-right", this.borderScale(s));
                bHasBorder = true;
            }
        }
        if (bInherit && !bHasBorder) {
            props.addValue("border", "none");
        }
    }

    public void cssPadding(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s = null;
        if (bInherit || style.getProperty("fo:padding", false) != null) {
            s = style.getAbsoluteProperty("fo:padding");
        }
        if (s != null) {
            props.addValue("padding", this.scale(s));
        } else {
            boolean bTop = false;
            boolean bBottom = false;
            boolean bLeft = false;
            boolean bRight = false;
            if ((bInherit || style.getProperty("fo:padding-top", false) != null) && (s = style.getAbsoluteProperty("fo:padding-top")) != null) {
                props.addValue("padding-top", this.scale(s));
                bTop = true;
            }
            if ((bInherit || style.getProperty("fo:padding-bottom", false) != null) && (s = style.getAbsoluteProperty("fo:padding-bottom")) != null) {
                props.addValue("padding-bottom", this.scale(s));
                bBottom = true;
            }
            if ((bInherit || style.getProperty("fo:padding-left", false) != null) && (s = style.getAbsoluteProperty("fo:padding-left")) != null) {
                props.addValue("padding-left", this.scale(s));
                bLeft = true;
            }
            if ((bInherit || style.getProperty("fo:padding-right", false) != null) && (s = style.getAbsoluteProperty("fo:padding-right")) != null) {
                props.addValue("padding-right", this.scale(s));
                bRight = true;
            }
            if (bInherit) {
                if (!(bTop || bBottom || bLeft || bRight)) {
                    props.addValue("padding", "0");
                } else {
                    if (!bTop) {
                        props.addValue("padding-top", "0");
                    }
                    if (!bBottom) {
                        props.addValue("padding-bottom", "0");
                    }
                    if (!bLeft) {
                        props.addValue("padding-left", "0");
                    }
                    if (!bRight) {
                        props.addValue("padding-right", "0");
                    }
                }
            }
        }
    }

    public void cssBackgroundCommon(StyleWithProperties style, CSVList props, boolean bInherit) {
        String sUrl = style.getBackgroundImageProperty("xlink:href");
        if (sUrl != null) {
            props.addValue("background-image", "url(" + this.escapeUrl(sUrl) + ")");
            String sRepeat = style.getBackgroundImageProperty("style:repeat");
            if ("no-repeat".equals(sRepeat) || "stretch".equals(sRepeat)) {
                props.addValue("background-repeat", "no-repeat");
            } else {
                props.addValue("background-repeat", "repeat");
            }
            String sPosition = style.getBackgroundImageProperty("style:position");
            if (sPosition != null) {
                props.addValue("background-position", sPosition);
            }
        }
    }

    public void cssBackground(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s = style.getProperty("fo:background-color", bInherit);
        if (s != null) {
            props.addValue("background-color", s);
        }
        this.cssBackgroundCommon(style, props, bInherit);
    }

    /*
     * Unable to fully structure code
     */
    public String borderScale(String sBorder) {
        in = new SimpleInputBuffer(sBorder);
        out = new StringBuffer();
        ** GOTO lbl17
        {
            out.append(" ");
            in.getChar();
            do {
                if (in.peekChar() == ' ') continue block0;
                if ('0' <= in.peekChar() && in.peekChar() <= '9') {
                    out.append(this.scale(in.getNumber() + in.getIdentifier()));
                }
                while (in.peekChar() != ' ' && in.peekChar() != '\u0000') {
                    out.append(in.getChar());
                }
lbl17:
                // 2 sources

            } while (in.peekChar() != '\u0000');
        }
        return out.toString();
    }

    private String escapeUrl(String sUrl) {
        StringBuffer buf = new StringBuffer();
        int nLen = sUrl.length();
        int i = 0;
        while (i < nLen) {
            char c = sUrl.charAt(i);
            if (c == '\'' || c == '\"' || c == '(' || c == ')' || c == ',' || c == ' ') {
                buf.append("\\");
            }
            buf.append(c);
            ++i;
        }
        return buf.toString();
    }
}

