/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Misc {
    private static final int BUFFERSIZE = 1024;

    public static final int[] doubleIntArray(int[] array) {
        int n = array.length;
        int[] newArray = new int[2 * n];
        int i = 0;
        while (i < n) {
            newArray[i] = array[i];
            ++i;
        }
        return newArray;
    }

    public static final String int2roman(int number) {
        StringBuffer roman = new StringBuffer();
        while (number >= 1000) {
            roman.append('m');
            number -= 1000;
        }
        if (number >= 900) {
            roman.append("cm");
            number -= 900;
        }
        if (number >= 500) {
            roman.append('d');
            number -= 500;
        }
        if (number >= 400) {
            roman.append("cd");
            number -= 400;
        }
        while (number >= 100) {
            roman.append('c');
            number -= 100;
        }
        if (number >= 90) {
            roman.append("xc");
            number -= 90;
        }
        if (number >= 50) {
            roman.append('l');
            number -= 50;
        }
        if (number >= 40) {
            roman.append("xl");
            number -= 40;
        }
        while (number >= 10) {
            roman.append('x');
            number -= 10;
        }
        if (number >= 9) {
            roman.append("ix");
            number -= 9;
        }
        if (number >= 5) {
            roman.append('v');
            number -= 5;
        }
        if (number >= 4) {
            roman.append("iv");
            number -= 4;
        }
        while (number >= 1) {
            roman.append('i');
            --number;
        }
        return roman.toString();
    }

    public static final String int2Roman(int number) {
        return Misc.int2roman(number).toUpperCase();
    }

    public static final String int2arabic(int number) {
        return new Integer(number).toString();
    }

    public static final String int2alph(int number, boolean bLetterSync) {
        return new Character((char)(number + 96)).toString();
    }

    public static final String int2Alph(int number, boolean bLetterSync) {
        return Misc.int2alph(number, bLetterSync).toUpperCase();
    }

    public static final int getPosInteger(String sInteger, int nDefault) {
        int n;
        try {
            n = Integer.parseInt(sInteger);
        }
        catch (NumberFormatException e) {
            return nDefault;
        }
        return n > 0 ? n : nDefault;
    }

    public static final float getFloat(String sFloat, float fDefault) {
        float f;
        try {
            f = Float.parseFloat(sFloat);
        }
        catch (NumberFormatException e) {
            return fDefault;
        }
        return f;
    }

    public static final int getIntegerFromHex(String sHex, int nDefault) {
        int n;
        try {
            n = Integer.parseInt(sHex, 16);
        }
        catch (NumberFormatException e) {
            return nDefault;
        }
        return n;
    }

    public static String truncateLength(String sValue) {
        if (sValue.endsWith("inch")) {
            return sValue.substring(0, sValue.length() - 2);
        }
        return sValue;
    }

    private static final float getUpi(String sUnit) {
        if ("in".equals(sUnit)) {
            return 1.0f;
        }
        if ("mm".equals(sUnit)) {
            return 25.4f;
        }
        if ("cm".equals(sUnit)) {
            return 2.54f;
        }
        if ("pc".equals(sUnit)) {
            return 6.0f;
        }
        return 72.0f;
    }

    public static final String length2px(String sLength) {
        if (sLength.equals("0")) {
            return "0";
        }
        float fLength = Misc.getFloat(sLength.substring(0, sLength.length() - 2), 1.0f);
        String sUnit = sLength.substring(sLength.length() - 2);
        float fPixels = 96.0f / Misc.getUpi(sUnit) * fLength;
        if ((double)Math.abs(fPixels) < 0.01) {
            return "0";
        }
        if (fPixels > 0.0f) {
            return Float.toString(fPixels < 1.0f ? 1.0f : fPixels) + "px";
        }
        return Float.toString(fPixels > -1.0f ? -1.0f : fPixels) + "px";
    }

    public static final String multiply(String sPercent, String sLength) {
        if (sLength.equals("0")) {
            return "0";
        }
        float fPercent = Misc.getFloat(sPercent.substring(0, sPercent.length() - 1), 1.0f);
        float fLength = Misc.getFloat(sLength.substring(0, sLength.length() - 2), 1.0f);
        String sUnit = sLength.substring(sLength.length() - 2);
        return Float.toString(fPercent * fLength / 100.0f) + sUnit;
    }

    public static final String add(String sLength1, String sLength2) {
        if (sLength1.equals("0")) {
            return sLength2;
        }
        if (sLength2.equals("0")) {
            return sLength1;
        }
        float fLength1 = Misc.getFloat(sLength1.substring(0, sLength1.length() - 2), 1.0f);
        String sUnit1 = sLength1.substring(sLength1.length() - 2);
        float fLength2 = Misc.getFloat(sLength2.substring(0, sLength2.length() - 2), 1.0f);
        String sUnit2 = sLength2.substring(sLength2.length() - 2);
        return Float.toString(fLength1 + Misc.getUpi(sUnit1) / Misc.getUpi(sUnit2) * fLength2) + sUnit1;
    }

    public static final String sub(String sLength1, String sLength2) {
        return Misc.add(sLength1, Misc.multiply("-100%", sLength2));
    }

    public static boolean isLessThan(String sThis, String sThat) {
        return Misc.sub(sThis, sThat).startsWith("-");
    }

    public static final String trimDocumentName(String name, String extension) {
        String temp = name.toLowerCase();
        if (temp.endsWith(extension)) {
            int nlen = name.length();
            int endIndex = nlen - extension.length();
            name = name.substring(0, endIndex);
        }
        return name;
    }

    public static final String removeExtension(String sName) {
        int n = sName.lastIndexOf(".");
        if (n < 0) {
            return sName;
        }
        return sName.substring(0, n);
    }

    public static final String getAttribute(Node node, String attribute) {
        Node attr;
        NamedNodeMap attrNodes = node.getAttributes();
        if (attrNodes != null && (attr = attrNodes.getNamedItem(attribute)) != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    public static final boolean isElement(Node node) {
        return node.getNodeType() == 1;
    }

    public static final boolean isElement(Node node, String sTagName) {
        return node.getNodeType() == 1 && node.getNodeName().equals(sTagName);
    }

    public static final boolean isText(Node node) {
        return node.getNodeType() == 3;
    }

    public static final String getAttribute(Element node, String attribute) {
        if (node.hasAttribute(attribute)) {
            return node.getAttribute(attribute);
        }
        return null;
    }

    public static final Element getChildByTagName(Node node, String sTagName) {
        if (node.hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            int nLen = nl.getLength();
            int i = 0;
            while (i < nLen) {
                Node child = nl.item(i);
                if (child.getNodeType() == 1 && child.getNodeName().equals(sTagName)) {
                    return (Element)child;
                }
                ++i;
            }
        }
        return null;
    }

    public static final Element getFirstChildElement(Node node) {
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                return (Element)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    public static String getPCDATA(Node node) {
        StringBuffer buf = new StringBuffer();
        if (node.hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            int nLen = nl.getLength();
            int i = 0;
            while (i < nLen) {
                if (nl.item(i).getNodeType() == 3) {
                    buf.append(nl.item(i).getNodeValue());
                }
                ++i;
            }
        }
        return buf.toString();
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String makeHref(String s) {
        try {
            URI uri = new URI(null, null, s, null);
            return uri.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public static byte[] inputStreamToByteArray(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("No input stream to read");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int nLen = 0;
        byte[] buffer = new byte[1024];
        while ((nLen = is.read(buffer)) > 0) {
            baos.write(buffer, 0, nLen);
        }
        return baos.toByteArray();
    }

    static {
        BUFFERSIZE = 1024;
    }
}

