/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.latex.i18n.I18n;
import writer2latex.latex.i18n.ReplacementTrie;
import writer2latex.latex.util.HeadingMap;
import writer2latex.latex.util.StyleMap;
import writer2latex.util.BooleanOption;
import writer2latex.util.ContentHandlingOption;
import writer2latex.util.IntegerOption;
import writer2latex.util.Misc;
import writer2latex.util.Option;
import writer2latex.util.XhtmlFormatOption;
import writer2latex.xhtml.XhtmlStyleMap;
import writer2latex.xmerge.NewDOMDocument;

public class Config {
    public static final int GENERIC = 0;
    public static final int DVIPS = 1;
    public static final int PDFTEX = 2;
    public static final int UNSPECIFIED = 3;
    public static final int IGNORE_ALL = 0;
    public static final int IGNORE_MOST = 1;
    public static final int CONVERT_BASIC = 2;
    public static final int CONVERT_MOST = 3;
    public static final int CONVERT_ALL = 4;
    public static final int IGNORE_STYLES = 6;
    public static final int IGNORE_HARD = 7;
    public static final int CONVERT_HEADER_FOOTER = 5;
    public static final int IGNORE = 0;
    public static final int ACCEPT = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    public static final int COMMENT = 1;
    public static final int PDFANNOTATION = 2;
    public static final int MARGINPAR = 3;
    public static final int CUSTOM = 4;
    private static final int BACKEND = 0;
    private static final int NO_PREAMBLE = 1;
    private static final int NO_INDEX = 2;
    private static final int DOCUMENTCLASS = 3;
    private static final int GLOBAL_OPTIONS = 4;
    private static final int INPUTENCODING = 5;
    private static final int MULTILINGUAL = 6;
    private static final int GREEK_MATH = 7;
    private static final int USE_OOOMATH = 8;
    private static final int USE_PIFONT = 9;
    private static final int USE_IFSYM = 10;
    private static final int USE_WASYSYM = 11;
    private static final int USE_BBDING = 12;
    private static final int USE_EUROSYM = 13;
    private static final int USE_TIPA = 14;
    private static final int USE_COLOR = 15;
    private static final int USE_COLORTBL = 16;
    private static final int USE_GEOMETRY = 17;
    private static final int USE_FANCYHDR = 18;
    private static final int USE_HYPERREF = 19;
    private static final int USE_CAPTION = 20;
    private static final int USE_LONGTABLE = 21;
    private static final int USE_SUPERTABULAR = 22;
    private static final int USE_TABULARY = 23;
    private static final int USE_ENDNOTES = 24;
    private static final int USE_ULEM = 25;
    private static final int USE_LASTPAGE = 26;
    private static final int USE_TITLEREF = 27;
    private static final int USE_OOOREF = 28;
    private static final int USE_BIBTEX = 29;
    private static final int BIBTEX_STYLE = 30;
    private static final int FORMATTING = 31;
    private static final int PAGE_FORMATTING = 32;
    private static final int OTHER_STYLES = 33;
    private static final int IMAGE_CONTENT = 34;
    private static final int TABLE_CONTENT = 35;
    private static final int IGNORE_HARD_PAGE_BREAKS = 36;
    private static final int IGNORE_HARD_LINE_BREAKS = 37;
    private static final int IGNORE_EMPTY_PARAGRAPHS = 38;
    private static final int IGNORE_DOUBLE_SPACES = 39;
    private static final int ALIGN_FRAMES = 40;
    private static final int FLOAT_FIGURES = 41;
    private static final int FLOAT_TABLES = 42;
    private static final int FLOAT_OPTIONS = 43;
    private static final int FIGURE_SEQUENCE_NAME = 44;
    private static final int TABLE_SEQUENCE_NAME = 45;
    private static final int IMAGE_OPTIONS = 46;
    private static final int REMOVE_GRAPHICS_EXTENSION = 47;
    private static final int KEEP_IMAGE_SIZE = 48;
    private static final int SIMPLE_TABLE_LIMIT = 49;
    private static final int NOTES = 50;
    private static final int TABSTOP = 51;
    private static final int WRAP_LINES_AFTER = 52;
    private static final int SPLIT_LINKED_SECTIONS = 53;
    private static final int SPLIT_TOPLEVEL_SECTIONS = 54;
    private static final int XHTML_NO_DOCTYPE = 55;
    private static final int XHTML_ENCODING = 56;
    private static final int XHTML_CUSTOM_STYLESHEET = 57;
    private static final int XHTML_FORMATTING = 58;
    private static final int XHTML_FRAME_FORMATTING = 59;
    private static final int XHTML_SECTION_FORMATTING = 60;
    private static final int XHTML_TABLE_FORMATTING = 61;
    private static final int XHTML_IGNORE_TABLE_DIMENSIONS = 62;
    private static final int XHTML_USE_DUBLIN_CORE = 63;
    private static final int XHTML_CONVERT_TO_PX = 64;
    private static final int XHTML_SCALING = 65;
    private static final int XHTML_COLUMN_SCALING = 66;
    private static final int XHTML_FLOAT_OBJECTS = 67;
    private static final int XHTML_TABSTOP_STYLE = 68;
    private static final int XHTML_USE_LIST_HACK = 69;
    private static final int XHTML_SPLIT_LEVEL = 70;
    private static final int XHTML_CALC_SPLIT = 71;
    private static final int XHTML_UPLINK = 72;
    private static final int XHTML_DIRECTORY_ICON = 73;
    private static final int XHTML_DOCUMENT_ICON = 74;
    private static final int DEBUG = 75;
    private static final int OPTION_COUNT = 76;
    Option[] options = new Option[76];
    protected boolean bDebug = false;
    protected LinkedList customPreamble = new LinkedList();
    protected StyleMap par = new StyleMap();
    protected StyleMap parBlock = new StyleMap();
    protected StyleMap text = new StyleMap();
    protected StyleMap list = new StyleMap();
    protected StyleMap listItem = new StyleMap();
    protected HeadingMap headingMap = new HeadingMap(5);
    protected XhtmlStyleMap xpar = new XhtmlStyleMap();
    protected XhtmlStyleMap xtext = new XhtmlStyleMap();
    protected XhtmlStyleMap xframe = new XhtmlStyleMap();
    protected XhtmlStyleMap xlist = new XhtmlStyleMap();
    protected XhtmlStyleMap xattr = new XhtmlStyleMap();
    protected Hashtable mathSymbols = new Hashtable();
    protected ReplacementTrie stringReplace = new ReplacementTrie();

    public Config() {
        this.options[1] = new BooleanOption("no_preamble", "false");
        this.options[2] = new BooleanOption("no_index", "false");
        this.options[3] = new Option("documentclass", "article");
        this.options[4] = new Option("global_options", "");
        this.options[0] = new IntegerOption("backend", "pdftex"){

            void setString(String sValue) {
                super.setString(sValue);
                if ("generic".equals(sValue)) {
                    this.nValue = 0;
                } else if ("dvips".equals(sValue)) {
                    this.nValue = 1;
                } else if ("pdftex".equals(sValue)) {
                    this.nValue = 2;
                } else if ("unspecified".equals(sValue)) {
                    this.nValue = 3;
                }
            }
        };
        this.options[5] = new IntegerOption("inputencoding", I18n.writeInputenc(0)){

            void setString(String sValue) {
                super.setString(sValue);
                this.nValue = I18n.readInputenc(sValue);
            }
        };
        this.options[6] = new BooleanOption("multilingual", "true");
        this.options[7] = new BooleanOption("greek_math", "true");
        this.options[8] = new BooleanOption("use_ooomath", "false");
        this.options[9] = new BooleanOption("use_pifont", "false");
        this.options[10] = new BooleanOption("use_ifsym", "false");
        this.options[11] = new BooleanOption("use_wasysym", "false");
        this.options[12] = new BooleanOption("use_bbding", "false");
        this.options[13] = new BooleanOption("use_eurosym", "false");
        this.options[14] = new BooleanOption("use_tipa", "false");
        this.options[15] = new BooleanOption("use_color", "true");
        this.options[16] = new BooleanOption("use_colortbl", "false");
        this.options[17] = new BooleanOption("use_geometry", "false");
        this.options[18] = new BooleanOption("use_fancyhdr", "false");
        this.options[19] = new BooleanOption("use_hyperref", "true");
        this.options[20] = new BooleanOption("use_caption", "false");
        this.options[21] = new BooleanOption("use_longtable", "false");
        this.options[22] = new BooleanOption("use_supertabular", "true");
        this.options[23] = new BooleanOption("use_tabulary", "false");
        this.options[24] = new BooleanOption("use_endnotes", "false");
        this.options[25] = new BooleanOption("use_ulem", "false");
        this.options[26] = new BooleanOption("use_lastpage", "false");
        this.options[27] = new BooleanOption("use_titleref", "false");
        this.options[28] = new BooleanOption("use_oooref", "false");
        this.options[29] = new BooleanOption("use_bibtex", "false");
        this.options[30] = new Option("bibtex_style", "plain");
        this.options[31] = new IntegerOption("formatting", "convert_basic"){

            void setString(String sValue) {
                super.setString(sValue);
                if ("convert_all".equals(sValue)) {
                    this.nValue = 4;
                } else if ("convert_most".equals(sValue)) {
                    this.nValue = 3;
                } else if ("convert_basic".equals(sValue)) {
                    this.nValue = 2;
                } else if ("ignore_most".equals(sValue)) {
                    this.nValue = 1;
                } else if ("ignore_all".equals(sValue)) {
                    this.nValue = 0;
                }
            }
        };
        this.options[32] = new IntegerOption("page_formatting", "convert_all"){

            void setString(String sValue) {
                super.setString(sValue);
                if ("convert_all".equals(sValue)) {
                    this.nValue = 4;
                } else if ("convert_header_footer".equals(sValue)) {
                    this.nValue = 5;
                } else if ("ignore_all".equals(sValue)) {
                    this.nValue = 0;
                }
            }
        };
        this.options[33] = new ContentHandlingOption("other_styles", "accept");
        this.options[34] = new ContentHandlingOption("image_content", "accept");
        this.options[35] = new ContentHandlingOption("table_content", "accept");
        this.options[36] = new BooleanOption("ignore_hard_page_breaks", "false");
        this.options[37] = new BooleanOption("ignore_hard_line_breaks", "false");
        this.options[38] = new BooleanOption("ignore_empty_paragraphs", "false");
        this.options[39] = new BooleanOption("ignore_double_spaces", "false");
        this.options[40] = new BooleanOption("align_frames", "true");
        this.options[41] = new BooleanOption("float_figures", "false");
        this.options[42] = new BooleanOption("float_tables", "false");
        this.options[43] = new Option("float_options", "h");
        this.options[44] = new BooleanOption("figure_sequence_name", "");
        this.options[45] = new BooleanOption("table_sequence_name", "");
        this.options[46] = new Option("image_options", "");
        this.options[47] = new BooleanOption("remove_graphics_extension", "false");
        this.options[48] = new BooleanOption("keep_image_size", "false");
        this.options[49] = new IntegerOption("simple_table_limit", "0"){

            void setString(String sValue) {
                super.setString(sValue);
                this.nValue = Misc.getPosInteger(sValue, 0);
            }
        };
        this.options[50] = new IntegerOption("notes", "comment"){

            void setString(String sValue) {
                super.setString(sValue);
                this.nValue = "ignore".equals(sValue) ? 0 : ("comment".equals(sValue) ? 1 : ("pdfannotation".equals(sValue) ? 2 : ("marginpar".equals(sValue) ? 3 : 4)));
            }
        };
        this.options[51] = new Option("tabstop", "");
        this.options[52] = new IntegerOption("wrap_lines_after", "72"){

            void setString(String sValue) {
                super.setString(sValue);
                this.nValue = Misc.getPosInteger(sValue, 0);
            }
        };
        this.options[53] = new BooleanOption("split_linked_sections", "false");
        this.options[54] = new BooleanOption("split_toplevel_sections", "false");
        this.options[55] = new BooleanOption("xhtml_no_doctype", "false");
        this.options[56] = new Option("xhtml_encoding", "UTF-8");
        this.options[57] = new Option("xhtml_custom_stylesheet", "");
        this.options[58] = new XhtmlFormatOption("xhtml_formatting", "convert_all");
        this.options[59] = new XhtmlFormatOption("xhtml_frame_formatting", "convert_all");
        this.options[60] = new XhtmlFormatOption("xhtml_section_formatting", "convert_all");
        this.options[61] = new XhtmlFormatOption("xhtml_table_formatting", "convert_all");
        this.options[62] = new BooleanOption("xhtml_ignore_table_dimensions", "false");
        this.options[63] = new BooleanOption("xhtml_use_dublin_core", "true");
        this.options[64] = new BooleanOption("xhtml_convert_to_px", "true");
        this.options[65] = new Option("xhtml_scaling", "100%");
        this.options[66] = new Option("xhtml_column_scaling", "100%");
        this.options[67] = new BooleanOption("xhtml_float_objects", "true");
        this.options[68] = new Option("xhtml_tabstop_style", "");
        this.options[69] = new BooleanOption("xhtml_use_list_hack", "false");
        this.options[70] = new IntegerOption("xhtml_split_level", "0"){

            void setString(String sValue) {
                super.setString(sValue);
                this.nValue = Misc.getPosInteger(sValue, 0);
            }
        };
        this.options[71] = new BooleanOption("xhtml_calc_split", "false");
        this.options[72] = new Option("xhtml_uplink", "");
        this.options[73] = new Option("xhtml_directory_icon", "");
        this.options[74] = new Option("xhtml_document_icon", "");
        this.options[75] = new BooleanOption("debug", "false");
        this.headingMap.setLevelData(1, "section", 1);
        this.headingMap.setLevelData(2, "subsection", 2);
        this.headingMap.setLevelData(3, "subsubsection", 3);
        this.headingMap.setLevelData(4, "paragraph", 4);
        this.headingMap.setLevelData(5, "subparagraph", 5);
        this.stringReplace.put("\u00a0\u2014", " \u2014", I18n.readFontencs("any"));
        this.stringReplace.put("\u00a0!", " !", I18n.readFontencs("any"));
        this.stringReplace.put("\u00a0?", " ?", I18n.readFontencs("any"));
        this.stringReplace.put("\u00a0:", " :", I18n.readFontencs("any"));
        this.stringReplace.put("\u00a0;", " ;", I18n.readFontencs("any"));
    }

    public void setOption(String sName, String sValue) {
        int j = 0;
        while (j < 76) {
            if (this.options[j].getName().equals(sName)) {
                this.options[j].setString(sValue);
                break;
            }
            ++j;
        }
    }

    public void read(InputStream is) {
        NewDOMDocument doc = new NewDOMDocument("config", ".xml");
        try {
            doc.read(is);
        }
        catch (IOException e) {
            System.err.println("Oops - I cannot read the configuration file");
            e.printStackTrace();
            return;
        }
        Document dom = doc.getContentDOM();
        if (dom == null) {
            System.err.println("Oops - I cannot understand the contents of the configuration file");
            return;
        }
        Element root = dom.getDocumentElement();
        if (!root.hasChildNodes()) {
            return;
        }
        NodeList nl = root.getChildNodes();
        int nLen = nl.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = nl.item(i);
            if (child.getNodeType() == 1) {
                String sName;
                String sChildName = child.getNodeName();
                if (sChildName.equals("option")) {
                    sName = Misc.getAttribute(child, "name");
                    String sValue = Misc.getAttribute(child, "value");
                    this.setOption(sName, sValue);
                } else if (sChildName.equals("style-map")) {
                    sName = Misc.getAttribute(child, "name");
                    String sClass = Misc.getAttribute(child, "class");
                    String sBefore = Misc.getAttribute(child, "before");
                    String sAfter = Misc.getAttribute(child, "after");
                    boolean bLineBreak = !"false".equals(Misc.getAttribute(child, "line-break"));
                    boolean bVerbatim = "true".equals(Misc.getAttribute(child, "verbatim"));
                    if ("paragraph".equals(sClass)) {
                        this.par.put(sName, sBefore, sAfter, bLineBreak, bVerbatim);
                    }
                    if ("paragraph-block".equals(sClass)) {
                        String sNext = Misc.getAttribute(child, "next");
                        this.parBlock.put(sName, sBefore, sAfter, sNext, bVerbatim);
                    } else if ("text".equals(sClass)) {
                        this.text.put(sName, sBefore, sAfter, false, bVerbatim);
                    } else if ("list".equals(sClass)) {
                        this.list.put(sName, sBefore, sAfter);
                    } else if ("listitem".equals(sClass)) {
                        this.listItem.put(sName, sBefore, sAfter);
                    }
                } else if (sChildName.equals("heading-map")) {
                    this.readHeadingMap(child);
                } else if (sChildName.equals("string-replace")) {
                    String sInput = Misc.getAttribute(child, "input");
                    String sLaTeXCode = Misc.getAttribute(child, "latex-code");
                    String sFontencs = Misc.getAttribute(child, "fontencs");
                    int nFontencs = I18n.readFontencs(sFontencs != null ? sFontencs : "any");
                    this.stringReplace.put(sInput, sLaTeXCode, nFontencs);
                } else if (sChildName.equals("custom-preamble")) {
                    if (child.hasChildNodes()) {
                        NodeList subNl = child.getChildNodes();
                        int nSubLen = subNl.getLength();
                        int j = 0;
                        while (j < nSubLen) {
                            Node subChild = subNl.item(j);
                            if (subChild.getNodeType() == 3) {
                                this.customPreamble.add(subChild.getNodeValue());
                            }
                            ++j;
                        }
                    }
                } else if (sChildName.equals("xhtml-style-map")) {
                    String sCss;
                    String sElement;
                    String sBlockCss;
                    sName = Misc.getAttribute(child, "name");
                    String sClass = Misc.getAttribute(child, "class");
                    String sBlockElement = Misc.getAttribute(child, "block-element");
                    if (sBlockElement == null) {
                        sBlockElement = "";
                    }
                    if ((sBlockCss = Misc.getAttribute(child, "block-css")) == null) {
                        sBlockCss = "(none)";
                    }
                    if ((sElement = Misc.getAttribute(child, "element")) == null) {
                        sElement = "";
                    }
                    if ((sCss = Misc.getAttribute(child, "css")) == null) {
                        sCss = "(none)";
                    }
                    if ("paragraph".equals(sClass)) {
                        this.xpar.put(sName, sBlockElement, sBlockCss, sElement, sCss);
                    } else if ("text".equals(sClass)) {
                        this.xtext.put(sName, sBlockElement, sBlockCss, sElement, sCss);
                    } else if ("frame".equals(sClass)) {
                        this.xframe.put(sName, sBlockElement, sBlockCss, sElement, sCss);
                    } else if ("list".equals(sClass)) {
                        this.xlist.put(sName, sBlockElement, sBlockCss, sElement, sCss);
                    } else if ("attribute".equals(sClass)) {
                        this.xattr.put(sName, sBlockElement, sBlockCss, sElement, sCss);
                    }
                } else if (sChildName.equals("math-symbol-map")) {
                    sName = Misc.getAttribute(child, "name");
                    String sLatex = Misc.getAttribute(child, "latex");
                    this.mathSymbols.put(sName, sLatex);
                }
            }
            ++i;
        }
    }

    public void readHeadingMap(Node node) {
        int nMaxLevel = Misc.getPosInteger(Misc.getAttribute(node, "max-level"), 0);
        this.headingMap.reset(nMaxLevel);
        NodeList nl = node.getChildNodes();
        int nLen = nl.getLength();
        int i = 0;
        while (i < nLen) {
            String sChildName;
            Node child = nl.item(i);
            if (child.getNodeType() == 1 && (sChildName = child.getNodeName()).equals("heading-level-map")) {
                int nWriterLevel = Misc.getPosInteger(Misc.getAttribute(child, "writer-level"), 1);
                String sName = Misc.getAttribute(child, "name");
                int nLevel = Misc.getPosInteger(Misc.getAttribute(child, "level"), 0);
                this.headingMap.setLevelData(nWriterLevel, sName, nLevel);
            }
            ++i;
        }
    }

    public void write(OutputStream os) {
        NewDOMDocument doc = new NewDOMDocument("config-file", ".xml");
        Document dom = null;
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            dom = domImpl.createDocument("", "config", null);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        Element rootElement = dom.getDocumentElement();
        int i = 0;
        while (i < 76) {
            Element optionNode = dom.createElement("option");
            optionNode.setAttribute("name", this.options[i].getName());
            optionNode.setAttribute("value", this.options[i].getString());
            rootElement.appendChild(optionNode);
            ++i;
        }
        Enumeration msEnum = this.mathSymbols.keys();
        while (msEnum.hasMoreElements()) {
            String sName = (String)msEnum.nextElement();
            String sLatex = (String)this.mathSymbols.get(sName);
            Element msNode = dom.createElement("math-symbol-map");
            msNode.setAttribute("name", sName);
            msNode.setAttribute("latex", sLatex);
            rootElement.appendChild(msNode);
        }
        this.writeStyleMap(dom, this.par, "paragraph");
        this.writeStyleMap(dom, this.parBlock, "paragraph-block");
        this.writeStyleMap(dom, this.text, "text");
        this.writeStyleMap(dom, this.list, "list");
        this.writeStyleMap(dom, this.listItem, "listitem");
        Element hmNode = dom.createElement("heading-map");
        hmNode.setAttribute("max-level", Integer.toString(this.headingMap.getMaxLevel()));
        rootElement.appendChild(hmNode);
        int i2 = 1;
        while (i2 <= this.headingMap.getMaxLevel()) {
            Element hlmNode = dom.createElement("heading-level-map");
            hlmNode.setAttribute("writer-level", Integer.toString(i2));
            hlmNode.setAttribute("name", this.headingMap.getName(i2));
            hlmNode.setAttribute("level", Integer.toString(this.headingMap.getLevel(i2)));
            hmNode.appendChild(hlmNode);
            ++i2;
        }
        String[] sInputStrings = this.stringReplace.getInputStrings();
        this.writeXStyleMap(dom, this.xpar, "paragraph");
        this.writeXStyleMap(dom, this.xtext, "text");
        this.writeXStyleMap(dom, this.xlist, "list");
        this.writeXStyleMap(dom, this.xframe, "frame");
        this.writeXStyleMap(dom, this.xframe, "attribute");
        this.writeContent(dom, this.customPreamble, "custom-preamble");
        doc.setContentDOM(dom);
        try {
            doc.write(os);
        }
        catch (IOException e) {
            System.err.println("Oops - problem writing the configuration");
            e.printStackTrace();
        }
    }

    public ReplacementTrie getStringReplace() {
        return this.stringReplace;
    }

    public boolean debug() {
        return ((BooleanOption)this.options[75]).getValue();
    }

    public String getDocumentclass() {
        return this.options[3].getString();
    }

    public String getGlobalOptions() {
        return this.options[4].getString();
    }

    public int getBackend() {
        return ((IntegerOption)this.options[0]).getValue();
    }

    public int getInputencoding() {
        return ((IntegerOption)this.options[5]).getValue();
    }

    public boolean multilingual() {
        return ((BooleanOption)this.options[6]).getValue();
    }

    public boolean greekMath() {
        return ((BooleanOption)this.options[7]).getValue();
    }

    public boolean noPreamble() {
        return ((BooleanOption)this.options[1]).getValue();
    }

    public boolean noIndex() {
        return ((BooleanOption)this.options[2]).getValue();
    }

    public boolean useOoomath() {
        return ((BooleanOption)this.options[8]).getValue();
    }

    public boolean usePifont() {
        return ((BooleanOption)this.options[9]).getValue();
    }

    public boolean useIfsym() {
        return ((BooleanOption)this.options[10]).getValue();
    }

    public boolean useWasysym() {
        return ((BooleanOption)this.options[11]).getValue();
    }

    public boolean useBbding() {
        return ((BooleanOption)this.options[12]).getValue();
    }

    public boolean useEurosym() {
        return ((BooleanOption)this.options[13]).getValue();
    }

    public boolean useTipa() {
        return ((BooleanOption)this.options[14]).getValue();
    }

    public boolean useColor() {
        return ((BooleanOption)this.options[15]).getValue();
    }

    public boolean useColortbl() {
        return ((BooleanOption)this.options[16]).getValue();
    }

    public boolean useGeometry() {
        return ((BooleanOption)this.options[17]).getValue();
    }

    public boolean useFancyhdr() {
        return ((BooleanOption)this.options[18]).getValue();
    }

    public boolean useHyperref() {
        return ((BooleanOption)this.options[19]).getValue();
    }

    public boolean useCaption() {
        return ((BooleanOption)this.options[20]).getValue();
    }

    public boolean useLongtable() {
        return ((BooleanOption)this.options[21]).getValue();
    }

    public boolean useSupertabular() {
        return ((BooleanOption)this.options[22]).getValue();
    }

    public boolean useTabulary() {
        return ((BooleanOption)this.options[23]).getValue();
    }

    public boolean useEndnotes() {
        return ((BooleanOption)this.options[24]).getValue();
    }

    public boolean useUlem() {
        return ((BooleanOption)this.options[25]).getValue();
    }

    public boolean useLastpage() {
        return ((BooleanOption)this.options[26]).getValue();
    }

    public boolean useTitleref() {
        return ((BooleanOption)this.options[27]).getValue();
    }

    public boolean useOooref() {
        return ((BooleanOption)this.options[28]).getValue();
    }

    public boolean useBibtex() {
        return ((BooleanOption)this.options[29]).getValue();
    }

    public String bibtexStyle() {
        return this.options[30].getString();
    }

    public int formatting() {
        return ((IntegerOption)this.options[31]).getValue();
    }

    public int pageFormatting() {
        return ((IntegerOption)this.options[32]).getValue();
    }

    public int otherStyles() {
        return ((IntegerOption)this.options[33]).getValue();
    }

    public int imageContent() {
        return ((IntegerOption)this.options[34]).getValue();
    }

    public int tableContent() {
        return ((IntegerOption)this.options[35]).getValue();
    }

    public boolean ignoreHardPageBreaks() {
        return ((BooleanOption)this.options[36]).getValue();
    }

    public boolean ignoreHardLineBreaks() {
        return ((BooleanOption)this.options[37]).getValue();
    }

    public boolean ignoreEmptyParagraphs() {
        return ((BooleanOption)this.options[38]).getValue();
    }

    public boolean ignoreDoubleSpaces() {
        return ((BooleanOption)this.options[39]).getValue();
    }

    public boolean alignFrames() {
        return ((BooleanOption)this.options[40]).getValue();
    }

    public boolean floatFigures() {
        return ((BooleanOption)this.options[41]).getValue();
    }

    public boolean floatTables() {
        return ((BooleanOption)this.options[42]).getValue();
    }

    public String getFloatOptions() {
        return this.options[43].getString();
    }

    public String getFigureSequenceName() {
        return this.options[44].getString();
    }

    public String getTableSequenceName() {
        return this.options[45].getString();
    }

    public String getImageOptions() {
        return this.options[46].getString();
    }

    public boolean removeGraphicsExtension() {
        return ((BooleanOption)this.options[47]).getValue();
    }

    public boolean keepImageSize() {
        return ((BooleanOption)this.options[48]).getValue();
    }

    public int getSimpleTableLimit() {
        return ((IntegerOption)this.options[49]).getValue();
    }

    public int notes() {
        return ((IntegerOption)this.options[50]).getValue();
    }

    public String getNotesCommand() {
        return this.options[50].getString();
    }

    public String getTabstop() {
        return this.options[51].getString();
    }

    public int getWrapLinesAfter() {
        return ((IntegerOption)this.options[52]).getValue();
    }

    public boolean splitLinkedSections() {
        return ((BooleanOption)this.options[53]).getValue();
    }

    public boolean splitToplevelSections() {
        return ((BooleanOption)this.options[54]).getValue();
    }

    public boolean xhtmlNoDoctype() {
        return ((BooleanOption)this.options[55]).getValue();
    }

    public String xhtmlEncoding() {
        return this.options[56].getString();
    }

    public String xhtmlCustomStylesheet() {
        return this.options[57].getString();
    }

    public int xhtmlFormatting() {
        return ((XhtmlFormatOption)this.options[58]).getValue();
    }

    public int xhtmlFrameFormatting() {
        return ((XhtmlFormatOption)this.options[59]).getValue();
    }

    public int xhtmlSectionFormatting() {
        return ((XhtmlFormatOption)this.options[60]).getValue();
    }

    public int xhtmlTableFormatting() {
        return ((XhtmlFormatOption)this.options[61]).getValue();
    }

    public boolean xhtmlIgnoreTableDimensions() {
        return ((BooleanOption)this.options[62]).getValue();
    }

    public boolean xhtmlUseDublinCore() {
        return ((BooleanOption)this.options[63]).getValue();
    }

    public boolean xhtmlConvertToPx() {
        return ((BooleanOption)this.options[64]).getValue();
    }

    public String getXhtmlScaling() {
        return this.options[65].getString();
    }

    public String getXhtmlColumnScaling() {
        return this.options[66].getString();
    }

    public boolean xhtmlFloatObjects() {
        return ((BooleanOption)this.options[67]).getValue();
    }

    public String getXhtmlTabstopStyle() {
        return this.options[68].getString();
    }

    public boolean xhtmlUseListHack() {
        return ((BooleanOption)this.options[69]).getValue();
    }

    public int getXhtmlSplitLevel() {
        return ((IntegerOption)this.options[70]).getValue();
    }

    public boolean xhtmlCalcSplit() {
        return ((BooleanOption)this.options[71]).getValue();
    }

    public String getXhtmlUplink() {
        return this.options[72].getString();
    }

    public String getXhtmlDirectoryIcon() {
        return this.options[73].getString();
    }

    public String getXhtmlDocumentIcon() {
        return this.options[74].getString();
    }

    public Hashtable getMathSymbols() {
        return this.mathSymbols;
    }

    public StyleMap getParStyleMap() {
        return this.par;
    }

    public StyleMap getParBlockStyleMap() {
        return this.parBlock;
    }

    public StyleMap getTextStyleMap() {
        return this.text;
    }

    public StyleMap getListStyleMap() {
        return this.list;
    }

    public StyleMap getListItemStyleMap() {
        return this.listItem;
    }

    public HeadingMap getHeadingMap() {
        return this.headingMap;
    }

    public LinkedList getCustomPreamble() {
        return this.customPreamble;
    }

    public XhtmlStyleMap getXParStyleMap() {
        return this.xpar;
    }

    public XhtmlStyleMap getXTextStyleMap() {
        return this.xtext;
    }

    public XhtmlStyleMap getXFrameStyleMap() {
        return this.xframe;
    }

    public XhtmlStyleMap getXListStyleMap() {
        return this.xlist;
    }

    public XhtmlStyleMap getXAttrStyleMap() {
        return this.xattr;
    }

    private void writeStyleMap(Document dom, StyleMap sm, String sClass) {
        Enumeration smEnum = sm.getNames();
        while (smEnum.hasMoreElements()) {
            String sName = (String)smEnum.nextElement();
            Element smNode = dom.createElement("style-map");
            smNode.setAttribute("name", sName);
            smNode.setAttribute("class", sClass);
            smNode.setAttribute("before", sm.getBefore(sName));
            smNode.setAttribute("after", sm.getAfter(sName));
            if (sm.getNext(sName) != null) {
                smNode.setAttribute("next", sm.getNext(sName));
            }
            if (!sm.getLineBreak(sName)) {
                smNode.setAttribute("line-break", "false");
            }
            if (sm.getVerbatim(sName)) {
                smNode.setAttribute("verbatim", "true");
            }
            dom.getDocumentElement().appendChild(smNode);
        }
    }

    private void writeXStyleMap(Document dom, XhtmlStyleMap sm, String sClass) {
        Enumeration smEnum = sm.getNames();
        while (smEnum.hasMoreElements()) {
            String sBlockCss;
            String sName = (String)smEnum.nextElement();
            Element smNode = dom.createElement("xhtml-style-map");
            smNode.setAttribute("name", sName);
            smNode.setAttribute("class", sClass);
            smNode.setAttribute("element", sm.getElement(sName));
            smNode.setAttribute("css", sm.getCss(sName));
            String sBlockElement = sm.getBlockElement(sName);
            if (sBlockElement != null) {
                smNode.setAttribute("block-element", sm.getCss(sBlockElement));
            }
            if ((sBlockCss = sm.getBlockCss(sName)) != null) {
                smNode.setAttribute("block-css", sm.getCss(sBlockCss));
            }
            dom.getDocumentElement().appendChild(smNode);
        }
    }

    private void writeContent(Document dom, LinkedList list, String sElement) {
        Element node = dom.createElement(sElement);
        int nLen = list.size();
        int i = 0;
        while (i < nLen) {
            node.appendChild(dom.createTextNode((String)list.get(i)));
            ++i;
        }
        dom.getDocumentElement().appendChild(node);
    }

    static {
        GENERIC = 0;
        DVIPS = 1;
        PDFTEX = 2;
        UNSPECIFIED = 3;
        IGNORE_ALL = 0;
        IGNORE_MOST = 1;
        CONVERT_BASIC = 2;
        CONVERT_MOST = 3;
        CONVERT_ALL = 4;
        IGNORE_STYLES = 6;
        IGNORE_HARD = 7;
        CONVERT_HEADER_FOOTER = 5;
        IGNORE = 0;
        ACCEPT = 1;
        WARNING = 2;
        ERROR = 3;
        COMMENT = 1;
        PDFANNOTATION = 2;
        MARGINPAR = 3;
        CUSTOM = 4;
        BACKEND = 0;
        NO_PREAMBLE = 1;
        NO_INDEX = 2;
        DOCUMENTCLASS = 3;
        GLOBAL_OPTIONS = 4;
        INPUTENCODING = 5;
        MULTILINGUAL = 6;
        GREEK_MATH = 7;
        USE_OOOMATH = 8;
        USE_PIFONT = 9;
        USE_IFSYM = 10;
        USE_WASYSYM = 11;
        USE_BBDING = 12;
        USE_EUROSYM = 13;
        USE_TIPA = 14;
        USE_COLOR = 15;
        USE_COLORTBL = 16;
        USE_GEOMETRY = 17;
        USE_FANCYHDR = 18;
        USE_HYPERREF = 19;
        USE_CAPTION = 20;
        USE_LONGTABLE = 21;
        USE_SUPERTABULAR = 22;
        USE_TABULARY = 23;
        USE_ENDNOTES = 24;
        USE_ULEM = 25;
        USE_LASTPAGE = 26;
        USE_TITLEREF = 27;
        USE_OOOREF = 28;
        USE_BIBTEX = 29;
        BIBTEX_STYLE = 30;
        FORMATTING = 31;
        PAGE_FORMATTING = 32;
        OTHER_STYLES = 33;
        IMAGE_CONTENT = 34;
        TABLE_CONTENT = 35;
        IGNORE_HARD_PAGE_BREAKS = 36;
        IGNORE_HARD_LINE_BREAKS = 37;
        IGNORE_EMPTY_PARAGRAPHS = 38;
        IGNORE_DOUBLE_SPACES = 39;
        ALIGN_FRAMES = 40;
        FLOAT_FIGURES = 41;
        FLOAT_TABLES = 42;
        FLOAT_OPTIONS = 43;
        FIGURE_SEQUENCE_NAME = 44;
        TABLE_SEQUENCE_NAME = 45;
        IMAGE_OPTIONS = 46;
        REMOVE_GRAPHICS_EXTENSION = 47;
        KEEP_IMAGE_SIZE = 48;
        SIMPLE_TABLE_LIMIT = 49;
        NOTES = 50;
        TABSTOP = 51;
        WRAP_LINES_AFTER = 52;
        SPLIT_LINKED_SECTIONS = 53;
        SPLIT_TOPLEVEL_SECTIONS = 54;
        XHTML_NO_DOCTYPE = 55;
        XHTML_ENCODING = 56;
        XHTML_CUSTOM_STYLESHEET = 57;
        XHTML_FORMATTING = 58;
        XHTML_FRAME_FORMATTING = 59;
        XHTML_SECTION_FORMATTING = 60;
        XHTML_TABLE_FORMATTING = 61;
        XHTML_IGNORE_TABLE_DIMENSIONS = 62;
        XHTML_USE_DUBLIN_CORE = 63;
        XHTML_CONVERT_TO_PX = 64;
        XHTML_SCALING = 65;
        XHTML_COLUMN_SCALING = 66;
        XHTML_FLOAT_OBJECTS = 67;
        XHTML_TABSTOP_STYLE = 68;
        XHTML_USE_LIST_HACK = 69;
        XHTML_SPLIT_LEVEL = 70;
        XHTML_CALC_SPLIT = 71;
        XHTML_UPLINK = 72;
        XHTML_DIRECTORY_ICON = 73;
        XHTML_DOCUMENT_ICON = 74;
        DEBUG = 75;
        OPTION_COUNT = 76;
    }
}

