/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import writer2latex.util.CSVList;
import writer2latex.xmerge.OfficeDocument;

public class MetaData {
    private String sTitle = "";
    private String sCreator = "";
    private String sInitialCreator = "";
    private String sDate = "";
    private String sDescription = "";
    private String sLanguage = "";
    private String sSubject = "";
    private String sKeywords = "";

    public MetaData(OfficeDocument oooDoc) {
        NodeList list;
        Document dom = oooDoc.getMetaDOM();
        if (dom == null) {
            dom = oooDoc.getContentDOM();
        }
        if ((list = dom.getElementsByTagName("office:meta")).getLength() == 0) {
            return;
        }
        Node meta = list.item(0);
        if (!meta.hasChildNodes()) {
            return;
        }
        CSVList keywords = new CSVList(", ");
        list = meta.getChildNodes();
        int nLen = list.getLength();
        int i = 0;
        while (i < nLen) {
            Node child = list.item(i);
            String sName = child.getNodeName();
            if ("dc:title".equals(sName)) {
                this.sTitle = this.getContent(child);
            }
            if ("dc:creator".equals(sName)) {
                this.sCreator = this.getContent(child);
            }
            if ("dc:date".equals(sName)) {
                this.sDate = this.getContent(child);
            }
            if ("dc:description".equals(sName)) {
                this.sDescription = this.getContent(child);
            }
            if ("dc:language".equals(sName)) {
                this.sLanguage = this.getContent(child);
            }
            if ("dc:subject".equals(sName)) {
                this.sSubject = this.getContent(child);
            }
            if ("meta:initial-creator".equals(sName)) {
                this.sInitialCreator = this.getContent(child);
            }
            if ("meta:keyword".equals(sName)) {
                keywords.addValue(this.getContent(child));
            }
            if ("meta:keywords".equals(sName) && child.hasChildNodes()) {
                NodeList keywordList = child.getChildNodes();
                int nWordCount = keywordList.getLength();
                int j = 0;
                while (j < nWordCount) {
                    Node grandchild = keywordList.item(j);
                    if ("meta:keyword".equals(grandchild.getNodeName())) {
                        keywords.addValue(this.getContent(grandchild));
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.sKeywords = keywords.toString();
    }

    public String getTitle() {
        return this.sTitle;
    }

    public String getCreator() {
        return this.sCreator == null ? this.sInitialCreator : this.sCreator;
    }

    public String getInitialCreator() {
        return this.sInitialCreator;
    }

    public String getDate() {
        return this.sDate;
    }

    public String getDescription() {
        return this.sDescription;
    }

    public String getLanguage() {
        return this.sLanguage;
    }

    public String getSubject() {
        return this.sSubject;
    }

    public String getKeywords() {
        return this.sKeywords;
    }

    private String getContent(Node node) {
        if (!node.hasChildNodes()) {
            return null;
        }
        String s = "";
        NodeList list = node.getChildNodes();
        int nLen = list.getLength();
        int i = 0;
        while (i < nLen) {
            if (list.item(i).getNodeType() == 3) {
                s = s + list.item(i).getNodeValue();
            }
            ++i;
        }
        return s;
    }
}

