#!/bin/bash
set -e -u

#write something into changelog
dch -e
#do it again to check for errors (script will exit on error)
dch -e

STARTDIR=$(pwd)

PKGDIR=./release
mkdir -p $PKGDIR

VERSION=`awk -F, '/AC_INIT/ {print $2}' ./configure.ac`
TARBALL="./webcontentcontrol-$VERSION.tar.gz"
TARBALL2="./webcontentcontrol_$VERSION.orig.tar.gz"

DEB="./webcontentcontrol_$VERSION-1_i386.deb"
DEB2="./webcontentcontrol_$VERSION-0ubuntu1_i386.deb"

echo "PKGDIR=$PKGDIR"
echo "VERSION=$VERSION"
echo "TARBALL=$TARBALL"
echo "DEB=$DEB"

./testing/make_tarball.sh .
./testing/make_deb.sh $TARBALL $PKGDIR 

#cp $TARBALL $PKGDIR
cd $PKGDIR

echo "Signing tarball for launchpad upload:"
gpg --armor --sign --detach-sig $TARBALL2
echo "Signing .deb for launchpad upload:"
gpg --armor --sign --detach-sig $DEB2

#confirm results visually
echo "============"
ls -lrt
echo "============"

#Upload to PPA :)
dput zohn-joidberg webcontentcontrol_$VERSION-0ubuntu1_source.changes

#Return to initial dir
cd $STARTDIR
echo "Current directory=$(pwd)"

./testing/increment_version.sh

