#!/bin/bash
set -e -u
echo "tarball=$1"
echo "pkg_dir=$2"

DIR=`dirname $1`
EXTRACTED=`basename $1 .tar.gz`
PKG_DIR=$2
mkdir -p $PKG_DIR

if [ -e $PKG_DIR/$EXTRACTED ]
then
    echo "$PKG_DIR/$EXTRACTED exists. Do you want to remove it? (y/n/q)"
    read ans
    case $ans in
    y|Y|yes) rm -rf $PKG_DIR/$EXTRACTED && echo "$PKG_DIR/$EXTRACTED removed.";;
    q) echo "exiting" && exit 1;;
    *) echo "Ok, not removing it.";;
    esac
fi

tar -xzvf $1 -C $PKG_DIR
cp -v $1 $PKG_DIR/$EXTRACTED.orig.tar.gz
rename -v 's/-/_/g' $PKG_DIR/$EXTRACTED.orig.tar.gz
cd $PKG_DIR/$EXTRACTED

export DEBFULLNAME="John Zoidberg"
dh_make -a -n -s -e zohn.joidberg@gmail.com -c gpl
rm debian/*.ex debian/*.EX
rm debian/README debian/README.Debian
#fakeroot debian/rules clean
#debian/rules build
#fakeroot debian/rules binary
#cat debian/webcontentcontrol/DEBIAN/control
#debuild -us -uc

#create&sign .deb
debuild
#create&sign .tar.gz
debuild -S

