#!/bin/bash

function check_fh {
    ## FireHol
    if ( test -f /var/lock/firehol || test -f /var/lock/subsys/firehol );
    then fh_running=1 && echo "FireHol is running" && return 1;
    else fh_running=0 && echo "FireHol is stopped" && return 0;
    fi
}

function check_tp {
    ## TinyProxy
    pid_tp="`pidof tinyproxy | tr -d [:space:]`"
    if (test -z $pid_tp);
    then tp_running=0 && echo "TinyProxy is stopped" && return 0;
    else tp_running=1 && echo "TinyProxy is running" && return 1;
    fi
}

function check_dg {
    ## DansGuardian
    pid_dg="`pidof dansguardian | tr -d [:space:]`"
    if (test -z $pid_dg);
    then dg_running=0 && echo "DansGuardian is stopped" && return 0;
    else dg_running=1 && echo "DansGuardian is running" && return 1;
    fi
}

function check_sq {
    ## squid
    pid_dg="`pidof squid | tr -d [:space:]`"
    if (test -z $pid_dg);
    then sq_running=0 && echo "squid is stopped" && return 0;
    else sq_running=1 && echo "squid is running" && return 1;
    fi
}

function check_all {
    check_fh
    check_tp
    check_dg
}

function start_all {
    check_all
    ## Starts what it not running
    ## Firehol
    if (test $fh_running -eq 0);
    then gksudo /etc/init.d/firehol start;
    else echo "FireHol already running";
    fi

    ## TinyProxy
    if (test $tp_running -eq 0);
    then gksudo /etc/init.d/tinyproxy start;
    else echo "TinyProxy already running";
    fi

    ## DansGuardian
    if (test $dg_running -eq 0);
    then gksudo /etc/init.d/dansguardian start;
    else echo "DansGuardian already running";
    fi
}

function restart_all_nogui {
    /etc/init.d/firehol restart;
    /etc/init.d/tinyproxy restart;
    /etc/init.d/dansguardian restart;
}

function stop_all {
    gksudo /etc/init.d/firehol stop;
    gksudo /etc/init.d/tinyproxy stop;
    gksudo /etc/init.d/dansguardian stop;
}

function start_all_nogui {
    ## Starts what it is not running
    ## Firehol
    if (test -z $fh_running);
    then /etc/init.d/firehol start;
    else echo "FireHol already running";
    fi

    ## TinyProxy
    if (test -z $tp_running);
    then /etc/init.d/tinyproxy start;
    else echo "TinyProxy already running";
    fi

    ## DansGuardian
    if (test -z $dg_running);
    then /etc/init.d/dansguardian start;
    else echo "DansGuardian already running";
    fi
}

function stop_all_nogui {
    /etc/init.d/firehol stop;
    /etc/init.d/tinyproxy stop;
    /etc/init.d/dansguardian stop;
}

function startcheck {
    check_all
    if (test $fh_running -eq 1) && (test $tp_running -eq 1) && (test $dg_running -eq 1);
    then
	echo "All OK! Everything is running"
	return 0
    else
	echo "There was an error"
	return 1
    fi
}

function stopcheck {
    check_all
    if (test $fh_running -eq 0) && (test $tp_running -eq 0) && (test $dg_running -eq 0);
    then
	echo "All OK! Everything was stopped"
	return 0
    else
	echo "There was an error"
	return 1
    fi
}

ProcessAllow()
{
    FILE=$1
    USERNAME=$2
    TMP=$(mktemp)
    cp -v $FILE $TMP
    sed -i '/^$/ d' $TMP
    sed -i '/^#/ d' $TMP
    nlines=$(wc -l $TMP | awk '{print $1}')
    echo nlines=$nlines
    echo "=============="
    cat $TMP
    echo "=============="
    if [ $nlines -ne 0 ]
    then
	echo "Processing groups from $FILE"
	#add user to allowed groups
	cat $TMP | xargs -n1 yourpath/add_user_to_group.sh $USERNAME
	return 0
    else
	echo "$FILE does not contain any groups"
	return 1
    fi
}

ProcessBan()
{
    FILE=$1
    USERNAME=$2
    TMP=$(mktemp)
    cp -v $FILE $TMP
    sed -i '/^$/ d' $TMP
    sed -i '/^#/ d' $TMP
    nlines=$(wc -l $TMP | awk '{print $1}')
    echo nlines=$nlines
    echo "=============="
    cat $TMP
    echo "=============="
    if [ $nlines -ne 0 ]
    then
	echo "Processing groups from $FILE"
	#remove user from banned groups
	cat $TMP | xargs -n1 yourpath/remove_user_from_group.sh $USERNAME
	return 0
    else
	echo "$FILE does not contain any groups"
	return 1
    fi
}
