#!/bin/bash

THIS_SCRIPT=`basename $0`
PLACEHOLDER="yourpath"
DIR=.
TMP=`mktemp` || ( echo "ERROR: Could not create temporary file." && exit 1 )

#adapts variables for use with sed
adapt_var()
{
    echo $1 >$TMP
    sed -i 's/\/$//g' $TMP #replace trailing "/"
    sed -i 's/\//\\\//g' $TMP #replace "/" with "\/"
}

# adapt_var $1
# var=`cat $TMP`
# echo $var
# exit 0

if [ $# -lt 1 ] || [ $# -gt 3 ]
then
        echo "usage : $0 <$PLACEHOLDER> [placeholder=$PLACEHOLDER] [DIR=.]"
	echo "Replaces placeholder with $PLACEHOLDER in all files except this script."
        exit 0
fi

#check that all temporary files are read-write
if ! ( [ -r $TMP ] && [ -w $TMP ] )
then
    echo "ERROR: $TMP does not have read/write permissions"
    exit -1
fi

if [ $# -eq 2 ]
then
	PLACEHOLDER=$2
fi
if [ $# -eq 3 ]
then
	PLACEHOLDER=$2
	DIR=$3
fi

#adapt variables for sed
adapt_var $1
REPLACEMENT=`cat $TMP`
adapt_var $PLACEHOLDER
PLACEHOLDER2=`cat $TMP`

cd $DIR
find . -type f | grep -v $THIS_SCRIPT | xargs -n1 sed -i s/$PLACEHOLDER2/$REPLACEMENT/g
