#include <glib/gi18n.h>
#include <locale.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

//#define LABEL_TEXT "\n　起動中です　\n"
#define LABEL_TEXT _("起動中です")
//#define LABEL_TEXT _("starting")
#define WAIT_TIME 7000
#define STR_BUF 4096
#define GETTEXT_PACKAGE "wbar"

 void exec_application(int argc, char *argv[])
{
	int i;
	char buf[STR_BUF];
	int pos;
	pid_t pid;

	pos = 0;
	buf[0] = '\0';
	for(i = 1; i < argc - 2; i++)
	{
		if(i > 1)
			buf[pos++] = ' ';
		strcpy(&buf[pos], argv[i]);
		pos += strlen(argv[i]);
		buf[pos] = '\0';
	}

	pid = fork();
	if(pid != 0)
	{
		printf("exec:%s\n", buf);
		if(execlp("sh", "sh", "-c", buf, NULL) == -1)
		{
			fprintf(stderr, "can't exec program");
			exit(-2);
		}
	}
}

static gint cb_timer_event(gpointer data)
{
	gtk_main_quit();

	return 1;
}

static int init_gui(int argc, char *argv[])
{
	GtkWidget *window;
	GtkWidget *fixed;
	GtkWidget *label;
	GtkWidget *image;
	GtkWidget *txt;

	window = gtk_window_new(GTK_WINDOW_POPUP);
	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER_ALWAYS);
	gtk_window_set_decorated(GTK_WINDOW(window), FALSE);

	/*  label = gtk_label_new(LABEL_TEXT);
	    gtk_container_add(GTK_CONTAINER(window), label);
	 */
	fixed = gtk_fixed_new ();
	gtk_widget_show (fixed);
	gtk_container_add (GTK_CONTAINER (window), fixed);

	label = gtk_label_new (LABEL_TEXT);
	gtk_widget_show (label);
	gtk_fixed_put (GTK_FIXED (fixed), label, 100, 16);
	gtk_widget_set_size_request (label, 78, 18);
	//printf("icon path :%s\n",argv[argc-1]);
	image = gtk_image_new_from_file (argv[2]);
	// image->pixel-size = 80;

	gtk_widget_set_size_request (image, 120, 120);  
	gtk_fixed_put (GTK_FIXED (fixed), image, 30, 30);

	printf("argv1 :%s  argv0:%s  argv2:%s argv3:%s \n", argv[1], argv[0], argv[2], argv[3]);
	txt = gtk_label_new (argv[3]);
	gtk_widget_show (txt);
	gtk_fixed_put (GTK_FIXED (fixed), txt, 150, 70);
	gtk_widget_set_size_request (txt, 110, 18);

	gtk_widget_show_all(window);
	return 1;
}

int main(int argc, char *argv[])
{

	gint timer_id;
	if(argc < 2)
	{
		fprintf(stderr, "argc error\n");
		return -1;
	}

	gtk_init(&argc, &argv);

	setlocale(LC_ALL,"");
	bindtextdomain(GETTEXT_PACKAGE, "/usr/share/locale");
	textdomain(GETTEXT_PACKAGE);

	if(init_gui(argc , argv) == 0)
	{
		return -2;
	}
	timer_id = gtk_timeout_add(WAIT_TIME, (GtkFunction)cb_timer_event, NULL);

	exec_application(argc, argv);
	gtk_main();

	gtk_timeout_remove(timer_id);

	return 0;
}



