/* Copyright 2011 Canonical, Ltd. This software is licensed under the GNU
 * Lesser General Public License version 3 or later (see the file COPYING).
 */

#ifndef UTOUCH_QML_UTOUCHPINCHAREA_H_
#define UTOUCH_QML_UTOUCHPINCHAREA_H_

#include "continuousgesturearea.h"

/**
 * An input-only item for receiving non-instantaneous pinch gesture events.
 */

class UTouchPinchArea : public ContinuousGestureArea {
  Q_OBJECT
  /**
   * This property holds the average radius of the touches.
   */
  Q_PROPERTY(GestureProperty* radius READ radius CONSTANT)

 public:
  explicit UTouchPinchArea(QDeclarativeItem* parent = 0);

  GestureProperty* radius() { return &radius_; }

  virtual bool IsGestureEventHandled(GestureEvent* event);
  virtual void HandleGestureUpdateEvent(bool end, GestureEvent* event);

 private:
  GestureProperty radius_;

  Q_DISABLE_COPY(UTouchPinchArea)
};

QML_DECLARE_TYPE(UTouchPinchArea)

#endif  // UTOUCH_QML_UTOUCHPINCHAREA_H_
