/*
* Copyright 2012-15 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Authors: AMD
 *
 */

#ifndef __DC_RESOURCE_DCE110_H__
#define __DC_RESOURCE_DCE110_H__

#include "core_types.h"

struct core_dc;
struct resource_pool;

#define TO_DCE110_RES_POOL(pool)\
	container_of(pool, struct dce110_resource_pool, base)

struct dce110_resource_pool {
	struct resource_pool base;
};

enum dc_status dce110_resource_build_pipe_hw_param(struct pipe_ctx *pipe_ctx);

void dce110_resource_build_bit_depth_reduction_params(
		const struct core_stream *stream,
		struct bit_depth_reduction_params *fmt_bit_depth);

struct resource_pool *dce110_create_resource_pool(
	uint8_t num_virtual_links,
	struct core_dc *dc,
	struct hw_asic_id asic_id);

#endif /* __DC_RESOURCE_DCE110_H__ */

