#!/bin/bash

TITLE="AMDGPU Driver Updater"
INSTALLED_DRIVER="AMDGPU Driver"
PACKAGE="update-amd-pro-nonpro-16.60-423303"
INSTALL_SCRIPT="$PACKAGE.sh"
AUTOSTART_CONF="$PACKAGE.desktop"
PACKAGE_FOLDER="/usr/share/$PACKAGE"
LOG_FILE="/var/log/$PACKAGE.log"
FAILED="Failed!\n\nCheck $LOG_FILE for details.\n"
AMD_PX_SCRIPT="/opt/amdgpu-pro/bin/amdgpu-pro-px"
AMD_PX_CONF="/etc/X11/xorg.conf.d/01-amdgpu-pro-px.conf"
UPDATE_SB_SCRIPT="/usr/sbin/update-secureboot-policy"
RELEASE_NOTE="/usr/share/$PACKAGE/release_note"
zenity_height=220
note=""

disable_updater() {
    if [ -f /etc/xdg/autostart/$AUTOSTART_CONF ]; then
        rm -f /etc/xdg/autostart/$AUTOSTART_CONF
    fi
    if [ -f /usr/bin/$INSTALL_SCRIPT ]; then
        rm -f /usr/bin/$INSTALL_SCRIPT
    fi
}

if [ "$(id -u)" != '0' ]; then
    if [ -f $RELASE_NOTE ]; then
        note=`cat $RELEASE_NOTE`
        lines=`cat $RELEASE_NOTE | wc -l`
        zenity_height=$((zenity_height + 15 * lines))
    fi

    ans=""
    if [ -f $LOG_FILE ]; then
        ans=$(zenity --height=220 --list --title "$TITLE" --text "Failed to upgrade $INSTALLED_DRIVER in last update!!\nCheck $LOG_FILE for details.\nIf you don't want to try again, please select [No. Thanks] to disable $TITLE." --radiolist  --column "Pick" --column "Opinion" TRUE "Upgarde Now" FALSE "Remind Me Later" FALSE "No. Thanks") || exit;
    else
        ans=$(zenity --height="$zenity_height" --list --title "$TITLE" --text "Found new $INSTALLED_DRIVER, do you want to upgrade to newer version?\n\n$note" --radiolist  --column "Pick" --column "Opinion" TRUE "Upgarde Now" FALSE "Remind Me Later") || exit;
    fi
    if [ "$ans" = "Upgarde Now" ]; then
        zenity --info --title "$TITLE" --text="\nYou need to authenticate to upgrade $INSTALLED_DRIVER"
    elif [ "$ans" = "Remind Me Later" ]; then
        echo "$TITLE: Remind Me Later"
        exit 0
    elif [ "$ans" = "No. Thanks" ]; then
        zenity --info --title "$TITLE" --text="\nYou need to authenticate to disable $TITLE"
    fi
    pkexec env DISPLAY=$DISPLAY XAUTHORITY=$XAUTHORITY /usr/bin/$INSTALL_SCRIPT "$ans"
    exit
else
    if [ ! "$#" = "1" ]; then
        echo "$TITLE: Illegal number of parameters!!"
        exit 0
    elif [ "$1" = "No. Thanks" ]; then
        echo "$TITLE: No. Thanks"
        disable_updater
        exit 0
    elif [ ! "$1" = "Upgarde Now" ]; then
        echo "$TITLE: Error!! Should never be here!!"
        exit 0
    fi
fi

(
export LANG=C
set -x -e

# Check what kind of driver we need? amdgpu-pro or amdpgu
amdgpu_type="amdgpu-pro"
dpkg -l | grep -e "libgl.*amdgpu-pro" > /dev/null || amdgpu_type="amdgpu"

echo "# Extracting $PACKAGE_FOLDER/${amdgpu_type}*.xz"
mkdir -p /tmp/$PACKAGE/
driver_tarball=$(basename $(ls $PACKAGE_FOLDER/${amdgpu_type}*.xz)) || (echo "# $FAILED" && exit 1);
driver_extracted_folder=${driver_tarball%.*.*}
[ -e $PACKAGE_FOLDER/$driver_tarball ] || (echo "# $FAILED" && exit 1);
tar xf $PACKAGE_FOLDER/$driver_tarball -C /tmp/$PACKAGE/ || (echo "# $FAILED" && exit 1);
[ -d /tmp/$PACKAGE/$driver_extracted_folder ] || (echo "# $FAILED" && exit 1);

echo "# Wait for Software Updater to exit..."
while fuser /var/lib/dpkg/lock; do sleep 1; done

echo "# Upgrading driver...\n\nPlease do not power off or unplug your machine."

# Workaround: Create fake update-secureboot-policy to avoid it from disabling secure boot
if [ -f "$UPDATE_SB_SCRIPT" ] && [ `cat $UPDATE_SB_SCRIPT | grep "Fake $UPDATE_SB_SCRIPT" | wc -l` -ne 1 ]; then
    mv $UPDATE_SB_SCRIPT $UPDATE_SB_SCRIPT.tmp
cat << EOF > $UPDATE_SB_SCRIPT
#!/bin/sh
echo "Fake $UPDATE_SB_SCRIPT!!"
exit 0
EOF
    chmod +x $UPDATE_SB_SCRIPT
fi

if [ "$amdgpu_type" == "amdgpu-pro" ]; then
    if [ -f $AMD_PX_SCRIPT ]; then
        peformance_mode=2
        if [ -f $AMD_PX_CONF ]; then
            performance_mode=`cat $AMD_PX_CONF | grep "RenderDriver" | grep "amdgpu" | wc -l`
        fi
        yes|/tmp/$PACKAGE/$driver_extracted_folder/amdgpu-pro-install --px || (echo "# $FAILED" && exit 1);
        # Launch xterm to run install script or dpkg command in case of popup window of "Configuring Secure Boot"
        #xterm -title "$TITLE" -e "/tmp/$PACKAGE/$driver_extracted_folder/amdgpu-pro-install --px" || (echo "# $FAILED" && exit 1);
        if [ x$performance_mode = x0 ]; then
            $AMD_PX_SCRIPT --mode powersaving
        elif [ x$performance_mode = x1 ]; then
            $AMD_PX_SCRIPT --mode performance
        fi
    else
        yes|/tmp/$PACKAGE/$driver_extracted_folder/amdgpu-pro-install || (echo "# $FAILED" && exit 1);
        #xterm -title "$TITLE" -e "/tmp/$PACKAGE/$driver_extracted_folder/amdgpu-pro-install" || (echo "# $FAILED" && exit 1);
    fi
else
    dpkg --skip-same-version -i /tmp/$PACKAGE/$driver_extracted_folder/*.deb || (echo "# $FAILED" && exit 1);
    #xterm -title "$TITLE" -e "dpkg --skip-same-version -i /tmp/$PACKAGE/$driver_extracted_folder/*.deb" || (echo "# $FAILED" && exit 1);
fi

# Workaround: Restore udpate-secureboot-policy
if [ -f "$UPDATE_SB_SCRIPT.tmp" ]; then
    mv $UPDATE_SB_SCRIPT.tmp $UPDATE_SB_SCRIPT
fi

rm -rf /tmp/$PACKAGE/

disable_updater

echo "# Succeeded!\n\nPlease reboot the system.\n"
) |& tee $LOG_FILE | sed 's/^[0-9]\+.*[^0-9]\+/hack \0/g' |
zenity --progress \
  --title="$TITLE" \
  --text="Running...\n\nPlease keep your PC/laptop on until this is done\n" \
  --pulsate \
  --auto-kill \
  --no-cancel

(( $? != 0 )) && zenity --error --text="$FAILED"

exit 0
