/* unity-place.c generated by valac 0.10.0, the Vala compiler
 * generated from unity-place.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */
/*
 * IMPLEMENTATION NOTE:
 * It may appear this code it is bit more bloated than it needs to be
 * (considering the pure number of classes and indirections), but this has
 * some good reasons.
 *
 * Firstly we want to hide away Vala's internal DBus marshalling which would
 * expose raw structs in the API. These structs are hidden away in _RendererInfo,
 * and _EntryInfo. We wrap these in handy GObjects with properties and what not.
 * In fact we want to hide all DBusisms, which is also why the DBus interfaces
 * are declared private.
 *
 * Secondly we want the generatedd C API to be nice and not too Vala-ish. We
 * must anticipate that place daemons consuming libunity will be written in
 * both Vala and C.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dee.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus.h>
#include <gio/gio.h>
#include <gee.h>


#define UNITY_PLACE_TYPE__RENDERERINFO (unity_place__rendererinfo_get_type ())
typedef struct _UnityPlace_RendererInfo UnityPlace_RendererInfo;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define UNITY_PLACE_TYPE_RENDERER_INFO (unity_place_renderer_info_get_type ())
#define UNITY_PLACE_RENDERER_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACE_TYPE_RENDERER_INFO, UnityPlaceRendererInfo))
#define UNITY_PLACE_RENDERER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACE_TYPE_RENDERER_INFO, UnityPlaceRendererInfoClass))
#define UNITY_PLACE_IS_RENDERER_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACE_TYPE_RENDERER_INFO))
#define UNITY_PLACE_IS_RENDERER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACE_TYPE_RENDERER_INFO))
#define UNITY_PLACE_RENDERER_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACE_TYPE_RENDERER_INFO, UnityPlaceRendererInfoClass))

typedef struct _UnityPlaceRendererInfo UnityPlaceRendererInfo;
typedef struct _UnityPlaceRendererInfoClass UnityPlaceRendererInfoClass;
typedef struct _UnityPlaceRendererInfoPrivate UnityPlaceRendererInfoPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define UNITY_PLACE_TYPE_SEARCH (unity_place_search_get_type ())
#define UNITY_PLACE_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACE_TYPE_SEARCH, UnityPlaceSearch))
#define UNITY_PLACE_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACE_TYPE_SEARCH, UnityPlaceSearchClass))
#define UNITY_PLACE_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACE_TYPE_SEARCH))
#define UNITY_PLACE_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACE_TYPE_SEARCH))
#define UNITY_PLACE_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACE_TYPE_SEARCH, UnityPlaceSearchClass))

typedef struct _UnityPlaceSearch UnityPlaceSearch;
typedef struct _UnityPlaceSearchClass UnityPlaceSearchClass;
typedef struct _UnityPlaceSearchPrivate UnityPlaceSearchPrivate;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define UNITY_PLACE_TYPE__ENTRYINFO (unity_place__entryinfo_get_type ())
typedef struct _UnityPlace_EntryInfo UnityPlace_EntryInfo;

#define UNITY_PLACE_TYPE__ENTRYINFODATA (unity_place__entryinfodata_get_type ())
typedef struct _UnityPlace_EntryInfoData UnityPlace_EntryInfoData;

#define UNITY_PLACE_TYPE_ENTRY_INFO (unity_place_entry_info_get_type ())
#define UNITY_PLACE_ENTRY_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACE_TYPE_ENTRY_INFO, UnityPlaceEntryInfo))
#define UNITY_PLACE_ENTRY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACE_TYPE_ENTRY_INFO, UnityPlaceEntryInfoClass))
#define UNITY_PLACE_IS_ENTRY_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACE_TYPE_ENTRY_INFO))
#define UNITY_PLACE_IS_ENTRY_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACE_TYPE_ENTRY_INFO))
#define UNITY_PLACE_ENTRY_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACE_TYPE_ENTRY_INFO, UnityPlaceEntryInfoClass))

typedef struct _UnityPlaceEntryInfo UnityPlaceEntryInfo;
typedef struct _UnityPlaceEntryInfoClass UnityPlaceEntryInfoClass;
typedef struct _UnityPlaceEntryInfoPrivate UnityPlaceEntryInfoPrivate;

#define UNITY_PLACE_TYPE_BROWSER (unity_place_browser_get_type ())
#define UNITY_PLACE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACE_TYPE_BROWSER, UnityPlaceBrowser))
#define UNITY_PLACE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACE_TYPE_BROWSER, UnityPlaceBrowserClass))
#define UNITY_PLACE_IS_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACE_TYPE_BROWSER))
#define UNITY_PLACE_IS_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACE_TYPE_BROWSER))
#define UNITY_PLACE_BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACE_TYPE_BROWSER, UnityPlaceBrowserClass))

typedef struct _UnityPlaceBrowser UnityPlaceBrowser;
typedef struct _UnityPlaceBrowserClass UnityPlaceBrowserClass;

#define UNITY_PLACE_TYPE_SERVICE (unity_place_service_get_type ())
#define UNITY_PLACE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACE_TYPE_SERVICE, UnityPlaceService))
#define UNITY_PLACE_IS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACE_TYPE_SERVICE))
#define UNITY_PLACE_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_PLACE_TYPE_SERVICE, UnityPlaceServiceIface))

typedef struct _UnityPlaceService UnityPlaceService;
typedef struct _UnityPlaceServiceIface UnityPlaceServiceIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
typedef struct _UnityPlaceServiceDBusProxy UnityPlaceServiceDBusProxy;
typedef DBusGProxyClass UnityPlaceServiceDBusProxyClass;

#define UNITY_PLACE_TYPE_ENTRY_SERVICE (unity_place_entry_service_get_type ())
#define UNITY_PLACE_ENTRY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACE_TYPE_ENTRY_SERVICE, UnityPlaceEntryService))
#define UNITY_PLACE_IS_ENTRY_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACE_TYPE_ENTRY_SERVICE))
#define UNITY_PLACE_ENTRY_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_PLACE_TYPE_ENTRY_SERVICE, UnityPlaceEntryServiceIface))

typedef struct _UnityPlaceEntryService UnityPlaceEntryService;
typedef struct _UnityPlaceEntryServiceIface UnityPlaceEntryServiceIface;
typedef struct _UnityPlaceEntryServiceDBusProxy UnityPlaceEntryServiceDBusProxy;
typedef DBusGProxyClass UnityPlaceEntryServiceDBusProxyClass;

#define UNITY_PLACE_TYPE_ACTIVATION (unity_place_activation_get_type ())
#define UNITY_PLACE_ACTIVATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACE_TYPE_ACTIVATION, UnityPlaceActivation))
#define UNITY_PLACE_IS_ACTIVATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACE_TYPE_ACTIVATION))
#define UNITY_PLACE_ACTIVATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_PLACE_TYPE_ACTIVATION, UnityPlaceActivationIface))

typedef struct _UnityPlaceActivation UnityPlaceActivation;
typedef struct _UnityPlaceActivationIface UnityPlaceActivationIface;

#define UNITY_PLACE_TYPE_SERVICE_IMPL (unity_place_service_impl_get_type ())
#define UNITY_PLACE_SERVICE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACE_TYPE_SERVICE_IMPL, UnityPlaceServiceImpl))
#define UNITY_PLACE_SERVICE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACE_TYPE_SERVICE_IMPL, UnityPlaceServiceImplClass))
#define UNITY_PLACE_IS_SERVICE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACE_TYPE_SERVICE_IMPL))
#define UNITY_PLACE_IS_SERVICE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACE_TYPE_SERVICE_IMPL))
#define UNITY_PLACE_SERVICE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACE_TYPE_SERVICE_IMPL, UnityPlaceServiceImplClass))

typedef struct _UnityPlaceServiceImpl UnityPlaceServiceImpl;
typedef struct _UnityPlaceServiceImplClass UnityPlaceServiceImplClass;
typedef struct _UnityPlaceServiceImplPrivate UnityPlaceServiceImplPrivate;

#define UNITY_PLACE_TYPE_ENTRY_SERVICE_IMPL (unity_place_entry_service_impl_get_type ())
#define UNITY_PLACE_ENTRY_SERVICE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACE_TYPE_ENTRY_SERVICE_IMPL, UnityPlaceEntryServiceImpl))
#define UNITY_PLACE_ENTRY_SERVICE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACE_TYPE_ENTRY_SERVICE_IMPL, UnityPlaceEntryServiceImplClass))
#define UNITY_PLACE_IS_ENTRY_SERVICE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACE_TYPE_ENTRY_SERVICE_IMPL))
#define UNITY_PLACE_IS_ENTRY_SERVICE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACE_TYPE_ENTRY_SERVICE_IMPL))
#define UNITY_PLACE_ENTRY_SERVICE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACE_TYPE_ENTRY_SERVICE_IMPL, UnityPlaceEntryServiceImplClass))

typedef struct _UnityPlaceEntryServiceImpl UnityPlaceEntryServiceImpl;
typedef struct _UnityPlaceEntryServiceImplClass UnityPlaceEntryServiceImplClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))

#define UNITY_PLACE_TYPE_ACTIVATION_STATUS (unity_place_activation_status_get_type ())
typedef struct _UnityPlaceServiceImplActivateData UnityPlaceServiceImplActivateData;
typedef struct _UnityPlaceEntryServiceImplPrivate UnityPlaceEntryServiceImplPrivate;

#define UNITY_PLACE_TYPE_BROWSER_SERVICE (unity_place_browser_service_get_type ())
#define UNITY_PLACE_BROWSER_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACE_TYPE_BROWSER_SERVICE, UnityPlaceBrowserService))
#define UNITY_PLACE_IS_BROWSER_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACE_TYPE_BROWSER_SERVICE))
#define UNITY_PLACE_BROWSER_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_PLACE_TYPE_BROWSER_SERVICE, UnityPlaceBrowserServiceIface))

typedef struct _UnityPlaceBrowserService UnityPlaceBrowserService;
typedef struct _UnityPlaceBrowserServiceIface UnityPlaceBrowserServiceIface;

#define UNITY_PLACE_TYPE__BROWSINGSTATE (unity_place__browsingstate_get_type ())
typedef struct _UnityPlace_BrowsingState UnityPlace_BrowsingState;

#define UNITY_PLACE_TYPE__ENTRYSIGNALS (unity_place__entrysignals_get_type ())
typedef struct _UnityPlace_EntrySignals UnityPlace_EntrySignals;

#define UNITY_PLACE_TYPE_CONTROLLER (unity_place_controller_get_type ())
#define UNITY_PLACE_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACE_TYPE_CONTROLLER, UnityPlaceController))
#define UNITY_PLACE_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACE_TYPE_CONTROLLER, UnityPlaceControllerClass))
#define UNITY_PLACE_IS_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACE_TYPE_CONTROLLER))
#define UNITY_PLACE_IS_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACE_TYPE_CONTROLLER))
#define UNITY_PLACE_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACE_TYPE_CONTROLLER, UnityPlaceControllerClass))

typedef struct _UnityPlaceController UnityPlaceController;
typedef struct _UnityPlaceControllerClass UnityPlaceControllerClass;
typedef struct _UnityPlaceControllerPrivate UnityPlaceControllerPrivate;
typedef struct _Block1Data Block1Data;
#define _unity_place__entrysignals_free0(var) ((var == NULL) ? NULL : (var = (unity_place__entrysignals_free (var), NULL)))

struct _UnityPlace_RendererInfo {
	char* default_renderer;
	char* groups_model;
	char* results_model;
	GHashTable* hints;
};

struct _UnityPlaceRendererInfo {
	GObject parent_instance;
	UnityPlaceRendererInfoPrivate * priv;
};

struct _UnityPlaceRendererInfoClass {
	GObjectClass parent_class;
};

struct _UnityPlaceRendererInfoPrivate {
	UnityPlace_RendererInfo* info;
	DeeModel* _groups_model;
	DeeModel* _results_model;
};

struct _UnityPlaceSearch {
	GInitiallyUnowned parent_instance;
	UnityPlaceSearchPrivate * priv;
};

struct _UnityPlaceSearchClass {
	GInitiallyUnownedClass parent_class;
};

struct _UnityPlaceSearchPrivate {
	char* search;
	GHashTable* hints;
};

struct _UnityPlace_EntryInfo {
	char* dbus_path;
	char* display_name;
	char* icon;
	guint position;
	char** mimetypes;
	gint mimetypes_length1;
	gint _mimetypes_size_;
	gboolean sensitive;
	char* sections_model;
	GHashTable* hints;
	UnityPlace_RendererInfo entry_renderer_info;
	UnityPlace_RendererInfo global_renderer_info;
};

struct _UnityPlace_EntryInfoData {
	char* dbus_path;
	char* display_name;
	char* icon;
	guint position;
	char** mimetypes;
	gint mimetypes_length1;
	gint _mimetypes_size_;
	gboolean sensitive;
	char* sections_model;
	GHashTable* hints;
};

struct _UnityPlaceEntryInfo {
	GObject parent_instance;
	UnityPlaceEntryInfoPrivate * priv;
};

struct _UnityPlaceEntryInfoClass {
	GObjectClass parent_class;
};

struct _UnityPlaceEntryInfoPrivate {
	UnityPlace_EntryInfo info;
	UnityPlaceRendererInfo* _entry_renderer_info;
	UnityPlaceRendererInfo* _global_renderer_info;
	DeeModel* _sections_model;
	gboolean _active;
	guint _active_section;
	UnityPlaceSearch* _active_search;
	UnityPlaceSearch* _active_global_search;
	UnityPlaceBrowser* _browser;
};

struct _UnityPlaceServiceIface {
	GTypeInterface parent_iface;
	UnityPlace_EntryInfo* (*get_entries) (UnityPlaceService* self, int* result_length1, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _UnityPlaceServiceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _UnityPlaceEntryServiceIface {
	GTypeInterface parent_iface;
	void (*set_global_search) (UnityPlaceEntryService* self, const char* search, GHashTable* hints, GError** error);
	void (*set_search) (UnityPlaceEntryService* self, const char* search, GHashTable* hints, GError** error);
	void (*set_active) (UnityPlaceEntryService* self, gboolean is_active, GError** error);
	void (*set_active_section) (UnityPlaceEntryService* self, guint section_id, GError** error);
};

struct _UnityPlaceEntryServiceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _UnityPlaceActivationIface {
	GTypeInterface parent_iface;
	void (*activate) (UnityPlaceActivation* self, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint32 (*activate_finish) (UnityPlaceActivation* self, GAsyncResult* _res_, GError** error);
};

struct _UnityPlaceServiceImpl {
	GObject parent_instance;
	UnityPlaceServiceImplPrivate * priv;
};

struct _UnityPlaceServiceImplClass {
	GObjectClass parent_class;
};

struct _UnityPlaceServiceImplPrivate {
	char* _dbus_path;
	GHashTable* entries;
	gboolean _exported;
	UnityPlaceActivation* _activation;
};

typedef enum  {
	UNITY_PLACE_ACTIVATION_STATUS_NOT_ACTIVATED,
	UNITY_PLACE_ACTIVATION_STATUS_ACTIVATED_SHOW_DASH,
	UNITY_PLACE_ACTIVATION_STATUS_ACTIVATED_HIDE_DASH
} UnityPlaceActivationStatus;

struct _UnityPlaceServiceImplActivateData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityPlaceServiceImpl* self;
	char* uri;
	guint32 result;
	guint32 activated;
	GError * e;
	GError * _inner_error_;
};

struct _UnityPlaceEntryServiceImpl {
	GObject parent_instance;
	UnityPlaceEntryServiceImplPrivate * priv;
};

struct _UnityPlaceEntryServiceImplClass {
	GObjectClass parent_class;
};

struct _UnityPlaceEntryServiceImplPrivate {
	gboolean _exported;
	UnityPlaceEntryInfo* _entry_info;
	guint place_entry_info_changed_signal_source;
	UnityPlaceBrowser* _browser;
};

struct _UnityPlace_BrowsingState {
	gboolean sensitive;
	char* comment;
};

struct _UnityPlaceBrowserServiceIface {
	GTypeInterface parent_iface;
	UnityPlace_BrowsingState* (*go_back) (UnityPlaceBrowserService* self, int* result_length1, GError** error);
	UnityPlace_BrowsingState* (*go_forward) (UnityPlaceBrowserService* self, int* result_length1, GError** error);
	UnityPlace_BrowsingState* (*get_state) (UnityPlaceBrowserService* self, int* result_length1, GError** error);
};

struct _UnityPlace_EntrySignals {
	gulong place_entry_info_changed_id;
	gulong entry_renderer_info_changed_id;
	gulong global_renderer_info_changed_id;
};

struct _UnityPlaceController {
	GObject parent_instance;
	UnityPlaceControllerPrivate * priv;
};

struct _UnityPlaceControllerClass {
	GObjectClass parent_class;
};

struct _UnityPlaceControllerPrivate {
	UnityPlaceServiceImpl* service;
	char* _dbus_path;
	gboolean _exported;
	GHashTable* entry_signals;
	GeeSet* ignore_remote_notify_props;
};

struct _Block1Data {
	int _ref_count_;
	UnityPlaceController * self;
	UnityPlaceEntryInfo* entry;
};


static gpointer unity_place_renderer_info_parent_class = NULL;
static gpointer unity_place_search_parent_class = NULL;
static gpointer unity_place_entry_info_parent_class = NULL;
static gpointer unity_place_service_impl_parent_class = NULL;
static UnityPlaceServiceIface* unity_place_service_impl_unity_place_service_parent_iface = NULL;
static UnityPlaceActivationIface* unity_place_service_impl_unity_place_activation_parent_iface = NULL;
static gpointer unity_place_entry_service_impl_parent_class = NULL;
static UnityPlaceEntryServiceIface* unity_place_entry_service_impl_unity_place_entry_service_parent_iface = NULL;
static gpointer unity_place_controller_parent_class = NULL;

GType unity_place__rendererinfo_get_type (void) G_GNUC_CONST;
UnityPlace_RendererInfo* unity_place__rendererinfo_dup (const UnityPlace_RendererInfo* self);
void unity_place__rendererinfo_free (UnityPlace_RendererInfo* self);
void unity_place__rendererinfo_copy (const UnityPlace_RendererInfo* self, UnityPlace_RendererInfo* dest);
void unity_place__rendererinfo_destroy (UnityPlace_RendererInfo* self);
GType unity_place_renderer_info_get_type (void) G_GNUC_CONST;
#define UNITY_PLACE_RENDERER_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_PLACE_TYPE_RENDERER_INFO, UnityPlaceRendererInfoPrivate))
enum  {
	UNITY_PLACE_RENDERER_INFO_DUMMY_PROPERTY,
	UNITY_PLACE_RENDERER_INFO_DEFAULT_RENDERER,
	UNITY_PLACE_RENDERER_INFO_GROUPS_MODEL,
	UNITY_PLACE_RENDERER_INFO_RESULTS_MODEL
};
UnityPlaceRendererInfo* unity_place_renderer_info_new (UnityPlace_RendererInfo* info);
UnityPlaceRendererInfo* unity_place_renderer_info_construct (GType object_type, UnityPlace_RendererInfo* info);
void unity_place_renderer_info_set_hint (UnityPlaceRendererInfo* self, const char* hint, const char* val);
char* unity_place_renderer_info_get_hint (UnityPlaceRendererInfo* self, const char* hint);
void unity_place_renderer_info_clear_hint (UnityPlaceRendererInfo* self, const char* hint);
void unity_place_renderer_info_clear_hints (UnityPlaceRendererInfo* self);
guint unity_place_renderer_info_num_hints (UnityPlaceRendererInfo* self);
void unity_place_renderer_info_get_raw (UnityPlaceRendererInfo* self, UnityPlace_RendererInfo* result);
const char* unity_place_renderer_info_get_default_renderer (UnityPlaceRendererInfo* self);
void unity_place_renderer_info_set_default_renderer (UnityPlaceRendererInfo* self, const char* value);
DeeModel* unity_place_renderer_info_get_groups_model (UnityPlaceRendererInfo* self);
void unity_place_renderer_info_set_groups_model (UnityPlaceRendererInfo* self, DeeModel* value);
DeeModel* unity_place_renderer_info_get_results_model (UnityPlaceRendererInfo* self);
void unity_place_renderer_info_set_results_model (UnityPlaceRendererInfo* self, DeeModel* value);
static void unity_place_renderer_info_finalize (GObject* obj);
static void unity_place_renderer_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_place_renderer_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType unity_place_search_get_type (void) G_GNUC_CONST;
#define UNITY_PLACE_SEARCH_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_PLACE_TYPE_SEARCH, UnityPlaceSearchPrivate))
enum  {
	UNITY_PLACE_SEARCH_DUMMY_PROPERTY
};
UnityPlaceSearch* unity_place_search_new (const char* search, GHashTable* hints);
UnityPlaceSearch* unity_place_search_construct (GType object_type, const char* search, GHashTable* hints);
char* unity_place_search_get_search_string (UnityPlaceSearch* self);
GList* unity_place_search_get_hints (UnityPlaceSearch* self);
void unity_place_search_set_hint (UnityPlaceSearch* self, const char* hint, const char* val);
char* unity_place_search_get_hint (UnityPlaceSearch* self, const char* hint);
void unity_place_search_clear_hint (UnityPlaceSearch* self, const char* hint);
void unity_place_search_clear_hints (UnityPlaceSearch* self);
guint unity_place_search_num_hints (UnityPlaceSearch* self);
gboolean unity_place_search_equals (UnityPlaceSearch* self, UnityPlaceSearch* other);
static void unity_place_search_finalize (GObject* obj);
GType unity_place__entryinfo_get_type (void) G_GNUC_CONST;
UnityPlace_EntryInfo* unity_place__entryinfo_dup (const UnityPlace_EntryInfo* self);
void unity_place__entryinfo_free (UnityPlace_EntryInfo* self);
void unity_place__entryinfo_copy (const UnityPlace_EntryInfo* self, UnityPlace_EntryInfo* dest);
void unity_place__entryinfo_destroy (UnityPlace_EntryInfo* self);
static char** _vala_array_dup3 (char** self, int length);
GType unity_place__entryinfodata_get_type (void) G_GNUC_CONST;
UnityPlace_EntryInfoData* unity_place__entryinfodata_dup (const UnityPlace_EntryInfoData* self);
void unity_place__entryinfodata_free (UnityPlace_EntryInfoData* self);
void unity_place__entryinfodata_copy (const UnityPlace_EntryInfoData* self, UnityPlace_EntryInfoData* dest);
void unity_place__entryinfodata_destroy (UnityPlace_EntryInfoData* self);
static char** _vala_array_dup4 (char** self, int length);
GType unity_place_entry_info_get_type (void) G_GNUC_CONST;
GType unity_place_browser_get_type (void) G_GNUC_CONST;
#define UNITY_PLACE_ENTRY_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_PLACE_TYPE_ENTRY_INFO, UnityPlaceEntryInfoPrivate))
enum  {
	UNITY_PLACE_ENTRY_INFO_DUMMY_PROPERTY,
	UNITY_PLACE_ENTRY_INFO_ENTRY_RENDERER_INFO,
	UNITY_PLACE_ENTRY_INFO_GLOBAL_RENDERER_INFO,
	UNITY_PLACE_ENTRY_INFO_DBUS_PATH,
	UNITY_PLACE_ENTRY_INFO_DISPLAY_NAME,
	UNITY_PLACE_ENTRY_INFO_ICON,
	UNITY_PLACE_ENTRY_INFO_POSITION,
	UNITY_PLACE_ENTRY_INFO_MIMETYPES,
	UNITY_PLACE_ENTRY_INFO_SENSITIVE,
	UNITY_PLACE_ENTRY_INFO_SECTIONS_MODEL,
	UNITY_PLACE_ENTRY_INFO_ACTIVE,
	UNITY_PLACE_ENTRY_INFO_ACTIVE_SECTION,
	UNITY_PLACE_ENTRY_INFO_ACTIVE_SEARCH,
	UNITY_PLACE_ENTRY_INFO_ACTIVE_GLOBAL_SEARCH,
	UNITY_PLACE_ENTRY_INFO_BROWSER
};
UnityPlaceEntryInfo* unity_place_entry_info_new (const char* dbus_path);
UnityPlaceEntryInfo* unity_place_entry_info_construct (GType object_type, const char* dbus_path);
void unity_place_entry_info_set_hint (UnityPlaceEntryInfo* self, const char* hint, const char* val);
char* unity_place_entry_info_get_hint (UnityPlaceEntryInfo* self, const char* hint);
void unity_place_entry_info_clear_hint (UnityPlaceEntryInfo* self, const char* hint);
void unity_place_entry_info_clear_hints (UnityPlaceEntryInfo* self);
guint unity_place_entry_info_num_hints (UnityPlaceEntryInfo* self);
void unity_place_entry_info_get_raw (UnityPlaceEntryInfo* self, UnityPlace_EntryInfo* result);
UnityPlaceRendererInfo* unity_place_entry_info_get_entry_renderer_info (UnityPlaceEntryInfo* self);
UnityPlaceRendererInfo* unity_place_entry_info_get_global_renderer_info (UnityPlaceEntryInfo* self);
const char* unity_place_entry_info_get_dbus_path (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_dbus_path (UnityPlaceEntryInfo* self, const char* value);
const char* unity_place_entry_info_get_display_name (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_display_name (UnityPlaceEntryInfo* self, const char* value);
const char* unity_place_entry_info_get_icon (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_icon (UnityPlaceEntryInfo* self, const char* value);
guint unity_place_entry_info_get_position (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_position (UnityPlaceEntryInfo* self, guint value);
char** unity_place_entry_info_get_mimetypes (UnityPlaceEntryInfo* self, int* result_length1);
void unity_place_entry_info_set_mimetypes (UnityPlaceEntryInfo* self, char** value, int value_length1);
static char** _vala_array_dup5 (char** self, int length);
gboolean unity_place_entry_info_get_sensitive (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_sensitive (UnityPlaceEntryInfo* self, gboolean value);
DeeModel* unity_place_entry_info_get_sections_model (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_sections_model (UnityPlaceEntryInfo* self, DeeModel* value);
gboolean unity_place_entry_info_get_active (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_active (UnityPlaceEntryInfo* self, gboolean value);
guint unity_place_entry_info_get_active_section (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_active_section (UnityPlaceEntryInfo* self, guint value);
UnityPlaceSearch* unity_place_entry_info_get_active_search (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_active_search (UnityPlaceEntryInfo* self, UnityPlaceSearch* value);
UnityPlaceSearch* unity_place_entry_info_get_active_global_search (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_active_global_search (UnityPlaceEntryInfo* self, UnityPlaceSearch* value);
UnityPlaceBrowser* unity_place_entry_info_get_browser (UnityPlaceEntryInfo* self);
void unity_place_entry_info_set_browser (UnityPlaceEntryInfo* self, UnityPlaceBrowser* value);
const char* unity_place_browser_get_dbus_path (UnityPlaceBrowser* self);
static GObject * unity_place_entry_info_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_place_entry_info_finalize (GObject* obj);
static void unity_place_entry_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_place_entry_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
UnityPlaceService* unity_place_service_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType unity_place_service_get_type (void) G_GNUC_CONST;
UnityPlace_EntryInfo* unity_place_service_get_entries (UnityPlaceService* self, int* result_length1, GError** error);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void unity_place_service_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _unity_place_service_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult unity_place_service_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_unity_place_service_introspect (UnityPlaceService* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_unity_place_service_property_get_all (UnityPlaceService* self, DBusConnection* connection, DBusMessage* message);
static void _vala_UnityPlace_EntryInfo_array_free (UnityPlace_EntryInfo* array, gint array_length);
static DBusHandlerResult _dbus_unity_place_service_get_entries (UnityPlaceService* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_unity_place_service_entry_added (GObject* _sender, UnityPlace_EntryInfo* entry, DBusConnection* _connection);
static void _dbus_unity_place_service_entry_removed (GObject* _sender, const char* entry_dbus_path, DBusConnection* _connection);
GType unity_place_service_dbus_proxy_get_type (void) G_GNUC_CONST;
static void _dbus_handle_unity_place_service_entry_added (UnityPlaceService* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_unity_place_service_entry_removed (UnityPlaceService* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult unity_place_service_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	UNITY_PLACE_SERVICE_DBUS_PROXY_DUMMY_PROPERTY
};
static UnityPlace_EntryInfo* unity_place_service_dbus_proxy_get_entries (UnityPlaceService* self, int* result_length1, GError** error);
static void unity_place_service_dbus_proxy_unity_place_service__interface_init (UnityPlaceServiceIface* iface);
static void unity_place_service_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_place_service_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
UnityPlaceEntryService* unity_place_entry_service_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType unity_place_entry_service_get_type (void) G_GNUC_CONST;
void unity_place_entry_service_set_global_search (UnityPlaceEntryService* self, const char* search, GHashTable* hints, GError** error);
void unity_place_entry_service_set_search (UnityPlaceEntryService* self, const char* search, GHashTable* hints, GError** error);
void unity_place_entry_service_set_active (UnityPlaceEntryService* self, gboolean is_active, GError** error);
void unity_place_entry_service_set_active_section (UnityPlaceEntryService* self, guint section_id, GError** error);
void unity_place_entry_service_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _unity_place_entry_service_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult unity_place_entry_service_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_unity_place_entry_service_introspect (UnityPlaceEntryService* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_unity_place_entry_service_property_get_all (UnityPlaceEntryService* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_unity_place_entry_service_set_global_search (UnityPlaceEntryService* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_unity_place_entry_service_set_search (UnityPlaceEntryService* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_unity_place_entry_service_set_active (UnityPlaceEntryService* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_unity_place_entry_service_set_active_section (UnityPlaceEntryService* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_unity_place_entry_service_entry_renderer_info_changed (GObject* _sender, UnityPlace_RendererInfo* renderer_info, DBusConnection* _connection);
static void _dbus_unity_place_entry_service_global_renderer_info_changed (GObject* _sender, UnityPlace_RendererInfo* renderer_info, DBusConnection* _connection);
static void _dbus_unity_place_entry_service_place_entry_info_changed (GObject* _sender, UnityPlace_EntryInfoData* entry_info_data, DBusConnection* _connection);
GType unity_place_entry_service_dbus_proxy_get_type (void) G_GNUC_CONST;
static void _dbus_handle_unity_place_entry_service_entry_renderer_info_changed (UnityPlaceEntryService* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_unity_place_entry_service_global_renderer_info_changed (UnityPlaceEntryService* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_unity_place_entry_service_place_entry_info_changed (UnityPlaceEntryService* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult unity_place_entry_service_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	UNITY_PLACE_ENTRY_SERVICE_DBUS_PROXY_DUMMY_PROPERTY
};
static void unity_place_entry_service_dbus_proxy_set_global_search (UnityPlaceEntryService* self, const char* search, GHashTable* hints, GError** error);
static void unity_place_entry_service_dbus_proxy_set_search (UnityPlaceEntryService* self, const char* search, GHashTable* hints, GError** error);
static void unity_place_entry_service_dbus_proxy_set_active (UnityPlaceEntryService* self, gboolean is_active, GError** error);
static void unity_place_entry_service_dbus_proxy_set_active_section (UnityPlaceEntryService* self, guint section_id, GError** error);
static void unity_place_entry_service_dbus_proxy_unity_place_entry_service__interface_init (UnityPlaceEntryServiceIface* iface);
static void unity_place_entry_service_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_place_entry_service_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
UnityPlaceActivation* unity_place_activation_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType unity_place_activation_get_type (void) G_GNUC_CONST;
GType unity_place_service_impl_get_type (void) G_GNUC_CONST;
GType unity_place_entry_service_impl_get_type (void) G_GNUC_CONST;
#define UNITY_PLACE_SERVICE_IMPL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_PLACE_TYPE_SERVICE_IMPL, UnityPlaceServiceImplPrivate))
enum  {
	UNITY_PLACE_SERVICE_IMPL_DUMMY_PROPERTY,
	UNITY_PLACE_SERVICE_IMPL_DBUS_PATH,
	UNITY_PLACE_SERVICE_IMPL_EXPORTED,
	UNITY_PLACE_SERVICE_IMPL_ACTIVATION
};
UnityPlaceServiceImpl* unity_place_service_impl_new (const char* dbus_path);
UnityPlaceServiceImpl* unity_place_service_impl_construct (GType object_type, const char* dbus_path);
static UnityPlace_EntryInfo* unity_place_service_impl_real_get_entries (UnityPlaceService* base, int* result_length1, GError** error);
UnityPlaceEntryInfo* unity_place_entry_service_impl_get_entry_info (UnityPlaceEntryServiceImpl* self);
void unity_place_service_impl_add_entry (UnityPlaceServiceImpl* self, UnityPlaceEntryInfo* entry_info);
UnityPlaceEntryServiceImpl* unity_place_entry_service_impl_new (UnityPlaceEntryInfo* entry_info);
UnityPlaceEntryServiceImpl* unity_place_entry_service_impl_construct (GType object_type, UnityPlaceEntryInfo* entry_info);
void unity_place_entry_service_impl_export (UnityPlaceEntryServiceImpl* self, GError** error);
UnityPlaceEntryInfo* unity_place_service_impl_get_entry (UnityPlaceServiceImpl* self, const char* dbus_path);
UnityPlaceEntryServiceImpl* unity_place_service_impl_get_entry_service (UnityPlaceServiceImpl* self, const char* dbus_path);
guint unity_place_service_impl_num_entries (UnityPlaceServiceImpl* self);
char** unity_place_service_impl_get_entry_paths (UnityPlaceServiceImpl* self, int* result_length1);
void unity_place_service_impl_remove_entry (UnityPlaceServiceImpl* self, const char* dbus_path);
void unity_place_entry_service_impl_unexport (UnityPlaceEntryServiceImpl* self, GError** error);
void unity_place_service_impl_export (UnityPlaceServiceImpl* self, GError** error);
void unity_place_service_impl_unexport (UnityPlaceServiceImpl* self, GError** error);
static void unity_place_service_impl_real_activate_data_free (gpointer _data);
static void unity_place_service_impl_real_activate (UnityPlaceActivation* base, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_place_service_impl_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean unity_place_service_impl_real_activate_co (UnityPlaceServiceImplActivateData* data);
UnityPlaceActivation* unity_place_service_impl_get_activation (UnityPlaceServiceImpl* self);
GType unity_place_activation_status_get_type (void) G_GNUC_CONST;
void unity_place_activation_activate (UnityPlaceActivation* self, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint32 unity_place_activation_activate_finish (UnityPlaceActivation* self, GAsyncResult* _res_, GError** error);
const char* unity_place_service_impl_get_dbus_path (UnityPlaceServiceImpl* self);
static void unity_place_service_impl_set_dbus_path (UnityPlaceServiceImpl* self, const char* value);
gboolean unity_place_service_impl_get_exported (UnityPlaceServiceImpl* self);
void unity_place_service_impl_set_activation (UnityPlaceServiceImpl* self, UnityPlaceActivation* value);
static GObject * unity_place_service_impl_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void unity_place_service_impl_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _unity_place_service_impl_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult unity_place_service_impl_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_unity_place_service_impl_introspect (UnityPlaceServiceImpl* self, DBusConnection* connection, DBusMessage* message);
static void unity_place_service_impl_finalize (GObject* obj);
static void unity_place_service_impl_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_place_service_impl_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define UNITY_PLACE_ENTRY_SERVICE_IMPL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_PLACE_TYPE_ENTRY_SERVICE_IMPL, UnityPlaceEntryServiceImplPrivate))
enum  {
	UNITY_PLACE_ENTRY_SERVICE_IMPL_DUMMY_PROPERTY,
	UNITY_PLACE_ENTRY_SERVICE_IMPL_ENTRY_INFO,
	UNITY_PLACE_ENTRY_SERVICE_IMPL_EXPORTED
};
static void unity_place_entry_service_impl_on_browser_changed (UnityPlaceEntryServiceImpl* self, GObject* obj, GParamSpec* pspec);
static void _unity_place_entry_service_impl_on_browser_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_place_entry_service_impl_real_set_global_search (UnityPlaceEntryService* base, const char* search, GHashTable* hints, GError** error);
static void unity_place_entry_service_impl_real_set_search (UnityPlaceEntryService* base, const char* search, GHashTable* hints, GError** error);
static void unity_place_entry_service_impl_real_set_active (UnityPlaceEntryService* base, gboolean is_active, GError** error);
static void unity_place_entry_service_impl_real_set_active_section (UnityPlaceEntryService* base, guint section_id, GError** error);
UnityPlaceBrowserService* unity_place_browser_service_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType unity_place__browsingstate_get_type (void) G_GNUC_CONST;
UnityPlace_BrowsingState* unity_place__browsingstate_dup (const UnityPlace_BrowsingState* self);
void unity_place__browsingstate_free (UnityPlace_BrowsingState* self);
void unity_place__browsingstate_copy (const UnityPlace_BrowsingState* self, UnityPlace_BrowsingState* dest);
void unity_place__browsingstate_destroy (UnityPlace_BrowsingState* self);
GType unity_place_browser_service_get_type (void) G_GNUC_CONST;
UnityPlaceBrowserService* unity_place_browser_get_service (UnityPlaceBrowser* self);
void unity_place_entry_service_impl_queue_place_entry_info_changed_signal (UnityPlaceEntryServiceImpl* self);
static gboolean unity_place_entry_service_impl_emit_place_entry_info_changed_signal (UnityPlaceEntryServiceImpl* self);
static gboolean _unity_place_entry_service_impl_emit_place_entry_info_changed_signal_gsource_func (gpointer self);
static char** _vala_array_dup6 (char** self, int length);
static void unity_place_entry_service_impl_set_entry_info (UnityPlaceEntryServiceImpl* self, UnityPlaceEntryInfo* value);
gboolean unity_place_entry_service_impl_get_exported (UnityPlaceEntryServiceImpl* self);
void unity_place_entry_service_impl_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _unity_place_entry_service_impl_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult unity_place_entry_service_impl_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_unity_place_entry_service_impl_introspect (UnityPlaceEntryServiceImpl* self, DBusConnection* connection, DBusMessage* message);
static void unity_place_entry_service_impl_finalize (GObject* obj);
static void unity_place_entry_service_impl_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_place_entry_service_impl_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType unity_place__entrysignals_get_type (void) G_GNUC_CONST;
UnityPlace_EntrySignals* unity_place__entrysignals_dup (const UnityPlace_EntrySignals* self);
void unity_place__entrysignals_free (UnityPlace_EntrySignals* self);
GType unity_place_controller_get_type (void) G_GNUC_CONST;
#define UNITY_PLACE_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_PLACE_TYPE_CONTROLLER, UnityPlaceControllerPrivate))
enum  {
	UNITY_PLACE_CONTROLLER_DUMMY_PROPERTY,
	UNITY_PLACE_CONTROLLER_DBUS_PATH,
	UNITY_PLACE_CONTROLLER_EXPORTED,
	UNITY_PLACE_CONTROLLER_ACTIVATION
};
UnityPlaceController* unity_place_controller_new (const char* dbus_path);
UnityPlaceController* unity_place_controller_construct (GType object_type, const char* dbus_path);
void unity_place_controller_add_entry (UnityPlaceController* self, UnityPlaceEntryInfo* entry);
static void unity_place_controller_on_entry_changed (UnityPlaceController* self, GObject* obj, GParamSpec* pspec);
static void _unity_place_controller_on_entry_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda3_ (GObject* obj, GParamSpec* pspec, Block1Data* _data1_);
static void __lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda4_ (GObject* obj, GParamSpec* pspec, Block1Data* _data1_);
static void __lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
UnityPlaceEntryInfo* unity_place_controller_get_entry (UnityPlaceController* self, const char* dbus_path);
void unity_place_controller_remove_entry (UnityPlaceController* self, const char* dbus_path);
guint unity_place_controller_num_entries (UnityPlaceController* self);
char** unity_place_controller_get_entry_paths (UnityPlaceController* self, int* result_length1);
UnityPlaceEntryInfo** unity_place_controller_get_entries (UnityPlaceController* self, int* result_length1);
void unity_place_controller_export (UnityPlaceController* self, GError** error);
void unity_place_controller_unexport (UnityPlaceController* self, GError** error);
const char* unity_place_controller_get_dbus_path (UnityPlaceController* self);
static void unity_place_controller_set_dbus_path (UnityPlaceController* self, const char* value);
gboolean unity_place_controller_get_exported (UnityPlaceController* self);
UnityPlaceActivation* unity_place_controller_get_activation (UnityPlaceController* self);
void unity_place_controller_set_activation (UnityPlaceController* self, UnityPlaceActivation* value);
static GObject * unity_place_controller_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_place_controller_finalize (GObject* obj);
static void unity_place_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_place_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const DBusObjectPathVTable _unity_place_service_dbus_path_vtable = {_unity_place_service_dbus_unregister, unity_place_service_dbus_message};
static const _DBusObjectVTable _unity_place_service_dbus_vtable = {unity_place_service_dbus_register_object};
static const DBusObjectPathVTable _unity_place_entry_service_dbus_path_vtable = {_unity_place_entry_service_dbus_unregister, unity_place_entry_service_dbus_message};
static const _DBusObjectVTable _unity_place_entry_service_dbus_vtable = {unity_place_entry_service_dbus_register_object};
static const DBusObjectPathVTable _unity_place_service_impl_dbus_path_vtable = {_unity_place_service_impl_dbus_unregister, unity_place_service_impl_dbus_message};
static const _DBusObjectVTable _unity_place_service_impl_dbus_vtable = {unity_place_service_impl_dbus_register_object};
static const DBusObjectPathVTable _unity_place_entry_service_impl_dbus_path_vtable = {_unity_place_entry_service_impl_dbus_unregister, unity_place_entry_service_impl_dbus_message};
static const _DBusObjectVTable _unity_place_entry_service_impl_dbus_vtable = {unity_place_entry_service_impl_dbus_register_object};

static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void unity_place__rendererinfo_copy (const UnityPlace_RendererInfo* self, UnityPlace_RendererInfo* dest) {
	dest->default_renderer = g_strdup (self->default_renderer);
	dest->groups_model = g_strdup (self->groups_model);
	dest->results_model = g_strdup (self->results_model);
	dest->hints = _g_hash_table_ref0 (self->hints);
}


void unity_place__rendererinfo_destroy (UnityPlace_RendererInfo* self) {
	_g_free0 (self->default_renderer);
	_g_free0 (self->groups_model);
	_g_free0 (self->results_model);
	_g_hash_table_unref0 (self->hints);
}


UnityPlace_RendererInfo* unity_place__rendererinfo_dup (const UnityPlace_RendererInfo* self) {
	UnityPlace_RendererInfo* dup;
	dup = g_new0 (UnityPlace_RendererInfo, 1);
	unity_place__rendererinfo_copy (self, dup);
	return dup;
}


void unity_place__rendererinfo_free (UnityPlace_RendererInfo* self) {
	unity_place__rendererinfo_destroy (self);
	g_free (self);
}


GType unity_place__rendererinfo_get_type (void) {
	static volatile gsize unity_place__rendererinfo_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place__rendererinfo_type_id__volatile)) {
		GType unity_place__rendererinfo_type_id;
		unity_place__rendererinfo_type_id = g_boxed_type_register_static ("UnityPlace_RendererInfo", (GBoxedCopyFunc) unity_place__rendererinfo_dup, (GBoxedFreeFunc) unity_place__rendererinfo_free);
		g_once_init_leave (&unity_place__rendererinfo_type_id__volatile, unity_place__rendererinfo_type_id);
	}
	return unity_place__rendererinfo_type_id__volatile;
}


UnityPlaceRendererInfo* unity_place_renderer_info_construct (GType object_type, UnityPlace_RendererInfo* info) {
	UnityPlaceRendererInfo * self;
	self = (UnityPlaceRendererInfo*) g_object_new (object_type, NULL);
	self->priv->info = info;
	return self;
}


UnityPlaceRendererInfo* unity_place_renderer_info_new (UnityPlace_RendererInfo* info) {
	return unity_place_renderer_info_construct (UNITY_PLACE_TYPE_RENDERER_INFO, info);
}


void unity_place_renderer_info_set_hint (UnityPlaceRendererInfo* self, const char* hint, const char* val) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (hint != NULL);
	g_return_if_fail (val != NULL);
	g_hash_table_insert ((*self->priv->info).hints, g_strdup (hint), g_strdup (val));
}


char* unity_place_renderer_info_get_hint (UnityPlaceRendererInfo* self, const char* hint) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hint != NULL, NULL);
	result = g_strdup ((const char*) g_hash_table_lookup ((*self->priv->info).hints, hint));
	return result;
}


void unity_place_renderer_info_clear_hint (UnityPlaceRendererInfo* self, const char* hint) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (hint != NULL);
	g_hash_table_remove ((*self->priv->info).hints, hint);
}


void unity_place_renderer_info_clear_hints (UnityPlaceRendererInfo* self) {
	g_return_if_fail (self != NULL);
	g_hash_table_remove_all ((*self->priv->info).hints);
}


guint unity_place_renderer_info_num_hints (UnityPlaceRendererInfo* self) {
	guint result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_hash_table_size ((*self->priv->info).hints);
	return result;
}


void unity_place_renderer_info_get_raw (UnityPlaceRendererInfo* self, UnityPlace_RendererInfo* result) {
	UnityPlace_RendererInfo _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	*result = (unity_place__rendererinfo_copy (self->priv->info, &_tmp0_), _tmp0_);
	return;
}


const char* unity_place_renderer_info_get_default_renderer (UnityPlaceRendererInfo* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (*self->priv->info).default_renderer;
	return result;
}


void unity_place_renderer_info_set_default_renderer (UnityPlaceRendererInfo* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	(*self->priv->info).default_renderer = (_tmp0_ = g_strdup (value), _g_free0 ((*self->priv->info).default_renderer), _tmp0_);
	g_object_notify ((GObject *) self, "default-renderer");
}


DeeModel* unity_place_renderer_info_get_groups_model (UnityPlaceRendererInfo* self) {
	DeeModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_groups_model;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void unity_place_renderer_info_set_groups_model (UnityPlaceRendererInfo* self, DeeModel* value) {
	DeeModel* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_groups_model = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_groups_model), _tmp0_);
	if (DEE_IS_SHARED_MODEL (value)) {
		DeeModel* _tmp1_;
		DeeSharedModel* model;
		char* _tmp2_;
		model = _g_object_ref0 ((_tmp1_ = value, DEE_IS_SHARED_MODEL (_tmp1_) ? ((DeeSharedModel*) _tmp1_) : NULL));
		(*self->priv->info).groups_model = (_tmp2_ = g_strdup (dee_shared_model_get_swarm_name (model)), _g_free0 ((*self->priv->info).groups_model), _tmp2_);
		_g_object_unref0 (model);
	} else {
		char* _tmp3_;
		(*self->priv->info).groups_model = (_tmp3_ = g_strdup ("__local__"), _g_free0 ((*self->priv->info).groups_model), _tmp3_);
	}
	g_object_notify ((GObject *) self, "groups-model");
}


DeeModel* unity_place_renderer_info_get_results_model (UnityPlaceRendererInfo* self) {
	DeeModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_results_model;
	return result;
}


void unity_place_renderer_info_set_results_model (UnityPlaceRendererInfo* self, DeeModel* value) {
	DeeModel* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_results_model = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_results_model), _tmp0_);
	if (DEE_IS_SHARED_MODEL (value)) {
		DeeModel* _tmp1_;
		DeeSharedModel* model;
		char* _tmp2_;
		model = _g_object_ref0 ((_tmp1_ = value, DEE_IS_SHARED_MODEL (_tmp1_) ? ((DeeSharedModel*) _tmp1_) : NULL));
		(*self->priv->info).results_model = (_tmp2_ = g_strdup (dee_shared_model_get_swarm_name (model)), _g_free0 ((*self->priv->info).results_model), _tmp2_);
		_g_object_unref0 (model);
	} else {
		char* _tmp3_;
		(*self->priv->info).results_model = (_tmp3_ = g_strdup ("__local__"), _g_free0 ((*self->priv->info).results_model), _tmp3_);
	}
	g_object_notify ((GObject *) self, "results-model");
}


static void unity_place_renderer_info_class_init (UnityPlaceRendererInfoClass * klass) {
	unity_place_renderer_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlaceRendererInfoPrivate));
	G_OBJECT_CLASS (klass)->get_property = unity_place_renderer_info_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_place_renderer_info_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_place_renderer_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_RENDERER_INFO_DEFAULT_RENDERER, g_param_spec_string ("default-renderer", "default-renderer", "default-renderer", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_RENDERER_INFO_GROUPS_MODEL, g_param_spec_object ("groups-model", "groups-model", "groups-model", DEE_TYPE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_RENDERER_INFO_RESULTS_MODEL, g_param_spec_object ("results-model", "results-model", "results-model", DEE_TYPE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_place_renderer_info_instance_init (UnityPlaceRendererInfo * self) {
	self->priv = UNITY_PLACE_RENDERER_INFO_GET_PRIVATE (self);
}


static void unity_place_renderer_info_finalize (GObject* obj) {
	UnityPlaceRendererInfo * self;
	self = UNITY_PLACE_RENDERER_INFO (obj);
	_g_object_unref0 (self->priv->_groups_model);
	_g_object_unref0 (self->priv->_results_model);
	G_OBJECT_CLASS (unity_place_renderer_info_parent_class)->finalize (obj);
}


/**
   * SECTION:unity-place-renderer-info
   * @short_description: Encapsulates all place entry metadata the Unity shell needs in order to render this model
   * @include: unity.h
   *
   *
   */
GType unity_place_renderer_info_get_type (void) {
	static volatile gsize unity_place_renderer_info_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place_renderer_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlaceRendererInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_place_renderer_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlaceRendererInfo), 0, (GInstanceInitFunc) unity_place_renderer_info_instance_init, NULL };
		GType unity_place_renderer_info_type_id;
		unity_place_renderer_info_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityPlaceRendererInfo", &g_define_type_info, 0);
		g_once_init_leave (&unity_place_renderer_info_type_id__volatile, unity_place_renderer_info_type_id);
	}
	return unity_place_renderer_info_type_id__volatile;
}


static void unity_place_renderer_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlaceRendererInfo * self;
	self = UNITY_PLACE_RENDERER_INFO (object);
	switch (property_id) {
		case UNITY_PLACE_RENDERER_INFO_DEFAULT_RENDERER:
		g_value_set_string (value, unity_place_renderer_info_get_default_renderer (self));
		break;
		case UNITY_PLACE_RENDERER_INFO_GROUPS_MODEL:
		g_value_set_object (value, unity_place_renderer_info_get_groups_model (self));
		break;
		case UNITY_PLACE_RENDERER_INFO_RESULTS_MODEL:
		g_value_set_object (value, unity_place_renderer_info_get_results_model (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_place_renderer_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlaceRendererInfo * self;
	self = UNITY_PLACE_RENDERER_INFO (object);
	switch (property_id) {
		case UNITY_PLACE_RENDERER_INFO_DEFAULT_RENDERER:
		unity_place_renderer_info_set_default_renderer (self, g_value_get_string (value));
		break;
		case UNITY_PLACE_RENDERER_INFO_GROUPS_MODEL:
		unity_place_renderer_info_set_groups_model (self, g_value_get_object (value));
		break;
		case UNITY_PLACE_RENDERER_INFO_RESULTS_MODEL:
		unity_place_renderer_info_set_results_model (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityPlaceSearch* unity_place_search_construct (GType object_type, const char* search, GHashTable* hints) {
	UnityPlaceSearch * self;
	char* _tmp0_;
	GHashTable* _tmp1_;
	g_return_val_if_fail (search != NULL, NULL);
	g_return_val_if_fail (hints != NULL, NULL);
	self = (UnityPlaceSearch*) g_object_new (object_type, NULL);
	self->priv->search = (_tmp0_ = g_strdup (search), _g_free0 (self->priv->search), _tmp0_);
	self->priv->hints = (_tmp1_ = _g_hash_table_ref0 (hints), _g_hash_table_unref0 (self->priv->hints), _tmp1_);
	return self;
}


UnityPlaceSearch* unity_place_search_new (const char* search, GHashTable* hints) {
	return unity_place_search_construct (UNITY_PLACE_TYPE_SEARCH, search, hints);
}


char* unity_place_search_get_search_string (UnityPlaceSearch* self) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_strdup (self->priv->search);
	return result;
}


GList* unity_place_search_get_hints (UnityPlaceSearch* self) {
	GList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_hash_table_get_keys (self->priv->hints);
	return result;
}


void unity_place_search_set_hint (UnityPlaceSearch* self, const char* hint, const char* val) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (hint != NULL);
	g_return_if_fail (val != NULL);
	g_hash_table_insert (self->priv->hints, g_strdup (hint), g_strdup (val));
}


char* unity_place_search_get_hint (UnityPlaceSearch* self, const char* hint) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hint != NULL, NULL);
	result = g_strdup ((const char*) g_hash_table_lookup (self->priv->hints, hint));
	return result;
}


void unity_place_search_clear_hint (UnityPlaceSearch* self, const char* hint) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (hint != NULL);
	g_hash_table_remove (self->priv->hints, hint);
}


void unity_place_search_clear_hints (UnityPlaceSearch* self) {
	g_return_if_fail (self != NULL);
	g_hash_table_remove_all (self->priv->hints);
}


guint unity_place_search_num_hints (UnityPlaceSearch* self) {
	guint result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_hash_table_size (self->priv->hints);
	return result;
}


gboolean unity_place_search_equals (UnityPlaceSearch* self, UnityPlaceSearch* other) {
	gboolean result = FALSE;
	char* _tmp0_;
	char* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (other == NULL) {
		result = FALSE;
		return result;
	}
	if ((_tmp2_ = _vala_strcmp0 (_tmp0_ = unity_place_search_get_search_string (self), _tmp1_ = unity_place_search_get_search_string (other)) != 0, _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_)) {
		result = FALSE;
		return result;
	}
	if (unity_place_search_num_hints (self) != unity_place_search_num_hints (other)) {
		result = FALSE;
		return result;
	}
	{
		GList* hint_collection;
		GList* hint_it;
		hint_collection = unity_place_search_get_hints (self);
		for (hint_it = hint_collection; hint_it != NULL; hint_it = hint_it->next) {
			const char* hint;
			hint = (const char*) hint_it->data;
			{
				char* _tmp3_;
				char* _tmp4_;
				gboolean _tmp5_;
				if ((_tmp5_ = _vala_strcmp0 (_tmp3_ = unity_place_search_get_hint (other, hint), _tmp4_ = unity_place_search_get_hint (self, hint)) != 0, _g_free0 (_tmp4_), _g_free0 (_tmp3_), _tmp5_)) {
					result = FALSE;
					_g_list_free0 (hint_collection);
					return result;
				}
			}
		}
		_g_list_free0 (hint_collection);
	}
	result = TRUE;
	return result;
}


static void unity_place_search_class_init (UnityPlaceSearchClass * klass) {
	unity_place_search_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlaceSearchPrivate));
	G_OBJECT_CLASS (klass)->finalize = unity_place_search_finalize;
}


static void unity_place_search_instance_init (UnityPlaceSearch * self) {
	self->priv = UNITY_PLACE_SEARCH_GET_PRIVATE (self);
}


static void unity_place_search_finalize (GObject* obj) {
	UnityPlaceSearch * self;
	self = UNITY_PLACE_SEARCH (obj);
	_g_free0 (self->priv->search);
	_g_hash_table_unref0 (self->priv->hints);
	G_OBJECT_CLASS (unity_place_search_parent_class)->finalize (obj);
}


/**
   *
   */
GType unity_place_search_get_type (void) {
	static volatile gsize unity_place_search_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place_search_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlaceSearchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_place_search_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlaceSearch), 0, (GInstanceInitFunc) unity_place_search_instance_init, NULL };
		GType unity_place_search_type_id;
		unity_place_search_type_id = g_type_register_static (G_TYPE_INITIALLY_UNOWNED, "UnityPlaceSearch", &g_define_type_info, 0);
		g_once_init_leave (&unity_place_search_type_id__volatile, unity_place_search_type_id);
	}
	return unity_place_search_type_id__volatile;
}


static char** _vala_array_dup3 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


void unity_place__entryinfo_copy (const UnityPlace_EntryInfo* self, UnityPlace_EntryInfo* dest) {
	char** _tmp0_;
	UnityPlace_RendererInfo _tmp1_ = {0};
	UnityPlace_RendererInfo _tmp2_ = {0};
	dest->dbus_path = g_strdup (self->dbus_path);
	dest->display_name = g_strdup (self->display_name);
	dest->icon = g_strdup (self->icon);
	dest->position = self->position;
	dest->mimetypes = (_tmp0_ = self->mimetypes, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup3 (_tmp0_, (*self).mimetypes_length1));
	dest->mimetypes_length1 = self->mimetypes_length1;
	dest->sensitive = self->sensitive;
	dest->sections_model = g_strdup (self->sections_model);
	dest->hints = _g_hash_table_ref0 (self->hints);
	dest->entry_renderer_info = (unity_place__rendererinfo_copy (&self->entry_renderer_info, &_tmp1_), _tmp1_);
	dest->global_renderer_info = (unity_place__rendererinfo_copy (&self->global_renderer_info, &_tmp2_), _tmp2_);
}


void unity_place__entryinfo_destroy (UnityPlace_EntryInfo* self) {
	_g_free0 (self->dbus_path);
	_g_free0 (self->display_name);
	_g_free0 (self->icon);
	self->mimetypes = (_vala_array_free (self->mimetypes, (*self).mimetypes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->sections_model);
	_g_hash_table_unref0 (self->hints);
	unity_place__rendererinfo_destroy (&self->entry_renderer_info);
	unity_place__rendererinfo_destroy (&self->global_renderer_info);
}


UnityPlace_EntryInfo* unity_place__entryinfo_dup (const UnityPlace_EntryInfo* self) {
	UnityPlace_EntryInfo* dup;
	dup = g_new0 (UnityPlace_EntryInfo, 1);
	unity_place__entryinfo_copy (self, dup);
	return dup;
}


void unity_place__entryinfo_free (UnityPlace_EntryInfo* self) {
	unity_place__entryinfo_destroy (self);
	g_free (self);
}


GType unity_place__entryinfo_get_type (void) {
	static volatile gsize unity_place__entryinfo_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place__entryinfo_type_id__volatile)) {
		GType unity_place__entryinfo_type_id;
		unity_place__entryinfo_type_id = g_boxed_type_register_static ("UnityPlace_EntryInfo", (GBoxedCopyFunc) unity_place__entryinfo_dup, (GBoxedFreeFunc) unity_place__entryinfo_free);
		g_once_init_leave (&unity_place__entryinfo_type_id__volatile, unity_place__entryinfo_type_id);
	}
	return unity_place__entryinfo_type_id__volatile;
}


static char** _vala_array_dup4 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


void unity_place__entryinfodata_copy (const UnityPlace_EntryInfoData* self, UnityPlace_EntryInfoData* dest) {
	char** _tmp0_;
	dest->dbus_path = g_strdup (self->dbus_path);
	dest->display_name = g_strdup (self->display_name);
	dest->icon = g_strdup (self->icon);
	dest->position = self->position;
	dest->mimetypes = (_tmp0_ = self->mimetypes, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup4 (_tmp0_, (*self).mimetypes_length1));
	dest->mimetypes_length1 = self->mimetypes_length1;
	dest->sensitive = self->sensitive;
	dest->sections_model = g_strdup (self->sections_model);
	dest->hints = _g_hash_table_ref0 (self->hints);
}


void unity_place__entryinfodata_destroy (UnityPlace_EntryInfoData* self) {
	_g_free0 (self->dbus_path);
	_g_free0 (self->display_name);
	_g_free0 (self->icon);
	self->mimetypes = (_vala_array_free (self->mimetypes, (*self).mimetypes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->sections_model);
	_g_hash_table_unref0 (self->hints);
}


UnityPlace_EntryInfoData* unity_place__entryinfodata_dup (const UnityPlace_EntryInfoData* self) {
	UnityPlace_EntryInfoData* dup;
	dup = g_new0 (UnityPlace_EntryInfoData, 1);
	unity_place__entryinfodata_copy (self, dup);
	return dup;
}


void unity_place__entryinfodata_free (UnityPlace_EntryInfoData* self) {
	unity_place__entryinfodata_destroy (self);
	g_free (self);
}


GType unity_place__entryinfodata_get_type (void) {
	static volatile gsize unity_place__entryinfodata_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place__entryinfodata_type_id__volatile)) {
		GType unity_place__entryinfodata_type_id;
		unity_place__entryinfodata_type_id = g_boxed_type_register_static ("UnityPlace_EntryInfoData", (GBoxedCopyFunc) unity_place__entryinfodata_dup, (GBoxedFreeFunc) unity_place__entryinfodata_free);
		g_once_init_leave (&unity_place__entryinfodata_type_id__volatile, unity_place__entryinfodata_type_id);
	}
	return unity_place__entryinfodata_type_id__volatile;
}


UnityPlaceEntryInfo* unity_place_entry_info_construct (GType object_type, const char* dbus_path) {
	UnityPlaceEntryInfo * self;
	gint _empty_length1;
	gint __empty_size_;
	char** _tmp0_;
	char** _empty;
	g_return_val_if_fail (dbus_path != NULL, NULL);
	_empty = (_tmp0_ = g_new0 (char*, 0 + 1), _empty_length1 = 0, __empty_size_ = _empty_length1, _tmp0_);
	self = (UnityPlaceEntryInfo*) g_object_new (object_type, "dbus-path", dbus_path, "mimetypes", _empty, NULL);
	_empty = (_vala_array_free (_empty, _empty_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


UnityPlaceEntryInfo* unity_place_entry_info_new (const char* dbus_path) {
	return unity_place_entry_info_construct (UNITY_PLACE_TYPE_ENTRY_INFO, dbus_path);
}


void unity_place_entry_info_set_hint (UnityPlaceEntryInfo* self, const char* hint, const char* val) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (hint != NULL);
	g_return_if_fail (val != NULL);
	g_hash_table_insert (self->priv->info.hints, g_strdup (hint), g_strdup (val));
}


char* unity_place_entry_info_get_hint (UnityPlaceEntryInfo* self, const char* hint) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hint != NULL, NULL);
	result = g_strdup ((const char*) g_hash_table_lookup (self->priv->info.hints, hint));
	return result;
}


void unity_place_entry_info_clear_hint (UnityPlaceEntryInfo* self, const char* hint) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (hint != NULL);
	g_hash_table_remove (self->priv->info.hints, hint);
}


void unity_place_entry_info_clear_hints (UnityPlaceEntryInfo* self) {
	g_return_if_fail (self != NULL);
	g_hash_table_remove_all (self->priv->info.hints);
}


guint unity_place_entry_info_num_hints (UnityPlaceEntryInfo* self) {
	guint result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_hash_table_size (self->priv->info.hints);
	return result;
}


void unity_place_entry_info_get_raw (UnityPlaceEntryInfo* self, UnityPlace_EntryInfo* result) {
	UnityPlace_EntryInfo _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	*result = (unity_place__entryinfo_copy (&self->priv->info, &_tmp0_), _tmp0_);
	return;
}


UnityPlaceRendererInfo* unity_place_entry_info_get_entry_renderer_info (UnityPlaceEntryInfo* self) {
	UnityPlaceRendererInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_entry_renderer_info;
	return result;
}


UnityPlaceRendererInfo* unity_place_entry_info_get_global_renderer_info (UnityPlaceEntryInfo* self) {
	UnityPlaceRendererInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_global_renderer_info;
	return result;
}


const char* unity_place_entry_info_get_dbus_path (UnityPlaceEntryInfo* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->info.dbus_path;
	return result;
}


void unity_place_entry_info_set_dbus_path (UnityPlaceEntryInfo* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->info.dbus_path = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->info.dbus_path), _tmp0_);
	g_object_notify ((GObject *) self, "dbus-path");
}


const char* unity_place_entry_info_get_display_name (UnityPlaceEntryInfo* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->info.display_name;
	return result;
}


void unity_place_entry_info_set_display_name (UnityPlaceEntryInfo* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->info.display_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->info.display_name), _tmp0_);
	g_object_notify ((GObject *) self, "display-name");
}


const char* unity_place_entry_info_get_icon (UnityPlaceEntryInfo* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->info.icon;
	return result;
}


void unity_place_entry_info_set_icon (UnityPlaceEntryInfo* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->info.icon = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->info.icon), _tmp0_);
	g_object_notify ((GObject *) self, "icon");
}


guint unity_place_entry_info_get_position (UnityPlaceEntryInfo* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->info.position;
	return result;
}


void unity_place_entry_info_set_position (UnityPlaceEntryInfo* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->info.position = value;
	g_object_notify ((GObject *) self, "position");
}


char** unity_place_entry_info_get_mimetypes (UnityPlaceEntryInfo* self, int* result_length1) {
	char** result;
	char** _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp0_ = self->priv->info.mimetypes, *result_length1 = self->priv->info.mimetypes_length1, _tmp0_);
	return result;
}


static char** _vala_array_dup5 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


void unity_place_entry_info_set_mimetypes (UnityPlaceEntryInfo* self, char** value, int value_length1) {
	char** _tmp0_;
	char** _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->info.mimetypes = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup5 (_tmp0_, value_length1)), self->priv->info.mimetypes = (_vala_array_free (self->priv->info.mimetypes, self->priv->info.mimetypes_length1, (GDestroyNotify) g_free), NULL), self->priv->info.mimetypes_length1 = value_length1, self->priv->info._mimetypes_size_ = self->priv->info.mimetypes_length1, _tmp1_);
	g_object_notify ((GObject *) self, "mimetypes");
}


gboolean unity_place_entry_info_get_sensitive (UnityPlaceEntryInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->info.sensitive;
	return result;
}


void unity_place_entry_info_set_sensitive (UnityPlaceEntryInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->info.sensitive = value;
	g_object_notify ((GObject *) self, "sensitive");
}


DeeModel* unity_place_entry_info_get_sections_model (UnityPlaceEntryInfo* self) {
	DeeModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_sections_model;
	return result;
}


void unity_place_entry_info_set_sections_model (UnityPlaceEntryInfo* self, DeeModel* value) {
	DeeModel* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_sections_model = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_sections_model), _tmp0_);
	if (DEE_IS_SHARED_MODEL (value)) {
		DeeModel* _tmp1_;
		DeeSharedModel* model;
		char* _tmp2_;
		model = _g_object_ref0 ((_tmp1_ = value, DEE_IS_SHARED_MODEL (_tmp1_) ? ((DeeSharedModel*) _tmp1_) : NULL));
		self->priv->info.sections_model = (_tmp2_ = g_strdup (dee_shared_model_get_swarm_name (model)), _g_free0 (self->priv->info.sections_model), _tmp2_);
		_g_object_unref0 (model);
	} else {
		char* _tmp3_;
		self->priv->info.sections_model = (_tmp3_ = g_strdup ("__local__"), _g_free0 (self->priv->info.sections_model), _tmp3_);
	}
	g_object_notify ((GObject *) self, "sections-model");
}


gboolean unity_place_entry_info_get_active (UnityPlaceEntryInfo* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}


void unity_place_entry_info_set_active (UnityPlaceEntryInfo* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
	g_object_notify ((GObject *) self, "active");
}


guint unity_place_entry_info_get_active_section (UnityPlaceEntryInfo* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_active_section;
	return result;
}


void unity_place_entry_info_set_active_section (UnityPlaceEntryInfo* self, guint value) {
	g_return_if_fail (self != NULL);
	self->priv->_active_section = value;
	g_object_notify ((GObject *) self, "active-section");
}


UnityPlaceSearch* unity_place_entry_info_get_active_search (UnityPlaceEntryInfo* self) {
	UnityPlaceSearch* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_active_search;
	return result;
}


void unity_place_entry_info_set_active_search (UnityPlaceEntryInfo* self, UnityPlaceSearch* value) {
	UnityPlaceSearch* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_active_search = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_active_search), _tmp0_);
	g_object_notify ((GObject *) self, "active-search");
}


UnityPlaceSearch* unity_place_entry_info_get_active_global_search (UnityPlaceEntryInfo* self) {
	UnityPlaceSearch* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_active_global_search;
	return result;
}


void unity_place_entry_info_set_active_global_search (UnityPlaceEntryInfo* self, UnityPlaceSearch* value) {
	UnityPlaceSearch* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_active_global_search = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_active_global_search), _tmp0_);
	g_object_notify ((GObject *) self, "active-global-search");
}


UnityPlaceBrowser* unity_place_entry_info_get_browser (UnityPlaceEntryInfo* self) {
	UnityPlaceBrowser* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_browser;
	return result;
}


void unity_place_entry_info_set_browser (UnityPlaceEntryInfo* self, UnityPlaceBrowser* value) {
	UnityPlaceBrowser* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_browser = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_browser), _tmp0_);
	if (value != NULL) {
		unity_place_entry_info_set_hint (self, "UnityPlaceBrowserPath", unity_place_browser_get_dbus_path (value));
		unity_place_entry_info_set_hint (self, "UnitySectionStyle", "breadcrumb");
	} else {
		unity_place_entry_info_clear_hint (self, "UnityPlaceBrowserPath");
		unity_place_entry_info_clear_hint (self, "UnitySectionStyle");
	}
	g_object_notify ((GObject *) self, "browser");
}


static GObject * unity_place_entry_info_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPlaceEntryInfo * self;
	parent_class = G_OBJECT_CLASS (unity_place_entry_info_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PLACE_ENTRY_INFO (obj);
	{
		GHashTable* _tmp6_;
		char* _tmp7_;
		char* _tmp8_;
		char* _tmp9_;
		GHashTable* _tmp10_;
		char* _tmp11_;
		char* _tmp12_;
		char* _tmp13_;
		GHashTable* _tmp14_;
		UnityPlaceRendererInfo* _tmp15_;
		UnityPlaceRendererInfo* _tmp16_;
		if (self->priv->info.dbus_path == NULL) {
			char* _tmp1_;
			g_critical ("unity-place.vala:369: No DBus path set for EntryInfo.\n" \
"'dbus-path' property in the UnityPlaceEntryInfo constructor");
			self->priv->info.dbus_path = (_tmp1_ = g_strdup (""), _g_free0 (self->priv->info.dbus_path), _tmp1_);
		}
		if (self->priv->info.display_name == NULL) {
			char* _tmp2_;
			self->priv->info.display_name = (_tmp2_ = g_strdup (""), _g_free0 (self->priv->info.display_name), _tmp2_);
		}
		if (self->priv->info.icon == NULL) {
			char* _tmp3_;
			self->priv->info.icon = (_tmp3_ = g_strdup (""), _g_free0 (self->priv->info.icon), _tmp3_);
		}
		self->priv->info.position = (guint) 0;
		if (self->priv->info.mimetypes == NULL) {
			char** _tmp4_;
			self->priv->info.mimetypes = (_tmp4_ = g_new0 (char*, 0 + 1), self->priv->info.mimetypes = (_vala_array_free (self->priv->info.mimetypes, self->priv->info.mimetypes_length1, (GDestroyNotify) g_free), NULL), self->priv->info.mimetypes_length1 = 0, self->priv->info._mimetypes_size_ = self->priv->info.mimetypes_length1, _tmp4_);
		}
		self->priv->info.sensitive = TRUE;
		if (self->priv->info.sections_model == NULL) {
			char* _tmp5_;
			self->priv->info.sections_model = (_tmp5_ = g_strdup (""), _g_free0 (self->priv->info.sections_model), _tmp5_);
		}
		self->priv->info.hints = (_tmp6_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free), _g_hash_table_unref0 (self->priv->info.hints), _tmp6_);
		self->priv->info.entry_renderer_info.default_renderer = (_tmp7_ = g_strdup (""), _g_free0 (self->priv->info.entry_renderer_info.default_renderer), _tmp7_);
		self->priv->info.entry_renderer_info.groups_model = (_tmp8_ = g_strdup (""), _g_free0 (self->priv->info.entry_renderer_info.groups_model), _tmp8_);
		self->priv->info.entry_renderer_info.results_model = (_tmp9_ = g_strdup (""), _g_free0 (self->priv->info.entry_renderer_info.results_model), _tmp9_);
		self->priv->info.entry_renderer_info.hints = (_tmp10_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free), _g_hash_table_unref0 (self->priv->info.entry_renderer_info.hints), _tmp10_);
		self->priv->info.global_renderer_info.default_renderer = (_tmp11_ = g_strdup (""), _g_free0 (self->priv->info.global_renderer_info.default_renderer), _tmp11_);
		self->priv->info.global_renderer_info.groups_model = (_tmp12_ = g_strdup (""), _g_free0 (self->priv->info.global_renderer_info.groups_model), _tmp12_);
		self->priv->info.global_renderer_info.results_model = (_tmp13_ = g_strdup (""), _g_free0 (self->priv->info.global_renderer_info.results_model), _tmp13_);
		self->priv->info.global_renderer_info.hints = (_tmp14_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free), _g_hash_table_unref0 (self->priv->info.global_renderer_info.hints), _tmp14_);
		self->priv->_entry_renderer_info = (_tmp15_ = unity_place_renderer_info_new (&self->priv->info.entry_renderer_info), _g_object_unref0 (self->priv->_entry_renderer_info), _tmp15_);
		self->priv->_global_renderer_info = (_tmp16_ = unity_place_renderer_info_new (&self->priv->info.global_renderer_info), _g_object_unref0 (self->priv->_global_renderer_info), _tmp16_);
	}
	return obj;
}


static void unity_place_entry_info_class_init (UnityPlaceEntryInfoClass * klass) {
	unity_place_entry_info_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlaceEntryInfoPrivate));
	G_OBJECT_CLASS (klass)->get_property = unity_place_entry_info_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_place_entry_info_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_place_entry_info_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_place_entry_info_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_ENTRY_RENDERER_INFO, g_param_spec_object ("entry-renderer-info", "entry-renderer-info", "entry-renderer-info", UNITY_PLACE_TYPE_RENDERER_INFO, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_GLOBAL_RENDERER_INFO, g_param_spec_object ("global-renderer-info", "global-renderer-info", "global-renderer-info", UNITY_PLACE_TYPE_RENDERER_INFO, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_DBUS_PATH, g_param_spec_string ("dbus-path", "dbus-path", "dbus-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_ICON, g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_POSITION, g_param_spec_uint ("position", "position", "position", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_MIMETYPES, g_param_spec_boxed ("mimetypes", "mimetypes", "mimetypes", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_SENSITIVE, g_param_spec_boolean ("sensitive", "sensitive", "sensitive", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_SECTIONS_MODEL, g_param_spec_object ("sections-model", "sections-model", "sections-model", DEE_TYPE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_ACTIVE_SECTION, g_param_spec_uint ("active-section", "active-section", "active-section", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_ACTIVE_SEARCH, g_param_spec_object ("active-search", "active-search", "active-search", UNITY_PLACE_TYPE_SEARCH, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_ACTIVE_GLOBAL_SEARCH, g_param_spec_object ("active-global-search", "active-global-search", "active-global-search", UNITY_PLACE_TYPE_SEARCH, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_INFO_BROWSER, g_param_spec_object ("browser", "browser", "browser", UNITY_PLACE_TYPE_BROWSER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_place_entry_info_instance_init (UnityPlaceEntryInfo * self) {
	UnityPlace_EntryInfo _tmp0_ = {0};
	self->priv = UNITY_PLACE_ENTRY_INFO_GET_PRIVATE (self);
	self->priv->info = (memset (&_tmp0_, 0, sizeof (UnityPlace_EntryInfo)), _tmp0_);
	self->priv->_active = FALSE;
	self->priv->_active_section = (guint) 0;
	self->priv->_browser = NULL;
}


static void unity_place_entry_info_finalize (GObject* obj) {
	UnityPlaceEntryInfo * self;
	self = UNITY_PLACE_ENTRY_INFO (obj);
	unity_place__entryinfo_destroy (&self->priv->info);
	_g_object_unref0 (self->priv->_entry_renderer_info);
	_g_object_unref0 (self->priv->_global_renderer_info);
	_g_object_unref0 (self->priv->_sections_model);
	_g_object_unref0 (self->priv->_active_search);
	_g_object_unref0 (self->priv->_active_global_search);
	_g_object_unref0 (self->priv->_browser);
	G_OBJECT_CLASS (unity_place_entry_info_parent_class)->finalize (obj);
}


GType unity_place_entry_info_get_type (void) {
	static volatile gsize unity_place_entry_info_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place_entry_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlaceEntryInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_place_entry_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlaceEntryInfo), 0, (GInstanceInitFunc) unity_place_entry_info_instance_init, NULL };
		GType unity_place_entry_info_type_id;
		unity_place_entry_info_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityPlaceEntryInfo", &g_define_type_info, 0);
		g_once_init_leave (&unity_place_entry_info_type_id__volatile, unity_place_entry_info_type_id);
	}
	return unity_place_entry_info_type_id__volatile;
}


static void unity_place_entry_info_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlaceEntryInfo * self;
	int length;
	self = UNITY_PLACE_ENTRY_INFO (object);
	switch (property_id) {
		case UNITY_PLACE_ENTRY_INFO_ENTRY_RENDERER_INFO:
		g_value_set_object (value, unity_place_entry_info_get_entry_renderer_info (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_GLOBAL_RENDERER_INFO:
		g_value_set_object (value, unity_place_entry_info_get_global_renderer_info (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_DBUS_PATH:
		g_value_set_string (value, unity_place_entry_info_get_dbus_path (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_DISPLAY_NAME:
		g_value_set_string (value, unity_place_entry_info_get_display_name (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_ICON:
		g_value_set_string (value, unity_place_entry_info_get_icon (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_POSITION:
		g_value_set_uint (value, unity_place_entry_info_get_position (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_MIMETYPES:
		g_value_set_boxed (value, unity_place_entry_info_get_mimetypes (self, &length));
		break;
		case UNITY_PLACE_ENTRY_INFO_SENSITIVE:
		g_value_set_boolean (value, unity_place_entry_info_get_sensitive (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_SECTIONS_MODEL:
		g_value_set_object (value, unity_place_entry_info_get_sections_model (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_ACTIVE:
		g_value_set_boolean (value, unity_place_entry_info_get_active (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_ACTIVE_SECTION:
		g_value_set_uint (value, unity_place_entry_info_get_active_section (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_ACTIVE_SEARCH:
		g_value_set_object (value, unity_place_entry_info_get_active_search (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_ACTIVE_GLOBAL_SEARCH:
		g_value_set_object (value, unity_place_entry_info_get_active_global_search (self));
		break;
		case UNITY_PLACE_ENTRY_INFO_BROWSER:
		g_value_set_object (value, unity_place_entry_info_get_browser (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_place_entry_info_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlaceEntryInfo * self;
	gpointer boxed;
	self = UNITY_PLACE_ENTRY_INFO (object);
	switch (property_id) {
		case UNITY_PLACE_ENTRY_INFO_DBUS_PATH:
		unity_place_entry_info_set_dbus_path (self, g_value_get_string (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_DISPLAY_NAME:
		unity_place_entry_info_set_display_name (self, g_value_get_string (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_ICON:
		unity_place_entry_info_set_icon (self, g_value_get_string (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_POSITION:
		unity_place_entry_info_set_position (self, g_value_get_uint (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_MIMETYPES:
		boxed = g_value_get_boxed (value);
		unity_place_entry_info_set_mimetypes (self, boxed, g_strv_length (boxed));
		break;
		case UNITY_PLACE_ENTRY_INFO_SENSITIVE:
		unity_place_entry_info_set_sensitive (self, g_value_get_boolean (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_SECTIONS_MODEL:
		unity_place_entry_info_set_sections_model (self, g_value_get_object (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_ACTIVE:
		unity_place_entry_info_set_active (self, g_value_get_boolean (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_ACTIVE_SECTION:
		unity_place_entry_info_set_active_section (self, g_value_get_uint (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_ACTIVE_SEARCH:
		unity_place_entry_info_set_active_search (self, g_value_get_object (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_ACTIVE_GLOBAL_SEARCH:
		unity_place_entry_info_set_active_global_search (self, g_value_get_object (value));
		break;
		case UNITY_PLACE_ENTRY_INFO_BROWSER:
		unity_place_entry_info_set_browser (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityPlace_EntryInfo* unity_place_service_get_entries (UnityPlaceService* self, int* result_length1, GError** error) {
	return UNITY_PLACE_SERVICE_GET_INTERFACE (self)->get_entries (self, result_length1, error);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _unity_place_service_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_unity_place_service_introspect (UnityPlaceService* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"com.canonical.Unity.Place\">\n  <method name=\"GetEntries\">\n    <arg name=\"result\" type=\"a(sssuasbsa{ss}(sssa{ss})(sssa{ss}))\" direction=\"out\"/>\n  </method>\n  <signal name=\"EntryAdded\">\n    <arg name=\"entry\" type=\"(sssuasbsa{ss}(sssa{ss})(sssa{ss}))\"/>\n  </signal>\n  <signal name=\"EntryRemoved\">\n    <arg name=\"entry_dbus_path\" type=\"s\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_unity_place_service_property_get_all (UnityPlaceService* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "com.canonical.Unity.Place") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _vala_UnityPlace_EntryInfo_array_free (UnityPlace_EntryInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			unity_place__entryinfo_destroy (&array[i]);
		}
	}
	g_free (array);
}


static DBusHandlerResult _dbus_unity_place_service_get_entries (UnityPlaceService* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	UnityPlace_EntryInfo* result;
	int result_length1;
	DBusMessage* reply;
	UnityPlace_EntryInfo* _tmp1_;
	DBusMessageIter _tmp2_;
	int _tmp3_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = unity_place_service_get_entries (self, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp1_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "(sssuasbsa{ss}(sssa{ss})(sssa{ss}))", &_tmp2_);
	for (_tmp3_ = 0; _tmp3_ < result_length1; _tmp3_++) {
		DBusMessageIter _tmp4_;
		const char* _tmp5_;
		const char* _tmp6_;
		const char* _tmp7_;
		dbus_uint32_t _tmp8_;
		char** _tmp9_;
		DBusMessageIter _tmp10_;
		int _tmp11_;
		dbus_bool_t _tmp13_;
		const char* _tmp14_;
		DBusMessageIter _tmp15_, _tmp16_;
		GHashTableIter _tmp17_;
		gpointer _tmp18_, _tmp19_;
		DBusMessageIter _tmp22_;
		const char* _tmp23_;
		const char* _tmp24_;
		const char* _tmp25_;
		DBusMessageIter _tmp26_, _tmp27_;
		GHashTableIter _tmp28_;
		gpointer _tmp29_, _tmp30_;
		DBusMessageIter _tmp33_;
		const char* _tmp34_;
		const char* _tmp35_;
		const char* _tmp36_;
		DBusMessageIter _tmp37_, _tmp38_;
		GHashTableIter _tmp39_;
		gpointer _tmp40_, _tmp41_;
		dbus_message_iter_open_container (&_tmp2_, DBUS_TYPE_STRUCT, NULL, &_tmp4_);
		_tmp5_ = (*_tmp1_).dbus_path;
		dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_STRING, &_tmp5_);
		_tmp6_ = (*_tmp1_).display_name;
		dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_STRING, &_tmp6_);
		_tmp7_ = (*_tmp1_).icon;
		dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_STRING, &_tmp7_);
		_tmp8_ = (*_tmp1_).position;
		dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_UINT32, &_tmp8_);
		_tmp9_ = (*_tmp1_).mimetypes;
		dbus_message_iter_open_container (&_tmp4_, DBUS_TYPE_ARRAY, "s", &_tmp10_);
		for (_tmp11_ = 0; _tmp11_ < (*_tmp1_).mimetypes_length1; _tmp11_++) {
			const char* _tmp12_;
			_tmp12_ = *_tmp9_;
			dbus_message_iter_append_basic (&_tmp10_, DBUS_TYPE_STRING, &_tmp12_);
			_tmp9_++;
		}
		dbus_message_iter_close_container (&_tmp4_, &_tmp10_);
		_tmp13_ = (*_tmp1_).sensitive;
		dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_BOOLEAN, &_tmp13_);
		_tmp14_ = (*_tmp1_).sections_model;
		dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_STRING, &_tmp14_);
		dbus_message_iter_open_container (&_tmp4_, DBUS_TYPE_ARRAY, "{ss}", &_tmp15_);
		g_hash_table_iter_init (&_tmp17_, (*_tmp1_).hints);
		while (g_hash_table_iter_next (&_tmp17_, &_tmp18_, &_tmp19_)) {
			char* _key;
			char* _value;
			const char* _tmp20_;
			const char* _tmp21_;
			dbus_message_iter_open_container (&_tmp15_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp16_);
			_key = (char*) _tmp18_;
			_value = (char*) _tmp19_;
			_tmp20_ = _key;
			dbus_message_iter_append_basic (&_tmp16_, DBUS_TYPE_STRING, &_tmp20_);
			_tmp21_ = _value;
			dbus_message_iter_append_basic (&_tmp16_, DBUS_TYPE_STRING, &_tmp21_);
			dbus_message_iter_close_container (&_tmp15_, &_tmp16_);
		}
		dbus_message_iter_close_container (&_tmp4_, &_tmp15_);
		dbus_message_iter_open_container (&_tmp4_, DBUS_TYPE_STRUCT, NULL, &_tmp22_);
		_tmp23_ = (*_tmp1_).entry_renderer_info.default_renderer;
		dbus_message_iter_append_basic (&_tmp22_, DBUS_TYPE_STRING, &_tmp23_);
		_tmp24_ = (*_tmp1_).entry_renderer_info.groups_model;
		dbus_message_iter_append_basic (&_tmp22_, DBUS_TYPE_STRING, &_tmp24_);
		_tmp25_ = (*_tmp1_).entry_renderer_info.results_model;
		dbus_message_iter_append_basic (&_tmp22_, DBUS_TYPE_STRING, &_tmp25_);
		dbus_message_iter_open_container (&_tmp22_, DBUS_TYPE_ARRAY, "{ss}", &_tmp26_);
		g_hash_table_iter_init (&_tmp28_, (*_tmp1_).entry_renderer_info.hints);
		while (g_hash_table_iter_next (&_tmp28_, &_tmp29_, &_tmp30_)) {
			char* _key;
			char* _value;
			const char* _tmp31_;
			const char* _tmp32_;
			dbus_message_iter_open_container (&_tmp26_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp27_);
			_key = (char*) _tmp29_;
			_value = (char*) _tmp30_;
			_tmp31_ = _key;
			dbus_message_iter_append_basic (&_tmp27_, DBUS_TYPE_STRING, &_tmp31_);
			_tmp32_ = _value;
			dbus_message_iter_append_basic (&_tmp27_, DBUS_TYPE_STRING, &_tmp32_);
			dbus_message_iter_close_container (&_tmp26_, &_tmp27_);
		}
		dbus_message_iter_close_container (&_tmp22_, &_tmp26_);
		dbus_message_iter_close_container (&_tmp4_, &_tmp22_);
		dbus_message_iter_open_container (&_tmp4_, DBUS_TYPE_STRUCT, NULL, &_tmp33_);
		_tmp34_ = (*_tmp1_).global_renderer_info.default_renderer;
		dbus_message_iter_append_basic (&_tmp33_, DBUS_TYPE_STRING, &_tmp34_);
		_tmp35_ = (*_tmp1_).global_renderer_info.groups_model;
		dbus_message_iter_append_basic (&_tmp33_, DBUS_TYPE_STRING, &_tmp35_);
		_tmp36_ = (*_tmp1_).global_renderer_info.results_model;
		dbus_message_iter_append_basic (&_tmp33_, DBUS_TYPE_STRING, &_tmp36_);
		dbus_message_iter_open_container (&_tmp33_, DBUS_TYPE_ARRAY, "{ss}", &_tmp37_);
		g_hash_table_iter_init (&_tmp39_, (*_tmp1_).global_renderer_info.hints);
		while (g_hash_table_iter_next (&_tmp39_, &_tmp40_, &_tmp41_)) {
			char* _key;
			char* _value;
			const char* _tmp42_;
			const char* _tmp43_;
			dbus_message_iter_open_container (&_tmp37_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp38_);
			_key = (char*) _tmp40_;
			_value = (char*) _tmp41_;
			_tmp42_ = _key;
			dbus_message_iter_append_basic (&_tmp38_, DBUS_TYPE_STRING, &_tmp42_);
			_tmp43_ = _value;
			dbus_message_iter_append_basic (&_tmp38_, DBUS_TYPE_STRING, &_tmp43_);
			dbus_message_iter_close_container (&_tmp37_, &_tmp38_);
		}
		dbus_message_iter_close_container (&_tmp33_, &_tmp37_);
		dbus_message_iter_close_container (&_tmp4_, &_tmp33_);
		dbus_message_iter_close_container (&_tmp2_, &_tmp4_);
		_tmp1_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp2_);
	result = (_vala_UnityPlace_EntryInfo_array_free (result,  result_length1), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult unity_place_service_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_unity_place_service_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_unity_place_service_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "com.canonical.Unity.Place", "GetEntries")) {
		result = _dbus_unity_place_service_get_entries (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_unity_place_service_entry_added (GObject* _sender, UnityPlace_EntryInfo* entry, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	DBusMessageIter _tmp44_;
	const char* _tmp45_;
	const char* _tmp46_;
	const char* _tmp47_;
	dbus_uint32_t _tmp48_;
	char** _tmp49_;
	DBusMessageIter _tmp50_;
	int _tmp51_;
	dbus_bool_t _tmp53_;
	const char* _tmp54_;
	DBusMessageIter _tmp55_, _tmp56_;
	GHashTableIter _tmp57_;
	gpointer _tmp58_, _tmp59_;
	DBusMessageIter _tmp62_;
	const char* _tmp63_;
	const char* _tmp64_;
	const char* _tmp65_;
	DBusMessageIter _tmp66_, _tmp67_;
	GHashTableIter _tmp68_;
	gpointer _tmp69_, _tmp70_;
	DBusMessageIter _tmp73_;
	const char* _tmp74_;
	const char* _tmp75_;
	const char* _tmp76_;
	DBusMessageIter _tmp77_, _tmp78_;
	GHashTableIter _tmp79_;
	gpointer _tmp80_, _tmp81_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "com.canonical.Unity.Place", "EntryAdded");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_STRUCT, NULL, &_tmp44_);
	_tmp45_ = (*entry).dbus_path;
	dbus_message_iter_append_basic (&_tmp44_, DBUS_TYPE_STRING, &_tmp45_);
	_tmp46_ = (*entry).display_name;
	dbus_message_iter_append_basic (&_tmp44_, DBUS_TYPE_STRING, &_tmp46_);
	_tmp47_ = (*entry).icon;
	dbus_message_iter_append_basic (&_tmp44_, DBUS_TYPE_STRING, &_tmp47_);
	_tmp48_ = (*entry).position;
	dbus_message_iter_append_basic (&_tmp44_, DBUS_TYPE_UINT32, &_tmp48_);
	_tmp49_ = (*entry).mimetypes;
	dbus_message_iter_open_container (&_tmp44_, DBUS_TYPE_ARRAY, "s", &_tmp50_);
	for (_tmp51_ = 0; _tmp51_ < (*entry).mimetypes_length1; _tmp51_++) {
		const char* _tmp52_;
		_tmp52_ = *_tmp49_;
		dbus_message_iter_append_basic (&_tmp50_, DBUS_TYPE_STRING, &_tmp52_);
		_tmp49_++;
	}
	dbus_message_iter_close_container (&_tmp44_, &_tmp50_);
	_tmp53_ = (*entry).sensitive;
	dbus_message_iter_append_basic (&_tmp44_, DBUS_TYPE_BOOLEAN, &_tmp53_);
	_tmp54_ = (*entry).sections_model;
	dbus_message_iter_append_basic (&_tmp44_, DBUS_TYPE_STRING, &_tmp54_);
	dbus_message_iter_open_container (&_tmp44_, DBUS_TYPE_ARRAY, "{ss}", &_tmp55_);
	g_hash_table_iter_init (&_tmp57_, (*entry).hints);
	while (g_hash_table_iter_next (&_tmp57_, &_tmp58_, &_tmp59_)) {
		char* _key;
		char* _value;
		const char* _tmp60_;
		const char* _tmp61_;
		dbus_message_iter_open_container (&_tmp55_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp56_);
		_key = (char*) _tmp58_;
		_value = (char*) _tmp59_;
		_tmp60_ = _key;
		dbus_message_iter_append_basic (&_tmp56_, DBUS_TYPE_STRING, &_tmp60_);
		_tmp61_ = _value;
		dbus_message_iter_append_basic (&_tmp56_, DBUS_TYPE_STRING, &_tmp61_);
		dbus_message_iter_close_container (&_tmp55_, &_tmp56_);
	}
	dbus_message_iter_close_container (&_tmp44_, &_tmp55_);
	dbus_message_iter_open_container (&_tmp44_, DBUS_TYPE_STRUCT, NULL, &_tmp62_);
	_tmp63_ = (*entry).entry_renderer_info.default_renderer;
	dbus_message_iter_append_basic (&_tmp62_, DBUS_TYPE_STRING, &_tmp63_);
	_tmp64_ = (*entry).entry_renderer_info.groups_model;
	dbus_message_iter_append_basic (&_tmp62_, DBUS_TYPE_STRING, &_tmp64_);
	_tmp65_ = (*entry).entry_renderer_info.results_model;
	dbus_message_iter_append_basic (&_tmp62_, DBUS_TYPE_STRING, &_tmp65_);
	dbus_message_iter_open_container (&_tmp62_, DBUS_TYPE_ARRAY, "{ss}", &_tmp66_);
	g_hash_table_iter_init (&_tmp68_, (*entry).entry_renderer_info.hints);
	while (g_hash_table_iter_next (&_tmp68_, &_tmp69_, &_tmp70_)) {
		char* _key;
		char* _value;
		const char* _tmp71_;
		const char* _tmp72_;
		dbus_message_iter_open_container (&_tmp66_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp67_);
		_key = (char*) _tmp69_;
		_value = (char*) _tmp70_;
		_tmp71_ = _key;
		dbus_message_iter_append_basic (&_tmp67_, DBUS_TYPE_STRING, &_tmp71_);
		_tmp72_ = _value;
		dbus_message_iter_append_basic (&_tmp67_, DBUS_TYPE_STRING, &_tmp72_);
		dbus_message_iter_close_container (&_tmp66_, &_tmp67_);
	}
	dbus_message_iter_close_container (&_tmp62_, &_tmp66_);
	dbus_message_iter_close_container (&_tmp44_, &_tmp62_);
	dbus_message_iter_open_container (&_tmp44_, DBUS_TYPE_STRUCT, NULL, &_tmp73_);
	_tmp74_ = (*entry).global_renderer_info.default_renderer;
	dbus_message_iter_append_basic (&_tmp73_, DBUS_TYPE_STRING, &_tmp74_);
	_tmp75_ = (*entry).global_renderer_info.groups_model;
	dbus_message_iter_append_basic (&_tmp73_, DBUS_TYPE_STRING, &_tmp75_);
	_tmp76_ = (*entry).global_renderer_info.results_model;
	dbus_message_iter_append_basic (&_tmp73_, DBUS_TYPE_STRING, &_tmp76_);
	dbus_message_iter_open_container (&_tmp73_, DBUS_TYPE_ARRAY, "{ss}", &_tmp77_);
	g_hash_table_iter_init (&_tmp79_, (*entry).global_renderer_info.hints);
	while (g_hash_table_iter_next (&_tmp79_, &_tmp80_, &_tmp81_)) {
		char* _key;
		char* _value;
		const char* _tmp82_;
		const char* _tmp83_;
		dbus_message_iter_open_container (&_tmp77_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp78_);
		_key = (char*) _tmp80_;
		_value = (char*) _tmp81_;
		_tmp82_ = _key;
		dbus_message_iter_append_basic (&_tmp78_, DBUS_TYPE_STRING, &_tmp82_);
		_tmp83_ = _value;
		dbus_message_iter_append_basic (&_tmp78_, DBUS_TYPE_STRING, &_tmp83_);
		dbus_message_iter_close_container (&_tmp77_, &_tmp78_);
	}
	dbus_message_iter_close_container (&_tmp73_, &_tmp77_);
	dbus_message_iter_close_container (&_tmp44_, &_tmp73_);
	dbus_message_iter_close_container (&_iter, &_tmp44_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_unity_place_service_entry_removed (GObject* _sender, const char* entry_dbus_path, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	const char* _tmp84_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "com.canonical.Unity.Place", "EntryRemoved");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp84_ = entry_dbus_path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp84_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void unity_place_service_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_unity_place_service_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "entry-added", (GCallback) _dbus_unity_place_service_entry_added, connection);
	g_signal_connect (object, "entry-removed", (GCallback) _dbus_unity_place_service_entry_removed, connection);
}


static void unity_place_service_base_init (UnityPlaceServiceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("entry_added", UNITY_PLACE_TYPE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, UNITY_PLACE_TYPE__ENTRYINFO);
		g_signal_new ("entry_removed", UNITY_PLACE_TYPE_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
		g_type_set_qdata (UNITY_PLACE_TYPE_SERVICE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_unity_place_service_dbus_vtable));
	}
}


/**
   * UnityPlaceService:
   *
   * DBus interface exported by a place daemon
   */
GType unity_place_service_get_type (void) {
	static volatile gsize unity_place_service_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlaceServiceIface), (GBaseInitFunc) unity_place_service_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType unity_place_service_type_id;
		unity_place_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "UnityPlaceService", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (unity_place_service_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (unity_place_service_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &unity_place_service_dbus_proxy_get_type);
		g_once_init_leave (&unity_place_service_type_id__volatile, unity_place_service_type_id);
	}
	return unity_place_service_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (UnityPlaceServiceDBusProxy, unity_place_service_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (UNITY_PLACE_TYPE_SERVICE, unity_place_service_dbus_proxy_unity_place_service__interface_init) );
UnityPlaceService* unity_place_service_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	UnityPlaceService* self;
	self = g_object_new (unity_place_service_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "com.canonical.Unity.Place", NULL);
	return self;
}


static GObject* unity_place_service_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (unity_place_service_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), unity_place_service_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_unity_place_service_entry_added (UnityPlaceService* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	UnityPlace_EntryInfo entry = {0};
	UnityPlace_EntryInfo _tmp1_;
	DBusMessageIter _tmp2_;
	const char* _tmp3_;
	const char* _tmp4_;
	const char* _tmp5_;
	dbus_uint32_t _tmp6_;
	char** _tmp7_;
	int _tmp7__length;
	int _tmp7__size;
	int _tmp7__length1;
	DBusMessageIter _tmp8_;
	dbus_bool_t _tmp10_;
	const char* _tmp11_;
	GHashTable* _tmp12_;
	DBusMessageIter _tmp13_;
	DBusMessageIter _tmp14_;
	UnityPlace_RendererInfo _tmp17_;
	DBusMessageIter _tmp18_;
	const char* _tmp19_;
	const char* _tmp20_;
	const char* _tmp21_;
	GHashTable* _tmp22_;
	DBusMessageIter _tmp23_;
	DBusMessageIter _tmp24_;
	UnityPlace_RendererInfo _tmp27_;
	DBusMessageIter _tmp28_;
	const char* _tmp29_;
	const char* _tmp30_;
	const char* _tmp31_;
	GHashTable* _tmp32_;
	DBusMessageIter _tmp33_;
	DBusMessageIter _tmp34_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "(sssuasbsa{ss}(sssa{ss})(sssa{ss}))")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_recurse (&iter, &_tmp2_);
	dbus_message_iter_get_basic (&_tmp2_, &_tmp3_);
	dbus_message_iter_next (&_tmp2_);
	_tmp1_.dbus_path = g_strdup (_tmp3_);
	dbus_message_iter_get_basic (&_tmp2_, &_tmp4_);
	dbus_message_iter_next (&_tmp2_);
	_tmp1_.display_name = g_strdup (_tmp4_);
	dbus_message_iter_get_basic (&_tmp2_, &_tmp5_);
	dbus_message_iter_next (&_tmp2_);
	_tmp1_.icon = g_strdup (_tmp5_);
	dbus_message_iter_get_basic (&_tmp2_, &_tmp6_);
	dbus_message_iter_next (&_tmp2_);
	_tmp1_.position = _tmp6_;
	_tmp7_ = g_new (char*, 5);
	_tmp7__length = 0;
	_tmp7__size = 4;
	_tmp7__length1 = 0;
	dbus_message_iter_recurse (&_tmp2_, &_tmp8_);
	for (; dbus_message_iter_get_arg_type (&_tmp8_); _tmp7__length1++) {
		const char* _tmp9_;
		if (_tmp7__size == _tmp7__length) {
			_tmp7__size = 2 * _tmp7__size;
			_tmp7_ = g_renew (char*, _tmp7_, _tmp7__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp8_, &_tmp9_);
		dbus_message_iter_next (&_tmp8_);
		_tmp7_[_tmp7__length++] = g_strdup (_tmp9_);
	}
	_tmp1_.mimetypes_length1 = _tmp7__length1;
	_tmp7_[_tmp7__length] = NULL;
	dbus_message_iter_next (&_tmp2_);
	_tmp1_.mimetypes = _tmp7_;
	dbus_message_iter_get_basic (&_tmp2_, &_tmp10_);
	dbus_message_iter_next (&_tmp2_);
	_tmp1_.sensitive = _tmp10_;
	dbus_message_iter_get_basic (&_tmp2_, &_tmp11_);
	dbus_message_iter_next (&_tmp2_);
	_tmp1_.sections_model = g_strdup (_tmp11_);
	_tmp12_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	dbus_message_iter_recurse (&_tmp2_, &_tmp13_);
	while (dbus_message_iter_get_arg_type (&_tmp13_)) {
		char* _key;
		char* _value;
		const char* _tmp15_;
		const char* _tmp16_;
		dbus_message_iter_recurse (&_tmp13_, &_tmp14_);
		dbus_message_iter_get_basic (&_tmp14_, &_tmp15_);
		dbus_message_iter_next (&_tmp14_);
		_key = g_strdup (_tmp15_);
		dbus_message_iter_get_basic (&_tmp14_, &_tmp16_);
		dbus_message_iter_next (&_tmp14_);
		_value = g_strdup (_tmp16_);
		g_hash_table_insert (_tmp12_, _key, _value);
		dbus_message_iter_next (&_tmp13_);
	}
	dbus_message_iter_next (&_tmp2_);
	_tmp1_.hints = _tmp12_;
	dbus_message_iter_recurse (&_tmp2_, &_tmp18_);
	dbus_message_iter_get_basic (&_tmp18_, &_tmp19_);
	dbus_message_iter_next (&_tmp18_);
	_tmp17_.default_renderer = g_strdup (_tmp19_);
	dbus_message_iter_get_basic (&_tmp18_, &_tmp20_);
	dbus_message_iter_next (&_tmp18_);
	_tmp17_.groups_model = g_strdup (_tmp20_);
	dbus_message_iter_get_basic (&_tmp18_, &_tmp21_);
	dbus_message_iter_next (&_tmp18_);
	_tmp17_.results_model = g_strdup (_tmp21_);
	_tmp22_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	dbus_message_iter_recurse (&_tmp18_, &_tmp23_);
	while (dbus_message_iter_get_arg_type (&_tmp23_)) {
		char* _key;
		char* _value;
		const char* _tmp25_;
		const char* _tmp26_;
		dbus_message_iter_recurse (&_tmp23_, &_tmp24_);
		dbus_message_iter_get_basic (&_tmp24_, &_tmp25_);
		dbus_message_iter_next (&_tmp24_);
		_key = g_strdup (_tmp25_);
		dbus_message_iter_get_basic (&_tmp24_, &_tmp26_);
		dbus_message_iter_next (&_tmp24_);
		_value = g_strdup (_tmp26_);
		g_hash_table_insert (_tmp22_, _key, _value);
		dbus_message_iter_next (&_tmp23_);
	}
	dbus_message_iter_next (&_tmp18_);
	_tmp17_.hints = _tmp22_;
	dbus_message_iter_next (&_tmp2_);
	_tmp1_.entry_renderer_info = _tmp17_;
	dbus_message_iter_recurse (&_tmp2_, &_tmp28_);
	dbus_message_iter_get_basic (&_tmp28_, &_tmp29_);
	dbus_message_iter_next (&_tmp28_);
	_tmp27_.default_renderer = g_strdup (_tmp29_);
	dbus_message_iter_get_basic (&_tmp28_, &_tmp30_);
	dbus_message_iter_next (&_tmp28_);
	_tmp27_.groups_model = g_strdup (_tmp30_);
	dbus_message_iter_get_basic (&_tmp28_, &_tmp31_);
	dbus_message_iter_next (&_tmp28_);
	_tmp27_.results_model = g_strdup (_tmp31_);
	_tmp32_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	dbus_message_iter_recurse (&_tmp28_, &_tmp33_);
	while (dbus_message_iter_get_arg_type (&_tmp33_)) {
		char* _key;
		char* _value;
		const char* _tmp35_;
		const char* _tmp36_;
		dbus_message_iter_recurse (&_tmp33_, &_tmp34_);
		dbus_message_iter_get_basic (&_tmp34_, &_tmp35_);
		dbus_message_iter_next (&_tmp34_);
		_key = g_strdup (_tmp35_);
		dbus_message_iter_get_basic (&_tmp34_, &_tmp36_);
		dbus_message_iter_next (&_tmp34_);
		_value = g_strdup (_tmp36_);
		g_hash_table_insert (_tmp32_, _key, _value);
		dbus_message_iter_next (&_tmp33_);
	}
	dbus_message_iter_next (&_tmp28_);
	_tmp27_.hints = _tmp32_;
	dbus_message_iter_next (&_tmp2_);
	_tmp1_.global_renderer_info = _tmp27_;
	dbus_message_iter_next (&iter);
	entry = _tmp1_;
	g_signal_emit_by_name (self, "entry-added", &entry);
	unity_place__entryinfo_destroy (&entry);
}


static void _dbus_handle_unity_place_service_entry_removed (UnityPlaceService* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* entry_dbus_path = NULL;
	const char* _tmp37_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp37_);
	dbus_message_iter_next (&iter);
	entry_dbus_path = g_strdup (_tmp37_);
	g_signal_emit_by_name (self, "entry-removed", entry_dbus_path);
	_g_free0 (entry_dbus_path);
}


DBusHandlerResult unity_place_service_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "com.canonical.Unity.Place", "EntryAdded")) {
			_dbus_handle_unity_place_service_entry_added (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "com.canonical.Unity.Place", "EntryRemoved")) {
			_dbus_handle_unity_place_service_entry_removed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void unity_place_service_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((UnityPlaceServiceDBusProxy*) self)->disposed) {
		return;
	}
	((UnityPlaceServiceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), unity_place_service_dbus_proxy_filter, self);
	G_OBJECT_CLASS (unity_place_service_dbus_proxy_parent_class)->dispose (self);
}


static void unity_place_service_dbus_proxy_class_init (UnityPlaceServiceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = unity_place_service_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = unity_place_service_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = unity_place_service_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_place_service_dbus_proxy_set_property;
}


static void unity_place_service_dbus_proxy_init (UnityPlaceServiceDBusProxy* self) {
}


static UnityPlace_EntryInfo* unity_place_service_dbus_proxy_get_entries (UnityPlaceService* self, int* result_length1, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	UnityPlace_EntryInfo* _result;
	int _result_length1;
	UnityPlace_EntryInfo* _tmp38_;
	int _tmp38__length;
	int _tmp38__size;
	int _tmp38__length1;
	DBusMessageIter _tmp39_;
	if (((UnityPlaceServiceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "com.canonical.Unity.Place", "GetEntries");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp76_;
			_edomain = DBUS_GERROR;
			_tmp76_ = _dbus_error.name + 27;
			if (strcmp (_tmp76_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp76_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp76_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp76_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp76_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp76_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp76_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp76_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp76_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp76_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp76_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp76_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp76_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp76_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp76_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp76_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp76_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp76_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp76_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp76_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp76_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp76_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp76_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp76_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp76_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp76_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp76_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp76_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp76_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp76_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp76_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp76_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp76_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "a(sssuasbsa{ss}(sssa{ss})(sssa{ss}))")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "a(sssuasbsa{ss}(sssa{ss})(sssa{ss}))", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp38_ = g_new (UnityPlace_EntryInfo, 5);
	_tmp38__length = 0;
	_tmp38__size = 4;
	_tmp38__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp39_);
	for (; dbus_message_iter_get_arg_type (&_tmp39_); _tmp38__length1++) {
		UnityPlace_EntryInfo _tmp40_;
		DBusMessageIter _tmp41_;
		const char* _tmp42_;
		const char* _tmp43_;
		const char* _tmp44_;
		dbus_uint32_t _tmp45_;
		char** _tmp46_;
		int _tmp46__length;
		int _tmp46__size;
		int _tmp46__length1;
		DBusMessageIter _tmp47_;
		dbus_bool_t _tmp49_;
		const char* _tmp50_;
		GHashTable* _tmp51_;
		DBusMessageIter _tmp52_;
		DBusMessageIter _tmp53_;
		UnityPlace_RendererInfo _tmp56_;
		DBusMessageIter _tmp57_;
		const char* _tmp58_;
		const char* _tmp59_;
		const char* _tmp60_;
		GHashTable* _tmp61_;
		DBusMessageIter _tmp62_;
		DBusMessageIter _tmp63_;
		UnityPlace_RendererInfo _tmp66_;
		DBusMessageIter _tmp67_;
		const char* _tmp68_;
		const char* _tmp69_;
		const char* _tmp70_;
		GHashTable* _tmp71_;
		DBusMessageIter _tmp72_;
		DBusMessageIter _tmp73_;
		if (_tmp38__size == _tmp38__length) {
			_tmp38__size = 2 * _tmp38__size;
			_tmp38_ = g_renew (UnityPlace_EntryInfo, _tmp38_, _tmp38__size + 1);
		}
		dbus_message_iter_recurse (&_tmp39_, &_tmp41_);
		dbus_message_iter_get_basic (&_tmp41_, &_tmp42_);
		dbus_message_iter_next (&_tmp41_);
		_tmp40_.dbus_path = g_strdup (_tmp42_);
		dbus_message_iter_get_basic (&_tmp41_, &_tmp43_);
		dbus_message_iter_next (&_tmp41_);
		_tmp40_.display_name = g_strdup (_tmp43_);
		dbus_message_iter_get_basic (&_tmp41_, &_tmp44_);
		dbus_message_iter_next (&_tmp41_);
		_tmp40_.icon = g_strdup (_tmp44_);
		dbus_message_iter_get_basic (&_tmp41_, &_tmp45_);
		dbus_message_iter_next (&_tmp41_);
		_tmp40_.position = _tmp45_;
		_tmp46_ = g_new (char*, 5);
		_tmp46__length = 0;
		_tmp46__size = 4;
		_tmp46__length1 = 0;
		dbus_message_iter_recurse (&_tmp41_, &_tmp47_);
		for (; dbus_message_iter_get_arg_type (&_tmp47_); _tmp46__length1++) {
			const char* _tmp48_;
			if (_tmp46__size == _tmp46__length) {
				_tmp46__size = 2 * _tmp46__size;
				_tmp46_ = g_renew (char*, _tmp46_, _tmp46__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp47_, &_tmp48_);
			dbus_message_iter_next (&_tmp47_);
			_tmp46_[_tmp46__length++] = g_strdup (_tmp48_);
		}
		_tmp40_.mimetypes_length1 = _tmp46__length1;
		_tmp46_[_tmp46__length] = NULL;
		dbus_message_iter_next (&_tmp41_);
		_tmp40_.mimetypes = _tmp46_;
		dbus_message_iter_get_basic (&_tmp41_, &_tmp49_);
		dbus_message_iter_next (&_tmp41_);
		_tmp40_.sensitive = _tmp49_;
		dbus_message_iter_get_basic (&_tmp41_, &_tmp50_);
		dbus_message_iter_next (&_tmp41_);
		_tmp40_.sections_model = g_strdup (_tmp50_);
		_tmp51_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
		dbus_message_iter_recurse (&_tmp41_, &_tmp52_);
		while (dbus_message_iter_get_arg_type (&_tmp52_)) {
			char* _key;
			char* _value;
			const char* _tmp54_;
			const char* _tmp55_;
			dbus_message_iter_recurse (&_tmp52_, &_tmp53_);
			dbus_message_iter_get_basic (&_tmp53_, &_tmp54_);
			dbus_message_iter_next (&_tmp53_);
			_key = g_strdup (_tmp54_);
			dbus_message_iter_get_basic (&_tmp53_, &_tmp55_);
			dbus_message_iter_next (&_tmp53_);
			_value = g_strdup (_tmp55_);
			g_hash_table_insert (_tmp51_, _key, _value);
			dbus_message_iter_next (&_tmp52_);
		}
		dbus_message_iter_next (&_tmp41_);
		_tmp40_.hints = _tmp51_;
		dbus_message_iter_recurse (&_tmp41_, &_tmp57_);
		dbus_message_iter_get_basic (&_tmp57_, &_tmp58_);
		dbus_message_iter_next (&_tmp57_);
		_tmp56_.default_renderer = g_strdup (_tmp58_);
		dbus_message_iter_get_basic (&_tmp57_, &_tmp59_);
		dbus_message_iter_next (&_tmp57_);
		_tmp56_.groups_model = g_strdup (_tmp59_);
		dbus_message_iter_get_basic (&_tmp57_, &_tmp60_);
		dbus_message_iter_next (&_tmp57_);
		_tmp56_.results_model = g_strdup (_tmp60_);
		_tmp61_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
		dbus_message_iter_recurse (&_tmp57_, &_tmp62_);
		while (dbus_message_iter_get_arg_type (&_tmp62_)) {
			char* _key;
			char* _value;
			const char* _tmp64_;
			const char* _tmp65_;
			dbus_message_iter_recurse (&_tmp62_, &_tmp63_);
			dbus_message_iter_get_basic (&_tmp63_, &_tmp64_);
			dbus_message_iter_next (&_tmp63_);
			_key = g_strdup (_tmp64_);
			dbus_message_iter_get_basic (&_tmp63_, &_tmp65_);
			dbus_message_iter_next (&_tmp63_);
			_value = g_strdup (_tmp65_);
			g_hash_table_insert (_tmp61_, _key, _value);
			dbus_message_iter_next (&_tmp62_);
		}
		dbus_message_iter_next (&_tmp57_);
		_tmp56_.hints = _tmp61_;
		dbus_message_iter_next (&_tmp41_);
		_tmp40_.entry_renderer_info = _tmp56_;
		dbus_message_iter_recurse (&_tmp41_, &_tmp67_);
		dbus_message_iter_get_basic (&_tmp67_, &_tmp68_);
		dbus_message_iter_next (&_tmp67_);
		_tmp66_.default_renderer = g_strdup (_tmp68_);
		dbus_message_iter_get_basic (&_tmp67_, &_tmp69_);
		dbus_message_iter_next (&_tmp67_);
		_tmp66_.groups_model = g_strdup (_tmp69_);
		dbus_message_iter_get_basic (&_tmp67_, &_tmp70_);
		dbus_message_iter_next (&_tmp67_);
		_tmp66_.results_model = g_strdup (_tmp70_);
		_tmp71_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
		dbus_message_iter_recurse (&_tmp67_, &_tmp72_);
		while (dbus_message_iter_get_arg_type (&_tmp72_)) {
			char* _key;
			char* _value;
			const char* _tmp74_;
			const char* _tmp75_;
			dbus_message_iter_recurse (&_tmp72_, &_tmp73_);
			dbus_message_iter_get_basic (&_tmp73_, &_tmp74_);
			dbus_message_iter_next (&_tmp73_);
			_key = g_strdup (_tmp74_);
			dbus_message_iter_get_basic (&_tmp73_, &_tmp75_);
			dbus_message_iter_next (&_tmp73_);
			_value = g_strdup (_tmp75_);
			g_hash_table_insert (_tmp71_, _key, _value);
			dbus_message_iter_next (&_tmp72_);
		}
		dbus_message_iter_next (&_tmp67_);
		_tmp66_.hints = _tmp71_;
		dbus_message_iter_next (&_tmp41_);
		_tmp40_.global_renderer_info = _tmp66_;
		dbus_message_iter_next (&_tmp39_);
		_tmp38_[_tmp38__length++] = _tmp40_;
	}
	_result_length1 = _tmp38__length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp38_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static void unity_place_service_dbus_proxy_unity_place_service__interface_init (UnityPlaceServiceIface* iface) {
	iface->get_entries = unity_place_service_dbus_proxy_get_entries;
}


static void unity_place_service_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void unity_place_service_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


void unity_place_entry_service_set_global_search (UnityPlaceEntryService* self, const char* search, GHashTable* hints, GError** error) {
	UNITY_PLACE_ENTRY_SERVICE_GET_INTERFACE (self)->set_global_search (self, search, hints, error);
}


void unity_place_entry_service_set_search (UnityPlaceEntryService* self, const char* search, GHashTable* hints, GError** error) {
	UNITY_PLACE_ENTRY_SERVICE_GET_INTERFACE (self)->set_search (self, search, hints, error);
}


void unity_place_entry_service_set_active (UnityPlaceEntryService* self, gboolean is_active, GError** error) {
	UNITY_PLACE_ENTRY_SERVICE_GET_INTERFACE (self)->set_active (self, is_active, error);
}


void unity_place_entry_service_set_active_section (UnityPlaceEntryService* self, guint section_id, GError** error) {
	UNITY_PLACE_ENTRY_SERVICE_GET_INTERFACE (self)->set_active_section (self, section_id, error);
}


void _unity_place_entry_service_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_unity_place_entry_service_introspect (UnityPlaceEntryService* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"com.canonical.Unity.PlaceEntry\">\n  <method name=\"SetGlobalSearch\">\n    <arg name=\"search\" type=\"s\" direction=\"in\"/>\n    <arg name=\"hints\" type=\"a{ss}\" direction=\"in\"/>\n  </method>\n  <method name=\"SetSearch\">\n    <arg name=\"search\" type=\"s\" direction=\"in\"/>\n    <arg name=\"hints\" type=\"a{ss}\" direction=\"in\"/>\n  </method>\n  <method name=\"SetActive\">\n    <arg name=\"is_active\" type=\"b\" direction=\"in\"/>\n  </method>\n  <method name=\"SetActiveSection\">\n    <arg name=\"section_id\" type=\"u\" direction=\"in\"/>\n  </method>\n  <signal name=\"EntryRendererInfoChanged\">\n    <arg name=\"renderer_info\" type=\"(sssa{ss})\"/>\n  </signal>\n  <signal name=\"GlobalRendererInfoChanged\">\n    <arg name=\"renderer_info\" type=\"(sssa{ss})\"/>\n  </signal>\n  <signal name=\"PlaceEntryInfoChanged\">\n    <arg name=\"entry_info_data\" type=\"(sssuasbsa{ss})\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_unity_place_entry_service_property_get_all (UnityPlaceEntryService* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "com.canonical.Unity.PlaceEntry") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_unity_place_entry_service_set_global_search (UnityPlaceEntryService* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* search = NULL;
	const char* _tmp1_;
	GHashTable* hints = NULL;
	GHashTable* _tmp2_;
	DBusMessageIter _tmp3_;
	DBusMessageIter _tmp4_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "sa{ss}")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	search = g_strdup (_tmp1_);
	_tmp2_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	dbus_message_iter_recurse (&iter, &_tmp3_);
	while (dbus_message_iter_get_arg_type (&_tmp3_)) {
		char* _key;
		char* _value;
		const char* _tmp5_;
		const char* _tmp6_;
		dbus_message_iter_recurse (&_tmp3_, &_tmp4_);
		dbus_message_iter_get_basic (&_tmp4_, &_tmp5_);
		dbus_message_iter_next (&_tmp4_);
		_key = g_strdup (_tmp5_);
		dbus_message_iter_get_basic (&_tmp4_, &_tmp6_);
		dbus_message_iter_next (&_tmp4_);
		_value = g_strdup (_tmp6_);
		g_hash_table_insert (_tmp2_, _key, _value);
		dbus_message_iter_next (&_tmp3_);
	}
	dbus_message_iter_next (&iter);
	hints = _tmp2_;
	unity_place_entry_service_set_global_search (self, search, hints, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (search);
	_g_hash_table_unref0 (hints);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_unity_place_entry_service_set_search (UnityPlaceEntryService* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* search = NULL;
	const char* _tmp7_;
	GHashTable* hints = NULL;
	GHashTable* _tmp8_;
	DBusMessageIter _tmp9_;
	DBusMessageIter _tmp10_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "sa{ss}")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp7_);
	dbus_message_iter_next (&iter);
	search = g_strdup (_tmp7_);
	_tmp8_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	dbus_message_iter_recurse (&iter, &_tmp9_);
	while (dbus_message_iter_get_arg_type (&_tmp9_)) {
		char* _key;
		char* _value;
		const char* _tmp11_;
		const char* _tmp12_;
		dbus_message_iter_recurse (&_tmp9_, &_tmp10_);
		dbus_message_iter_get_basic (&_tmp10_, &_tmp11_);
		dbus_message_iter_next (&_tmp10_);
		_key = g_strdup (_tmp11_);
		dbus_message_iter_get_basic (&_tmp10_, &_tmp12_);
		dbus_message_iter_next (&_tmp10_);
		_value = g_strdup (_tmp12_);
		g_hash_table_insert (_tmp8_, _key, _value);
		dbus_message_iter_next (&_tmp9_);
	}
	dbus_message_iter_next (&iter);
	hints = _tmp8_;
	unity_place_entry_service_set_search (self, search, hints, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (search);
	_g_hash_table_unref0 (hints);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_unity_place_entry_service_set_active (UnityPlaceEntryService* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	gboolean is_active = FALSE;
	dbus_bool_t _tmp13_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "b")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp13_);
	dbus_message_iter_next (&iter);
	is_active = _tmp13_;
	unity_place_entry_service_set_active (self, is_active, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_unity_place_entry_service_set_active_section (UnityPlaceEntryService* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint section_id = 0U;
	dbus_uint32_t _tmp14_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp14_);
	dbus_message_iter_next (&iter);
	section_id = _tmp14_;
	unity_place_entry_service_set_active_section (self, section_id, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult unity_place_entry_service_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_unity_place_entry_service_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_unity_place_entry_service_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "com.canonical.Unity.PlaceEntry", "SetGlobalSearch")) {
		result = _dbus_unity_place_entry_service_set_global_search (object, connection, message);
	} else if (dbus_message_is_method_call (message, "com.canonical.Unity.PlaceEntry", "SetSearch")) {
		result = _dbus_unity_place_entry_service_set_search (object, connection, message);
	} else if (dbus_message_is_method_call (message, "com.canonical.Unity.PlaceEntry", "SetActive")) {
		result = _dbus_unity_place_entry_service_set_active (object, connection, message);
	} else if (dbus_message_is_method_call (message, "com.canonical.Unity.PlaceEntry", "SetActiveSection")) {
		result = _dbus_unity_place_entry_service_set_active_section (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_unity_place_entry_service_entry_renderer_info_changed (GObject* _sender, UnityPlace_RendererInfo* renderer_info, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	DBusMessageIter _tmp15_;
	const char* _tmp16_;
	const char* _tmp17_;
	const char* _tmp18_;
	DBusMessageIter _tmp19_, _tmp20_;
	GHashTableIter _tmp21_;
	gpointer _tmp22_, _tmp23_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "com.canonical.Unity.PlaceEntry", "EntryRendererInfoChanged");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_STRUCT, NULL, &_tmp15_);
	_tmp16_ = (*renderer_info).default_renderer;
	dbus_message_iter_append_basic (&_tmp15_, DBUS_TYPE_STRING, &_tmp16_);
	_tmp17_ = (*renderer_info).groups_model;
	dbus_message_iter_append_basic (&_tmp15_, DBUS_TYPE_STRING, &_tmp17_);
	_tmp18_ = (*renderer_info).results_model;
	dbus_message_iter_append_basic (&_tmp15_, DBUS_TYPE_STRING, &_tmp18_);
	dbus_message_iter_open_container (&_tmp15_, DBUS_TYPE_ARRAY, "{ss}", &_tmp19_);
	g_hash_table_iter_init (&_tmp21_, (*renderer_info).hints);
	while (g_hash_table_iter_next (&_tmp21_, &_tmp22_, &_tmp23_)) {
		char* _key;
		char* _value;
		const char* _tmp24_;
		const char* _tmp25_;
		dbus_message_iter_open_container (&_tmp19_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp20_);
		_key = (char*) _tmp22_;
		_value = (char*) _tmp23_;
		_tmp24_ = _key;
		dbus_message_iter_append_basic (&_tmp20_, DBUS_TYPE_STRING, &_tmp24_);
		_tmp25_ = _value;
		dbus_message_iter_append_basic (&_tmp20_, DBUS_TYPE_STRING, &_tmp25_);
		dbus_message_iter_close_container (&_tmp19_, &_tmp20_);
	}
	dbus_message_iter_close_container (&_tmp15_, &_tmp19_);
	dbus_message_iter_close_container (&_iter, &_tmp15_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_unity_place_entry_service_global_renderer_info_changed (GObject* _sender, UnityPlace_RendererInfo* renderer_info, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	DBusMessageIter _tmp26_;
	const char* _tmp27_;
	const char* _tmp28_;
	const char* _tmp29_;
	DBusMessageIter _tmp30_, _tmp31_;
	GHashTableIter _tmp32_;
	gpointer _tmp33_, _tmp34_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "com.canonical.Unity.PlaceEntry", "GlobalRendererInfoChanged");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_STRUCT, NULL, &_tmp26_);
	_tmp27_ = (*renderer_info).default_renderer;
	dbus_message_iter_append_basic (&_tmp26_, DBUS_TYPE_STRING, &_tmp27_);
	_tmp28_ = (*renderer_info).groups_model;
	dbus_message_iter_append_basic (&_tmp26_, DBUS_TYPE_STRING, &_tmp28_);
	_tmp29_ = (*renderer_info).results_model;
	dbus_message_iter_append_basic (&_tmp26_, DBUS_TYPE_STRING, &_tmp29_);
	dbus_message_iter_open_container (&_tmp26_, DBUS_TYPE_ARRAY, "{ss}", &_tmp30_);
	g_hash_table_iter_init (&_tmp32_, (*renderer_info).hints);
	while (g_hash_table_iter_next (&_tmp32_, &_tmp33_, &_tmp34_)) {
		char* _key;
		char* _value;
		const char* _tmp35_;
		const char* _tmp36_;
		dbus_message_iter_open_container (&_tmp30_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp31_);
		_key = (char*) _tmp33_;
		_value = (char*) _tmp34_;
		_tmp35_ = _key;
		dbus_message_iter_append_basic (&_tmp31_, DBUS_TYPE_STRING, &_tmp35_);
		_tmp36_ = _value;
		dbus_message_iter_append_basic (&_tmp31_, DBUS_TYPE_STRING, &_tmp36_);
		dbus_message_iter_close_container (&_tmp30_, &_tmp31_);
	}
	dbus_message_iter_close_container (&_tmp26_, &_tmp30_);
	dbus_message_iter_close_container (&_iter, &_tmp26_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_unity_place_entry_service_place_entry_info_changed (GObject* _sender, UnityPlace_EntryInfoData* entry_info_data, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	DBusMessageIter _tmp37_;
	const char* _tmp38_;
	const char* _tmp39_;
	const char* _tmp40_;
	dbus_uint32_t _tmp41_;
	char** _tmp42_;
	DBusMessageIter _tmp43_;
	int _tmp44_;
	dbus_bool_t _tmp46_;
	const char* _tmp47_;
	DBusMessageIter _tmp48_, _tmp49_;
	GHashTableIter _tmp50_;
	gpointer _tmp51_, _tmp52_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "com.canonical.Unity.PlaceEntry", "PlaceEntryInfoChanged");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_STRUCT, NULL, &_tmp37_);
	_tmp38_ = (*entry_info_data).dbus_path;
	dbus_message_iter_append_basic (&_tmp37_, DBUS_TYPE_STRING, &_tmp38_);
	_tmp39_ = (*entry_info_data).display_name;
	dbus_message_iter_append_basic (&_tmp37_, DBUS_TYPE_STRING, &_tmp39_);
	_tmp40_ = (*entry_info_data).icon;
	dbus_message_iter_append_basic (&_tmp37_, DBUS_TYPE_STRING, &_tmp40_);
	_tmp41_ = (*entry_info_data).position;
	dbus_message_iter_append_basic (&_tmp37_, DBUS_TYPE_UINT32, &_tmp41_);
	_tmp42_ = (*entry_info_data).mimetypes;
	dbus_message_iter_open_container (&_tmp37_, DBUS_TYPE_ARRAY, "s", &_tmp43_);
	for (_tmp44_ = 0; _tmp44_ < (*entry_info_data).mimetypes_length1; _tmp44_++) {
		const char* _tmp45_;
		_tmp45_ = *_tmp42_;
		dbus_message_iter_append_basic (&_tmp43_, DBUS_TYPE_STRING, &_tmp45_);
		_tmp42_++;
	}
	dbus_message_iter_close_container (&_tmp37_, &_tmp43_);
	_tmp46_ = (*entry_info_data).sensitive;
	dbus_message_iter_append_basic (&_tmp37_, DBUS_TYPE_BOOLEAN, &_tmp46_);
	_tmp47_ = (*entry_info_data).sections_model;
	dbus_message_iter_append_basic (&_tmp37_, DBUS_TYPE_STRING, &_tmp47_);
	dbus_message_iter_open_container (&_tmp37_, DBUS_TYPE_ARRAY, "{ss}", &_tmp48_);
	g_hash_table_iter_init (&_tmp50_, (*entry_info_data).hints);
	while (g_hash_table_iter_next (&_tmp50_, &_tmp51_, &_tmp52_)) {
		char* _key;
		char* _value;
		const char* _tmp53_;
		const char* _tmp54_;
		dbus_message_iter_open_container (&_tmp48_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp49_);
		_key = (char*) _tmp51_;
		_value = (char*) _tmp52_;
		_tmp53_ = _key;
		dbus_message_iter_append_basic (&_tmp49_, DBUS_TYPE_STRING, &_tmp53_);
		_tmp54_ = _value;
		dbus_message_iter_append_basic (&_tmp49_, DBUS_TYPE_STRING, &_tmp54_);
		dbus_message_iter_close_container (&_tmp48_, &_tmp49_);
	}
	dbus_message_iter_close_container (&_tmp37_, &_tmp48_);
	dbus_message_iter_close_container (&_iter, &_tmp37_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void unity_place_entry_service_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_unity_place_entry_service_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "entry-renderer-info-changed", (GCallback) _dbus_unity_place_entry_service_entry_renderer_info_changed, connection);
	g_signal_connect (object, "global-renderer-info-changed", (GCallback) _dbus_unity_place_entry_service_global_renderer_info_changed, connection);
	g_signal_connect (object, "place-entry-info-changed", (GCallback) _dbus_unity_place_entry_service_place_entry_info_changed, connection);
}


static void unity_place_entry_service_base_init (UnityPlaceEntryServiceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("entry_renderer_info_changed", UNITY_PLACE_TYPE_ENTRY_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, UNITY_PLACE_TYPE__RENDERERINFO);
		g_signal_new ("global_renderer_info_changed", UNITY_PLACE_TYPE_ENTRY_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, UNITY_PLACE_TYPE__RENDERERINFO);
		g_signal_new ("place_entry_info_changed", UNITY_PLACE_TYPE_ENTRY_SERVICE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, UNITY_PLACE_TYPE__ENTRYINFODATA);
		g_type_set_qdata (UNITY_PLACE_TYPE_ENTRY_SERVICE, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_unity_place_entry_service_dbus_vtable));
	}
}


/**
   * UnityPlaceEntryService:
   *
   * DBus interface for a given place entry exported by a place daemon
   */
GType unity_place_entry_service_get_type (void) {
	static volatile gsize unity_place_entry_service_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place_entry_service_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlaceEntryServiceIface), (GBaseInitFunc) unity_place_entry_service_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType unity_place_entry_service_type_id;
		unity_place_entry_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "UnityPlaceEntryService", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (unity_place_entry_service_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (unity_place_entry_service_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &unity_place_entry_service_dbus_proxy_get_type);
		g_once_init_leave (&unity_place_entry_service_type_id__volatile, unity_place_entry_service_type_id);
	}
	return unity_place_entry_service_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (UnityPlaceEntryServiceDBusProxy, unity_place_entry_service_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (UNITY_PLACE_TYPE_ENTRY_SERVICE, unity_place_entry_service_dbus_proxy_unity_place_entry_service__interface_init) );
UnityPlaceEntryService* unity_place_entry_service_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	UnityPlaceEntryService* self;
	self = g_object_new (unity_place_entry_service_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "com.canonical.Unity.PlaceEntry", NULL);
	return self;
}


static GObject* unity_place_entry_service_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (unity_place_entry_service_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), unity_place_entry_service_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_unity_place_entry_service_entry_renderer_info_changed (UnityPlaceEntryService* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	UnityPlace_RendererInfo renderer_info = {0};
	UnityPlace_RendererInfo _tmp77_;
	DBusMessageIter _tmp78_;
	const char* _tmp79_;
	const char* _tmp80_;
	const char* _tmp81_;
	GHashTable* _tmp82_;
	DBusMessageIter _tmp83_;
	DBusMessageIter _tmp84_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "(sssa{ss})")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_recurse (&iter, &_tmp78_);
	dbus_message_iter_get_basic (&_tmp78_, &_tmp79_);
	dbus_message_iter_next (&_tmp78_);
	_tmp77_.default_renderer = g_strdup (_tmp79_);
	dbus_message_iter_get_basic (&_tmp78_, &_tmp80_);
	dbus_message_iter_next (&_tmp78_);
	_tmp77_.groups_model = g_strdup (_tmp80_);
	dbus_message_iter_get_basic (&_tmp78_, &_tmp81_);
	dbus_message_iter_next (&_tmp78_);
	_tmp77_.results_model = g_strdup (_tmp81_);
	_tmp82_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	dbus_message_iter_recurse (&_tmp78_, &_tmp83_);
	while (dbus_message_iter_get_arg_type (&_tmp83_)) {
		char* _key;
		char* _value;
		const char* _tmp85_;
		const char* _tmp86_;
		dbus_message_iter_recurse (&_tmp83_, &_tmp84_);
		dbus_message_iter_get_basic (&_tmp84_, &_tmp85_);
		dbus_message_iter_next (&_tmp84_);
		_key = g_strdup (_tmp85_);
		dbus_message_iter_get_basic (&_tmp84_, &_tmp86_);
		dbus_message_iter_next (&_tmp84_);
		_value = g_strdup (_tmp86_);
		g_hash_table_insert (_tmp82_, _key, _value);
		dbus_message_iter_next (&_tmp83_);
	}
	dbus_message_iter_next (&_tmp78_);
	_tmp77_.hints = _tmp82_;
	dbus_message_iter_next (&iter);
	renderer_info = _tmp77_;
	g_signal_emit_by_name (self, "entry-renderer-info-changed", &renderer_info);
	unity_place__rendererinfo_destroy (&renderer_info);
}


static void _dbus_handle_unity_place_entry_service_global_renderer_info_changed (UnityPlaceEntryService* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	UnityPlace_RendererInfo renderer_info = {0};
	UnityPlace_RendererInfo _tmp87_;
	DBusMessageIter _tmp88_;
	const char* _tmp89_;
	const char* _tmp90_;
	const char* _tmp91_;
	GHashTable* _tmp92_;
	DBusMessageIter _tmp93_;
	DBusMessageIter _tmp94_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "(sssa{ss})")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_recurse (&iter, &_tmp88_);
	dbus_message_iter_get_basic (&_tmp88_, &_tmp89_);
	dbus_message_iter_next (&_tmp88_);
	_tmp87_.default_renderer = g_strdup (_tmp89_);
	dbus_message_iter_get_basic (&_tmp88_, &_tmp90_);
	dbus_message_iter_next (&_tmp88_);
	_tmp87_.groups_model = g_strdup (_tmp90_);
	dbus_message_iter_get_basic (&_tmp88_, &_tmp91_);
	dbus_message_iter_next (&_tmp88_);
	_tmp87_.results_model = g_strdup (_tmp91_);
	_tmp92_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	dbus_message_iter_recurse (&_tmp88_, &_tmp93_);
	while (dbus_message_iter_get_arg_type (&_tmp93_)) {
		char* _key;
		char* _value;
		const char* _tmp95_;
		const char* _tmp96_;
		dbus_message_iter_recurse (&_tmp93_, &_tmp94_);
		dbus_message_iter_get_basic (&_tmp94_, &_tmp95_);
		dbus_message_iter_next (&_tmp94_);
		_key = g_strdup (_tmp95_);
		dbus_message_iter_get_basic (&_tmp94_, &_tmp96_);
		dbus_message_iter_next (&_tmp94_);
		_value = g_strdup (_tmp96_);
		g_hash_table_insert (_tmp92_, _key, _value);
		dbus_message_iter_next (&_tmp93_);
	}
	dbus_message_iter_next (&_tmp88_);
	_tmp87_.hints = _tmp92_;
	dbus_message_iter_next (&iter);
	renderer_info = _tmp87_;
	g_signal_emit_by_name (self, "global-renderer-info-changed", &renderer_info);
	unity_place__rendererinfo_destroy (&renderer_info);
}


static void _dbus_handle_unity_place_entry_service_place_entry_info_changed (UnityPlaceEntryService* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	UnityPlace_EntryInfoData entry_info_data = {0};
	UnityPlace_EntryInfoData _tmp97_;
	DBusMessageIter _tmp98_;
	const char* _tmp99_;
	const char* _tmp100_;
	const char* _tmp101_;
	dbus_uint32_t _tmp102_;
	char** _tmp103_;
	int _tmp103__length;
	int _tmp103__size;
	int _tmp103__length1;
	DBusMessageIter _tmp104_;
	dbus_bool_t _tmp106_;
	const char* _tmp107_;
	GHashTable* _tmp108_;
	DBusMessageIter _tmp109_;
	DBusMessageIter _tmp110_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "(sssuasbsa{ss})")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_recurse (&iter, &_tmp98_);
	dbus_message_iter_get_basic (&_tmp98_, &_tmp99_);
	dbus_message_iter_next (&_tmp98_);
	_tmp97_.dbus_path = g_strdup (_tmp99_);
	dbus_message_iter_get_basic (&_tmp98_, &_tmp100_);
	dbus_message_iter_next (&_tmp98_);
	_tmp97_.display_name = g_strdup (_tmp100_);
	dbus_message_iter_get_basic (&_tmp98_, &_tmp101_);
	dbus_message_iter_next (&_tmp98_);
	_tmp97_.icon = g_strdup (_tmp101_);
	dbus_message_iter_get_basic (&_tmp98_, &_tmp102_);
	dbus_message_iter_next (&_tmp98_);
	_tmp97_.position = _tmp102_;
	_tmp103_ = g_new (char*, 5);
	_tmp103__length = 0;
	_tmp103__size = 4;
	_tmp103__length1 = 0;
	dbus_message_iter_recurse (&_tmp98_, &_tmp104_);
	for (; dbus_message_iter_get_arg_type (&_tmp104_); _tmp103__length1++) {
		const char* _tmp105_;
		if (_tmp103__size == _tmp103__length) {
			_tmp103__size = 2 * _tmp103__size;
			_tmp103_ = g_renew (char*, _tmp103_, _tmp103__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp104_, &_tmp105_);
		dbus_message_iter_next (&_tmp104_);
		_tmp103_[_tmp103__length++] = g_strdup (_tmp105_);
	}
	_tmp97_.mimetypes_length1 = _tmp103__length1;
	_tmp103_[_tmp103__length] = NULL;
	dbus_message_iter_next (&_tmp98_);
	_tmp97_.mimetypes = _tmp103_;
	dbus_message_iter_get_basic (&_tmp98_, &_tmp106_);
	dbus_message_iter_next (&_tmp98_);
	_tmp97_.sensitive = _tmp106_;
	dbus_message_iter_get_basic (&_tmp98_, &_tmp107_);
	dbus_message_iter_next (&_tmp98_);
	_tmp97_.sections_model = g_strdup (_tmp107_);
	_tmp108_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	dbus_message_iter_recurse (&_tmp98_, &_tmp109_);
	while (dbus_message_iter_get_arg_type (&_tmp109_)) {
		char* _key;
		char* _value;
		const char* _tmp111_;
		const char* _tmp112_;
		dbus_message_iter_recurse (&_tmp109_, &_tmp110_);
		dbus_message_iter_get_basic (&_tmp110_, &_tmp111_);
		dbus_message_iter_next (&_tmp110_);
		_key = g_strdup (_tmp111_);
		dbus_message_iter_get_basic (&_tmp110_, &_tmp112_);
		dbus_message_iter_next (&_tmp110_);
		_value = g_strdup (_tmp112_);
		g_hash_table_insert (_tmp108_, _key, _value);
		dbus_message_iter_next (&_tmp109_);
	}
	dbus_message_iter_next (&_tmp98_);
	_tmp97_.hints = _tmp108_;
	dbus_message_iter_next (&iter);
	entry_info_data = _tmp97_;
	g_signal_emit_by_name (self, "place-entry-info-changed", &entry_info_data);
	unity_place__entryinfodata_destroy (&entry_info_data);
}


DBusHandlerResult unity_place_entry_service_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "com.canonical.Unity.PlaceEntry", "EntryRendererInfoChanged")) {
			_dbus_handle_unity_place_entry_service_entry_renderer_info_changed (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "com.canonical.Unity.PlaceEntry", "GlobalRendererInfoChanged")) {
			_dbus_handle_unity_place_entry_service_global_renderer_info_changed (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "com.canonical.Unity.PlaceEntry", "PlaceEntryInfoChanged")) {
			_dbus_handle_unity_place_entry_service_place_entry_info_changed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void unity_place_entry_service_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((UnityPlaceEntryServiceDBusProxy*) self)->disposed) {
		return;
	}
	((UnityPlaceEntryServiceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), unity_place_entry_service_dbus_proxy_filter, self);
	G_OBJECT_CLASS (unity_place_entry_service_dbus_proxy_parent_class)->dispose (self);
}


static void unity_place_entry_service_dbus_proxy_class_init (UnityPlaceEntryServiceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = unity_place_entry_service_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = unity_place_entry_service_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = unity_place_entry_service_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_place_entry_service_dbus_proxy_set_property;
}


static void unity_place_entry_service_dbus_proxy_init (UnityPlaceEntryServiceDBusProxy* self) {
}


static void unity_place_entry_service_dbus_proxy_set_global_search (UnityPlaceEntryService* self, const char* search, GHashTable* hints, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp113_;
	DBusMessageIter _tmp114_, _tmp115_;
	GHashTableIter _tmp116_;
	gpointer _tmp117_, _tmp118_;
	if (((UnityPlaceEntryServiceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "com.canonical.Unity.PlaceEntry", "SetGlobalSearch");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp113_ = search;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp113_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "{ss}", &_tmp114_);
	g_hash_table_iter_init (&_tmp116_, hints);
	while (g_hash_table_iter_next (&_tmp116_, &_tmp117_, &_tmp118_)) {
		char* _key;
		char* _value;
		const char* _tmp119_;
		const char* _tmp120_;
		dbus_message_iter_open_container (&_tmp114_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp115_);
		_key = (char*) _tmp117_;
		_value = (char*) _tmp118_;
		_tmp119_ = _key;
		dbus_message_iter_append_basic (&_tmp115_, DBUS_TYPE_STRING, &_tmp119_);
		_tmp120_ = _value;
		dbus_message_iter_append_basic (&_tmp115_, DBUS_TYPE_STRING, &_tmp120_);
		dbus_message_iter_close_container (&_tmp114_, &_tmp115_);
	}
	dbus_message_iter_close_container (&_iter, &_tmp114_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp121_;
			_edomain = DBUS_GERROR;
			_tmp121_ = _dbus_error.name + 27;
			if (strcmp (_tmp121_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp121_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp121_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp121_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp121_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp121_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp121_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp121_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp121_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp121_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp121_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp121_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp121_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp121_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp121_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp121_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp121_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp121_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp121_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp121_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp121_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp121_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp121_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp121_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp121_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp121_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp121_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp121_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp121_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp121_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp121_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp121_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp121_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void unity_place_entry_service_dbus_proxy_set_search (UnityPlaceEntryService* self, const char* search, GHashTable* hints, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp122_;
	DBusMessageIter _tmp123_, _tmp124_;
	GHashTableIter _tmp125_;
	gpointer _tmp126_, _tmp127_;
	if (((UnityPlaceEntryServiceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "com.canonical.Unity.PlaceEntry", "SetSearch");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp122_ = search;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp122_);
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "{ss}", &_tmp123_);
	g_hash_table_iter_init (&_tmp125_, hints);
	while (g_hash_table_iter_next (&_tmp125_, &_tmp126_, &_tmp127_)) {
		char* _key;
		char* _value;
		const char* _tmp128_;
		const char* _tmp129_;
		dbus_message_iter_open_container (&_tmp123_, DBUS_TYPE_DICT_ENTRY, NULL, &_tmp124_);
		_key = (char*) _tmp126_;
		_value = (char*) _tmp127_;
		_tmp128_ = _key;
		dbus_message_iter_append_basic (&_tmp124_, DBUS_TYPE_STRING, &_tmp128_);
		_tmp129_ = _value;
		dbus_message_iter_append_basic (&_tmp124_, DBUS_TYPE_STRING, &_tmp129_);
		dbus_message_iter_close_container (&_tmp123_, &_tmp124_);
	}
	dbus_message_iter_close_container (&_iter, &_tmp123_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp130_;
			_edomain = DBUS_GERROR;
			_tmp130_ = _dbus_error.name + 27;
			if (strcmp (_tmp130_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp130_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp130_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp130_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp130_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp130_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp130_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp130_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp130_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp130_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp130_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp130_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp130_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp130_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp130_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp130_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp130_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp130_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp130_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp130_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp130_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp130_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp130_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp130_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp130_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp130_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp130_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp130_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp130_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp130_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp130_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp130_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp130_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void unity_place_entry_service_dbus_proxy_set_active (UnityPlaceEntryService* self, gboolean is_active, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_bool_t _tmp131_;
	if (((UnityPlaceEntryServiceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "com.canonical.Unity.PlaceEntry", "SetActive");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp131_ = is_active;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_BOOLEAN, &_tmp131_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp132_;
			_edomain = DBUS_GERROR;
			_tmp132_ = _dbus_error.name + 27;
			if (strcmp (_tmp132_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp132_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp132_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp132_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp132_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp132_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp132_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp132_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp132_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp132_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp132_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp132_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp132_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp132_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp132_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp132_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp132_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp132_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp132_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp132_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp132_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp132_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp132_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp132_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp132_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp132_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp132_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp132_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp132_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp132_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp132_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp132_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp132_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void unity_place_entry_service_dbus_proxy_set_active_section (UnityPlaceEntryService* self, guint section_id, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp133_;
	if (((UnityPlaceEntryServiceDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "com.canonical.Unity.PlaceEntry", "SetActiveSection");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp133_ = section_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp133_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp134_;
			_edomain = DBUS_GERROR;
			_tmp134_ = _dbus_error.name + 27;
			if (strcmp (_tmp134_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp134_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp134_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp134_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp134_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp134_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp134_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp134_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp134_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp134_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp134_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp134_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp134_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp134_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp134_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp134_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp134_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp134_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp134_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp134_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp134_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp134_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp134_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp134_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp134_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp134_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp134_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp134_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp134_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp134_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp134_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp134_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp134_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void unity_place_entry_service_dbus_proxy_unity_place_entry_service__interface_init (UnityPlaceEntryServiceIface* iface) {
	iface->set_global_search = unity_place_entry_service_dbus_proxy_set_global_search;
	iface->set_search = unity_place_entry_service_dbus_proxy_set_search;
	iface->set_active = unity_place_entry_service_dbus_proxy_set_active;
	iface->set_active_section = unity_place_entry_service_dbus_proxy_set_active_section;
}


static void unity_place_entry_service_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void unity_place_entry_service_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


UnityPlaceServiceImpl* unity_place_service_impl_construct (GType object_type, const char* dbus_path) {
	UnityPlaceServiceImpl * self;
	g_return_val_if_fail (dbus_path != NULL, NULL);
	self = (UnityPlaceServiceImpl*) g_object_new (object_type, "dbus-path", dbus_path, NULL);
	return self;
}


UnityPlaceServiceImpl* unity_place_service_impl_new (const char* dbus_path) {
	return unity_place_service_impl_construct (UNITY_PLACE_TYPE_SERVICE_IMPL, dbus_path);
}


static UnityPlace_EntryInfo* unity_place_service_impl_real_get_entries (UnityPlaceService* base, int* result_length1, GError** error) {
	UnityPlaceServiceImpl * self;
	UnityPlace_EntryInfo* result = NULL;
	gint _result__length1;
	gint __result__size_;
	UnityPlace_EntryInfo* _tmp1_;
	gint _tmp0_;
	UnityPlace_EntryInfo* _result_;
	gint i;
	UnityPlace_EntryInfo* _tmp4_;
	self = (UnityPlaceServiceImpl*) base;
	_result_ = (_tmp1_ = g_new0 (UnityPlace_EntryInfo, _tmp0_ = g_hash_table_size (self->priv->entries)), _result__length1 = _tmp0_, __result__size_ = _result__length1, _tmp1_);
	i = 0;
	{
		GList* entry_collection;
		GList* entry_it;
		entry_collection = g_hash_table_get_values (self->priv->entries);
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			UnityPlaceEntryServiceImpl* entry;
			entry = (UnityPlaceEntryServiceImpl*) entry_it->data;
			{
				UnityPlace_EntryInfo _tmp2_ = {0};
				UnityPlace_EntryInfo _tmp3_;
				_result_[i] = (_tmp3_ = (unity_place_entry_info_get_raw (unity_place_entry_service_impl_get_entry_info (entry), &_tmp2_), _tmp2_), unity_place__entryinfo_destroy (&_result_[i]), _tmp3_);
				i++;
			}
		}
		_g_list_free0 (entry_collection);
	}
	result = (_tmp4_ = _result_, *result_length1 = _result__length1, _tmp4_);
	return result;
	_result_ = (_vala_UnityPlace_EntryInfo_array_free (_result_, _result__length1), NULL);
}


void unity_place_service_impl_add_entry (UnityPlaceServiceImpl* self, UnityPlaceEntryInfo* entry_info) {
	UnityPlaceEntryServiceImpl* entry;
	UnityPlace_EntryInfo _tmp0_ = {0};
	UnityPlace_EntryInfo _tmp1_;
	UnityPlace_EntryInfo _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry_info != NULL);
	if (((UnityPlaceEntryServiceImpl*) g_hash_table_lookup (self->priv->entries, unity_place_entry_info_get_dbus_path (entry_info))) != NULL) {
		return;
	}
	entry = unity_place_entry_service_impl_new (entry_info);
	g_hash_table_insert (self->priv->entries, g_strdup (unity_place_entry_info_get_dbus_path (entry_info)), _g_object_ref0 (entry));
	if (self->priv->_exported) {
		{
			unity_place_entry_service_impl_export (entry, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DBUS_GERROR) {
					goto __catch38_dbus_gerror;
				}
				_g_object_unref0 (entry);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally38;
		__catch38_dbus_gerror:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("unity-place.vala:565: Failed to export place entry '%s': %s", unity_place_entry_info_get_dbus_path (entry_info), e->message);
				_g_error_free0 (e);
			}
		}
		__finally38:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (entry);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_signal_emit_by_name ((UnityPlaceService*) self, "entry-added", (_tmp2_ = _tmp1_ = (unity_place_entry_info_get_raw (entry_info, &_tmp0_), _tmp0_), &_tmp2_));
	unity_place__entryinfo_destroy (&_tmp1_);
	_g_object_unref0 (entry);
}


UnityPlaceEntryInfo* unity_place_service_impl_get_entry (UnityPlaceServiceImpl* self, const char* dbus_path) {
	UnityPlaceEntryInfo* result = NULL;
	UnityPlaceEntryServiceImpl* entry;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dbus_path != NULL, NULL);
	entry = _g_object_ref0 ((UnityPlaceEntryServiceImpl*) g_hash_table_lookup (self->priv->entries, dbus_path));
	if (entry != NULL) {
		result = _g_object_ref0 (unity_place_entry_service_impl_get_entry_info (entry));
		_g_object_unref0 (entry);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (entry);
		return result;
	}
	_g_object_unref0 (entry);
}


UnityPlaceEntryServiceImpl* unity_place_service_impl_get_entry_service (UnityPlaceServiceImpl* self, const char* dbus_path) {
	UnityPlaceEntryServiceImpl* result = NULL;
	UnityPlaceEntryServiceImpl* entry;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dbus_path != NULL, NULL);
	entry = _g_object_ref0 ((UnityPlaceEntryServiceImpl*) g_hash_table_lookup (self->priv->entries, dbus_path));
	if (entry != NULL) {
		result = entry;
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (entry);
		return result;
	}
	_g_object_unref0 (entry);
}


guint unity_place_service_impl_num_entries (UnityPlaceServiceImpl* self) {
	guint result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_hash_table_size (self->priv->entries);
	return result;
}


char** unity_place_service_impl_get_entry_paths (UnityPlaceServiceImpl* self, int* result_length1) {
	char** result = NULL;
	gint _result__length1;
	gint __result__size_;
	char** _tmp1_;
	gint _tmp0_;
	char** _result_;
	gint i;
	char** _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = (_tmp1_ = g_new0 (char*, (_tmp0_ = g_hash_table_size (self->priv->entries)) + 1), _result__length1 = _tmp0_, __result__size_ = _result__length1, _tmp1_);
	i = 0;
	{
		GList* entry_collection;
		GList* entry_it;
		entry_collection = g_hash_table_get_values (self->priv->entries);
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			UnityPlaceEntryServiceImpl* entry;
			entry = (UnityPlaceEntryServiceImpl*) entry_it->data;
			{
				char* _tmp2_;
				_result_[i] = (_tmp2_ = g_strdup (unity_place_entry_info_get_dbus_path (unity_place_entry_service_impl_get_entry_info (entry))), _g_free0 (_result_[i]), _tmp2_);
				i++;
			}
		}
		_g_list_free0 (entry_collection);
	}
	result = (_tmp3_ = _result_, *result_length1 = _result__length1, _tmp3_);
	return result;
	_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_free), NULL);
}


void unity_place_service_impl_remove_entry (UnityPlaceServiceImpl* self, const char* dbus_path) {
	UnityPlaceEntryServiceImpl* entry;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dbus_path != NULL);
	entry = _g_object_ref0 ((UnityPlaceEntryServiceImpl*) g_hash_table_lookup (self->priv->entries, dbus_path));
	if (entry == NULL) {
		_g_object_unref0 (entry);
		return;
	}
	g_signal_emit_by_name ((UnityPlaceService*) self, "entry-removed", dbus_path);
	if (self->priv->_exported) {
		{
			unity_place_entry_service_impl_unexport (entry, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == DBUS_GERROR) {
					goto __catch39_dbus_gerror;
				}
				_g_object_unref0 (entry);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		goto __finally39;
		__catch39_dbus_gerror:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_critical ("unity-place.vala:622: Failed to unexport place entry '%s': %s", unity_place_entry_info_get_dbus_path (unity_place_entry_service_impl_get_entry_info (entry)), e->message);
				_g_error_free0 (e);
			}
		}
		__finally39:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (entry);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_hash_table_remove (self->priv->entries, dbus_path);
	_g_object_unref0 (entry);
}


void unity_place_service_impl_export (UnityPlaceServiceImpl* self, GError** error) {
	DBusGConnection* conn;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	conn = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_vala_dbus_register_object (dbus_g_connection_get_connection (conn), self->priv->_dbus_path, (GObject*) self);
	{
		GList* entry_collection;
		GList* entry_it;
		entry_collection = g_hash_table_get_values (self->priv->entries);
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			UnityPlaceEntryServiceImpl* entry;
			entry = (UnityPlaceEntryServiceImpl*) entry_it->data;
			{
				unity_place_entry_service_impl_export (entry, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DBUS_GERROR) {
						g_propagate_error (error, _inner_error_);
						_g_list_free0 (entry_collection);
						_dbus_g_connection_unref0 (conn);
						return;
					} else {
						_g_list_free0 (entry_collection);
						_dbus_g_connection_unref0 (conn);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
		}
		_g_list_free0 (entry_collection);
	}
	self->priv->_exported = TRUE;
	g_object_notify ((GObject*) self, "exported");
	_dbus_g_connection_unref0 (conn);
}


void unity_place_service_impl_unexport (UnityPlaceServiceImpl* self, GError** error) {
	DBusGConnection* conn;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GList* entry_collection;
		GList* entry_it;
		entry_collection = g_hash_table_get_values (self->priv->entries);
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			UnityPlaceEntryServiceImpl* entry;
			entry = (UnityPlaceEntryServiceImpl*) entry_it->data;
			{
				unity_place_entry_service_impl_unexport (entry, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == DBUS_GERROR) {
						g_propagate_error (error, _inner_error_);
						_g_list_free0 (entry_collection);
						return;
					} else {
						_g_list_free0 (entry_collection);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
		}
		_g_list_free0 (entry_collection);
	}
	conn = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	dbus_g_connection_unregister_g_object (conn, (GObject*) self);
	self->priv->_exported = FALSE;
	g_object_notify ((GObject*) self, "exported");
	_dbus_g_connection_unref0 (conn);
}


static void unity_place_service_impl_real_activate_data_free (gpointer _data) {
	UnityPlaceServiceImplActivateData* data;
	data = _data;
	_g_free0 (data->uri);
	g_object_unref (data->self);
	g_slice_free (UnityPlaceServiceImplActivateData, data);
}


static void unity_place_service_impl_real_activate (UnityPlaceActivation* base, const char* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityPlaceServiceImpl * self;
	UnityPlaceServiceImplActivateData* _data_;
	self = (UnityPlaceServiceImpl*) base;
	_data_ = g_slice_new0 (UnityPlaceServiceImplActivateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_place_service_impl_real_activate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_place_service_impl_real_activate_data_free);
	_data_->self = g_object_ref (self);
	_data_->uri = g_strdup (uri);
	unity_place_service_impl_real_activate_co (_data_);
}


static guint32 unity_place_service_impl_real_activate_finish (UnityPlaceActivation* base, GAsyncResult* _res_, GError** error) {
	guint32 result;
	UnityPlaceServiceImplActivateData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static void unity_place_service_impl_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityPlaceServiceImplActivateData* data;
	data = _user_data_;
	data->_res_ = _res_;
	unity_place_service_impl_real_activate_co (data);
}


static gboolean unity_place_service_impl_real_activate_co (UnityPlaceServiceImplActivateData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
		case 19:
		goto _state_19;
	}
	_state_0:
	if (data->self->priv->_activation == NULL) {
		data->result = (guint32) UNITY_PLACE_ACTIVATION_STATUS_NOT_ACTIVATED;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	{
		data->_state_ = 19;
		unity_place_activation_activate (data->self->priv->_activation, data->uri, unity_place_service_impl_activate_ready, data);
		return FALSE;
		_state_19:
		data->activated = unity_place_activation_activate_finish (data->self->priv->_activation, data->_res_, &data->_inner_error_);
		if (data->_inner_error_ != NULL) {
			if (data->_inner_error_->domain == DBUS_GERROR) {
				goto __catch40_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
		data->result = data->activated;
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	goto __finally40;
	__catch40_dbus_gerror:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		{
			data->result = (guint32) UNITY_PLACE_ACTIVATION_STATUS_NOT_ACTIVATED;
			_g_error_free0 (data->e);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_error_free0 (data->e);
		}
	}
	__finally40:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


const char* unity_place_service_impl_get_dbus_path (UnityPlaceServiceImpl* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_dbus_path;
	return result;
}


static void unity_place_service_impl_set_dbus_path (UnityPlaceServiceImpl* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_dbus_path = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_dbus_path), _tmp0_);
	g_object_notify ((GObject *) self, "dbus-path");
}


gboolean unity_place_service_impl_get_exported (UnityPlaceServiceImpl* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_exported;
	return result;
}


UnityPlaceActivation* unity_place_service_impl_get_activation (UnityPlaceServiceImpl* self) {
	UnityPlaceActivation* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_activation;
	return result;
}


void unity_place_service_impl_set_activation (UnityPlaceServiceImpl* self, UnityPlaceActivation* value) {
	UnityPlaceActivation* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_activation = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_activation), _tmp0_);
	g_object_notify ((GObject *) self, "activation");
}


static GObject * unity_place_service_impl_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPlaceServiceImpl * self;
	parent_class = G_OBJECT_CLASS (unity_place_service_impl_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PLACE_SERVICE_IMPL (obj);
	{
		GHashTable* _tmp0_;
		self->priv->entries = (_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_object_unref), _g_hash_table_unref0 (self->priv->entries), _tmp0_);
	}
	return obj;
}


void _unity_place_service_impl_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_unity_place_service_impl_introspect (UnityPlaceServiceImpl* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"com.canonical.Unity.Place\">\n  <method name=\"GetEntries\">\n    <arg name=\"result\" type=\"a(sssuasbsa{ss}(sssa{ss})(sssa{ss}))\" direction=\"out\"/>\n  </method>\n  <signal name=\"EntryAdded\">\n    <arg name=\"entry\" type=\"(sssuasbsa{ss}(sssa{ss})(sssa{ss}))\"/>\n  </signal>\n  <signal name=\"EntryRemoved\">\n    <arg name=\"entry_dbus_path\" type=\"s\"/>\n  </signal>\n</interface>\n<interface name=\"com.canonical.Unity.Activation\">\n  <method name=\"Activate\">\n    <arg name=\"uri\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"u\" direction=\"out\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult unity_place_service_impl_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_unity_place_service_impl_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (unity_place_service_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else if (unity_place_activation_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void unity_place_service_impl_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_unity_place_service_impl_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	unity_place_service_dbus_register_object (connection, path, object);
	unity_place_activation_dbus_register_object (connection, path, object);
}


static void unity_place_service_impl_class_init (UnityPlaceServiceImplClass * klass) {
	unity_place_service_impl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlaceServiceImplPrivate));
	G_OBJECT_CLASS (klass)->get_property = unity_place_service_impl_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_place_service_impl_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_place_service_impl_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_place_service_impl_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_SERVICE_IMPL_DBUS_PATH, g_param_spec_string ("dbus-path", "dbus-path", "dbus-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_SERVICE_IMPL_EXPORTED, g_param_spec_boolean ("exported", "exported", "exported", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_SERVICE_IMPL_ACTIVATION, g_param_spec_object ("activation", "activation", "activation", UNITY_PLACE_TYPE_ACTIVATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_type_set_qdata (UNITY_PLACE_TYPE_SERVICE_IMPL, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_unity_place_service_impl_dbus_vtable));
}


static void unity_place_service_impl_unity_place_service_interface_init (UnityPlaceServiceIface * iface) {
	unity_place_service_impl_unity_place_service_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_entries = unity_place_service_impl_real_get_entries;
}


static void unity_place_service_impl_unity_place_activation_interface_init (UnityPlaceActivationIface * iface) {
	unity_place_service_impl_unity_place_activation_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = unity_place_service_impl_real_activate;
	iface->activate_finish = unity_place_service_impl_real_activate_finish;
}


static void unity_place_service_impl_instance_init (UnityPlaceServiceImpl * self) {
	self->priv = UNITY_PLACE_SERVICE_IMPL_GET_PRIVATE (self);
	self->priv->_activation = NULL;
}


static void unity_place_service_impl_finalize (GObject* obj) {
	UnityPlaceServiceImpl * self;
	self = UNITY_PLACE_SERVICE_IMPL (obj);
	_g_free0 (self->priv->_dbus_path);
	_g_hash_table_unref0 (self->priv->entries);
	_g_object_unref0 (self->priv->_activation);
	G_OBJECT_CLASS (unity_place_service_impl_parent_class)->finalize (obj);
}


/**
   * UnityPlaceServiceImpl:
   *
   * Private helper class to shield of DBus details and ugly
   * internal structs used for marshalling
   */
GType unity_place_service_impl_get_type (void) {
	static volatile gsize unity_place_service_impl_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place_service_impl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlaceServiceImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_place_service_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlaceServiceImpl), 0, (GInstanceInitFunc) unity_place_service_impl_instance_init, NULL };
		static const GInterfaceInfo unity_place_service_info = { (GInterfaceInitFunc) unity_place_service_impl_unity_place_service_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo unity_place_activation_info = { (GInterfaceInitFunc) unity_place_service_impl_unity_place_activation_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType unity_place_service_impl_type_id;
		unity_place_service_impl_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityPlaceServiceImpl", &g_define_type_info, 0);
		g_type_add_interface_static (unity_place_service_impl_type_id, UNITY_PLACE_TYPE_SERVICE, &unity_place_service_info);
		g_type_add_interface_static (unity_place_service_impl_type_id, UNITY_PLACE_TYPE_ACTIVATION, &unity_place_activation_info);
		g_once_init_leave (&unity_place_service_impl_type_id__volatile, unity_place_service_impl_type_id);
	}
	return unity_place_service_impl_type_id__volatile;
}


static void unity_place_service_impl_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlaceServiceImpl * self;
	self = UNITY_PLACE_SERVICE_IMPL (object);
	switch (property_id) {
		case UNITY_PLACE_SERVICE_IMPL_DBUS_PATH:
		g_value_set_string (value, unity_place_service_impl_get_dbus_path (self));
		break;
		case UNITY_PLACE_SERVICE_IMPL_EXPORTED:
		g_value_set_boolean (value, unity_place_service_impl_get_exported (self));
		break;
		case UNITY_PLACE_SERVICE_IMPL_ACTIVATION:
		g_value_set_object (value, unity_place_service_impl_get_activation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_place_service_impl_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlaceServiceImpl * self;
	self = UNITY_PLACE_SERVICE_IMPL (object);
	switch (property_id) {
		case UNITY_PLACE_SERVICE_IMPL_DBUS_PATH:
		unity_place_service_impl_set_dbus_path (self, g_value_get_string (value));
		break;
		case UNITY_PLACE_SERVICE_IMPL_ACTIVATION:
		unity_place_service_impl_set_activation (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _unity_place_entry_service_impl_on_browser_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_place_entry_service_impl_on_browser_changed (self, _sender, pspec);
}


UnityPlaceEntryServiceImpl* unity_place_entry_service_impl_construct (GType object_type, UnityPlaceEntryInfo* entry_info) {
	UnityPlaceEntryServiceImpl * self;
	UnityPlaceBrowser* _tmp0_;
	g_return_val_if_fail (entry_info != NULL, NULL);
	self = (UnityPlaceEntryServiceImpl*) g_object_new (object_type, "entry-info", entry_info, NULL);
	self->priv->_browser = (_tmp0_ = _g_object_ref0 (unity_place_entry_info_get_browser (entry_info)), _g_object_unref0 (self->priv->_browser), _tmp0_);
	g_signal_connect_object ((GObject*) entry_info, "notify::browser", (GCallback) _unity_place_entry_service_impl_on_browser_changed_g_object_notify, self, 0);
	return self;
}


UnityPlaceEntryServiceImpl* unity_place_entry_service_impl_new (UnityPlaceEntryInfo* entry_info) {
	return unity_place_entry_service_impl_construct (UNITY_PLACE_TYPE_ENTRY_SERVICE_IMPL, entry_info);
}


static void unity_place_entry_service_impl_real_set_global_search (UnityPlaceEntryService* base, const char* search, GHashTable* hints, GError** error) {
	UnityPlaceEntryServiceImpl * self;
	UnityPlaceSearch* s;
	self = (UnityPlaceEntryServiceImpl*) base;
	g_return_if_fail (search != NULL);
	g_return_if_fail (hints != NULL);
	s = g_object_ref_sink (unity_place_search_new (search, hints));
	if (!unity_place_search_equals (s, unity_place_entry_info_get_active_global_search (self->priv->_entry_info))) {
		unity_place_entry_info_set_active_global_search (self->priv->_entry_info, s);
	}
	_g_object_unref0 (s);
}


static void unity_place_entry_service_impl_real_set_search (UnityPlaceEntryService* base, const char* search, GHashTable* hints, GError** error) {
	UnityPlaceEntryServiceImpl * self;
	UnityPlaceSearch* s;
	self = (UnityPlaceEntryServiceImpl*) base;
	g_return_if_fail (search != NULL);
	g_return_if_fail (hints != NULL);
	s = g_object_ref_sink (unity_place_search_new (search, hints));
	if (!unity_place_search_equals (s, unity_place_entry_info_get_active_search (self->priv->_entry_info))) {
		unity_place_entry_info_set_active_search (self->priv->_entry_info, s);
	}
	_g_object_unref0 (s);
}


static void unity_place_entry_service_impl_real_set_active (UnityPlaceEntryService* base, gboolean is_active, GError** error) {
	UnityPlaceEntryServiceImpl * self;
	self = (UnityPlaceEntryServiceImpl*) base;
	unity_place_entry_info_set_active (self->priv->_entry_info, is_active);
}


static void unity_place_entry_service_impl_real_set_active_section (UnityPlaceEntryService* base, guint section_id, GError** error) {
	UnityPlaceEntryServiceImpl * self;
	self = (UnityPlaceEntryServiceImpl*) base;
	unity_place_entry_info_set_active_section (self->priv->_entry_info, section_id);
}


void unity_place_entry_service_impl_export (UnityPlaceEntryServiceImpl* self, GError** error) {
	DBusGConnection* conn;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	conn = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_vala_dbus_register_object (dbus_g_connection_get_connection (conn), unity_place_entry_info_get_dbus_path (self->priv->_entry_info), (GObject*) self);
	if (unity_place_entry_info_get_browser (self->priv->_entry_info) != NULL) {
		UnityPlaceBrowserService* _tmp0_;
		g_debug ("unity-place.vala:760: Exporting browser at '%s'", unity_place_browser_get_dbus_path (unity_place_entry_info_get_browser (self->priv->_entry_info)));
		_vala_dbus_register_object (dbus_g_connection_get_connection (conn), unity_place_browser_get_dbus_path (unity_place_entry_info_get_browser (self->priv->_entry_info)), (GObject*) (_tmp0_ = unity_place_browser_get_service (unity_place_entry_info_get_browser (self->priv->_entry_info))));
		_g_object_unref0 (_tmp0_);
	} else {
		g_debug ("unity-place.vala:766: No browser to export");
	}
	self->priv->_exported = TRUE;
	g_object_notify ((GObject*) self, "exported");
	_dbus_g_connection_unref0 (conn);
}


void unity_place_entry_service_impl_unexport (UnityPlaceEntryServiceImpl* self, GError** error) {
	DBusGConnection* conn;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	conn = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	dbus_g_connection_unregister_g_object (conn, (GObject*) self);
	if (unity_place_entry_info_get_browser (self->priv->_entry_info) != NULL) {
		UnityPlaceBrowserService* _tmp0_;
		g_debug ("unity-place.vala:779: Unexporting browser '%s'", unity_place_browser_get_dbus_path (unity_place_entry_info_get_browser (self->priv->_entry_info)));
		dbus_g_connection_unregister_g_object (conn, (GObject*) (_tmp0_ = unity_place_browser_get_service (unity_place_entry_info_get_browser (self->priv->_entry_info))));
		_g_object_unref0 (_tmp0_);
	}
	self->priv->_exported = FALSE;
	g_object_notify ((GObject*) self, "exported");
	_dbus_g_connection_unref0 (conn);
}


static void unity_place_entry_service_impl_on_browser_changed (UnityPlaceEntryServiceImpl* self, GObject* obj, GParamSpec* pspec) {
	DBusGConnection* conn;
	gboolean _tmp2_ = FALSE;
	UnityPlaceBrowser* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	conn = NULL;
	{
		DBusGConnection* _tmp0_;
		DBusGConnection* _tmp1_;
		_tmp0_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch41_dbus_gerror;
			}
			_dbus_g_connection_unref0 (conn);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		conn = (_tmp1_ = _tmp0_, _dbus_g_connection_unref0 (conn), _tmp1_);
	}
	goto __finally41;
	__catch41_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("unity-place.vala:793: Unable to connect to session bus: %s", e->message);
			_g_error_free0 (e);
			_dbus_g_connection_unref0 (conn);
			return;
		}
	}
	__finally41:
	if (_inner_error_ != NULL) {
		_dbus_g_connection_unref0 (conn);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	if (self->priv->_browser == unity_place_entry_info_get_browser (unity_place_entry_service_impl_get_entry_info (self))) {
		_dbus_g_connection_unref0 (conn);
		return;
	}
	if (self->priv->_browser != NULL) {
		_tmp2_ = self->priv->_exported;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		UnityPlaceBrowserService* _tmp3_;
		g_debug ("unity-place.vala:804: Unexporting browser '%s'", unity_place_browser_get_dbus_path (self->priv->_browser));
		dbus_g_connection_unregister_g_object (conn, (GObject*) (_tmp3_ = unity_place_browser_get_service (self->priv->_browser)));
		_g_object_unref0 (_tmp3_);
	}
	self->priv->_browser = (_tmp4_ = _g_object_ref0 (unity_place_entry_info_get_browser (unity_place_entry_service_impl_get_entry_info (self))), _g_object_unref0 (self->priv->_browser), _tmp4_);
	if (self->priv->_browser != NULL) {
		_tmp5_ = self->priv->_exported;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		UnityPlaceBrowserService* _tmp6_;
		g_debug ("unity-place.vala:813: Exporting browser '%s'", unity_place_browser_get_dbus_path (self->priv->_browser));
		_vala_dbus_register_object (dbus_g_connection_get_connection (conn), unity_place_browser_get_dbus_path (self->priv->_browser), (GObject*) (_tmp6_ = unity_place_browser_get_service (self->priv->_browser)));
		_g_object_unref0 (_tmp6_);
	}
	_dbus_g_connection_unref0 (conn);
}


static gboolean _unity_place_entry_service_impl_emit_place_entry_info_changed_signal_gsource_func (gpointer self) {
	gboolean result;
	result = unity_place_entry_service_impl_emit_place_entry_info_changed_signal (self);
	return result;
}


void unity_place_entry_service_impl_queue_place_entry_info_changed_signal (UnityPlaceEntryServiceImpl* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->place_entry_info_changed_signal_source == 0) {
		self->priv->place_entry_info_changed_signal_source = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _unity_place_entry_service_impl_emit_place_entry_info_changed_signal_gsource_func, g_object_ref (self), g_object_unref);
	}
}


static char** _vala_array_dup6 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gboolean unity_place_entry_service_impl_emit_place_entry_info_changed_signal (UnityPlaceEntryServiceImpl* self) {
	gboolean result = FALSE;
	UnityPlace_EntryInfoData entry_data = {0};
	UnityPlace_EntryInfo _tmp0_ = {0};
	UnityPlace_EntryInfo _entry;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char** _tmp4_;
	char** _tmp5_;
	char* _tmp6_;
	GHashTable* _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	memset (&entry_data, 0, sizeof (UnityPlace_EntryInfoData));
	_entry = (unity_place_entry_info_get_raw (self->priv->_entry_info, &_tmp0_), _tmp0_);
	entry_data.dbus_path = (_tmp1_ = g_strdup (_entry.dbus_path), _g_free0 (entry_data.dbus_path), _tmp1_);
	entry_data.display_name = (_tmp2_ = g_strdup (_entry.display_name), _g_free0 (entry_data.display_name), _tmp2_);
	entry_data.icon = (_tmp3_ = g_strdup (_entry.icon), _g_free0 (entry_data.icon), _tmp3_);
	entry_data.position = _entry.position;
	entry_data.mimetypes = (_tmp5_ = (_tmp4_ = _entry.mimetypes, (_tmp4_ == NULL) ? ((gpointer) _tmp4_) : _vala_array_dup6 (_tmp4_, _entry.mimetypes_length1)), entry_data.mimetypes = (_vala_array_free (entry_data.mimetypes, entry_data.mimetypes_length1, (GDestroyNotify) g_free), NULL), entry_data.mimetypes_length1 = _entry.mimetypes_length1, entry_data._mimetypes_size_ = entry_data.mimetypes_length1, _tmp5_);
	entry_data.sensitive = _entry.sensitive;
	entry_data.sections_model = (_tmp6_ = g_strdup (_entry.sections_model), _g_free0 (entry_data.sections_model), _tmp6_);
	entry_data.hints = (_tmp7_ = _g_hash_table_ref0 (_entry.hints), _g_hash_table_unref0 (entry_data.hints), _tmp7_);
	g_signal_emit_by_name ((UnityPlaceEntryService*) self, "place-entry-info-changed", &entry_data);
	self->priv->place_entry_info_changed_signal_source = (guint) 0;
	result = FALSE;
	unity_place__entryinfo_destroy (&_entry);
	unity_place__entryinfodata_destroy (&entry_data);
	return result;
}


UnityPlaceEntryInfo* unity_place_entry_service_impl_get_entry_info (UnityPlaceEntryServiceImpl* self) {
	UnityPlaceEntryInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_entry_info;
	return result;
}


static void unity_place_entry_service_impl_set_entry_info (UnityPlaceEntryServiceImpl* self, UnityPlaceEntryInfo* value) {
	UnityPlaceEntryInfo* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_entry_info = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_entry_info), _tmp0_);
	g_object_notify ((GObject *) self, "entry-info");
}


gboolean unity_place_entry_service_impl_get_exported (UnityPlaceEntryServiceImpl* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_exported;
	return result;
}


void _unity_place_entry_service_impl_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_unity_place_entry_service_impl_introspect (UnityPlaceEntryServiceImpl* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"com.canonical.Unity.PlaceEntry\">\n  <method name=\"SetGlobalSearch\">\n    <arg name=\"search\" type=\"s\" direction=\"in\"/>\n    <arg name=\"hints\" type=\"a{ss}\" direction=\"in\"/>\n  </method>\n  <method name=\"SetSearch\">\n    <arg name=\"search\" type=\"s\" direction=\"in\"/>\n    <arg name=\"hints\" type=\"a{ss}\" direction=\"in\"/>\n  </method>\n  <method name=\"SetActive\">\n    <arg name=\"is_active\" type=\"b\" direction=\"in\"/>\n  </method>\n  <method name=\"SetActiveSection\">\n    <arg name=\"section_id\" type=\"u\" direction=\"in\"/>\n  </method>\n  <signal name=\"EntryRendererInfoChanged\">\n    <arg name=\"renderer_info\" type=\"(sssa{ss})\"/>\n  </signal>\n  <signal name=\"GlobalRendererInfoChanged\">\n    <arg name=\"renderer_info\" type=\"(sssa{ss})\"/>\n  </signal>\n  <signal name=\"PlaceEntryInfoChanged\">\n    <arg name=\"entry_info_data\" type=\"(sssuasbsa{ss})\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult unity_place_entry_service_impl_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_unity_place_entry_service_impl_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (unity_place_entry_service_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void unity_place_entry_service_impl_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_unity_place_entry_service_impl_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	unity_place_entry_service_dbus_register_object (connection, path, object);
}


static void unity_place_entry_service_impl_class_init (UnityPlaceEntryServiceImplClass * klass) {
	unity_place_entry_service_impl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlaceEntryServiceImplPrivate));
	G_OBJECT_CLASS (klass)->get_property = unity_place_entry_service_impl_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_place_entry_service_impl_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_place_entry_service_impl_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_SERVICE_IMPL_ENTRY_INFO, g_param_spec_object ("entry-info", "entry-info", "entry-info", UNITY_PLACE_TYPE_ENTRY_INFO, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_ENTRY_SERVICE_IMPL_EXPORTED, g_param_spec_boolean ("exported", "exported", "exported", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_type_set_qdata (UNITY_PLACE_TYPE_ENTRY_SERVICE_IMPL, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_unity_place_entry_service_impl_dbus_vtable));
}


static void unity_place_entry_service_impl_unity_place_entry_service_interface_init (UnityPlaceEntryServiceIface * iface) {
	unity_place_entry_service_impl_unity_place_entry_service_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_global_search = unity_place_entry_service_impl_real_set_global_search;
	iface->set_search = unity_place_entry_service_impl_real_set_search;
	iface->set_active = unity_place_entry_service_impl_real_set_active;
	iface->set_active_section = unity_place_entry_service_impl_real_set_active_section;
}


static void unity_place_entry_service_impl_instance_init (UnityPlaceEntryServiceImpl * self) {
	self->priv = UNITY_PLACE_ENTRY_SERVICE_IMPL_GET_PRIVATE (self);
	self->priv->_exported = FALSE;
	self->priv->place_entry_info_changed_signal_source = (guint) 0;
	self->priv->_browser = NULL;
}


static void unity_place_entry_service_impl_finalize (GObject* obj) {
	UnityPlaceEntryServiceImpl * self;
	self = UNITY_PLACE_ENTRY_SERVICE_IMPL (obj);
	_g_object_unref0 (self->priv->_entry_info);
	_g_object_unref0 (self->priv->_browser);
	G_OBJECT_CLASS (unity_place_entry_service_impl_parent_class)->finalize (obj);
}


/**
   * UnityPlaceEntryServiceImpl:
   *
   * Private helper class to shield of DBus details and ugly
   * internal structs used for marshalling
   */
GType unity_place_entry_service_impl_get_type (void) {
	static volatile gsize unity_place_entry_service_impl_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place_entry_service_impl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlaceEntryServiceImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_place_entry_service_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlaceEntryServiceImpl), 0, (GInstanceInitFunc) unity_place_entry_service_impl_instance_init, NULL };
		static const GInterfaceInfo unity_place_entry_service_info = { (GInterfaceInitFunc) unity_place_entry_service_impl_unity_place_entry_service_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType unity_place_entry_service_impl_type_id;
		unity_place_entry_service_impl_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityPlaceEntryServiceImpl", &g_define_type_info, 0);
		g_type_add_interface_static (unity_place_entry_service_impl_type_id, UNITY_PLACE_TYPE_ENTRY_SERVICE, &unity_place_entry_service_info);
		g_once_init_leave (&unity_place_entry_service_impl_type_id__volatile, unity_place_entry_service_impl_type_id);
	}
	return unity_place_entry_service_impl_type_id__volatile;
}


static void unity_place_entry_service_impl_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlaceEntryServiceImpl * self;
	self = UNITY_PLACE_ENTRY_SERVICE_IMPL (object);
	switch (property_id) {
		case UNITY_PLACE_ENTRY_SERVICE_IMPL_ENTRY_INFO:
		g_value_set_object (value, unity_place_entry_service_impl_get_entry_info (self));
		break;
		case UNITY_PLACE_ENTRY_SERVICE_IMPL_EXPORTED:
		g_value_set_boolean (value, unity_place_entry_service_impl_get_exported (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_place_entry_service_impl_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlaceEntryServiceImpl * self;
	self = UNITY_PLACE_ENTRY_SERVICE_IMPL (object);
	switch (property_id) {
		case UNITY_PLACE_ENTRY_SERVICE_IMPL_ENTRY_INFO:
		unity_place_entry_service_impl_set_entry_info (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityPlace_EntrySignals* unity_place__entrysignals_dup (const UnityPlace_EntrySignals* self) {
	UnityPlace_EntrySignals* dup;
	dup = g_new0 (UnityPlace_EntrySignals, 1);
	memcpy (dup, self, sizeof (UnityPlace_EntrySignals));
	return dup;
}


void unity_place__entrysignals_free (UnityPlace_EntrySignals* self) {
	g_free (self);
}


GType unity_place__entrysignals_get_type (void) {
	static volatile gsize unity_place__entrysignals_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place__entrysignals_type_id__volatile)) {
		GType unity_place__entrysignals_type_id;
		unity_place__entrysignals_type_id = g_boxed_type_register_static ("UnityPlace_EntrySignals", (GBoxedCopyFunc) unity_place__entrysignals_dup, (GBoxedFreeFunc) unity_place__entrysignals_free);
		g_once_init_leave (&unity_place__entrysignals_type_id__volatile, unity_place__entrysignals_type_id);
	}
	return unity_place__entrysignals_type_id__volatile;
}


UnityPlaceController* unity_place_controller_construct (GType object_type, const char* dbus_path) {
	UnityPlaceController * self;
	g_return_val_if_fail (dbus_path != NULL, NULL);
	self = (UnityPlaceController*) g_object_new (object_type, "dbus-path", dbus_path, NULL);
	return self;
}


UnityPlaceController* unity_place_controller_new (const char* dbus_path) {
	return unity_place_controller_construct (UNITY_PLACE_TYPE_CONTROLLER, dbus_path);
}


static void _unity_place_controller_on_entry_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_place_controller_on_entry_changed (self, _sender, pspec);
}


static void _lambda3_ (GObject* obj, GParamSpec* pspec, Block1Data* _data1_) {
	UnityPlaceController * self;
	GObject* _tmp0_;
	UnityPlaceRendererInfo* renderer_info;
	UnityPlaceEntryServiceImpl* entry_service;
	self = _data1_->self;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	renderer_info = _g_object_ref0 ((_tmp0_ = obj, UNITY_PLACE_IS_RENDERER_INFO (_tmp0_) ? ((UnityPlaceRendererInfo*) _tmp0_) : NULL));
	entry_service = unity_place_service_impl_get_entry_service (self->priv->service, unity_place_entry_info_get_dbus_path (_data1_->entry));
	if (entry_service == NULL) {
		g_warning ("unity-place.vala:942: Entry renderer info changed for unknown entry '%" \
"s'", unity_place_entry_info_get_dbus_path (_data1_->entry));
	} else {
		UnityPlace_RendererInfo _tmp1_ = {0};
		UnityPlace_RendererInfo _tmp2_;
		UnityPlace_RendererInfo _tmp3_;
		g_signal_emit_by_name ((UnityPlaceEntryService*) entry_service, "entry-renderer-info-changed", (_tmp3_ = _tmp2_ = (unity_place_renderer_info_get_raw (renderer_info, &_tmp1_), _tmp1_), &_tmp3_));
		unity_place__rendererinfo_destroy (&_tmp2_);
	}
	_g_object_unref0 (entry_service);
	_g_object_unref0 (renderer_info);
}


static void __lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda3_ (_sender, pspec, self);
}


static void _lambda4_ (GObject* obj, GParamSpec* pspec, Block1Data* _data1_) {
	UnityPlaceController * self;
	GObject* _tmp0_;
	UnityPlaceRendererInfo* renderer_info;
	UnityPlaceEntryServiceImpl* entry_service;
	self = _data1_->self;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	renderer_info = _g_object_ref0 ((_tmp0_ = obj, UNITY_PLACE_IS_RENDERER_INFO (_tmp0_) ? ((UnityPlaceRendererInfo*) _tmp0_) : NULL));
	entry_service = unity_place_service_impl_get_entry_service (self->priv->service, unity_place_entry_info_get_dbus_path (_data1_->entry));
	if (entry_service == NULL) {
		g_warning ("unity-place.vala:958: Global renderer info changed for unknown entry '" \
"%s'", unity_place_entry_info_get_dbus_path (_data1_->entry));
	} else {
		UnityPlace_RendererInfo _tmp1_ = {0};
		UnityPlace_RendererInfo _tmp2_;
		UnityPlace_RendererInfo _tmp3_;
		g_signal_emit_by_name ((UnityPlaceEntryService*) entry_service, "global-renderer-info-changed", (_tmp3_ = _tmp2_ = (unity_place_renderer_info_get_raw (renderer_info, &_tmp1_), _tmp1_), &_tmp3_));
		unity_place__rendererinfo_destroy (&_tmp2_);
	}
	_g_object_unref0 (entry_service);
	_g_object_unref0 (renderer_info);
}


static void __lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda4_ (_sender, pspec, self);
}


static gpointer _unity_place__entrysignals_dup0 (gpointer self) {
	return self ? unity_place__entrysignals_dup (self) : NULL;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->entry);
		g_slice_free (Block1Data, _data1_);
	}
}


void unity_place_controller_add_entry (UnityPlaceController* self, UnityPlaceEntryInfo* entry) {
	Block1Data* _data1_;
	UnityPlace_EntrySignals signals = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->entry = _g_object_ref0 (entry);
	unity_place_service_impl_add_entry (self->priv->service, _data1_->entry);
	memset (&signals, 0, sizeof (UnityPlace_EntrySignals));
	signals.place_entry_info_changed_id = g_signal_connect_object ((GObject*) _data1_->entry, "notify", (GCallback) _unity_place_controller_on_entry_changed_g_object_notify, self, 0);
	signals.entry_renderer_info_changed_id = g_signal_connect_data ((GObject*) unity_place_entry_info_get_entry_renderer_info (_data1_->entry), "notify", (GCallback) __lambda3__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	signals.global_renderer_info_changed_id = g_signal_connect_data ((GObject*) unity_place_entry_info_get_global_renderer_info (_data1_->entry), "notify", (GCallback) __lambda4__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	g_hash_table_insert (self->priv->entry_signals, g_strdup (unity_place_entry_info_get_dbus_path (_data1_->entry)), _unity_place__entrysignals_dup0 (&signals));
	block1_data_unref (_data1_);
}


UnityPlaceEntryInfo* unity_place_controller_get_entry (UnityPlaceController* self, const char* dbus_path) {
	UnityPlaceEntryInfo* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (dbus_path != NULL, NULL);
	result = unity_place_service_impl_get_entry (self->priv->service, dbus_path);
	return result;
}


void unity_place_controller_remove_entry (UnityPlaceController* self, const char* dbus_path) {
	UnityPlace_EntrySignals* signals;
	UnityPlaceEntryInfo* entry;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dbus_path != NULL);
	signals = _unity_place__entrysignals_dup0 ((UnityPlace_EntrySignals*) g_hash_table_lookup (self->priv->entry_signals, dbus_path));
	if (signals == NULL) {
		g_warning ("unity-place.vala:982: No signals connected for unknown entry '%s'", dbus_path);
		unity_place_service_impl_remove_entry (self->priv->service, dbus_path);
		_unity_place__entrysignals_free0 (signals);
		return;
	}
	entry = unity_place_service_impl_get_entry (self->priv->service, dbus_path);
	if (entry == NULL) {
		g_warning ("unity-place.vala:991: Can not disconnect signals for unknown entry '%s" \
"'", dbus_path);
		g_hash_table_remove (self->priv->entry_signals, dbus_path);
		_g_object_unref0 (entry);
		_unity_place__entrysignals_free0 (signals);
		return;
	}
	g_signal_handler_disconnect ((GObject*) entry, (*signals).place_entry_info_changed_id);
	g_signal_handler_disconnect ((GObject*) unity_place_entry_info_get_entry_renderer_info (entry), (*signals).entry_renderer_info_changed_id);
	g_signal_handler_disconnect ((GObject*) unity_place_entry_info_get_global_renderer_info (entry), (*signals).global_renderer_info_changed_id);
	unity_place_service_impl_remove_entry (self->priv->service, dbus_path);
	_g_object_unref0 (entry);
	_unity_place__entrysignals_free0 (signals);
}


guint unity_place_controller_num_entries (UnityPlaceController* self) {
	guint result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = unity_place_service_impl_num_entries (self->priv->service);
	return result;
}


char** unity_place_controller_get_entry_paths (UnityPlaceController* self, int* result_length1) {
	char** result = NULL;
	gint _tmp0_;
	char** _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp1_ = unity_place_service_impl_get_entry_paths (self->priv->service, &_tmp0_), *result_length1 = _tmp0_, _tmp1_);
	return result;
}


UnityPlaceEntryInfo** unity_place_controller_get_entries (UnityPlaceController* self, int* result_length1) {
	UnityPlaceEntryInfo** result = NULL;
	guint len;
	gint _result__length1;
	gint __result__size_;
	UnityPlaceEntryInfo** _tmp0_;
	UnityPlaceEntryInfo** _result_;
	gint entry_paths_length1;
	gint _entry_paths_size_;
	char** _tmp2_;
	gint _tmp1_;
	char** entry_paths;
	gint i;
	UnityPlaceEntryInfo** _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	len = unity_place_controller_num_entries (self);
	_result_ = (_tmp0_ = g_new0 (UnityPlaceEntryInfo*, len + 1), _result__length1 = len, __result__size_ = _result__length1, _tmp0_);
	entry_paths = (_tmp2_ = unity_place_controller_get_entry_paths (self, &_tmp1_), entry_paths_length1 = _tmp1_, _entry_paths_size_ = entry_paths_length1, _tmp2_);
	i = 0;
	{
		gboolean _tmp3_;
		i = 0;
		_tmp3_ = TRUE;
		while (TRUE) {
			UnityPlaceEntryInfo* _tmp4_;
			if (!_tmp3_) {
				i++;
			}
			_tmp3_ = FALSE;
			if (!(i < len)) {
				break;
			}
			_result_[i] = (_tmp4_ = unity_place_controller_get_entry (self, entry_paths[i]), _g_object_unref0 (_result_[i]), _tmp4_);
		}
	}
	result = (_tmp5_ = _result_, *result_length1 = _result__length1, _tmp5_);
	entry_paths = (_vala_array_free (entry_paths, entry_paths_length1, (GDestroyNotify) g_free), NULL);
	return result;
	entry_paths = (_vala_array_free (entry_paths, entry_paths_length1, (GDestroyNotify) g_free), NULL);
	_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_object_unref), NULL);
}


void unity_place_controller_export (UnityPlaceController* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	unity_place_service_impl_export (self->priv->service, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->priv->_exported = TRUE;
	g_object_notify ((GObject*) self, "exported");
}


void unity_place_controller_unexport (UnityPlaceController* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	unity_place_service_impl_unexport (self->priv->service, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->priv->_exported = FALSE;
	g_object_notify ((GObject*) self, "exported");
}


static void unity_place_controller_on_entry_changed (UnityPlaceController* self, GObject* obj, GParamSpec* pspec) {
	GObject* _tmp0_;
	UnityPlaceEntryInfo* entry;
	UnityPlaceEntryServiceImpl* entry_service;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	entry = _g_object_ref0 ((_tmp0_ = obj, UNITY_PLACE_IS_ENTRY_INFO (_tmp0_) ? ((UnityPlaceEntryInfo*) _tmp0_) : NULL));
	entry_service = unity_place_service_impl_get_entry_service (self->priv->service, unity_place_entry_info_get_dbus_path (entry));
	if (entry_service == NULL) {
		g_warning ("unity-place.vala:1053: Got change signal from unknown entry service '%" \
"s'", unity_place_entry_info_get_dbus_path (entry));
		_g_object_unref0 (entry_service);
		_g_object_unref0 (entry);
		return;
	}
	if (gee_collection_contains ((GeeCollection*) self->priv->ignore_remote_notify_props, g_param_spec_get_name (pspec))) {
		_g_object_unref0 (entry_service);
		_g_object_unref0 (entry);
		return;
	}
	unity_place_entry_service_impl_queue_place_entry_info_changed_signal (entry_service);
	_g_object_unref0 (entry_service);
	_g_object_unref0 (entry);
}


const char* unity_place_controller_get_dbus_path (UnityPlaceController* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_dbus_path;
	return result;
}


static void unity_place_controller_set_dbus_path (UnityPlaceController* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_dbus_path = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_dbus_path), _tmp0_);
	g_object_notify ((GObject *) self, "dbus-path");
}


gboolean unity_place_controller_get_exported (UnityPlaceController* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_exported;
	return result;
}


UnityPlaceActivation* unity_place_controller_get_activation (UnityPlaceController* self) {
	UnityPlaceActivation* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = unity_place_service_impl_get_activation (self->priv->service);
	return result;
}


void unity_place_controller_set_activation (UnityPlaceController* self, UnityPlaceActivation* value) {
	g_return_if_fail (self != NULL);
	unity_place_service_impl_set_activation (self->priv->service, value);
	g_object_notify ((GObject *) self, "activation");
}


static GObject * unity_place_controller_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPlaceController * self;
	parent_class = G_OBJECT_CLASS (unity_place_controller_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PLACE_CONTROLLER (obj);
	{
		UnityPlaceServiceImpl* _tmp0_;
		GHashTable* _tmp1_;
		GeeSet* _tmp2_;
		self->priv->service = (_tmp0_ = unity_place_service_impl_new (self->priv->_dbus_path), _g_object_unref0 (self->priv->service), _tmp0_);
		self->priv->entry_signals = (_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, unity_place__entrysignals_free), _g_hash_table_unref0 (self->priv->entry_signals), _tmp1_);
		self->priv->ignore_remote_notify_props = (_tmp2_ = (GeeSet*) gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL), _g_object_unref0 (self->priv->ignore_remote_notify_props), _tmp2_);
		gee_collection_add ((GeeCollection*) self->priv->ignore_remote_notify_props, "active-search");
		gee_collection_add ((GeeCollection*) self->priv->ignore_remote_notify_props, "active-global-search");
		gee_collection_add ((GeeCollection*) self->priv->ignore_remote_notify_props, "active");
		gee_collection_add ((GeeCollection*) self->priv->ignore_remote_notify_props, "active-section");
	}
	return obj;
}


static void unity_place_controller_class_init (UnityPlaceControllerClass * klass) {
	unity_place_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlaceControllerPrivate));
	G_OBJECT_CLASS (klass)->get_property = unity_place_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_place_controller_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_place_controller_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_place_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_CONTROLLER_DBUS_PATH, g_param_spec_string ("dbus-path", "dbus-path", "dbus-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_CONTROLLER_EXPORTED, g_param_spec_boolean ("exported", "exported", "exported", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACE_CONTROLLER_ACTIVATION, g_param_spec_object ("activation", "activation", "activation", UNITY_PLACE_TYPE_ACTIVATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_place_controller_instance_init (UnityPlaceController * self) {
	self->priv = UNITY_PLACE_CONTROLLER_GET_PRIVATE (self);
	self->priv->_exported = FALSE;
}


static void unity_place_controller_finalize (GObject* obj) {
	UnityPlaceController * self;
	self = UNITY_PLACE_CONTROLLER (obj);
	_g_object_unref0 (self->priv->service);
	_g_free0 (self->priv->_dbus_path);
	_g_hash_table_unref0 (self->priv->entry_signals);
	_g_object_unref0 (self->priv->ignore_remote_notify_props);
	G_OBJECT_CLASS (unity_place_controller_parent_class)->finalize (obj);
}


/**
   * UnityPlaceController:
   *
   * Main handle for controlling the place entries managed by a place daemon
   */
GType unity_place_controller_get_type (void) {
	static volatile gsize unity_place_controller_type_id__volatile = 0;
	if (g_once_init_enter (&unity_place_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlaceControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_place_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlaceController), 0, (GInstanceInitFunc) unity_place_controller_instance_init, NULL };
		GType unity_place_controller_type_id;
		unity_place_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityPlaceController", &g_define_type_info, 0);
		g_once_init_leave (&unity_place_controller_type_id__volatile, unity_place_controller_type_id);
	}
	return unity_place_controller_type_id__volatile;
}


static void unity_place_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlaceController * self;
	self = UNITY_PLACE_CONTROLLER (object);
	switch (property_id) {
		case UNITY_PLACE_CONTROLLER_DBUS_PATH:
		g_value_set_string (value, unity_place_controller_get_dbus_path (self));
		break;
		case UNITY_PLACE_CONTROLLER_EXPORTED:
		g_value_set_boolean (value, unity_place_controller_get_exported (self));
		break;
		case UNITY_PLACE_CONTROLLER_ACTIVATION:
		g_value_set_object (value, unity_place_controller_get_activation (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_place_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlaceController * self;
	self = UNITY_PLACE_CONTROLLER (object);
	switch (property_id) {
		case UNITY_PLACE_CONTROLLER_DBUS_PATH:
		unity_place_controller_set_dbus_path (self, g_value_get_string (value));
		break;
		case UNITY_PLACE_CONTROLLER_ACTIVATION:
		unity_place_controller_set_activation (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}



