/* places-place-search-bar.c generated by valac 0.10.0, the Vala compiler
 * generated from places-place-search-bar.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <clutk/clutk.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <dee.h>
#include <unity.h>
#include <clutter/clutter.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <cairo.h>
#include <gdk/gdk.h>


#define UNITY_PLACES_TYPE_PLACE_SEARCH_BAR (unity_places_place_search_bar_get_type ())
#define UNITY_PLACES_PLACE_SEARCH_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_BAR, UnityPlacesPlaceSearchBar))
#define UNITY_PLACES_PLACE_SEARCH_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_PLACE_SEARCH_BAR, UnityPlacesPlaceSearchBarClass))
#define UNITY_PLACES_IS_PLACE_SEARCH_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_BAR))
#define UNITY_PLACES_IS_PLACE_SEARCH_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_PLACE_SEARCH_BAR))
#define UNITY_PLACES_PLACE_SEARCH_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_BAR, UnityPlacesPlaceSearchBarClass))

typedef struct _UnityPlacesPlaceSearchBar UnityPlacesPlaceSearchBar;
typedef struct _UnityPlacesPlaceSearchBarClass UnityPlacesPlaceSearchBarClass;
typedef struct _UnityPlacesPlaceSearchBarPrivate UnityPlacesPlaceSearchBarPrivate;

#define UNITY_PLACES_TYPE_PLACE_SEARCH_ENTRY (unity_places_place_search_entry_get_type ())
#define UNITY_PLACES_PLACE_SEARCH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_ENTRY, UnityPlacesPlaceSearchEntry))
#define UNITY_PLACES_PLACE_SEARCH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_PLACE_SEARCH_ENTRY, UnityPlacesPlaceSearchEntryClass))
#define UNITY_PLACES_IS_PLACE_SEARCH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_ENTRY))
#define UNITY_PLACES_IS_PLACE_SEARCH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_PLACE_SEARCH_ENTRY))
#define UNITY_PLACES_PLACE_SEARCH_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_ENTRY, UnityPlacesPlaceSearchEntryClass))

typedef struct _UnityPlacesPlaceSearchEntry UnityPlacesPlaceSearchEntry;
typedef struct _UnityPlacesPlaceSearchEntryClass UnityPlacesPlaceSearchEntryClass;

#define UNITY_PLACES_TYPE_PLACE_SEARCH_SECTIONS_BAR (unity_places_place_search_sections_bar_get_type ())
#define UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_SECTIONS_BAR, UnityPlacesPlaceSearchSectionsBar))
#define UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_PLACE_SEARCH_SECTIONS_BAR, UnityPlacesPlaceSearchSectionsBarClass))
#define UNITY_PLACES_IS_PLACE_SEARCH_SECTIONS_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_SECTIONS_BAR))
#define UNITY_PLACES_IS_PLACE_SEARCH_SECTIONS_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_PLACE_SEARCH_SECTIONS_BAR))
#define UNITY_PLACES_PLACE_SEARCH_SECTIONS_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_SECTIONS_BAR, UnityPlacesPlaceSearchSectionsBarClass))

typedef struct _UnityPlacesPlaceSearchSectionsBar UnityPlacesPlaceSearchSectionsBar;
typedef struct _UnityPlacesPlaceSearchSectionsBarClass UnityPlacesPlaceSearchSectionsBarClass;

#define UNITY_PLACES_TYPE_PLACE_SEARCH_EXTRA_ACTION (unity_places_place_search_extra_action_get_type ())
#define UNITY_PLACES_PLACE_SEARCH_EXTRA_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_EXTRA_ACTION, UnityPlacesPlaceSearchExtraAction))
#define UNITY_PLACES_PLACE_SEARCH_EXTRA_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_PLACE_SEARCH_EXTRA_ACTION, UnityPlacesPlaceSearchExtraActionClass))
#define UNITY_PLACES_IS_PLACE_SEARCH_EXTRA_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_EXTRA_ACTION))
#define UNITY_PLACES_IS_PLACE_SEARCH_EXTRA_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_PLACE_SEARCH_EXTRA_ACTION))
#define UNITY_PLACES_PLACE_SEARCH_EXTRA_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_EXTRA_ACTION, UnityPlacesPlaceSearchExtraActionClass))

typedef struct _UnityPlacesPlaceSearchExtraAction UnityPlacesPlaceSearchExtraAction;
typedef struct _UnityPlacesPlaceSearchExtraActionClass UnityPlacesPlaceSearchExtraActionClass;

#define UNITY_PLACES_TYPE_PLACE_ENTRY (unity_places_place_entry_get_type ())
#define UNITY_PLACES_PLACE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE_ENTRY, UnityPlacesPlaceEntry))
#define UNITY_PLACES_IS_PLACE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE_ENTRY))
#define UNITY_PLACES_PLACE_ENTRY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_PLACES_TYPE_PLACE_ENTRY, UnityPlacesPlaceEntryIface))

typedef struct _UnityPlacesPlaceEntry UnityPlacesPlaceEntry;
typedef struct _UnityPlacesPlaceEntryIface UnityPlacesPlaceEntryIface;

#define UNITY_PLACES_TYPE_PLACE (unity_places_place_get_type ())
#define UNITY_PLACES_PLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE, UnityPlacesPlace))
#define UNITY_PLACES_PLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_PLACE, UnityPlacesPlaceClass))
#define UNITY_PLACES_IS_PLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE))
#define UNITY_PLACES_IS_PLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_PLACE))
#define UNITY_PLACES_PLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_PLACE, UnityPlacesPlaceClass))

typedef struct _UnityPlacesPlace UnityPlacesPlace;
typedef struct _UnityPlacesPlaceClass UnityPlacesPlaceClass;

#define UNITY_PLACES_TYPE_PLACE_SEARCH_BAR_BACKGROUND (unity_places_place_search_bar_background_get_type ())
#define UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_BAR_BACKGROUND, UnityPlacesPlaceSearchBarBackground))
#define UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_PLACE_SEARCH_BAR_BACKGROUND, UnityPlacesPlaceSearchBarBackgroundClass))
#define UNITY_PLACES_IS_PLACE_SEARCH_BAR_BACKGROUND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_BAR_BACKGROUND))
#define UNITY_PLACES_IS_PLACE_SEARCH_BAR_BACKGROUND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_PLACE_SEARCH_BAR_BACKGROUND))
#define UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_BAR_BACKGROUND, UnityPlacesPlaceSearchBarBackgroundClass))

typedef struct _UnityPlacesPlaceSearchBarBackground UnityPlacesPlaceSearchBarBackground;
typedef struct _UnityPlacesPlaceSearchBarBackgroundClass UnityPlacesPlaceSearchBarBackgroundClass;

#define UNITY_PLACES_TYPE_PLACE_SEARCH_NAVIGATION (unity_places_place_search_navigation_get_type ())
#define UNITY_PLACES_PLACE_SEARCH_NAVIGATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_NAVIGATION, UnityPlacesPlaceSearchNavigation))
#define UNITY_PLACES_PLACE_SEARCH_NAVIGATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_PLACES_TYPE_PLACE_SEARCH_NAVIGATION, UnityPlacesPlaceSearchNavigationClass))
#define UNITY_PLACES_IS_PLACE_SEARCH_NAVIGATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_NAVIGATION))
#define UNITY_PLACES_IS_PLACE_SEARCH_NAVIGATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_PLACES_TYPE_PLACE_SEARCH_NAVIGATION))
#define UNITY_PLACES_PLACE_SEARCH_NAVIGATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_PLACES_TYPE_PLACE_SEARCH_NAVIGATION, UnityPlacesPlaceSearchNavigationClass))

typedef struct _UnityPlacesPlaceSearchNavigation UnityPlacesPlaceSearchNavigation;
typedef struct _UnityPlacesPlaceSearchNavigationClass UnityPlacesPlaceSearchNavigationClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define UNITY_TESTING_TYPE_OBJECT_REGISTRY (unity_testing_object_registry_get_type ())
#define UNITY_TESTING_OBJECT_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TESTING_TYPE_OBJECT_REGISTRY, UnityTestingObjectRegistry))
#define UNITY_TESTING_OBJECT_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TESTING_TYPE_OBJECT_REGISTRY, UnityTestingObjectRegistryClass))
#define UNITY_TESTING_IS_OBJECT_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TESTING_TYPE_OBJECT_REGISTRY))
#define UNITY_TESTING_IS_OBJECT_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TESTING_TYPE_OBJECT_REGISTRY))
#define UNITY_TESTING_OBJECT_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TESTING_TYPE_OBJECT_REGISTRY, UnityTestingObjectRegistryClass))

typedef struct _UnityTestingObjectRegistry UnityTestingObjectRegistry;
typedef struct _UnityTestingObjectRegistryClass UnityTestingObjectRegistryClass;
#define _unity_testing_object_registry_unref0(var) ((var == NULL) ? NULL : (var = (unity_testing_object_registry_unref (var), NULL)))
typedef struct _UnityPlacesPlaceSearchEntryPrivate UnityPlacesPlaceSearchEntryPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define UNITY_PLACES_TYPE_ACTIVATION_STATUS (unity_places_activation_status_get_type ())

#define UNITY_PLACES_TYPE_SECTION_STYLE (unity_places_section_style_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block5Data Block5Data;
typedef struct _UnityPlacesPlaceSearchBarBackgroundPrivate UnityPlacesPlaceSearchBarBackgroundPrivate;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _UnityPlacesPlaceSearchBar {
	CtkBox parent_instance;
	UnityPlacesPlaceSearchBarPrivate * priv;
	UnityPlacesPlaceSearchEntry* entry;
	UnityPlacesPlaceSearchSectionsBar* sections;
	UnityPlacesPlaceSearchExtraAction* extra_action;
};

struct _UnityPlacesPlaceSearchBarClass {
	CtkBoxClass parent_class;
};

struct _UnityPlacesPlaceEntryIface {
	GTypeInterface parent_iface;
	void (*connect) (UnityPlacesPlaceEntry* self);
	void (*set_search) (UnityPlacesPlaceEntry* self, const char* search, GHashTable* hints);
	void (*set_active_section) (UnityPlacesPlaceEntry* self, guint section_id);
	void (*set_global_search) (UnityPlacesPlaceEntry* self, const char* search, GHashTable* hints);
	const char* (*get_name) (UnityPlacesPlaceEntry* self);
	void (*set_name) (UnityPlacesPlaceEntry* self, const char* value);
	const char* (*get_icon) (UnityPlacesPlaceEntry* self);
	void (*set_icon) (UnityPlacesPlaceEntry* self, const char* value);
	const char* (*get_description) (UnityPlacesPlaceEntry* self);
	void (*set_description) (UnityPlacesPlaceEntry* self, const char* value);
	guint (*get_position) (UnityPlacesPlaceEntry* self);
	void (*set_position) (UnityPlacesPlaceEntry* self, guint value);
	char** (*get_mimetypes) (UnityPlacesPlaceEntry* self, int* result_length1);
	void (*set_mimetypes) (UnityPlacesPlaceEntry* self, char** value, int value_length1);
	gboolean (*get_sensitive) (UnityPlacesPlaceEntry* self);
	void (*set_sensitive) (UnityPlacesPlaceEntry* self, gboolean value);
	GeeHashMap* (*get_hints) (UnityPlacesPlaceEntry* self);
	void (*set_hints) (UnityPlacesPlaceEntry* self, GeeHashMap* value);
	gboolean (*get_online) (UnityPlacesPlaceEntry* self);
	void (*set_online) (UnityPlacesPlaceEntry* self, gboolean value);
	gboolean (*get_active) (UnityPlacesPlaceEntry* self);
	void (*set_active) (UnityPlacesPlaceEntry* self, gboolean value);
	DeeModel* (*get_sections_model) (UnityPlacesPlaceEntry* self);
	void (*set_sections_model) (UnityPlacesPlaceEntry* self, DeeModel* value);
	const char* (*get_entry_renderer_name) (UnityPlacesPlaceEntry* self);
	void (*set_entry_renderer_name) (UnityPlacesPlaceEntry* self, const char* value);
	DeeModel* (*get_entry_groups_model) (UnityPlacesPlaceEntry* self);
	void (*set_entry_groups_model) (UnityPlacesPlaceEntry* self, DeeModel* value);
	DeeModel* (*get_entry_results_model) (UnityPlacesPlaceEntry* self);
	void (*set_entry_results_model) (UnityPlacesPlaceEntry* self, DeeModel* value);
	GeeHashMap* (*get_entry_renderer_hints) (UnityPlacesPlaceEntry* self);
	void (*set_entry_renderer_hints) (UnityPlacesPlaceEntry* self, GeeHashMap* value);
	const char* (*get_global_renderer_name) (UnityPlacesPlaceEntry* self);
	void (*set_global_renderer_name) (UnityPlacesPlaceEntry* self, const char* value);
	DeeModel* (*get_global_groups_model) (UnityPlacesPlaceEntry* self);
	void (*set_global_groups_model) (UnityPlacesPlaceEntry* self, DeeModel* value);
	DeeModel* (*get_global_results_model) (UnityPlacesPlaceEntry* self);
	void (*set_global_results_model) (UnityPlacesPlaceEntry* self, DeeModel* value);
	GeeHashMap* (*get_global_renderer_hints) (UnityPlacesPlaceEntry* self);
	void (*set_global_renderer_hints) (UnityPlacesPlaceEntry* self, GeeHashMap* value);
	UnityPlacesPlace* (*get_parent) (UnityPlacesPlaceEntry* self);
	void (*set_parent) (UnityPlacesPlaceEntry* self, UnityPlacesPlace* value);
};

struct _UnityPlacesPlaceSearchBarPrivate {
	UnityPlacesPlaceEntry* active_entry;
	UnityPlacesPlaceSearchBarBackground* bg;
	UnityPlacesPlaceSearchNavigation* navigation;
	gboolean _search_fail;
};

struct _UnityPlacesPlaceSearchEntry {
	CtkBox parent_instance;
	UnityPlacesPlaceSearchEntryPrivate * priv;
	CtkImage* left_icon;
	CtkText* hint_text;
	CtkText* text;
	UnityCairoCanvas* right_icon;
};

struct _UnityPlacesPlaceSearchEntryClass {
	CtkBoxClass parent_class;
};

typedef enum  {
	UNITY_PLACES_ACTIVATION_STATUS_NOT_ACTIVATED,
	UNITY_PLACES_ACTIVATION_STATUS_ACTIVATED_FALLBACK,
	UNITY_PLACES_ACTIVATION_STATUS_ACTIVATED_SHOW_DASH,
	UNITY_PLACES_ACTIVATION_STATUS_ACTIVATED_HIDE_DASH
} UnityPlacesActivationStatus;

typedef enum  {
	UNITY_PLACES_SECTION_STYLE_BUTTONS,
	UNITY_PLACES_SECTION_STYLE_BREADCRUMB
} UnityPlacesSectionStyle;

struct _Block5Data {
	int _ref_count_;
	UnityPlacesPlaceSearchBar * self;
	guint section;
};

struct _UnityPlacesPlaceSearchBarBackground {
	CtkBin parent_instance;
	UnityPlacesPlaceSearchBarBackgroundPrivate * priv;
};

struct _UnityPlacesPlaceSearchBarBackgroundClass {
	CtkBinClass parent_class;
};

struct _UnityPlacesPlaceSearchBarBackgroundPrivate {
	gint last_width;
	gint last_height;
	GdkPixbuf* tile;
	gint _entry_position;
	ClutterCairoTexture* texture;
	CtkEffectGlow* glow;
	gboolean _search_empty;
	UnityPlacesPlaceSearchNavigation* _navigation;
	UnityPlacesPlaceSearchEntry* _search_entry;
};


static gpointer unity_places_place_search_bar_parent_class = NULL;
static gpointer unity_places_place_search_bar_background_parent_class = NULL;

GType unity_places_place_search_bar_get_type (void) G_GNUC_CONST;
GType unity_places_place_search_entry_get_type (void) G_GNUC_CONST;
GType unity_places_place_search_sections_bar_get_type (void) G_GNUC_CONST;
GType unity_places_place_search_extra_action_get_type (void) G_GNUC_CONST;
GType unity_places_place_get_type (void) G_GNUC_CONST;
GType unity_places_place_entry_get_type (void) G_GNUC_CONST;
GType unity_places_place_search_bar_background_get_type (void) G_GNUC_CONST;
GType unity_places_place_search_navigation_get_type (void) G_GNUC_CONST;
#define UNITY_PLACES_PLACE_SEARCH_BAR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_PLACES_TYPE_PLACE_SEARCH_BAR, UnityPlacesPlaceSearchBarPrivate))
enum  {
	UNITY_PLACES_PLACE_SEARCH_BAR_DUMMY_PROPERTY,
	UNITY_PLACES_PLACE_SEARCH_BAR_SEARCH_FAIL
};
#define UNITY_PLACES_PLACE_SEARCH_BAR_SPACING 8
#define UNITY_PLACES_PLACE_SEARCH_BAR_RANDOM_TEXT_WIDTH 400
UnityPlacesPlaceSearchBar* unity_places_place_search_bar_new (void);
UnityPlacesPlaceSearchBar* unity_places_place_search_bar_construct (GType object_type);
gpointer unity_testing_object_registry_ref (gpointer instance);
void unity_testing_object_registry_unref (gpointer instance);
GParamSpec* unity_testing_param_spec_object_registry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void unity_testing_value_set_object_registry (GValue* value, gpointer v_object);
void unity_testing_value_take_object_registry (GValue* value, gpointer v_object);
gpointer unity_testing_value_get_object_registry (const GValue* value);
GType unity_testing_object_registry_get_type (void) G_GNUC_CONST;
UnityTestingObjectRegistry* unity_testing_object_registry_get_default (void);
void unity_testing_object_registry_register (UnityTestingObjectRegistry* self, const char* name, GObject* object);
void unity_places_place_search_bar_reset (UnityPlacesPlaceSearchBar* self);
void unity_places_place_search_bar_set_search_fail (UnityPlacesPlaceSearchBar* self, gboolean value);
void unity_places_place_search_entry_reset (UnityPlacesPlaceSearchEntry* self);
void unity_places_place_search_bar_search (UnityPlacesPlaceSearchBar* self, const char* text);
static void unity_places_place_search_bar_on_search_text_changed (UnityPlacesPlaceSearchBar* self, const char* text);
char* unity_places_place_search_bar_get_search_text (UnityPlacesPlaceSearchBar* self);
static void unity_places_place_search_bar_real_allocate (ClutterActor* base, const ClutterActorBox* box, ClutterAllocationFlags flags);
gboolean unity_places_place_search_bar_background_update_background (UnityPlacesPlaceSearchBarBackground* self);
static gboolean _unity_places_place_search_bar_background_update_background_gsource_func (gpointer self);
static void unity_places_place_search_bar_real_get_preferred_height (ClutterActor* base, float for_width, float* min_height, float* nat_height);
void unity_places_place_entry_set_search (UnityPlacesPlaceEntry* self, const char* search, GHashTable* hints);
static void unity_places_place_search_bar_on_extra_action_activated (UnityPlacesPlaceSearchBar* self);
UnityPlacesPlace* unity_places_place_entry_get_parent (UnityPlacesPlaceEntry* self);
GType unity_places_activation_status_get_type (void) G_GNUC_CONST;
UnityPlacesActivationStatus unity_places_place_activate (UnityPlacesPlace* self, const char* uri, const char* mimetype);
void unity_places_place_search_bar_set_active_entry_view (UnityPlacesPlaceSearchBar* self, UnityPlacesPlaceEntry* entry, gint x, guint section);
void unity_places_place_search_bar_background_set_entry_position (UnityPlacesPlaceSearchBarBackground* self, gint value);
void unity_places_place_search_sections_bar_set_active_entry (UnityPlacesPlaceSearchSectionsBar* self, UnityPlacesPlaceEntry* entry);
GType unity_places_section_style_get_type (void) G_GNUC_CONST;
UnityPlacesSectionStyle unity_places_place_search_sections_bar_get_style (UnityPlacesPlaceSearchSectionsBar* self);
static gboolean _lambda42_ (Block5Data* _data5_);
void unity_places_place_search_sections_bar_set_active_section (UnityPlacesPlaceSearchSectionsBar* self, guint section_id);
static gboolean __lambda42__gsource_func (gpointer self);
void unity_places_place_search_navigation_set_active_entry (UnityPlacesPlaceSearchNavigation* self, UnityPlacesPlaceEntry* entry);
void unity_places_place_search_entry_set_active_entry (UnityPlacesPlaceSearchEntry* self, UnityPlacesPlaceEntry* entry);
GeeHashMap* unity_places_place_entry_get_hints (UnityPlacesPlaceEntry* self);
void unity_places_place_search_extra_action_set_icon_from_gicon_string (UnityPlacesPlaceSearchExtraAction* self, const char* icon_string);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
gboolean unity_places_place_search_bar_get_search_fail (UnityPlacesPlaceSearchBar* self);
void unity_places_place_search_bar_background_set_search_empty (UnityPlacesPlaceSearchBarBackground* self, gboolean value);
UnityPlacesPlaceSearchNavigation* unity_places_place_search_navigation_new (void);
UnityPlacesPlaceSearchNavigation* unity_places_place_search_navigation_construct (GType object_type);
UnityPlacesPlaceSearchEntry* unity_places_place_search_entry_new (void);
UnityPlacesPlaceSearchEntry* unity_places_place_search_entry_construct (GType object_type);
static void _unity_places_place_search_bar_on_search_text_changed_unity_places_place_search_entry_text_changed (UnityPlacesPlaceSearchEntry* _sender, const char* text, gpointer self);
UnityPlacesPlaceSearchSectionsBar* unity_places_place_search_sections_bar_new (void);
UnityPlacesPlaceSearchSectionsBar* unity_places_place_search_sections_bar_construct (GType object_type);
UnityPlacesPlaceSearchExtraAction* unity_places_place_search_extra_action_new (void);
UnityPlacesPlaceSearchExtraAction* unity_places_place_search_extra_action_construct (GType object_type);
static void _unity_places_place_search_bar_on_extra_action_activated_unity_places_place_search_extra_action_activated (UnityPlacesPlaceSearchExtraAction* _sender, gpointer self);
UnityPlacesPlaceSearchBarBackground* unity_places_place_search_bar_background_new (UnityPlacesPlaceSearchNavigation* nav, UnityPlacesPlaceSearchEntry* search_entry);
UnityPlacesPlaceSearchBarBackground* unity_places_place_search_bar_background_construct (GType object_type, UnityPlacesPlaceSearchNavigation* nav, UnityPlacesPlaceSearchEntry* search_entry);
static GObject * unity_places_place_search_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_places_place_search_bar_finalize (GObject* obj);
static void unity_places_place_search_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_places_place_search_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_PLACES_TYPE_PLACE_SEARCH_BAR_BACKGROUND, UnityPlacesPlaceSearchBarBackgroundPrivate))
enum  {
	UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_DUMMY_PROPERTY,
	UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_ENTRY_POSITION,
	UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_SEARCH_EMPTY,
	UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_NAVIGATION,
	UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_SEARCH_ENTRY
};
#define UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_BG "/usr/share/unity/dash_background.png"
static void unity_places_place_search_bar_background_real_allocate (ClutterActor* base, const ClutterActorBox* box, ClutterAllocationFlags flags);
gint unity_places_place_search_bar_background_get_entry_position (UnityPlacesPlaceSearchBarBackground* self);
UnityPlacesPlaceSearchNavigation* unity_places_place_search_bar_background_get_navigation (UnityPlacesPlaceSearchBarBackground* self);
UnityPlacesPlaceSearchEntry* unity_places_place_search_bar_background_get_search_entry (UnityPlacesPlaceSearchBarBackground* self);
gboolean unity_places_place_search_bar_background_get_search_empty (UnityPlacesPlaceSearchBarBackground* self);
static void unity_places_place_search_bar_background_set_navigation (UnityPlacesPlaceSearchBarBackground* self, UnityPlacesPlaceSearchNavigation* value);
static void unity_places_place_search_bar_background_set_search_entry (UnityPlacesPlaceSearchBarBackground* self, UnityPlacesPlaceSearchEntry* value);
static GObject * unity_places_place_search_bar_background_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_places_place_search_bar_background_finalize (GObject* obj);
static void unity_places_place_search_bar_background_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_places_place_search_bar_background_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



UnityPlacesPlaceSearchBar* unity_places_place_search_bar_construct (GType object_type) {
	UnityPlacesPlaceSearchBar * self;
	UnityTestingObjectRegistry* _tmp0_;
	self = (UnityPlacesPlaceSearchBar*) g_object_new (object_type, "orientation", CTK_ORIENTATION_HORIZONTAL, "homogeneous", FALSE, "spacing", 20, NULL);
	unity_testing_object_registry_register (_tmp0_ = unity_testing_object_registry_get_default (), "UnityPlacesSearchBar", (GObject*) self);
	_unity_testing_object_registry_unref0 (_tmp0_);
	return self;
}


UnityPlacesPlaceSearchBar* unity_places_place_search_bar_new (void) {
	return unity_places_place_search_bar_construct (UNITY_PLACES_TYPE_PLACE_SEARCH_BAR);
}


void unity_places_place_search_bar_reset (UnityPlacesPlaceSearchBar* self) {
	g_return_if_fail (self != NULL);
	unity_places_place_search_bar_set_search_fail (self, FALSE);
	unity_places_place_search_entry_reset (self->entry);
}


void unity_places_place_search_bar_search (UnityPlacesPlaceSearchBar* self, const char* text) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	clutter_text_set_text ((ClutterText*) self->entry->text, text);
	unity_places_place_search_bar_on_search_text_changed (self, text);
}


char* unity_places_place_search_bar_get_search_text (UnityPlacesPlaceSearchBar* self) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_strdup (clutter_text_get_text ((ClutterText*) self->entry->text));
	return result;
}


static gboolean _unity_places_place_search_bar_background_update_background_gsource_func (gpointer self) {
	gboolean result;
	result = unity_places_place_search_bar_background_update_background (self);
	return result;
}


static void unity_places_place_search_bar_real_allocate (ClutterActor* base, const ClutterActorBox* box, ClutterAllocationFlags flags) {
	UnityPlacesPlaceSearchBar * self;
	float ex;
	float ewidth;
	gboolean _tmp0_ = FALSE;
	self = (UnityPlacesPlaceSearchBar*) base;
	ex = clutter_actor_get_x ((ClutterActor*) self->entry);
	ewidth = clutter_actor_get_width ((ClutterActor*) self->entry);
	CLUTTER_ACTOR_CLASS (unity_places_place_search_bar_parent_class)->allocate ((ClutterActor*) CTK_BOX (self), box, flags);
	if (clutter_actor_get_x ((ClutterActor*) self->entry) != ex) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = clutter_actor_get_width ((ClutterActor*) self->entry) != ewidth;
	}
	if (_tmp0_) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 0, _unity_places_place_search_bar_background_update_background_gsource_func, g_object_ref (self->priv->bg), g_object_unref);
	}
}


static void unity_places_place_search_bar_real_get_preferred_height (ClutterActor* base, float for_width, float* min_height, float* nat_height) {
	UnityPlacesPlaceSearchBar * self;
	float mheight = 0.0F;
	float nheight = 0.0F;
	self = (UnityPlacesPlaceSearchBar*) base;
	clutter_actor_get_preferred_height ((ClutterActor*) self->entry, (float) UNITY_PLACES_PLACE_SEARCH_BAR_RANDOM_TEXT_WIDTH, &mheight, &nheight);
	*min_height = mheight + (UNITY_PLACES_PLACE_SEARCH_BAR_SPACING * 3);
	*nat_height = nheight + (UNITY_PLACES_PLACE_SEARCH_BAR_SPACING * 3);
}


static void unity_places_place_search_bar_on_search_text_changed (UnityPlacesPlaceSearchBar* self, const char* text) {
	g_return_if_fail (self != NULL);
	if (UNITY_PLACES_IS_PLACE_ENTRY (self->priv->active_entry)) {
		GHashTable* hints;
		hints = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
		unity_places_place_entry_set_search (self->priv->active_entry, text, hints);
		_g_hash_table_unref0 (hints);
	}
}


static void unity_places_place_search_bar_on_extra_action_activated (UnityPlacesPlaceSearchBar* self) {
	g_return_if_fail (self != NULL);
	if (UNITY_PLACES_IS_PLACE_ENTRY (self->priv->active_entry)) {
		UnityPlacesActivationStatus _result_;
		_result_ = unity_places_place_activate (unity_places_place_entry_get_parent (self->priv->active_entry), ".", "");
		switch (_result_) {
			case UNITY_PLACES_ACTIVATION_STATUS_ACTIVATED_SHOW_DASH:
			{
				break;
			}
			case UNITY_PLACES_ACTIVATION_STATUS_NOT_ACTIVATED:
			case UNITY_PLACES_ACTIVATION_STATUS_ACTIVATED_HIDE_DASH:
			case UNITY_PLACES_ACTIVATION_STATUS_ACTIVATED_FALLBACK:
			{
				unity_shell_hide_unity (unity_global_shell);
				break;
			}
			default:
			{
				g_warning ("places-place-search-bar.vala:173: Unexpected activation status: %u", (guint) _result_);
				break;
			}
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _lambda42_ (Block5Data* _data5_) {
	UnityPlacesPlaceSearchBar * self;
	gboolean result = FALSE;
	self = _data5_->self;
	unity_places_place_search_sections_bar_set_active_section (self->sections, _data5_->section);
	result = FALSE;
	return result;
}


static gboolean __lambda42__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda42_ (self);
	return result;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		g_slice_free (Block5Data, _data5_);
	}
}


void unity_places_place_search_bar_set_active_entry_view (UnityPlacesPlaceSearchBar* self, UnityPlacesPlaceEntry* entry, gint x, guint section) {
	Block5Data* _data5_;
	UnityPlacesPlaceEntry* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->section = section;
	self->priv->active_entry = (_tmp0_ = _g_object_ref0 (entry), _g_object_unref0 (self->priv->active_entry), _tmp0_);
	unity_places_place_search_bar_background_set_entry_position (self->priv->bg, x);
	unity_places_place_search_sections_bar_set_active_entry (self->sections, entry);
	if (unity_places_place_search_sections_bar_get_style (self->sections) == UNITY_PLACES_SECTION_STYLE_BREADCRUMB) {
		_tmp1_ = _data5_->section == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (!_tmp1_) {
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 0, __lambda42__gsource_func, block5_data_ref (_data5_), block5_data_unref);
	}
	unity_places_place_search_navigation_set_active_entry (self->priv->navigation, entry);
	unity_places_place_search_entry_set_active_entry (self->entry, entry);
	clutter_actor_grab_key_focus ((ClutterActor*) self->entry->text);
	if (unity_places_place_entry_get_hints (entry) != NULL) {
		char* _tmp2_;
		gboolean _tmp3_;
		if ((_tmp3_ = (_tmp2_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) unity_places_place_entry_get_hints (entry), "UnityExtraAction")) != NULL, _g_free0 (_tmp2_), _tmp3_)) {
			char* _tmp4_;
			unity_places_place_search_extra_action_set_icon_from_gicon_string (self->extra_action, _tmp4_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) unity_places_place_entry_get_hints (entry), "UnityExtraAction"));
			_g_free0 (_tmp4_);
			clutter_actor_show ((ClutterActor*) self->extra_action);
		} else {
			clutter_actor_hide ((ClutterActor*) self->extra_action);
		}
	}
	block5_data_unref (_data5_);
}


gboolean unity_places_place_search_bar_get_search_fail (UnityPlacesPlaceSearchBar* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_search_fail;
	return result;
}


void unity_places_place_search_bar_set_search_fail (UnityPlacesPlaceSearchBar* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_search_fail != value) {
		self->priv->_search_fail = value;
		unity_places_place_search_bar_background_set_search_empty (self->priv->bg, self->priv->_search_fail);
		unity_places_place_search_bar_background_update_background (self->priv->bg);
	}
	g_object_notify ((GObject *) self, "search-fail");
}


static void _unity_places_place_search_bar_on_search_text_changed_unity_places_place_search_entry_text_changed (UnityPlacesPlaceSearchEntry* _sender, const char* text, gpointer self) {
	unity_places_place_search_bar_on_search_text_changed (self, text);
}


static void _unity_places_place_search_bar_on_extra_action_activated_unity_places_place_search_extra_action_activated (UnityPlacesPlaceSearchExtraAction* _sender, gpointer self) {
	unity_places_place_search_bar_on_extra_action_activated (self);
}


static GObject * unity_places_place_search_bar_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPlacesPlaceSearchBar * self;
	parent_class = G_OBJECT_CLASS (unity_places_place_search_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PLACES_PLACE_SEARCH_BAR (obj);
	{
		CtkPadding _tmp0_ = {0};
		CtkPadding _tmp1_;
		UnityPlacesPlaceSearchNavigation* _tmp2_;
		UnityPlacesPlaceSearchEntry* _tmp3_;
		UnityPlacesPlaceSearchSectionsBar* _tmp4_;
		ClutterColor _tmp5_ = {0};
		ClutterColor _tmp6_;
		ClutterRectangle* space;
		UnityPlacesPlaceSearchExtraAction* _tmp7_;
		UnityPlacesPlaceSearchBarBackground* _tmp8_;
		ctk_actor_set_padding ((CtkActor*) self, (_tmp1_ = (_tmp0_.top = UNITY_PLACES_PLACE_SEARCH_BAR_SPACING * 2.0f, _tmp0_.right = UNITY_PLACES_PLACE_SEARCH_BAR_SPACING * 1.0f, _tmp0_.bottom = UNITY_PLACES_PLACE_SEARCH_BAR_SPACING * 1.0f, _tmp0_.left = UNITY_PLACES_PLACE_SEARCH_BAR_SPACING * 1.0f, _tmp0_), &_tmp1_));
		self->priv->navigation = (_tmp2_ = g_object_ref_sink (unity_places_place_search_navigation_new ()), _g_object_unref0 (self->priv->navigation), _tmp2_);
		ctk_box_pack ((CtkBox*) self, (ClutterActor*) self->priv->navigation, FALSE, TRUE);
		clutter_actor_show ((ClutterActor*) self->priv->navigation);
		self->entry = (_tmp3_ = g_object_ref_sink (unity_places_place_search_entry_new ()), _g_object_unref0 (self->entry), _tmp3_);
		ctk_box_pack ((CtkBox*) self, (ClutterActor*) self->entry, FALSE, TRUE);
		clutter_actor_show ((ClutterActor*) self->entry);
		g_signal_connect_object (self->entry, "text-changed", (GCallback) _unity_places_place_search_bar_on_search_text_changed_unity_places_place_search_entry_text_changed, self, 0);
		self->sections = (_tmp4_ = g_object_ref_sink (unity_places_place_search_sections_bar_new ()), _g_object_unref0 (self->sections), _tmp4_);
		ctk_box_pack ((CtkBox*) self, (ClutterActor*) self->sections, FALSE, TRUE);
		clutter_actor_show ((ClutterActor*) self->sections);
		space = g_object_ref_sink ((ClutterRectangle*) clutter_rectangle_new_with_color ((_tmp6_ = (_tmp5_.red = (guint8) 255, _tmp5_.green = (guint8) 255, _tmp5_.blue = (guint8) 255, _tmp5_.alpha = (guint8) 0, _tmp5_), &_tmp6_)));
		ctk_box_pack ((CtkBox*) self, (ClutterActor*) space, TRUE, TRUE);
		clutter_actor_show ((ClutterActor*) space);
		self->extra_action = (_tmp7_ = g_object_ref_sink (unity_places_place_search_extra_action_new ()), _g_object_unref0 (self->extra_action), _tmp7_);
		ctk_box_pack ((CtkBox*) self, (ClutterActor*) self->extra_action, FALSE, TRUE);
		clutter_actor_hide ((ClutterActor*) self->extra_action);
		g_signal_connect_object (self->extra_action, "activated", (GCallback) _unity_places_place_search_bar_on_extra_action_activated_unity_places_place_search_extra_action_activated, self, 0);
		self->priv->bg = (_tmp8_ = g_object_ref_sink (unity_places_place_search_bar_background_new (self->priv->navigation, self->entry)), _g_object_unref0 (self->priv->bg), _tmp8_);
		ctk_actor_set_background ((CtkActor*) self, (ClutterActor*) self->priv->bg);
		clutter_actor_show ((ClutterActor*) self->priv->bg);
		_g_object_unref0 (space);
	}
	return obj;
}


static void unity_places_place_search_bar_class_init (UnityPlacesPlaceSearchBarClass * klass) {
	unity_places_place_search_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlacesPlaceSearchBarPrivate));
	CLUTTER_ACTOR_CLASS (klass)->allocate = unity_places_place_search_bar_real_allocate;
	CLUTTER_ACTOR_CLASS (klass)->get_preferred_height = unity_places_place_search_bar_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->get_property = unity_places_place_search_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_places_place_search_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_places_place_search_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_places_place_search_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_PLACE_SEARCH_BAR_SEARCH_FAIL, g_param_spec_boolean ("search-fail", "search-fail", "search-fail", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_places_place_search_bar_instance_init (UnityPlacesPlaceSearchBar * self) {
	self->priv = UNITY_PLACES_PLACE_SEARCH_BAR_GET_PRIVATE (self);
	self->priv->active_entry = NULL;
	self->priv->_search_fail = FALSE;
}


static void unity_places_place_search_bar_finalize (GObject* obj) {
	UnityPlacesPlaceSearchBar * self;
	self = UNITY_PLACES_PLACE_SEARCH_BAR (obj);
	_g_object_unref0 (self->priv->active_entry);
	_g_object_unref0 (self->priv->bg);
	_g_object_unref0 (self->priv->navigation);
	_g_object_unref0 (self->entry);
	_g_object_unref0 (self->sections);
	_g_object_unref0 (self->extra_action);
	G_OBJECT_CLASS (unity_places_place_search_bar_parent_class)->finalize (obj);
}


GType unity_places_place_search_bar_get_type (void) {
	static volatile gsize unity_places_place_search_bar_type_id__volatile = 0;
	if (g_once_init_enter (&unity_places_place_search_bar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlacesPlaceSearchBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_places_place_search_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlacesPlaceSearchBar), 0, (GInstanceInitFunc) unity_places_place_search_bar_instance_init, NULL };
		GType unity_places_place_search_bar_type_id;
		unity_places_place_search_bar_type_id = g_type_register_static (CTK_TYPE_BOX, "UnityPlacesPlaceSearchBar", &g_define_type_info, 0);
		g_once_init_leave (&unity_places_place_search_bar_type_id__volatile, unity_places_place_search_bar_type_id);
	}
	return unity_places_place_search_bar_type_id__volatile;
}


static void unity_places_place_search_bar_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlacesPlaceSearchBar * self;
	self = UNITY_PLACES_PLACE_SEARCH_BAR (object);
	switch (property_id) {
		case UNITY_PLACES_PLACE_SEARCH_BAR_SEARCH_FAIL:
		g_value_set_boolean (value, unity_places_place_search_bar_get_search_fail (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_places_place_search_bar_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlacesPlaceSearchBar * self;
	self = UNITY_PLACES_PLACE_SEARCH_BAR (object);
	switch (property_id) {
		case UNITY_PLACES_PLACE_SEARCH_BAR_SEARCH_FAIL:
		unity_places_place_search_bar_set_search_fail (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityPlacesPlaceSearchBarBackground* unity_places_place_search_bar_background_construct (GType object_type, UnityPlacesPlaceSearchNavigation* nav, UnityPlacesPlaceSearchEntry* search_entry) {
	UnityPlacesPlaceSearchBarBackground * self;
	g_return_val_if_fail (nav != NULL, NULL);
	g_return_val_if_fail (search_entry != NULL, NULL);
	self = (UnityPlacesPlaceSearchBarBackground*) g_object_new (object_type, "navigation", nav, "search-entry", search_entry, NULL);
	return self;
}


UnityPlacesPlaceSearchBarBackground* unity_places_place_search_bar_background_new (UnityPlacesPlaceSearchNavigation* nav, UnityPlacesPlaceSearchEntry* search_entry) {
	return unity_places_place_search_bar_background_construct (UNITY_PLACES_TYPE_PLACE_SEARCH_BAR_BACKGROUND, nav, search_entry);
}


static void unity_places_place_search_bar_background_real_allocate (ClutterActor* base, const ClutterActorBox* box, ClutterAllocationFlags flags) {
	UnityPlacesPlaceSearchBarBackground * self;
	gint width;
	gint height;
	gboolean _tmp0_ = FALSE;
	self = (UnityPlacesPlaceSearchBarBackground*) base;
	width = (gint) ((*box).x2 - (*box).x1);
	height = (gint) ((*box).y2 - (*box).y1);
	CLUTTER_ACTOR_CLASS (unity_places_place_search_bar_background_parent_class)->allocate ((ClutterActor*) CTK_BIN (self), box, flags);
	if (width != self->priv->last_width) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = height != self->priv->last_height;
	}
	if (_tmp0_) {
		self->priv->last_width = width;
		self->priv->last_height = height;
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 0, _unity_places_place_search_bar_background_update_background_gsource_func, g_object_ref (self), g_object_unref);
	}
}


static gpointer _cairo_pattern_reference0 (gpointer self) {
	return self ? cairo_pattern_reference (self) : NULL;
}


gboolean unity_places_place_search_bar_background_update_background (UnityPlacesPlaceSearchBarBackground* self) {
	gboolean result = FALSE;
	cairo_t* cr;
	cairo_t* _tmp0_;
	gint x;
	gint y;
	gint width;
	gint height;
	gint radius;
	g_return_val_if_fail (self != NULL, FALSE);
	cr = NULL;
	clutter_cairo_texture_set_surface_size (self->priv->texture, (guint) self->priv->last_width, (guint) self->priv->last_height);
	cr = (_tmp0_ = clutter_cairo_texture_create (self->priv->texture), _cairo_destroy0 (cr), _tmp0_);
	cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
	cairo_paint (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
	cairo_set_line_width (cr, 1.0);
	cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.0);
	cairo_translate (cr, 0.5, 0.5);
	x = 0;
	y = UNITY_PLACES_PLACE_SEARCH_BAR_SPACING;
	width = self->priv->last_width - 2;
	height = self->priv->last_height - 2;
	radius = 7;
	cairo_move_to (cr, (double) x, (double) (y + radius));
	cairo_curve_to (cr, (double) x, (double) y, (double) x, (double) y, (double) (x + radius), (double) y);
	if (unity_places_place_search_bar_background_get_entry_position (self) != 0) {
		cairo_line_to (cr, (double) (unity_places_place_search_bar_background_get_entry_position (self) - y), (double) y);
		cairo_line_to (cr, (double) unity_places_place_search_bar_background_get_entry_position (self), (double) (y - y));
		cairo_line_to (cr, (double) (unity_places_place_search_bar_background_get_entry_position (self) + y), (double) y);
	}
	cairo_line_to (cr, (double) (width - radius), (double) y);
	cairo_curve_to (cr, (double) width, (double) y, (double) width, (double) y, (double) width, (double) (y + radius));
	cairo_line_to (cr, (double) width, (double) (height - radius));
	cairo_curve_to (cr, (double) width, (double) height, (double) width, (double) height, (double) (width - radius), (double) height);
	cairo_line_to (cr, (double) (x + radius), (double) height);
	cairo_curve_to (cr, (double) x, (double) height, (double) x, (double) height, (double) x, (double) (height - radius));
	cairo_close_path (cr);
	cairo_stroke_preserve (cr);
	cairo_clip_preserve (cr);
	if (GDK_IS_PIXBUF (self->priv->tile)) {
		cairo_pattern_t* pat;
		gdk_cairo_set_source_pixbuf (cr, self->priv->tile, (double) 0, (double) 0);
		pat = _cairo_pattern_reference0 (cairo_get_source (cr));
		cairo_pattern_set_extend (pat, CAIRO_EXTEND_REPEAT);
		cairo_paint_with_alpha (cr, 0.25);
		_cairo_pattern_destroy0 (pat);
	}
	cairo_reset_clip (cr);
	cairo_set_source_rgba (cr, 1.0, 1.0, 1.0, 0.6);
	cairo_stroke (cr);
	x = (gint) clutter_actor_get_x ((ClutterActor*) self->priv->_navigation);
	y = ((gint) clutter_actor_get_y ((ClutterActor*) self->priv->_navigation)) - 1;
	width = x + ((gint) clutter_actor_get_width ((ClutterActor*) self->priv->_navigation));
	height = y + ((gint) clutter_actor_get_height ((ClutterActor*) self->priv->_navigation));
	cairo_move_to (cr, (double) x, (double) (y + radius));
	cairo_curve_to (cr, (double) x, (double) y, (double) x, (double) y, (double) (x + radius), (double) y);
	cairo_line_to (cr, (double) (width - radius), (double) y);
	cairo_curve_to (cr, (double) width, (double) y, (double) width, (double) y, (double) width, (double) (y + radius));
	cairo_line_to (cr, (double) width, (double) (height - radius));
	cairo_curve_to (cr, (double) width, (double) height, (double) width, (double) height, (double) (width - radius), (double) height);
	cairo_line_to (cr, (double) (x + radius), (double) height);
	cairo_curve_to (cr, (double) x, (double) height, (double) x, (double) height, (double) x, (double) (height - radius));
	cairo_close_path (cr);
	cairo_set_source_rgba (cr, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 0.05f);
	cairo_fill_preserve (cr);
	cairo_set_source_rgba (cr, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 0.6f);
	cairo_stroke (cr);
	cairo_rectangle (cr, (double) (x + ((width - x) / 2)), (double) (y + 1), (double) 1, (double) ((height - y) - 1));
	cairo_fill (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_CLEAR);
	x = (gint) clutter_actor_get_x ((ClutterActor*) self->priv->_search_entry);
	y = ((gint) clutter_actor_get_y ((ClutterActor*) self->priv->_search_entry)) - 1;
	width = x + ((gint) clutter_actor_get_width ((ClutterActor*) self->priv->_search_entry));
	height = (y + ((gint) clutter_actor_get_height ((ClutterActor*) self->priv->_search_entry))) + 1;
	cairo_move_to (cr, (double) x, (double) (y + radius));
	cairo_curve_to (cr, (double) x, (double) y, (double) x, (double) y, (double) (x + radius), (double) y);
	cairo_line_to (cr, (double) (width - radius), (double) y);
	cairo_curve_to (cr, (double) width, (double) y, (double) width, (double) y, (double) width, (double) (y + radius));
	cairo_line_to (cr, (double) width, (double) (height - radius));
	cairo_curve_to (cr, (double) width, (double) height, (double) width, (double) height, (double) (width - radius), (double) height);
	cairo_line_to (cr, (double) (x + radius), (double) height);
	cairo_curve_to (cr, (double) x, (double) height, (double) x, (double) height, (double) x, (double) (height - radius));
	cairo_close_path (cr);
	cairo_fill_preserve (cr);
	cairo_set_operator (cr, CAIRO_OPERATOR_OVER);
	if (self->priv->_search_empty) {
		cairo_set_source_rgba (cr, (double) 1.0f, (double) 0.0f, (double) 0.0f, (double) 0.3f);
		cairo_fill_preserve (cr);
	}
	cairo_set_source_rgba (cr, (double) 1.0f, (double) 1.0f, (double) 1.0f, (double) 0.6f);
	cairo_stroke (cr);
	ctk_effect_set_invalidate_effect_cache ((CtkEffect*) self->priv->glow, TRUE);
	result = FALSE;
	_cairo_destroy0 (cr);
	return result;
}


gint unity_places_place_search_bar_background_get_entry_position (UnityPlacesPlaceSearchBarBackground* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_entry_position;
	return result;
}


void unity_places_place_search_bar_background_set_entry_position (UnityPlacesPlaceSearchBarBackground* self, gint value) {
	g_return_if_fail (self != NULL);
	if (self->priv->_entry_position != value) {
		self->priv->_entry_position = value;
		unity_places_place_search_bar_background_update_background (self);
	}
	g_object_notify ((GObject *) self, "entry-position");
}


gboolean unity_places_place_search_bar_background_get_search_empty (UnityPlacesPlaceSearchBarBackground* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_search_empty;
	return result;
}


void unity_places_place_search_bar_background_set_search_empty (UnityPlacesPlaceSearchBarBackground* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_search_empty = value;
	g_object_notify ((GObject *) self, "search-empty");
}


UnityPlacesPlaceSearchNavigation* unity_places_place_search_bar_background_get_navigation (UnityPlacesPlaceSearchBarBackground* self) {
	UnityPlacesPlaceSearchNavigation* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_navigation;
	return result;
}


static void unity_places_place_search_bar_background_set_navigation (UnityPlacesPlaceSearchBarBackground* self, UnityPlacesPlaceSearchNavigation* value) {
	UnityPlacesPlaceSearchNavigation* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_navigation = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_navigation), _tmp0_);
	g_object_notify ((GObject *) self, "navigation");
}


UnityPlacesPlaceSearchEntry* unity_places_place_search_bar_background_get_search_entry (UnityPlacesPlaceSearchBarBackground* self) {
	UnityPlacesPlaceSearchEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_search_entry;
	return result;
}


static void unity_places_place_search_bar_background_set_search_entry (UnityPlacesPlaceSearchBarBackground* self, UnityPlacesPlaceSearchEntry* value) {
	UnityPlacesPlaceSearchEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_search_entry = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_search_entry), _tmp0_);
	g_object_notify ((GObject *) self, "search-entry");
}


static GObject * unity_places_place_search_bar_background_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPlacesPlaceSearchBarBackground * self;
	GError * _inner_error_;
	parent_class = G_OBJECT_CLASS (unity_places_place_search_bar_background_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND (obj);
	_inner_error_ = NULL;
	{
		ClutterCairoTexture* _tmp2_;
		CtkEffectGlow* _tmp3_;
		ClutterColor _tmp4_ = {0};
		ClutterColor _tmp5_;
		{
			GdkPixbuf* _tmp0_;
			GdkPixbuf* _tmp1_;
			_tmp0_ = gdk_pixbuf_new_from_file (UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_BG, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch32_g_error;
			}
			self->priv->tile = (_tmp1_ = _tmp0_, _g_object_unref0 (self->priv->tile), _tmp1_);
		}
		goto __finally32;
		__catch32_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("places-place-search-bar.vala:264: Unable to load dash background");
				_g_error_free0 (e);
			}
		}
		__finally32:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		self->priv->texture = (_tmp2_ = g_object_ref_sink ((ClutterCairoTexture*) clutter_cairo_texture_new ((guint) 10, (guint) 10)), _g_object_unref0 (self->priv->texture), _tmp2_);
		clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) self->priv->texture);
		clutter_actor_show ((ClutterActor*) self->priv->texture);
		self->priv->glow = (_tmp3_ = g_object_ref_sink ((CtkEffectGlow*) ctk_effect_glow_new ()), _g_object_unref0 (self->priv->glow), _tmp3_);
		ctk_effect_glow_set_color (self->priv->glow, (_tmp5_ = (_tmp4_.red = (guint8) 255, _tmp4_.green = (guint8) 255, _tmp4_.blue = (guint8) 255, _tmp4_.alpha = (guint8) 255, _tmp4_), &_tmp5_));
		ctk_effect_glow_set_factor (self->priv->glow, 1.0f);
		ctk_effect_set_margin ((CtkEffect*) self->priv->glow, 5);
		ctk_actor_add_effect ((CtkActor*) self, (CtkEffect*) self->priv->glow);
		unity_places_place_search_bar_background_set_search_empty (self, FALSE);
	}
	return obj;
}


static void unity_places_place_search_bar_background_class_init (UnityPlacesPlaceSearchBarBackgroundClass * klass) {
	unity_places_place_search_bar_background_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPlacesPlaceSearchBarBackgroundPrivate));
	CLUTTER_ACTOR_CLASS (klass)->allocate = unity_places_place_search_bar_background_real_allocate;
	G_OBJECT_CLASS (klass)->get_property = unity_places_place_search_bar_background_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_places_place_search_bar_background_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_places_place_search_bar_background_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_places_place_search_bar_background_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_ENTRY_POSITION, g_param_spec_int ("entry-position", "entry-position", "entry-position", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_SEARCH_EMPTY, g_param_spec_boolean ("search-empty", "search-empty", "search-empty", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_NAVIGATION, g_param_spec_object ("navigation", "navigation", "navigation", UNITY_PLACES_TYPE_PLACE_SEARCH_NAVIGATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_SEARCH_ENTRY, g_param_spec_object ("search-entry", "search-entry", "search-entry", UNITY_PLACES_TYPE_PLACE_SEARCH_ENTRY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void unity_places_place_search_bar_background_instance_init (UnityPlacesPlaceSearchBarBackground * self) {
	self->priv = UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_GET_PRIVATE (self);
	self->priv->last_width = 0;
	self->priv->last_height = 0;
	self->priv->tile = NULL;
	self->priv->_entry_position = 0;
}


static void unity_places_place_search_bar_background_finalize (GObject* obj) {
	UnityPlacesPlaceSearchBarBackground * self;
	self = UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND (obj);
	_g_object_unref0 (self->priv->tile);
	_g_object_unref0 (self->priv->texture);
	_g_object_unref0 (self->priv->glow);
	_g_object_unref0 (self->priv->_navigation);
	_g_object_unref0 (self->priv->_search_entry);
	G_OBJECT_CLASS (unity_places_place_search_bar_background_parent_class)->finalize (obj);
}


GType unity_places_place_search_bar_background_get_type (void) {
	static volatile gsize unity_places_place_search_bar_background_type_id__volatile = 0;
	if (g_once_init_enter (&unity_places_place_search_bar_background_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPlacesPlaceSearchBarBackgroundClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_places_place_search_bar_background_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPlacesPlaceSearchBarBackground), 0, (GInstanceInitFunc) unity_places_place_search_bar_background_instance_init, NULL };
		GType unity_places_place_search_bar_background_type_id;
		unity_places_place_search_bar_background_type_id = g_type_register_static (CTK_TYPE_BIN, "UnityPlacesPlaceSearchBarBackground", &g_define_type_info, 0);
		g_once_init_leave (&unity_places_place_search_bar_background_type_id__volatile, unity_places_place_search_bar_background_type_id);
	}
	return unity_places_place_search_bar_background_type_id__volatile;
}


static void unity_places_place_search_bar_background_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPlacesPlaceSearchBarBackground * self;
	self = UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND (object);
	switch (property_id) {
		case UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_ENTRY_POSITION:
		g_value_set_int (value, unity_places_place_search_bar_background_get_entry_position (self));
		break;
		case UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_SEARCH_EMPTY:
		g_value_set_boolean (value, unity_places_place_search_bar_background_get_search_empty (self));
		break;
		case UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_NAVIGATION:
		g_value_set_object (value, unity_places_place_search_bar_background_get_navigation (self));
		break;
		case UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_SEARCH_ENTRY:
		g_value_set_object (value, unity_places_place_search_bar_background_get_search_entry (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_places_place_search_bar_background_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPlacesPlaceSearchBarBackground * self;
	self = UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND (object);
	switch (property_id) {
		case UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_ENTRY_POSITION:
		unity_places_place_search_bar_background_set_entry_position (self, g_value_get_int (value));
		break;
		case UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_SEARCH_EMPTY:
		unity_places_place_search_bar_background_set_search_empty (self, g_value_get_boolean (value));
		break;
		case UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_NAVIGATION:
		unity_places_place_search_bar_background_set_navigation (self, g_value_get_object (value));
		break;
		case UNITY_PLACES_PLACE_SEARCH_BAR_BACKGROUND_SEARCH_ENTRY:
		unity_places_place_search_bar_background_set_search_entry (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




