/* scrollerchild.c generated by valac 0.10.0, the Vala compiler
 * generated from scrollerchild.vala, do not modify */

/*
 *      scrollerchild.vala.vala
 *      Copyright (C) 2010 Canonical Ltd
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 *
 *
 *      Authored by Gordon Allott <gord.allott@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <float.h>
#include <math.h>
#include <clutk/clutk.h>
#include <unity.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <clutter/clutter.h>
#include <clutter-gtk/clutter-gtk.h>


#define UNITY_LAUNCHER_TYPE_ANIM_STATE (unity_launcher_anim_state_get_type ())

#define UNITY_LAUNCHER_TYPE_PIN_TYPE (unity_launcher_pin_type_get_type ())

#define UNITY_LAUNCHER_TYPE_SCROLLER_CHILD (unity_launcher_scroller_child_get_type ())
#define UNITY_LAUNCHER_SCROLLER_CHILD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, UnityLauncherScrollerChild))
#define UNITY_LAUNCHER_SCROLLER_CHILD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, UnityLauncherScrollerChildClass))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD))
#define UNITY_LAUNCHER_SCROLLER_CHILD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, UnityLauncherScrollerChildClass))

typedef struct _UnityLauncherScrollerChild UnityLauncherScrollerChild;
typedef struct _UnityLauncherScrollerChildClass UnityLauncherScrollerChildClass;
typedef struct _UnityLauncherScrollerChildPrivate UnityLauncherScrollerChildPrivate;

#define UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER (unity_launcher_scroller_child_controller_get_type ())
#define UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, UnityLauncherScrollerChildController))
#define UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, UnityLauncherScrollerChildControllerClass))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER))
#define UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, UnityLauncherScrollerChildControllerClass))

typedef struct _UnityLauncherScrollerChildController UnityLauncherScrollerChildController;
typedef struct _UnityLauncherScrollerChildControllerClass UnityLauncherScrollerChildControllerClass;

#define UNITY_LAUNCHER_SCROLLER_CHILD_TYPE_GROUP_TYPE (unity_launcher_scroller_child_group_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	UNITY_LAUNCHER_ANIM_STATE_RISING,
	UNITY_LAUNCHER_ANIM_STATE_LOOPING,
	UNITY_LAUNCHER_ANIM_STATE_FALLING,
	UNITY_LAUNCHER_ANIM_STATE_STOPPED
} UnityLauncherAnimState;

typedef enum  {
	UNITY_LAUNCHER_PIN_TYPE_UNPINNED,
	UNITY_LAUNCHER_PIN_TYPE_PINNED,
	UNITY_LAUNCHER_PIN_TYPE_ALWAYS,
	UNITY_LAUNCHER_PIN_TYPE_NEVER
} UnityLauncherPinType;

struct _UnityLauncherScrollerChild {
	CtkActor parent_instance;
	UnityLauncherScrollerChildPrivate * priv;
	UnityLauncherPinType pin_type;
	gboolean do_not_render;
	UnityLauncherScrollerChildController* controller;
	float grabbed_push;
	UnityUnityIcon* processed_icon;
};

struct _UnityLauncherScrollerChildClass {
	CtkActorClass parent_class;
};

typedef enum  {
	UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_APPLICATION,
	UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_PLACE,
	UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_DEVICE,
	UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_SYSTEM
} UnityLauncherScrollerChildGroupType;

struct _UnityLauncherScrollerChildPrivate {
	GdkPixbuf* _icon;
	float _position;
	gboolean _running;
	gboolean _active;
	gboolean _needs_attention;
	gboolean _activating;
	float _rotation;
	gboolean _enable_close_state;
	UnityLauncherScrollerChildGroupType _group_type;
	gboolean _is_dragging_state;
	UnityThemeImage* close_symbol;
	UnityThemeImage* active_indicator;
	UnityThemeImage* running_indicator_notify;
	UnityThemeImage* running_indicator;
	GdkPixbuf* honeycomb_mask;
	CtkEffectDropShadow* effect_drop_shadow;
	CtkEffectGlow* effect_icon_glow;
	ClutterAnimation* active_indicator_anim;
	ClutterAnimation* running_indicator_anim;
	ClutterTimeline* wiggle_timeline;
	ClutterTimeline* glow_timeline;
	UnityLauncherAnimState glow_state;
	UnityLauncherAnimState wiggle_state;
	guint num_wiggles;
	float old_rotate_value;
	gboolean previous_close_state;
	float previous_glow_alpha;
	float previous_wiggle_alpha;
};


static gpointer unity_launcher_scroller_child_parent_class = NULL;

#define UNITY_LAUNCHER_HONEYCOMB_MASK_FILE PKGDATADIR "/honeycomb-mask.png"
#define UNITY_LAUNCHER_MENU_BG_FILE PKGDATADIR "/tight_check_4px.png"
#define UNITY_LAUNCHER_WIGGLE_SIZE ((float) 15)
#define UNITY_LAUNCHER_WIGGLE_FREQUENCY 4
#define UNITY_LAUNCHER_WIGGLE_RUN_LENGTH 1000
#define UNITY_LAUNCHER_WIGGLE_PAUSE_LENGTH 5
GType unity_launcher_anim_state_get_type (void) G_GNUC_CONST;
GType unity_launcher_pin_type_get_type (void) G_GNUC_CONST;
GType unity_launcher_scroller_child_get_type (void) G_GNUC_CONST;
GType unity_launcher_scroller_child_controller_get_type (void) G_GNUC_CONST;
GType unity_launcher_scroller_child_group_type_get_type (void) G_GNUC_CONST;
#define UNITY_LAUNCHER_SCROLLER_CHILD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, UnityLauncherScrollerChildPrivate))
enum  {
	UNITY_LAUNCHER_SCROLLER_CHILD_DUMMY_PROPERTY,
	UNITY_LAUNCHER_SCROLLER_CHILD_ICON,
	UNITY_LAUNCHER_SCROLLER_CHILD_POSITION,
	UNITY_LAUNCHER_SCROLLER_CHILD_RUNNING,
	UNITY_LAUNCHER_SCROLLER_CHILD_ACTIVE,
	UNITY_LAUNCHER_SCROLLER_CHILD_NEEDS_ATTENTION,
	UNITY_LAUNCHER_SCROLLER_CHILD_ACTIVATING,
	UNITY_LAUNCHER_SCROLLER_CHILD_ROTATION,
	UNITY_LAUNCHER_SCROLLER_CHILD_ENABLE_CLOSE_STATE,
	UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE,
	UNITY_LAUNCHER_SCROLLER_CHILD_IS_DRAGGING_STATE
};
char* unity_launcher_scroller_child_to_string (UnityLauncherScrollerChild* self);
gboolean unity_launcher_scroller_child_get_running (UnityLauncherScrollerChild* self);
gboolean unity_launcher_scroller_child_get_active (UnityLauncherScrollerChild* self);
float unity_launcher_scroller_child_get_position (UnityLauncherScrollerChild* self);
UnityLauncherScrollerChild* unity_launcher_scroller_child_new (void);
UnityLauncherScrollerChild* unity_launcher_scroller_child_construct (GType object_type);
static void unity_launcher_scroller_child_load_textures (UnityLauncherScrollerChild* self);
static void unity_launcher_scroller_child_on_icon_changed (UnityLauncherScrollerChild* self);
static void _unity_launcher_scroller_child_on_icon_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_launcher_scroller_child_on_running_changed (UnityLauncherScrollerChild* self);
static void _unity_launcher_scroller_child_on_running_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_launcher_scroller_child_on_active_changed (UnityLauncherScrollerChild* self);
static void _unity_launcher_scroller_child_on_active_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_launcher_scroller_child_on_activating_changed (UnityLauncherScrollerChild* self);
static void _unity_launcher_scroller_child_on_activating_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_launcher_scroller_child_on_needs_attention_changed (UnityLauncherScrollerChild* self);
static void _unity_launcher_scroller_child_on_needs_attention_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_launcher_scroller_child_on_dragging_state_changed (UnityLauncherScrollerChild* self);
static void _unity_launcher_scroller_child_on_dragging_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_launcher_scroller_child_on_drag_drop (UnityLauncherScrollerChild* self, UnityDragModel* model, float x, float y);
static void _unity_launcher_scroller_child_on_drag_drop_unity_drag_controller_drag_drop (UnityDragController* _sender, UnityDragModel* model, float x, float y, gpointer self);
static void unity_launcher_scroller_child_on_enable_close_state_changed (UnityLauncherScrollerChild* self);
static void _unity_launcher_scroller_child_on_enable_close_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_launcher_scroller_child_on_rotation_changed (UnityLauncherScrollerChild* self);
ClutterActor* unity_launcher_scroller_child_get_content (UnityLauncherScrollerChild* self);
void unity_launcher_scroller_child_set_is_dragging_state (UnityLauncherScrollerChild* self, gboolean value);
gboolean unity_launcher_scroller_child_get_is_dragging_state (UnityLauncherScrollerChild* self);
#define UNITY_LAUNCHER_SHORT_DELAY ((guint) 400)
gboolean unity_launcher_scroller_child_get_enable_close_state (UnityLauncherScrollerChild* self);
static float unity_launcher_scroller_child_get_ease_out_sine (float alpha);
static float unity_launcher_scroller_child_get_circular_alpha (float alpha);
void unity_launcher_scroller_child_force_rotation_jump (UnityLauncherScrollerChild* self, float degrees);
void unity_launcher_scroller_child_set_rotation (UnityLauncherScrollerChild* self, float value);
static void unity_launcher_scroller_child_on_glow_timeline_new_frame (UnityLauncherScrollerChild* self);
static void unity_launcher_scroller_child_glow_anim_rising (UnityLauncherScrollerChild* self, float progress);
static void unity_launcher_scroller_child_glow_anim_looping (UnityLauncherScrollerChild* self, float progress);
static void unity_launcher_scroller_child_glow_anim_falling (UnityLauncherScrollerChild* self, float progress);
#define UNITY_LAUNCHER_LONG_DELAY ((guint) 1600)
static void unity_launcher_scroller_child_on_wiggle_timeline_new_frame (UnityLauncherScrollerChild* self);
static void unity_launcher_scroller_child_wiggle_anim_rising (UnityLauncherScrollerChild* self, float progress);
static void unity_launcher_scroller_child_wiggle_anim_looping (UnityLauncherScrollerChild* self, float progress);
static void unity_launcher_scroller_child_wiggle_anim_falling (UnityLauncherScrollerChild* self, float progress);
static gboolean unity_launcher_scroller_child_check_continue_wiggle (UnityLauncherScrollerChild* self);
gboolean unity_launcher_scroller_child_get_needs_attention (UnityLauncherScrollerChild* self);
static gboolean _unity_launcher_scroller_child_check_continue_wiggle_gsource_func (gpointer self);
GdkPixbuf* unity_launcher_scroller_child_get_icon (UnityLauncherScrollerChild* self);
float unity_launcher_scroller_child_get_rotation (UnityLauncherScrollerChild* self);
gboolean unity_launcher_scroller_child_get_activating (UnityLauncherScrollerChild* self);
void unity_launcher_scroller_child_set_activating (UnityLauncherScrollerChild* self, gboolean value);
static void unity_launcher_scroller_child_real_get_preferred_width (ClutterActor* base, float for_height, float* minimum_width, float* natural_width);
static void unity_launcher_scroller_child_real_get_preferred_height (ClutterActor* base, float for_width, float* minimum_height, float* natural_height);
static void unity_launcher_scroller_child_real_allocate (ClutterActor* base, const ClutterActorBox* box, ClutterAllocationFlags flags);
static void unity_launcher_scroller_child_real_pick (ClutterActor* base, const ClutterColor* color);
static void unity_launcher_scroller_child_real_paint (ClutterActor* base);
static void unity_launcher_scroller_child_real_map (ClutterActor* base);
static void unity_launcher_scroller_child_real_unmap (ClutterActor* base);
void unity_launcher_scroller_child_set_icon (UnityLauncherScrollerChild* self, GdkPixbuf* value);
void unity_launcher_scroller_child_set_position (UnityLauncherScrollerChild* self, float value);
void unity_launcher_scroller_child_set_running (UnityLauncherScrollerChild* self, gboolean value);
void unity_launcher_scroller_child_set_active (UnityLauncherScrollerChild* self, gboolean value);
void unity_launcher_scroller_child_set_needs_attention (UnityLauncherScrollerChild* self, gboolean value);
void unity_launcher_scroller_child_set_enable_close_state (UnityLauncherScrollerChild* self, gboolean value);
UnityLauncherScrollerChildGroupType unity_launcher_scroller_child_get_group_type (UnityLauncherScrollerChild* self);
void unity_launcher_scroller_child_set_group_type (UnityLauncherScrollerChild* self, UnityLauncherScrollerChildGroupType value);
static void _unity_launcher_scroller_child_on_glow_timeline_new_frame_clutter_timeline_new_frame (ClutterTimeline* _sender, gint msecs, gpointer self);
static void _unity_launcher_scroller_child_on_wiggle_timeline_new_frame_clutter_timeline_new_frame (ClutterTimeline* _sender, gint msecs, gpointer self);
static void _unity_launcher_scroller_child_on_rotation_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static GObject * unity_launcher_scroller_child_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_launcher_scroller_child_finalize (GObject* obj);
static void unity_launcher_scroller_child_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_launcher_scroller_child_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



GType unity_launcher_anim_state_get_type (void) {
	static volatile gsize unity_launcher_anim_state_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_anim_state_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_LAUNCHER_ANIM_STATE_RISING, "UNITY_LAUNCHER_ANIM_STATE_RISING", "rising"}, {UNITY_LAUNCHER_ANIM_STATE_LOOPING, "UNITY_LAUNCHER_ANIM_STATE_LOOPING", "looping"}, {UNITY_LAUNCHER_ANIM_STATE_FALLING, "UNITY_LAUNCHER_ANIM_STATE_FALLING", "falling"}, {UNITY_LAUNCHER_ANIM_STATE_STOPPED, "UNITY_LAUNCHER_ANIM_STATE_STOPPED", "stopped"}, {0, NULL, NULL}};
		GType unity_launcher_anim_state_type_id;
		unity_launcher_anim_state_type_id = g_enum_register_static ("UnityLauncherAnimState", values);
		g_once_init_leave (&unity_launcher_anim_state_type_id__volatile, unity_launcher_anim_state_type_id);
	}
	return unity_launcher_anim_state_type_id__volatile;
}


GType unity_launcher_pin_type_get_type (void) {
	static volatile gsize unity_launcher_pin_type_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_pin_type_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_LAUNCHER_PIN_TYPE_UNPINNED, "UNITY_LAUNCHER_PIN_TYPE_UNPINNED", "unpinned"}, {UNITY_LAUNCHER_PIN_TYPE_PINNED, "UNITY_LAUNCHER_PIN_TYPE_PINNED", "pinned"}, {UNITY_LAUNCHER_PIN_TYPE_ALWAYS, "UNITY_LAUNCHER_PIN_TYPE_ALWAYS", "always"}, {UNITY_LAUNCHER_PIN_TYPE_NEVER, "UNITY_LAUNCHER_PIN_TYPE_NEVER", "never"}, {0, NULL, NULL}};
		GType unity_launcher_pin_type_type_id;
		unity_launcher_pin_type_type_id = g_enum_register_static ("UnityLauncherPinType", values);
		g_once_init_leave (&unity_launcher_pin_type_type_id__volatile, unity_launcher_pin_type_type_id);
	}
	return unity_launcher_pin_type_type_id__volatile;
}


GType unity_launcher_scroller_child_group_type_get_type (void) {
	static volatile gsize unity_launcher_scroller_child_group_type_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_scroller_child_group_type_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_APPLICATION, "UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_APPLICATION", "application"}, {UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_PLACE, "UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_PLACE", "place"}, {UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_DEVICE, "UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_DEVICE", "device"}, {UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_SYSTEM, "UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_SYSTEM", "system"}, {0, NULL, NULL}};
		GType unity_launcher_scroller_child_group_type_type_id;
		unity_launcher_scroller_child_group_type_type_id = g_enum_register_static ("UnityLauncherScrollerChildGroupType", values);
		g_once_init_leave (&unity_launcher_scroller_child_group_type_type_id__volatile, unity_launcher_scroller_child_group_type_type_id);
	}
	return unity_launcher_scroller_child_group_type_type_id__volatile;
}


char* unity_launcher_scroller_child_to_string (UnityLauncherScrollerChild* self) {
	char* result = NULL;
	const char* _tmp0_;
	const char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	if (self->priv->_running) {
		_tmp0_ = "yes";
	} else {
		_tmp0_ = "no";
	}
	_tmp1_ = NULL;
	if (self->priv->_active) {
		_tmp1_ = "yes";
	} else {
		_tmp1_ = "no";
	}
	result = g_strdup_printf ("A scroller child; running: %s, active: %s, position: %f, opacity %f", _tmp0_, _tmp1_, (double) self->priv->_position, (double) clutter_actor_get_opacity ((ClutterActor*) self));
	return result;
}


UnityLauncherScrollerChild* unity_launcher_scroller_child_construct (GType object_type) {
	UnityLauncherScrollerChild * self;
	self = (UnityLauncherScrollerChild*) g_object_new (object_type, "group-type", UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE_APPLICATION, NULL);
	return self;
}


UnityLauncherScrollerChild* unity_launcher_scroller_child_new (void) {
	return unity_launcher_scroller_child_construct (UNITY_LAUNCHER_TYPE_SCROLLER_CHILD);
}


static void _unity_launcher_scroller_child_on_icon_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_launcher_scroller_child_on_icon_changed (self);
}


static void _unity_launcher_scroller_child_on_running_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_launcher_scroller_child_on_running_changed (self);
}


static void _unity_launcher_scroller_child_on_active_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_launcher_scroller_child_on_active_changed (self);
}


static void _unity_launcher_scroller_child_on_activating_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_launcher_scroller_child_on_activating_changed (self);
}


static void _unity_launcher_scroller_child_on_needs_attention_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_launcher_scroller_child_on_needs_attention_changed (self);
}


static void _unity_launcher_scroller_child_on_dragging_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_launcher_scroller_child_on_dragging_state_changed (self);
}


static void _unity_launcher_scroller_child_on_drag_drop_unity_drag_controller_drag_drop (UnityDragController* _sender, UnityDragModel* model, float x, float y, gpointer self) {
	unity_launcher_scroller_child_on_drag_drop (self, model, x, y);
}


static void _unity_launcher_scroller_child_on_enable_close_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_launcher_scroller_child_on_enable_close_state_changed (self);
}


static void unity_launcher_scroller_child_load_textures (UnityLauncherScrollerChild* self) {
	UnityThemeImage* _tmp0_;
	UnityThemeImage* _tmp1_;
	UnityThemeImage* _tmp2_;
	UnityThemeImage* _tmp3_;
	UnityUnityIcon* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->active_indicator = (_tmp0_ = g_object_ref_sink (unity_theme_image_new ("application-selected")), _g_object_unref0 (self->priv->active_indicator), _tmp0_);
	self->priv->running_indicator = (_tmp1_ = g_object_ref_sink (unity_theme_image_new ("application-running")), _g_object_unref0 (self->priv->running_indicator), _tmp1_);
	self->priv->running_indicator_notify = (_tmp2_ = g_object_ref_sink (unity_theme_image_new ("application-running-notify")), _g_object_unref0 (self->priv->running_indicator_notify), _tmp2_);
	self->priv->close_symbol = (_tmp3_ = g_object_ref_sink (unity_theme_image_new ("close_symbol")), _g_object_unref0 (self->priv->close_symbol), _tmp3_);
	clutter_actor_set_parent ((ClutterActor*) self->priv->active_indicator, (ClutterActor*) self);
	clutter_actor_set_parent ((ClutterActor*) self->priv->running_indicator_notify, (ClutterActor*) self);
	clutter_actor_set_parent ((ClutterActor*) self->priv->running_indicator, (ClutterActor*) self);
	clutter_actor_set_parent ((ClutterActor*) self->priv->close_symbol, (ClutterActor*) self);
	clutter_actor_set_opacity ((ClutterActor*) self->priv->active_indicator, (guint8) 0);
	clutter_actor_set_opacity ((ClutterActor*) self->priv->running_indicator_notify, (guint8) 0);
	clutter_actor_set_opacity ((ClutterActor*) self->priv->running_indicator, (guint8) 0);
	clutter_actor_set_opacity ((ClutterActor*) self->priv->close_symbol, (guint8) 0);
	g_object_set ((ClutterActor*) self->priv->close_symbol, "scale-gravity", CLUTTER_GRAVITY_CENTER, NULL);
	g_object_set ((ClutterActor*) self->priv->close_symbol, "scale-x", 0.0, NULL);
	g_object_set ((ClutterActor*) self->priv->close_symbol, "scale-y", 0.0, NULL);
	{
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		_tmp4_ = gdk_pixbuf_new_from_file (UNITY_LAUNCHER_HONEYCOMB_MASK_FILE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch53_g_error;
		}
		self->priv->honeycomb_mask = (_tmp5_ = _tmp4_, _g_object_unref0 (self->priv->honeycomb_mask), _tmp5_);
	}
	goto __finally53;
	__catch53_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("scrollerchild.vala:166: Unable to load asset %s: %s", UNITY_LAUNCHER_HONEYCOMB_MASK_FILE, e->message);
			_g_error_free0 (e);
		}
	}
	__finally53:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->processed_icon = (_tmp6_ = g_object_ref_sink (unity_unity_icon_new (NULL, NULL)), _g_object_unref0 (self->processed_icon), _tmp6_);
	clutter_actor_set_size ((ClutterActor*) self->processed_icon, (float) 48, (float) 48);
	clutter_actor_set_parent ((ClutterActor*) self->processed_icon, (ClutterActor*) self);
	g_signal_connect_object ((GObject*) self, "notify::icon", (GCallback) _unity_launcher_scroller_child_on_icon_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::running", (GCallback) _unity_launcher_scroller_child_on_running_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::active", (GCallback) _unity_launcher_scroller_child_on_active_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::activating", (GCallback) _unity_launcher_scroller_child_on_activating_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::needs-attention", (GCallback) _unity_launcher_scroller_child_on_needs_attention_changed_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::is-dragging-state", (GCallback) _unity_launcher_scroller_child_on_dragging_state_changed_g_object_notify, self, 0);
	g_signal_connect_object (unity_drag_controller_get_default (), "drag-drop", (GCallback) _unity_launcher_scroller_child_on_drag_drop_unity_drag_controller_drag_drop, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::enable-close-state", (GCallback) _unity_launcher_scroller_child_on_enable_close_state_changed_g_object_notify, self, 0);
	unity_launcher_scroller_child_on_running_changed (self);
	unity_launcher_scroller_child_on_active_changed (self);
	unity_launcher_scroller_child_on_rotation_changed (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ClutterActor* unity_launcher_scroller_child_get_content (UnityLauncherScrollerChild* self) {
	ClutterActor* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	unity_launcher_scroller_child_set_is_dragging_state (self, TRUE);
	result = _g_object_ref0 ((ClutterActor*) self);
	return result;
}


static void unity_launcher_scroller_child_on_drag_drop (UnityLauncherScrollerChild* self, UnityDragModel* model, float x, float y) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	if (self->priv->_is_dragging_state) {
		unity_launcher_scroller_child_set_is_dragging_state (self, FALSE);
	}
}


static void unity_launcher_scroller_child_on_dragging_state_changed (UnityLauncherScrollerChild* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->_is_dragging_state) {
		ClutterAnimation* _tmp0_;
		ClutterAnimation* _tmp1_;
		self->priv->running_indicator_anim = (_tmp0_ = _g_object_ref0 (clutter_actor_animate ((ClutterActor*) self->priv->running_indicator, (gulong) CLUTTER_EASE_IN_OUT_SINE, UNITY_LAUNCHER_SHORT_DELAY, "opacity", 0x00, NULL)), _g_object_unref0 (self->priv->running_indicator_anim), _tmp0_);
		self->priv->active_indicator_anim = (_tmp1_ = _g_object_ref0 (clutter_actor_animate ((ClutterActor*) self->priv->active_indicator, (gulong) CLUTTER_EASE_IN_OUT_SINE, UNITY_LAUNCHER_SHORT_DELAY, "opacity", 0x00, NULL)), _g_object_unref0 (self->priv->active_indicator_anim), _tmp1_);
		clutter_actor_animate ((ClutterActor*) self->priv->running_indicator_notify, (gulong) CLUTTER_EASE_IN_QUAD, (guint) 150, "opacity", 0x00, NULL);
	} else {
		unity_launcher_scroller_child_on_running_changed (self);
		unity_launcher_scroller_child_on_active_changed (self);
	}
}


static void unity_launcher_scroller_child_on_enable_close_state_changed (UnityLauncherScrollerChild* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_enable_close_state == TRUE) {
		_tmp0_ = self->priv->previous_close_state == FALSE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		clutter_actor_animate ((ClutterActor*) self->priv->close_symbol, (gulong) CLUTTER_EASE_OUT_CUBIC, (guint) 300, "opacity", 0xff, "scale-x", 1.0, "scale-y", 1.0, NULL);
	} else {
		gboolean _tmp1_ = FALSE;
		if (self->priv->_enable_close_state == FALSE) {
			_tmp1_ = self->priv->previous_close_state == TRUE;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			clutter_actor_animate ((ClutterActor*) self->priv->close_symbol, (gulong) CLUTTER_EASE_OUT_CUBIC, (guint) 300, "opacity", 0x00, "scale-x", 0.0, "scale-y", 0.0, NULL);
		}
	}
	self->priv->previous_close_state = self->priv->_enable_close_state;
}


static float unity_launcher_scroller_child_get_ease_out_sine (float alpha) {
	float result = 0.0F;
	result = (float) sin (G_PI_2 * alpha);
	return result;
}


static float unity_launcher_scroller_child_get_circular_alpha (float alpha) {
	float result = 0.0F;
	double sine;
	sine = sin ((alpha * (G_PI * 2)) - G_PI);
	result = fmaxf ((((float) sine) / 2.0f) + 0.5f, 0.0f);
	return result;
}


void unity_launcher_scroller_child_force_rotation_jump (UnityLauncherScrollerChild* self, float degrees) {
	g_return_if_fail (self != NULL);
	if (self->priv->_is_dragging_state) {
		return;
	}
	if (CLUTTER_IS_ANIMATION (clutter_actor_get_animation ((ClutterActor*) self->processed_icon))) {
		clutter_animation_completed (clutter_actor_get_animation ((ClutterActor*) self->processed_icon));
	}
	unity_unity_icon_set_rotation (self->processed_icon, degrees);
	unity_launcher_scroller_child_set_rotation (self, degrees);
	clutter_actor_queue_redraw ((ClutterActor*) self);
}


static void unity_launcher_scroller_child_on_glow_timeline_new_frame (UnityLauncherScrollerChild* self) {
	float progress;
	g_return_if_fail (self != NULL);
	progress = (float) clutter_timeline_get_progress (self->priv->glow_timeline);
	switch (self->priv->glow_state) {
		case UNITY_LAUNCHER_ANIM_STATE_RISING:
		{
			unity_launcher_scroller_child_glow_anim_rising (self, progress);
			break;
		}
		case UNITY_LAUNCHER_ANIM_STATE_LOOPING:
		{
			unity_launcher_scroller_child_glow_anim_looping (self, progress);
			break;
		}
		case UNITY_LAUNCHER_ANIM_STATE_FALLING:
		{
			unity_launcher_scroller_child_glow_anim_falling (self, progress);
			break;
		}
		default:
		{
			self->priv->glow_state = UNITY_LAUNCHER_ANIM_STATE_STOPPED;
			clutter_timeline_stop (self->priv->glow_timeline);
			break;
		}
	}
	clutter_actor_queue_redraw ((ClutterActor*) self->processed_icon);
}


static void unity_launcher_scroller_child_glow_anim_rising (UnityLauncherScrollerChild* self, float progress) {
	g_return_if_fail (self != NULL);
	progress = unity_launcher_scroller_child_get_ease_out_sine (progress);
	ctk_effect_set_opacity ((CtkEffect*) self->priv->effect_icon_glow, progress);
	self->priv->previous_glow_alpha = progress;
	if (progress >= 1.0) {
		self->priv->glow_state = UNITY_LAUNCHER_ANIM_STATE_LOOPING;
		clutter_timeline_stop (self->priv->glow_timeline);
		clutter_timeline_set_duration (self->priv->glow_timeline, UNITY_LAUNCHER_LONG_DELAY);
		clutter_timeline_set_loop (self->priv->glow_timeline, TRUE);
		clutter_timeline_start (self->priv->glow_timeline);
		return;
	}
}


static void unity_launcher_scroller_child_glow_anim_looping (UnityLauncherScrollerChild* self, float progress) {
	g_return_if_fail (self != NULL);
	progress = 1.0f - unity_launcher_scroller_child_get_circular_alpha (progress);
	ctk_effect_set_opacity ((CtkEffect*) self->priv->effect_icon_glow, progress);
	self->priv->previous_glow_alpha = progress;
	clutter_actor_queue_redraw ((ClutterActor*) self->processed_icon);
}


static void unity_launcher_scroller_child_glow_anim_falling (UnityLauncherScrollerChild* self, float progress) {
	float alpha_length;
	g_return_if_fail (self != NULL);
	alpha_length = self->priv->previous_glow_alpha;
	ctk_effect_set_opacity ((CtkEffect*) self->priv->effect_icon_glow, alpha_length - (progress * alpha_length));
	if (progress >= 1.0) {
		self->priv->glow_state = UNITY_LAUNCHER_ANIM_STATE_STOPPED;
		clutter_timeline_stop (self->priv->glow_timeline);
		clutter_timeline_set_loop (self->priv->glow_timeline, FALSE);
	}
}


static void unity_launcher_scroller_child_on_wiggle_timeline_new_frame (UnityLauncherScrollerChild* self) {
	float progress;
	g_return_if_fail (self != NULL);
	progress = (float) clutter_timeline_get_progress (self->priv->wiggle_timeline);
	switch (self->priv->wiggle_state) {
		case UNITY_LAUNCHER_ANIM_STATE_RISING:
		{
			unity_launcher_scroller_child_wiggle_anim_rising (self, progress);
			break;
		}
		case UNITY_LAUNCHER_ANIM_STATE_LOOPING:
		{
			unity_launcher_scroller_child_wiggle_anim_looping (self, progress);
			break;
		}
		case UNITY_LAUNCHER_ANIM_STATE_FALLING:
		{
			unity_launcher_scroller_child_wiggle_anim_falling (self, progress);
			break;
		}
		default:
		{
			self->priv->wiggle_state = UNITY_LAUNCHER_ANIM_STATE_STOPPED;
			clutter_timeline_stop (self->priv->wiggle_timeline);
			break;
		}
	}
	clutter_actor_queue_redraw ((ClutterActor*) self->processed_icon);
}


static void unity_launcher_scroller_child_wiggle_anim_rising (UnityLauncherScrollerChild* self, float progress) {
	g_return_if_fail (self != NULL);
	progress = unity_launcher_scroller_child_get_ease_out_sine (progress);
	clutter_actor_set_rotation ((ClutterActor*) self->processed_icon, CLUTTER_Z_AXIS, (double) (progress * UNITY_LAUNCHER_WIGGLE_SIZE), 25.0f, 25.0f, 0.0f);
	self->priv->previous_wiggle_alpha = progress;
	if (progress >= 1.0) {
		self->priv->wiggle_state = UNITY_LAUNCHER_ANIM_STATE_LOOPING;
		clutter_timeline_stop (self->priv->wiggle_timeline);
		clutter_timeline_set_duration (self->priv->wiggle_timeline, (guint) UNITY_LAUNCHER_WIGGLE_RUN_LENGTH);
		clutter_timeline_set_loop (self->priv->wiggle_timeline, TRUE);
		clutter_timeline_start (self->priv->wiggle_timeline);
		return;
	}
}


static void unity_launcher_scroller_child_wiggle_anim_looping (UnityLauncherScrollerChild* self, float progress) {
	gint frequency;
	g_return_if_fail (self != NULL);
	if (progress >= 1.0) {
		self->priv->wiggle_state = UNITY_LAUNCHER_ANIM_STATE_FALLING;
		clutter_timeline_stop (self->priv->wiggle_timeline);
		clutter_timeline_set_loop (self->priv->wiggle_timeline, FALSE);
		clutter_timeline_start (self->priv->wiggle_timeline);
	}
	frequency = UNITY_LAUNCHER_WIGGLE_FREQUENCY * (UNITY_LAUNCHER_WIGGLE_RUN_LENGTH / 1000);
	progress = unity_launcher_scroller_child_get_circular_alpha (fmodf (progress * frequency, 1.0f));
	progress = ((1.0f - progress) * 2.0f) - 1.0f;
	clutter_actor_set_rotation ((ClutterActor*) self->processed_icon, CLUTTER_Z_AXIS, (double) (progress * UNITY_LAUNCHER_WIGGLE_SIZE), 25.0f, 25.0f, 0.0f);
	clutter_actor_queue_redraw ((ClutterActor*) self->processed_icon);
	self->priv->previous_wiggle_alpha = progress;
}


static gboolean unity_launcher_scroller_child_check_continue_wiggle (UnityLauncherScrollerChild* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_needs_attention) {
		_tmp0_ = self->priv->num_wiggles > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->num_wiggles = self->priv->num_wiggles - ((guint) 1);
		clutter_timeline_set_duration (self->priv->wiggle_timeline, (guint) (500 / UNITY_LAUNCHER_WIGGLE_FREQUENCY));
		self->priv->wiggle_state = UNITY_LAUNCHER_ANIM_STATE_RISING;
		clutter_timeline_start (self->priv->wiggle_timeline);
	}
	result = FALSE;
	return result;
}


static gboolean _unity_launcher_scroller_child_check_continue_wiggle_gsource_func (gpointer self) {
	gboolean result;
	result = unity_launcher_scroller_child_check_continue_wiggle (self);
	return result;
}


static void unity_launcher_scroller_child_wiggle_anim_falling (UnityLauncherScrollerChild* self, float progress) {
	float alpha_length;
	float angle;
	g_return_if_fail (self != NULL);
	alpha_length = self->priv->previous_wiggle_alpha;
	angle = alpha_length - (progress * alpha_length);
	clutter_actor_set_rotation ((ClutterActor*) self->processed_icon, CLUTTER_Z_AXIS, (double) angle, 25.0f, 25.0f, 0.0f);
	if (progress >= 1.0) {
		self->priv->wiggle_state = UNITY_LAUNCHER_ANIM_STATE_STOPPED;
		clutter_timeline_stop (self->priv->wiggle_timeline);
		clutter_timeline_set_loop (self->priv->wiggle_timeline, FALSE);
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) UNITY_LAUNCHER_WIGGLE_PAUSE_LENGTH, _unity_launcher_scroller_child_check_continue_wiggle_gsource_func, g_object_ref (self), g_object_unref);
	}
}


static void unity_launcher_scroller_child_on_icon_changed (UnityLauncherScrollerChild* self) {
	g_return_if_fail (self != NULL);
	if (GDK_IS_PIXBUF (self->priv->_icon)) {
		GdkPixbuf* scaled_buf;
		gint max_size;
		gboolean _tmp0_ = FALSE;
		GdkPixbuf* color_buf;
		guint red = 0U;
		guint green = 0U;
		guint blue = 0U;
		gint pixels_length1;
		gint _pixels_size_;
		guchar* _tmp3_;
		guchar* pixels;
		ClutterActor* tex;
		ClutterActor* color;
		ClutterActor* _tmp4_;
		ClutterActor* _tmp5_;
		UnityUnityIcon* _tmp6_;
		CtkEffectDropShadow* _tmp7_;
		scaled_buf = NULL;
		max_size = 48;
		if (!unity_pixbuf_is_tile (self->priv->_icon)) {
			max_size = 32;
		}
		if (gdk_pixbuf_get_width (self->priv->_icon) > max_size) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = gdk_pixbuf_get_height (self->priv->_icon) > max_size;
		}
		if (_tmp0_) {
			GdkPixbuf* _tmp1_;
			scaled_buf = (_tmp1_ = gdk_pixbuf_scale_simple (self->priv->_icon, max_size, max_size, GDK_INTERP_HYPER), _g_object_unref0 (scaled_buf), _tmp1_);
		} else {
			GdkPixbuf* _tmp2_;
			scaled_buf = (_tmp2_ = _g_object_ref0 (self->priv->_icon), _g_object_unref0 (scaled_buf), _tmp2_);
		}
		color_buf = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, 1, 1);
		unity_get_average_color (scaled_buf, &red, &green, &blue);
		pixels = (_tmp3_ = gdk_pixbuf_get_pixels (color_buf), pixels_length1 = -1, _pixels_size_ = pixels_length1, _tmp3_);
		pixels[0] = (guchar) red;
		pixels[1] = (guchar) green;
		pixels[2] = (guchar) blue;
		pixels[3] = (guchar) 255;
		tex = _g_object_ref0 (gtk_clutter_texture_new_from_pixbuf (scaled_buf));
		color = _g_object_ref0 (gtk_clutter_texture_new_from_pixbuf (color_buf));
		self->processed_icon = (_tmp6_ = g_object_ref_sink (unity_unity_icon_new ((_tmp4_ = tex, CLUTTER_IS_TEXTURE (_tmp4_) ? ((ClutterTexture*) _tmp4_) : NULL), (_tmp5_ = color, CLUTTER_IS_TEXTURE (_tmp5_) ? ((ClutterTexture*) _tmp5_) : NULL))), _g_object_unref0 (self->processed_icon), _tmp6_);
		clutter_actor_set_parent ((ClutterActor*) self->processed_icon, (ClutterActor*) self);
		unity_unity_icon_set_rotation (self->processed_icon, self->priv->_rotation);
		self->priv->effect_drop_shadow = (_tmp7_ = g_object_ref_sink (ctk_effect_drop_shadow_new (5.0f, 0, 2)), _g_object_unref0 (self->priv->effect_drop_shadow), _tmp7_);
		ctk_effect_set_opacity ((CtkEffect*) self->priv->effect_drop_shadow, 0.4f);
		ctk_effect_set_margin ((CtkEffect*) self->priv->effect_drop_shadow, 5);
		ctk_actor_add_effect ((CtkActor*) self->processed_icon, (CtkEffect*) self->priv->effect_drop_shadow);
		clutter_actor_set_scale ((ClutterActor*) self->processed_icon, (double) 0.0f, (double) 0.0f);
		g_object_set ((ClutterActor*) self->processed_icon, "scale-gravity", CLUTTER_GRAVITY_CENTER, NULL);
		clutter_actor_animate ((ClutterActor*) self->processed_icon, (gulong) CLUTTER_EASE_OUT_CUBIC, (guint) 300, "scale-x", 1.0, "scale-y", 1.0, NULL);
		clutter_actor_queue_redraw ((ClutterActor*) self);
		_g_object_unref0 (color);
		_g_object_unref0 (tex);
		_g_object_unref0 (color_buf);
		_g_object_unref0 (scaled_buf);
	}
}


static void unity_launcher_scroller_child_on_running_changed (UnityLauncherScrollerChild* self) {
	guint target_opacity;
	ClutterAnimation* _tmp0_;
	g_return_if_fail (self != NULL);
	target_opacity = (guint) 0;
	if (self->priv->_running) {
		target_opacity = (guint) 255;
	}
	if (CLUTTER_IS_ANIMATION (self->priv->running_indicator_anim)) {
		clutter_animation_completed (self->priv->running_indicator_anim);
	}
	self->priv->running_indicator_anim = (_tmp0_ = _g_object_ref0 (clutter_actor_animate ((ClutterActor*) self->priv->running_indicator, (gulong) CLUTTER_EASE_IN_OUT_SINE, UNITY_LAUNCHER_SHORT_DELAY, "opacity", target_opacity, NULL)), _g_object_unref0 (self->priv->running_indicator_anim), _tmp0_);
}


static void unity_launcher_scroller_child_on_active_changed (UnityLauncherScrollerChild* self) {
	guint target_opacity;
	gboolean _tmp0_ = FALSE;
	ClutterAnimation* _tmp1_;
	g_return_if_fail (self != NULL);
	target_opacity = (guint) 0;
	if (self->priv->_active) {
		target_opacity = (guint) 255;
	}
	if (self->priv->_active) {
		_tmp0_ = self->priv->_running;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		clutter_actor_animate ((ClutterActor*) self->priv->running_indicator_notify, (gulong) CLUTTER_EASE_IN_QUAD, (guint) 150, "opacity", 0x00, NULL);
		clutter_actor_animate ((ClutterActor*) self->priv->running_indicator, (gulong) CLUTTER_EASE_IN_QUAD, (guint) 150, "opacity", 0xff, NULL);
	}
	if (CLUTTER_IS_ANIMATION (self->priv->active_indicator_anim)) {
		clutter_animation_completed (self->priv->active_indicator_anim);
	}
	self->priv->active_indicator_anim = (_tmp1_ = _g_object_ref0 (clutter_actor_animate ((ClutterActor*) self->priv->active_indicator, (gulong) CLUTTER_EASE_IN_OUT_SINE, UNITY_LAUNCHER_SHORT_DELAY, "opacity", target_opacity, NULL)), _g_object_unref0 (self->priv->active_indicator_anim), _tmp1_);
}


static void unity_launcher_scroller_child_on_rotation_changed (UnityLauncherScrollerChild* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_is_dragging_state) {
		return;
	}
	self->priv->old_rotate_value = unity_unity_icon_get_rotation (self->processed_icon);
	if (CLUTTER_IS_ANIMATION (clutter_actor_get_animation ((ClutterActor*) self->processed_icon))) {
		clutter_animation_completed (clutter_actor_get_animation ((ClutterActor*) self->processed_icon));
	}
	unity_unity_icon_set_rotation (self->processed_icon, self->priv->old_rotate_value);
	if (self->priv->_rotation <= 1.0) {
		_tmp0_ = self->priv->_rotation >= 0.0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		clutter_actor_animate ((ClutterActor*) self->processed_icon, (gulong) CLUTTER_EASE_IN_OUT_QUAD, (guint) 300, "rotation", self->priv->_rotation, NULL);
	} else {
		clutter_actor_animate ((ClutterActor*) self->processed_icon, (gulong) CLUTTER_EASE_OUT_QUINT, (guint) 300, "rotation", self->priv->_rotation, NULL);
		if (self->priv->_activating) {
			g_debug ("scrollerchild.vala:536: stopping glow ");
			unity_launcher_scroller_child_set_activating (self, FALSE);
		}
	}
}


static void unity_launcher_scroller_child_on_activating_changed (UnityLauncherScrollerChild* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (clutter_timeline_is_playing (self->priv->glow_timeline)) {
		_tmp0_ = self->priv->_activating == FALSE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		clutter_timeline_stop (self->priv->glow_timeline);
		clutter_timeline_set_duration (self->priv->glow_timeline, UNITY_LAUNCHER_SHORT_DELAY);
		self->priv->glow_state = UNITY_LAUNCHER_ANIM_STATE_FALLING;
		clutter_timeline_start (self->priv->glow_timeline);
	} else {
		gboolean _tmp1_ = FALSE;
		if (clutter_timeline_is_playing (self->priv->glow_timeline) == FALSE) {
			_tmp1_ = self->priv->_activating;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			CtkEffectGlow* _tmp2_;
			ClutterColor _tmp3_ = {0};
			ClutterColor c;
			self->priv->effect_icon_glow = (_tmp2_ = g_object_ref_sink ((CtkEffectGlow*) ctk_effect_glow_new ()), _g_object_unref0 (self->priv->effect_icon_glow), _tmp2_);
			c = (memset (&_tmp3_, 0, sizeof (ClutterColor)), _tmp3_.red = (guint8) 255, _tmp3_.green = (guint8) 255, _tmp3_.blue = (guint8) 255, _tmp3_.alpha = (guint8) 255, _tmp3_);
			ctk_effect_glow_set_color (self->priv->effect_icon_glow, &c);
			ctk_effect_set_opacity ((CtkEffect*) self->priv->effect_icon_glow, 1.0f);
			ctk_actor_add_effect ((CtkActor*) self->processed_icon, (CtkEffect*) self->priv->effect_icon_glow);
			ctk_effect_set_margin ((CtkEffect*) self->priv->effect_icon_glow, 6);
			clutter_timeline_set_duration (self->priv->glow_timeline, UNITY_LAUNCHER_SHORT_DELAY);
			self->priv->glow_state = UNITY_LAUNCHER_ANIM_STATE_RISING;
			clutter_timeline_start (self->priv->glow_timeline);
		}
	}
}


static void unity_launcher_scroller_child_on_needs_attention_changed (UnityLauncherScrollerChild* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_needs_attention) {
		_tmp0_ = clutter_timeline_is_playing (self->priv->wiggle_timeline) == FALSE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->priv->num_wiggles = (guint) 2;
		clutter_actor_animate ((ClutterActor*) self->priv->running_indicator_notify, (gulong) CLUTTER_EASE_IN_QUAD, (guint) 150, "opacity", 0xff, NULL);
		clutter_actor_animate ((ClutterActor*) self->priv->running_indicator, (gulong) CLUTTER_EASE_IN_QUAD, (guint) 150, "opacity", 0x00, NULL);
		clutter_timeline_set_duration (self->priv->wiggle_timeline, (guint) (500 / UNITY_LAUNCHER_WIGGLE_FREQUENCY));
		self->priv->wiggle_state = UNITY_LAUNCHER_ANIM_STATE_RISING;
		clutter_timeline_start (self->priv->wiggle_timeline);
	} else {
		gboolean _tmp1_ = FALSE;
		if (self->priv->_needs_attention == FALSE) {
			_tmp1_ = clutter_timeline_is_playing (self->priv->wiggle_timeline);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			clutter_actor_animate ((ClutterActor*) self->priv->running_indicator_notify, (gulong) CLUTTER_EASE_IN_QUAD, (guint) 150, "opacity", 0x00, NULL);
			clutter_actor_animate ((ClutterActor*) self->priv->running_indicator, (gulong) CLUTTER_EASE_IN_QUAD, (guint) 150, "opacity", 0xff, NULL);
			clutter_timeline_stop (self->priv->wiggle_timeline);
			clutter_timeline_set_duration (self->priv->wiggle_timeline, (guint) (500 / UNITY_LAUNCHER_WIGGLE_FREQUENCY));
			self->priv->wiggle_state = UNITY_LAUNCHER_ANIM_STATE_FALLING;
			clutter_timeline_start (self->priv->wiggle_timeline);
		}
	}
}


static void unity_launcher_scroller_child_real_get_preferred_width (ClutterActor* base, float for_height, float* minimum_width, float* natural_width) {
	UnityLauncherScrollerChild * self;
	float nat = 0.0F;
	float min = 0.0F;
	self = (UnityLauncherScrollerChild*) base;
	clutter_actor_get_preferred_width ((ClutterActor*) self->processed_icon, for_height, &min, &nat);
	*natural_width = nat;
	*minimum_width = min;
	clutter_actor_get_preferred_width ((ClutterActor*) self->priv->running_indicator, for_height, &min, &nat);
	*natural_width = (*natural_width) + nat;
	clutter_actor_get_preferred_width ((ClutterActor*) self->priv->active_indicator, for_height, &min, &nat);
	*natural_width = (*natural_width) + nat;
}


static void unity_launcher_scroller_child_real_get_preferred_height (ClutterActor* base, float for_width, float* minimum_height, float* natural_height) {
	UnityLauncherScrollerChild * self;
	self = (UnityLauncherScrollerChild*) base;
	*natural_height = (float) 48;
	*minimum_height = (float) 48;
}


static void unity_launcher_scroller_child_real_allocate (ClutterActor* base, const ClutterActorBox* box, ClutterAllocationFlags flags) {
	UnityLauncherScrollerChild * self;
	float x = 0.0F;
	float y = 0.0F;
	ClutterActorBox child_box = {0};
	float midpoint;
	float width = 0.0F;
	float height = 0.0F;
	float n_width = 0.0F;
	float n_height = 0.0F;
	self = (UnityLauncherScrollerChild*) base;
	x = (float) 0;
	y = (float) 0;
	CLUTTER_ACTOR_CLASS (unity_launcher_scroller_child_parent_class)->allocate ((ClutterActor*) CTK_ACTOR (self), box, flags);
	memset (&child_box, 0, sizeof (ClutterActorBox));
	midpoint = (float) 0;
	clutter_actor_get_preferred_width ((ClutterActor*) self->priv->running_indicator, (float) 58, &n_width, &width);
	clutter_actor_get_preferred_height ((ClutterActor*) self->priv->running_indicator, (float) 58, &n_height, &height);
	midpoint = (self->processed_icon->stored_height - height) / 2.0f;
	if (self->priv->_rotation > 0) {
		midpoint = (clutter_actor_box_get_height (box) - midpoint) - self->processed_icon->stored_ymod;
	}
	child_box.x1 = (float) 0;
	child_box.y1 = midpoint;
	child_box.x2 = child_box.x1 + width;
	child_box.y2 = child_box.y1 + height;
	clutter_actor_allocate ((ClutterActor*) self->priv->running_indicator, &child_box, flags);
	clutter_actor_allocate ((ClutterActor*) self->priv->running_indicator_notify, &child_box, flags);
	x = x + clutter_actor_box_get_width (&child_box);
	clutter_actor_get_preferred_width ((ClutterActor*) self->processed_icon, (float) 48, &width, &n_width);
	clutter_actor_get_preferred_height ((ClutterActor*) self->processed_icon, (float) 48, &height, &n_height);
	child_box.x1 = self->grabbed_push + ((clutter_actor_box_get_width (box) - width) / 2.0f);
	child_box.y1 = (float) 0;
	child_box.x2 = child_box.x1 + 48;
	child_box.y2 = child_box.y1 + height;
	clutter_actor_allocate ((ClutterActor*) self->processed_icon, &child_box, flags);
	clutter_actor_get_preferred_width ((ClutterActor*) self->priv->active_indicator, (float) 48, &n_width, &width);
	clutter_actor_get_preferred_height ((ClutterActor*) self->priv->active_indicator, (float) 48, &n_height, &height);
	midpoint = (self->processed_icon->stored_height - height) / 2.0f;
	if (self->priv->_rotation > 0) {
		midpoint = (clutter_actor_box_get_height (box) - midpoint) - self->processed_icon->stored_ymod;
	}
	child_box.x1 = clutter_actor_box_get_width (box) - width;
	child_box.y1 = midpoint;
	child_box.x2 = child_box.x1 + width;
	child_box.y2 = child_box.y1 + height;
	clutter_actor_allocate ((ClutterActor*) self->priv->active_indicator, &child_box, flags);
	clutter_actor_get_preferred_width ((ClutterActor*) self->priv->close_symbol, (float) 48, &n_width, &width);
	clutter_actor_get_preferred_height ((ClutterActor*) self->priv->close_symbol, (float) 48, &n_height, &height);
	child_box.x1 = (-(width / 2.0f)) + 5;
	child_box.y1 = -(height / 2.0f);
	child_box.x2 = (width / 2.0f) + 5;
	child_box.y2 = height / 2.0f;
	clutter_actor_allocate ((ClutterActor*) self->priv->close_symbol, &child_box, flags);
}


static void unity_launcher_scroller_child_real_pick (ClutterActor* base, const ClutterColor* color) {
	UnityLauncherScrollerChild * self;
	self = (UnityLauncherScrollerChild*) base;
	CLUTTER_ACTOR_CLASS (unity_launcher_scroller_child_parent_class)->pick ((ClutterActor*) CTK_ACTOR (self), color);
}


static void unity_launcher_scroller_child_real_paint (ClutterActor* base) {
	UnityLauncherScrollerChild * self;
	self = (UnityLauncherScrollerChild*) base;
	clutter_actor_paint ((ClutterActor*) self->priv->active_indicator);
	clutter_actor_paint ((ClutterActor*) self->priv->running_indicator_notify);
	clutter_actor_paint ((ClutterActor*) self->priv->running_indicator);
	clutter_actor_paint ((ClutterActor*) self->processed_icon);
	clutter_actor_paint ((ClutterActor*) self->priv->close_symbol);
}


static void unity_launcher_scroller_child_real_map (ClutterActor* base) {
	UnityLauncherScrollerChild * self;
	self = (UnityLauncherScrollerChild*) base;
	CLUTTER_ACTOR_CLASS (unity_launcher_scroller_child_parent_class)->map ((ClutterActor*) CTK_ACTOR (self));
	clutter_actor_map ((ClutterActor*) self->priv->close_symbol);
	clutter_actor_map ((ClutterActor*) self->priv->running_indicator);
	clutter_actor_map ((ClutterActor*) self->priv->active_indicator);
	clutter_actor_map ((ClutterActor*) self->priv->running_indicator_notify);
	clutter_actor_map ((ClutterActor*) self->processed_icon);
}


static void unity_launcher_scroller_child_real_unmap (ClutterActor* base) {
	UnityLauncherScrollerChild * self;
	self = (UnityLauncherScrollerChild*) base;
	CLUTTER_ACTOR_CLASS (unity_launcher_scroller_child_parent_class)->unmap ((ClutterActor*) CTK_ACTOR (self));
	clutter_actor_map ((ClutterActor*) self->priv->close_symbol);
	clutter_actor_unmap ((ClutterActor*) self->priv->running_indicator);
	clutter_actor_unmap ((ClutterActor*) self->priv->active_indicator);
	clutter_actor_unmap ((ClutterActor*) self->priv->running_indicator_notify);
	clutter_actor_unmap ((ClutterActor*) self->processed_icon);
}


GdkPixbuf* unity_launcher_scroller_child_get_icon (UnityLauncherScrollerChild* self) {
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_icon;
	return result;
}


void unity_launcher_scroller_child_set_icon (UnityLauncherScrollerChild* self, GdkPixbuf* value) {
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_icon = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_icon), _tmp0_);
	g_object_notify ((GObject *) self, "icon");
}


float unity_launcher_scroller_child_get_position (UnityLauncherScrollerChild* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_position;
	return result;
}


void unity_launcher_scroller_child_set_position (UnityLauncherScrollerChild* self, float value) {
	g_return_if_fail (self != NULL);
	self->priv->_position = value;
	g_object_notify ((GObject *) self, "position");
}


gboolean unity_launcher_scroller_child_get_running (UnityLauncherScrollerChild* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_running;
	return result;
}


void unity_launcher_scroller_child_set_running (UnityLauncherScrollerChild* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_running = value;
	g_object_notify ((GObject *) self, "running");
}


gboolean unity_launcher_scroller_child_get_active (UnityLauncherScrollerChild* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}


void unity_launcher_scroller_child_set_active (UnityLauncherScrollerChild* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
	g_object_notify ((GObject *) self, "active");
}


gboolean unity_launcher_scroller_child_get_needs_attention (UnityLauncherScrollerChild* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_needs_attention;
	return result;
}


void unity_launcher_scroller_child_set_needs_attention (UnityLauncherScrollerChild* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_needs_attention = value;
	g_object_notify ((GObject *) self, "needs-attention");
}


gboolean unity_launcher_scroller_child_get_activating (UnityLauncherScrollerChild* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_activating;
	return result;
}


void unity_launcher_scroller_child_set_activating (UnityLauncherScrollerChild* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_activating = value;
	g_object_notify ((GObject *) self, "activating");
}


float unity_launcher_scroller_child_get_rotation (UnityLauncherScrollerChild* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_rotation;
	return result;
}


void unity_launcher_scroller_child_set_rotation (UnityLauncherScrollerChild* self, float value) {
	g_return_if_fail (self != NULL);
	self->priv->_rotation = value;
	g_object_notify ((GObject *) self, "rotation");
}


gboolean unity_launcher_scroller_child_get_enable_close_state (UnityLauncherScrollerChild* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enable_close_state;
	return result;
}


void unity_launcher_scroller_child_set_enable_close_state (UnityLauncherScrollerChild* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_enable_close_state = value;
	g_object_notify ((GObject *) self, "enable-close-state");
}


UnityLauncherScrollerChildGroupType unity_launcher_scroller_child_get_group_type (UnityLauncherScrollerChild* self) {
	UnityLauncherScrollerChildGroupType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_group_type;
	return result;
}


void unity_launcher_scroller_child_set_group_type (UnityLauncherScrollerChild* self, UnityLauncherScrollerChildGroupType value) {
	g_return_if_fail (self != NULL);
	self->priv->_group_type = value;
	g_object_notify ((GObject *) self, "group-type");
}


gboolean unity_launcher_scroller_child_get_is_dragging_state (UnityLauncherScrollerChild* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_dragging_state;
	return result;
}


void unity_launcher_scroller_child_set_is_dragging_state (UnityLauncherScrollerChild* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_dragging_state = value;
	g_object_notify ((GObject *) self, "is-dragging-state");
}


static void _unity_launcher_scroller_child_on_glow_timeline_new_frame_clutter_timeline_new_frame (ClutterTimeline* _sender, gint msecs, gpointer self) {
	unity_launcher_scroller_child_on_glow_timeline_new_frame (self);
}


static void _unity_launcher_scroller_child_on_wiggle_timeline_new_frame_clutter_timeline_new_frame (ClutterTimeline* _sender, gint msecs, gpointer self) {
	unity_launcher_scroller_child_on_wiggle_timeline_new_frame (self);
}


static void _unity_launcher_scroller_child_on_rotation_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_launcher_scroller_child_on_rotation_changed (self);
}


static GObject * unity_launcher_scroller_child_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityLauncherScrollerChild * self;
	parent_class = G_OBJECT_CLASS (unity_launcher_scroller_child_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_LAUNCHER_SCROLLER_CHILD (obj);
	{
		ClutterTimeline* _tmp0_;
		ClutterTimeline* _tmp1_;
		unity_launcher_scroller_child_load_textures (self);
		unity_launcher_scroller_child_set_position (self, 0.0f);
		self->priv->glow_timeline = (_tmp0_ = clutter_timeline_new ((guint) 1), _g_object_unref0 (self->priv->glow_timeline), _tmp0_);
		self->priv->wiggle_timeline = (_tmp1_ = clutter_timeline_new ((guint) 1), _g_object_unref0 (self->priv->wiggle_timeline), _tmp1_);
		g_signal_connect_object (self->priv->glow_timeline, "new-frame", (GCallback) _unity_launcher_scroller_child_on_glow_timeline_new_frame_clutter_timeline_new_frame, self, 0);
		g_signal_connect_object (self->priv->wiggle_timeline, "new-frame", (GCallback) _unity_launcher_scroller_child_on_wiggle_timeline_new_frame_clutter_timeline_new_frame, self, 0);
		g_signal_connect_object ((GObject*) self, "notify::rotation", (GCallback) _unity_launcher_scroller_child_on_rotation_changed_g_object_notify, self, 0);
	}
	return obj;
}


static void unity_launcher_scroller_child_class_init (UnityLauncherScrollerChildClass * klass) {
	unity_launcher_scroller_child_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityLauncherScrollerChildPrivate));
	CLUTTER_ACTOR_CLASS (klass)->get_preferred_width = unity_launcher_scroller_child_real_get_preferred_width;
	CLUTTER_ACTOR_CLASS (klass)->get_preferred_height = unity_launcher_scroller_child_real_get_preferred_height;
	CLUTTER_ACTOR_CLASS (klass)->allocate = unity_launcher_scroller_child_real_allocate;
	CLUTTER_ACTOR_CLASS (klass)->pick = unity_launcher_scroller_child_real_pick;
	CLUTTER_ACTOR_CLASS (klass)->paint = unity_launcher_scroller_child_real_paint;
	CLUTTER_ACTOR_CLASS (klass)->map = unity_launcher_scroller_child_real_map;
	CLUTTER_ACTOR_CLASS (klass)->unmap = unity_launcher_scroller_child_real_unmap;
	G_OBJECT_CLASS (klass)->get_property = unity_launcher_scroller_child_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_launcher_scroller_child_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_launcher_scroller_child_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_launcher_scroller_child_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_CHILD_ICON, g_param_spec_object ("icon", "icon", "icon", GDK_TYPE_PIXBUF, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_CHILD_POSITION, g_param_spec_float ("position", "position", "position", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_CHILD_RUNNING, g_param_spec_boolean ("running", "running", "running", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_CHILD_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_CHILD_NEEDS_ATTENTION, g_param_spec_boolean ("needs-attention", "needs-attention", "needs-attention", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_CHILD_ACTIVATING, g_param_spec_boolean ("activating", "activating", "activating", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_CHILD_ROTATION, g_param_spec_float ("rotation", "rotation", "rotation", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_CHILD_ENABLE_CLOSE_STATE, g_param_spec_boolean ("enable-close-state", "enable-close-state", "enable-close-state", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE, g_param_spec_enum ("group-type", "group-type", "group-type", UNITY_LAUNCHER_SCROLLER_CHILD_TYPE_GROUP_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_SCROLLER_CHILD_IS_DRAGGING_STATE, g_param_spec_boolean ("is-dragging-state", "is-dragging-state", "is-dragging-state", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("drag_removed", UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void unity_launcher_scroller_child_instance_init (UnityLauncherScrollerChild * self) {
	self->priv = UNITY_LAUNCHER_SCROLLER_CHILD_GET_PRIVATE (self);
	self->do_not_render = FALSE;
	self->grabbed_push = 0.0f;
	self->priv->num_wiggles = (guint) 0;
	self->priv->old_rotate_value = 0.0f;
	self->priv->previous_close_state = FALSE;
	self->priv->previous_glow_alpha = 0.0f;
	self->priv->previous_wiggle_alpha = 0.0f;
}


static void unity_launcher_scroller_child_finalize (GObject* obj) {
	UnityLauncherScrollerChild * self;
	self = UNITY_LAUNCHER_SCROLLER_CHILD (obj);
	{
		clutter_actor_unparent ((ClutterActor*) self->priv->running_indicator);
		clutter_actor_unparent ((ClutterActor*) self->priv->active_indicator);
	}
	_g_object_unref0 (self->priv->_icon);
	_g_object_unref0 (self->controller);
	_g_object_unref0 (self->processed_icon);
	_g_object_unref0 (self->priv->close_symbol);
	_g_object_unref0 (self->priv->active_indicator);
	_g_object_unref0 (self->priv->running_indicator_notify);
	_g_object_unref0 (self->priv->running_indicator);
	_g_object_unref0 (self->priv->honeycomb_mask);
	_g_object_unref0 (self->priv->effect_drop_shadow);
	_g_object_unref0 (self->priv->effect_icon_glow);
	_g_object_unref0 (self->priv->active_indicator_anim);
	_g_object_unref0 (self->priv->running_indicator_anim);
	_g_object_unref0 (self->priv->wiggle_timeline);
	_g_object_unref0 (self->priv->glow_timeline);
	G_OBJECT_CLASS (unity_launcher_scroller_child_parent_class)->finalize (obj);
}


GType unity_launcher_scroller_child_get_type (void) {
	static volatile gsize unity_launcher_scroller_child_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_scroller_child_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityLauncherScrollerChildClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_launcher_scroller_child_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityLauncherScrollerChild), 0, (GInstanceInitFunc) unity_launcher_scroller_child_instance_init, NULL };
		GType unity_launcher_scroller_child_type_id;
		unity_launcher_scroller_child_type_id = g_type_register_static (CTK_TYPE_ACTOR, "UnityLauncherScrollerChild", &g_define_type_info, 0);
		g_once_init_leave (&unity_launcher_scroller_child_type_id__volatile, unity_launcher_scroller_child_type_id);
	}
	return unity_launcher_scroller_child_type_id__volatile;
}


static void unity_launcher_scroller_child_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityLauncherScrollerChild * self;
	self = UNITY_LAUNCHER_SCROLLER_CHILD (object);
	switch (property_id) {
		case UNITY_LAUNCHER_SCROLLER_CHILD_ICON:
		g_value_set_object (value, unity_launcher_scroller_child_get_icon (self));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_POSITION:
		g_value_set_float (value, unity_launcher_scroller_child_get_position (self));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_RUNNING:
		g_value_set_boolean (value, unity_launcher_scroller_child_get_running (self));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_ACTIVE:
		g_value_set_boolean (value, unity_launcher_scroller_child_get_active (self));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_NEEDS_ATTENTION:
		g_value_set_boolean (value, unity_launcher_scroller_child_get_needs_attention (self));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_ACTIVATING:
		g_value_set_boolean (value, unity_launcher_scroller_child_get_activating (self));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_ROTATION:
		g_value_set_float (value, unity_launcher_scroller_child_get_rotation (self));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_ENABLE_CLOSE_STATE:
		g_value_set_boolean (value, unity_launcher_scroller_child_get_enable_close_state (self));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE:
		g_value_set_enum (value, unity_launcher_scroller_child_get_group_type (self));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_IS_DRAGGING_STATE:
		g_value_set_boolean (value, unity_launcher_scroller_child_get_is_dragging_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_launcher_scroller_child_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityLauncherScrollerChild * self;
	self = UNITY_LAUNCHER_SCROLLER_CHILD (object);
	switch (property_id) {
		case UNITY_LAUNCHER_SCROLLER_CHILD_ICON:
		unity_launcher_scroller_child_set_icon (self, g_value_get_object (value));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_POSITION:
		unity_launcher_scroller_child_set_position (self, g_value_get_float (value));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_RUNNING:
		unity_launcher_scroller_child_set_running (self, g_value_get_boolean (value));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_ACTIVE:
		unity_launcher_scroller_child_set_active (self, g_value_get_boolean (value));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_NEEDS_ATTENTION:
		unity_launcher_scroller_child_set_needs_attention (self, g_value_get_boolean (value));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_ACTIVATING:
		unity_launcher_scroller_child_set_activating (self, g_value_get_boolean (value));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_ROTATION:
		unity_launcher_scroller_child_set_rotation (self, g_value_get_float (value));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_ENABLE_CLOSE_STATE:
		unity_launcher_scroller_child_set_enable_close_state (self, g_value_get_boolean (value));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_GROUP_TYPE:
		unity_launcher_scroller_child_set_group_type (self, g_value_get_enum (value));
		break;
		case UNITY_LAUNCHER_SCROLLER_CHILD_IS_DRAGGING_STATE:
		unity_launcher_scroller_child_set_is_dragging_state (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




