/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Alex Launi <alex.launi@canonical.com>
 *
 */

using GLib;

namespace Unity.MusicLens {
  
  public class MusicStoreGenreFilterParser : GenreFilterParser, MusicStoreFilterParser
  {

    public MusicStoreGenreFilterParser (GenreFilterParser parser)
    {
      base (parser.filter as CheckOptionFilterCompact);
    }
    
    public override string parse ()
    {
      StringBuilder builder = new StringBuilder ("&genres=");
      
      foreach (FilterOption genre in get_all_selected_genres ()) {
	string id = genre.id;
	if (genre.id == null)
	  continue;

	foreach (string alt in map.get_genre_synonyms (id))
	{
	  builder.append_printf ("%s,", alt);
	}
      }
      // cut off hanging ','
      builder.truncate (builder.len - 1);

      return builder.str;
    }
  }
}
