export bin=/system/bin
export PATH=$bin:/usr/bin:/usr/sbin:/bin:/usr/local/bin:$PATH
export TERM=linux
export HOME=/root

APP_PATH="/data/ubuntu"
HOME_PATH="$APP_PATH/ufa"
COMMAND="$APP_PATH/run-lxc"
CONTAINER_PATH="$APP_PATH/containers/ufa"
CONTAINER_NAME="ufa"
ROOTFS_PATH="$CONTAINER_PATH/rootfs"
DEBUG_MODE=""
DEBUG_PATH="lxc.debug"

if [ $# -eq 2 ];
    then
    if [ $2 = "debug" ] ;
    then
        DEBUG_MODE="-l debug -o $DEBUG_PATH"
    fi
fi

case $1 in

start)
        $COMMAND lxc-start -n $CONTAINER_NAME $DEBUG_MODE
        rm -f ${DEBUG_PATH}
        ;;
stop)
        $COMMAND lxc-stop -n $CONTAINER_NAME $DEBUG_MODE
        ;;
suspend)
        $COMMAND lxc-freeze -n $CONTAINER_NAME $DEBUG_MODE
        ;;
resume)
        $COMMAND lxc-unfreeze -n $CONTAINER_NAME $DEBUG_MODE
        ;;
mount)
        echo "this option is now a no-op, run with start or shell"
        ;;
shell|console)
        $COMMAND lxc-console -n $CONTAINER_NAME $DEBUG_MODE
        if [ "$?" -ne "0" ]; then
            echo "console didn't start, perhaps the container isn't running?"
            echo "trying to start the container"
            $COMMAND lxc-start -n $CONTAINER_NAME $DEBUG_MODE
        fi
        ;;
esac
