# -*- coding: utf-8 -*-

# Authors: Roberto Alsina <alecu@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Tests for the humanize function."""

from ubuntuone.controlpanel.tests import TestCase
from ubuntuone.controlpanel.gui import humanize


class HumanizeTestCase(TestCase):

    """Test cases for the humanize function."""

    def test_zero(self):
        """Humanize zero bytes."""
        self.assertEquals(humanize(0), "0 bytes")

    def test_exact(self):
        """Humanize should not show unnecesary digits."""
        self.assertEquals(humanize(1024), "1 KiB")

    def test_huge(self):
        """Humanize should work for big numbers."""
        self.assertEquals(humanize(2 ** 40), "1 TiB")

    def test_decimal(self):
        """Humanize should work for numbers ending in 0."""
        self.assertEquals(humanize(12400), "12.1 KiB")

    def test_trailing_zero(self):
        """Humanize should work for numbers ending in 0."""
        self.assertEquals(humanize(102400), "100 KiB")
