import dbus
import subprocess

import ucltip 

#{{{def find_cmd(possibles):
def find_cmd(possibles):
    """try to find exists command in possible commands

    @return SingleCmd the first matched command
    """
    for cmd in possibles:
        if ucltip.cmdexists(cmd):
            return cmd
    raise ucltip.CommandNotFound()
#}}}

class ISOBurner(object):

    __DEBUG__ = False

    #{{{def __init__(self, iso):
    def __init__(self, iso):
        self.iso = iso
        self.burnercmd = None 
    #}}}

    #{{{def prepare(self):
    def prepare(self):
        """check media and app exits"""
        self.burnercmd = find_cmd(self._possible_burners.keys())
        # is there any media
        if not self.hasSupportedMedia():
            raise Exception("Supported Media Not Found")
    #}}}

    #{{{def burn(self):
    def burn(self):
        """burning iso to target media
        """
        run = ucltip.SingleCmd(self.burnercmd)
        # for debug
        run.__DEBUG__ = self.__DEBUG__
        argv = self._possible_burners[self.burnercmd]
        argv.append(self.iso)
        #@TODO process status after exected cmd
        run(*argv)
    #}}}
pass

class USBISOBurner(ISOBurner):

    #Supported burners and their arguments
    _possible_burners = { 'usb-creator':['-n', '--iso'],
                          'usb-creator-gtk':['-n', '--iso'],
                          'usb-creator-kde':['-n', '--iso'] }

    def hasSupportedMedia(self):
        # @TODO check usb media
        return True
pass

class CDISOBurner(ISOBurner):

    #Supported burners and their arguments
    _possible_burners = { 'brasero':['-i'],
                          'nautilus-cd-burner':['--source-iso='] }

    #{{{def hasSupportedMedia(self):
    def hasSupportedMedia(self):
        """check if has supported media

        @return True or False
        """
        def check(name):
            try:
                bus = dbus.SystemBus()
                obj = bus.get_object('org.freedesktop.%s' % name, '/org/freedesktop/%s' % name.replace('.','/'))
                iface = dbus.Interface(obj, 'org.freedesktop.%s' % name)
                devices = iface.EnumerateDevices()
                for device in devices:
                    obj = bus.get_object('org.freedesktop.%s' % name, device)
                    dev = dbus.Interface(obj, 'org.freedesktop.DBus.Properties')
                    supported_media = dev.Get('org.freedesktop.%s.Device' % name, 'DriveMediaCompatibility')
                    for item in supported_media:
                        if 'optical_dvd_r' in item:
                            return True
            except dbus.DBusException, msg:
                print "%s, %s Failed burner parse" % (name, str(msg))
            return False
        return check('UDisks') or check('DeviceKit.Disks')
    #}}}
pass
