from distutils.core import setup
from DistUtilsExtra.command import *
import glob
import os
import re

# look/set what version we have
changelog = "debian/changelog"
if os.path.exists(changelog):
    head=open(changelog).readline()
    match = re.compile(".*\((.*)\).*").match(head)
    if match:
        version = match.group(1)

setup(
    name = 'ubuntu-gdm-themes',
    version = version,
    data_files=[('share/gdm/themes/Human', 
                 glob.glob('Human/*.png')+glob.glob('Human/*.svg')+\
		 glob.glob('Human/*.xml')),
                ('share/gdm/themes/Human/gtk-2.0', glob.glob('Human/gtk-2.0/*')),
                ('share/gdm/themes/HumanCircle', 
		 glob.glob('HumanCircle/*.png')+glob.glob('HumanCircle/*.svg')+\
		 glob.glob('HumanCircle/*.xml')),
                ('share/gdm/themes/HP-UMPC-GDM', 
		 glob.glob('HP-UMPC-GDM/*.png')+glob.glob('HP-UMPC-GDM/*.svg')+\
		 glob.glob('HP-UMPC-GDM/*.xml')),
		            ('share/gdm/themes/HP-UMPC-GDM/gtk-2.0', glob.glob('HP-UMPC-GDM/gtk-2.0/*')),
		('share/gdm/themes/HumanList',
                 glob.glob('HumanList/*.png')+glob.glob('HumanList/*.svg')+\
                 glob.glob('HumanList/*.xml')),
                ('share/gdm/themes/HumanList/gtk-2.0', glob.glob('HumanList/gtk-2.0/*')),
               ],
    cmdclass = { "build" : build_extra.build_extra,
                 "build_i18n" :  build_i18n.build_i18n }
)

