/***************************************************************************
 *Copyright (C) 2008 Inventec Corporation.
 *
 * This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 **************************************************************************/
#ifndef MUTE_INCLUDED
#define MUTE_INCLUDED

#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/module.h>

#include <linux/moduleparam.h>
#include <linux/types.h>
#include <linux/kdev_t.h>
#include <linux/fs.h>
#include <linux/cdev.h>
#include <asm/io.h>
#include <linux/jiffies.h>
int mute_open ( struct inode *node, struct file *filp );
int mute_release ( struct inode *node, struct file *filp );
ssize_t mute_read ( struct file *filp, char __user *buff, size_t count, loff_t *fpos );
ssize_t mute_write ( struct file *filp, const char __user *buff, size_t count, loff_t *fpos );

#endif
