/***************************************************************************
                             th-pixbufsink.h
                             ---------------
    begin                : Sun Apr 30 2006
    copyright            : (C) 2006 by Tim-Philipp Müller
    email                : t.i.m@orange.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   GStreamer sink that accepts data in a format that allows us to turn   *
 *   it easily into a GdkPixbuf. Its primary purpose is to (a) abstract    *
 *   away the GstBuffer => GdkPixbuf conversion, and (b) make prerolled    *
 *   video frames available to the application (so that we can operate     *
 *   entirely in PAUSED state) (fakesink doesn't do that yet, see open     *
 *   feature request)                                                      *
 *                                                                         *
 ***************************************************************************/


#ifndef _th_pixbuf_sink_h_included_
#define _th_pixbuf_sink_h_included_

#include <gst/gst.h>
#include <gst/base/gstbasesink.h>

#define TH_TYPE_PIXBUF_SINK            (th_pixbuf_sink_get_type())
#define TH_PIXBUF_SINK(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj),TH_TYPE_PIXBUF_SINK,ThPixbufSink))
#define TH_PIXBUF_SINK_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass),TH_TYPE_PIXBUF_SINK,ThPixbufSinkClass))
#define TH_IS_PIXBUF_SINK(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj),TH_TYPE_PIXBUF_SINK))
#define TH_IS_PIXBUF_SINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass),TH_TYPE_PIXBUF_SINK))

typedef struct _ThPixbufSink       ThPixbufSink;
typedef struct _ThPixbufSinkClass  ThPixbufSinkClass;

struct _ThPixbufSink 
{
  GstBaseSink  basesink;

  /* current caps */
  gint         width;
  gint         height;
  gint         rowstride;
  gint         par_n;
  gint         par_d;
};

struct _ThPixbufSinkClass 
{
  GstBaseSinkClass  basesinkclass;
};

GType   th_pixbuf_sink_get_type (void);

#endif /* _th_pixbuf_sink_h_included_ */

