/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * main.c
 * Copyright (C) a 2009 <a@a>
 * 
 * main.c is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * main.c is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __DTSETTING_COMMON_H__
#define __DTSETTING_COMMON_H__

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <config.h>

#include <gtk/gtk.h>
#include <glade/glade.h>

//******************************
// Define
//******************************
#define DT_BASE_KEY		"/apps/directtouch"
#define DT_SCHEME_HOME	DT_BASE_KEY "/home"
#define DT_SCHEME_WEB	DT_BASE_KEY "/web"
#define DT_SCHEME_MAIL	DT_BASE_KEY "/mail"
#define DT_SCHEME_USER	DT_BASE_KEY "/user"

#define DT_TYPE_HOME		DT_SCHEME_HOME "/type"
#define DT_MODE_HOME		DT_SCHEME_HOME "/mode"		
#define DT_APPLI_HOME	DT_SCHEME_HOME "/application"

#define DT_TYPE_WEB		DT_SCHEME_WEB "/type"
#define DT_MODE_WEB		DT_SCHEME_WEB "/mode"		
#define DT_APPLI_WEB		DT_SCHEME_WEB "/application"

#define DT_TYPE_MAIL		DT_SCHEME_MAIL "/type"
#define DT_MODE_MAIL		DT_SCHEME_MAIL "/mode"		
#define DT_APPLI_MAIL	DT_SCHEME_MAIL "/application"

#define DT_TYPE_USER		DT_SCHEME_USER "/type"
#define DT_MODE_USER		DT_SCHEME_USER "/mode"		
#define DT_APPLI_USER	DT_SCHEME_USER "/application"

#define DT_NAME_HOME		"home"
#define DT_NAME_WEB		"web"
#define DT_NAME_MAIL		"mail"
#define DT_NAME_USER		"user"

#define DT_CMB_ID_HOME	"combobox1"
#define DT_CMB_ID_WEB	"combobox2"
#define DT_CMB_ID_MAIL	"combobox3"
#define DT_CMB_ID_USER	"combobox4"

#define DT_ENT_ID_HOME	"d_ent1"
#define DT_ENT_ID_WEB	"d_ent2"
#define DT_ENT_ID_MAIL	"d_ent3"
#define DT_ENT_ID_USER	"d_ent4"

#define DT_BTN_ID_HOME	"d_btn1"
#define DT_BTN_ID_WEB	"d_btn2"
#define DT_BTN_ID_MAIL	"d_btn3"
#define DT_BTN_ID_USER	"d_btn4"

#define DT_ENT_ID_EVENT	"d3_ent"

#define DT_BOOL_DEF		FALSE
#define DT_INT_DEF		0
#define DT_STR_DEF		"default"

enum {
	DT_MENU_LAUNCHER,
	DT_MENU_INTERNET,
	DT_MENU_MAIL,
	DT_MENU_OPTICAL,
	DT_MENU_MEDIA,
	DT_MENU_APPLI,
	DT_MENUS
};

//******************************
// Variables
//******************************
GtkWidget   *dialog;
GtkWidget   *dialog2;
gint		gcombo_index;
gint		ghbox_pos;

//******************************
// Prottype
//******************************
void
dt_show_sub_dialog (const gchar*);

GtkWidget*
dt_create_dialog2 (void);

void
dt_select_category (void);

gboolean
dt_update_entry (void);

gboolean
dt_update_gconf (void);

void
dt_init_entry (void);

#endif  /* __DTSETTING_COMMON_H__ */
