/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * callbacks.c
 * Copyright (C) a 2009 <a@a>
 * 
 * callbacks.c is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * callbacks.c is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "callbacks.h"
#include "common.h"

/* callback from main dialog */
/* callback for icon drawing */
gint
cb_d_expose (GtkWidget *widget, GdkEventExpose *event, gpointer data) 
{
	gdk_draw_pixbuf (widget->window, NULL, (GdkPixbuf *) data,
			0 , 0 , 0 , 0 , -1, -1, GDK_RGB_DITHER_NONE , 0 , 0);

	return TRUE;
}

/* callback for combobox menu */
void
on_combobox1_changed (GtkComboBox *combobox, gpointer data)
{
	g_print ("callback on_combobox1_changed()\n");
	gcombo_index = gtk_combo_box_get_active (combobox);
	g_print ("on_combobox1_changed() gcombo_index[%d]\n",gcombo_index);
	ghbox_pos = DT_HBOX_POS1;
	dt_select_category ();
}

void
on_combobox2_changed (GtkComboBox *combobox, gpointer data)
{
	g_print ("callback on_combobox2_changed()\n");
	gcombo_index = gtk_combo_box_get_active (combobox);
	g_print ("on_combobox2_changed() gcombo_index[%d]\n",gcombo_index);
	ghbox_pos = DT_HBOX_POS2;
	dt_select_category ();
}

void
on_combobox3_changed (GtkComboBox *combobox, gpointer data)
{
	g_print ("callback on_combobox3_changed()\n");
	gcombo_index = gtk_combo_box_get_active (combobox);
	g_print ("on_combobox3_changed() gcombo_index[%d]\n",gcombo_index);
	ghbox_pos = DT_HBOX_POS3;
	dt_select_category ();
}

void
on_combobox4_changed (GtkComboBox *combobox, gpointer data)
{
	g_print ("callback on_combobox4_changed()\n");
	gcombo_index = gtk_combo_box_get_active (combobox);
	g_print ("on_combobox4_changed() gcombo_index[%d]\n",gcombo_index);
	ghbox_pos = DT_HBOX_POS4;
	dt_select_category ();
}

/* callback for reference button */
void
on_d_btn1_clicked (GtkButton *button, gpointer data)
{
	g_print ("callback on_d_btn1_clicked()\n");
	ghbox_pos = DT_HBOX_POS1;
	dt_show_sub_dialog (DT_TYPE_HOME);
}

void
on_d_btn2_clicked (GtkButton *button, gpointer data)
{
	g_print ("callback on_d_btn2_clicked()\n");
	ghbox_pos = DT_HBOX_POS2;
	dt_show_sub_dialog (DT_TYPE_WEB);
}

void
on_d_btn3_clicked (GtkButton *button, gpointer data)
{
	g_print ("callback on_d_btn3_clicked()\n");
	ghbox_pos = DT_HBOX_POS3;
	dt_show_sub_dialog (DT_TYPE_MAIL);
}

void
on_d_btn4_clicked (GtkButton *button, gpointer data)
{
	g_print ("callback on_d_btn4_clicked()\n");
	ghbox_pos = DT_HBOX_POS4;
	dt_show_sub_dialog (DT_TYPE_USER);
}

void
on_d_ok_clicked (GtkButton *button, gpointer data)
{
	gboolean result = FALSE;

	g_print ("callback on_d_ok_clicked()\n");
	result = dt_update_gconf ();
	if(result){
		gtk_widget_destroy (dialog);
	}
}

void
on_d_cancel_clicked (GtkButton *button, gpointer data)
{
	g_print ("callback on_d_cancel_clicked()\n");
	gtk_widget_destroy (dialog);
}

void
on_d_init_clicked (GtkButton *button, gpointer data)
{
	g_print ("callback on_d_init_clicked()\n");
	dt_init_entry ();
}

/* callback from file-chooser dialog */
void
on_d2_open_clicked (GtkButton *button, gpointer data)
{
	g_print ("callback on_d2_open_clicked()\n");
	dt_update_entry ();
	gtk_widget_hide (dialog2);
}

void
on_d2_cancel_clicked (GtkButton *button, gpointer data)
{
	g_print ("callback on_d2_cancel_clicked()\n");
	gtk_widget_hide (dialog2);
}

void
on_dialog_file_activated (GtkFileChooserDialog *self, gpointer user_data)
{
	/* Select File by Double-Click or Enter in FileChooser */
	g_print ("callback on_dialog_file_activated()\n");
	on_d2_open_clicked (NULL, NULL);
}

/* callback from destory-event */
void
d_destroy (GtkWidget *widget, gpointer data)
{
	g_print ("callback d_destroy()\n");
	gtk_main_quit ();
}

void
d2_destroy (GtkWidget *widget, gpointer data)
{
	g_print ("callback d2_destroy()\n");
	gtk_widget_hide (widget);
}
