/*
 * <insert one-line description of what the program does>
 * Copyright (c) <2008-2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *

File Name:          IniFile.c

Description:

Environment (opt):
 
Notes (opt):
  =====================================================================
  Revision   Revision History		Author     Date
  =====================================================================
  
  =====================================================================
****************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <ctype.h>

#include "InfoMgmt/TCAgentIni.h"
#include "GUI/error.h"
#include "GUI/resmgmt.h"
#include "InfoMgmt/InfoBase.h"


/* Description: Set entry value for the given Section and Entry
 * Module: INI File API
 * Parameter:	Section (specified section name)
 * 		Ident (specified Entry name)
 * 		Value (the value which will be set)
 * 		FileName (INI file name)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL. 
*/

int Ini_WriteString(char *Section, char *Ident, char *Value, char *FileName)
{
	FILE *inifile = NULL;
	char buf[MAX_LINE_NO][MAXNUM_PER_LINE];

	memset(buf, '\0', MAX_LINE_NO*MAXNUM_PER_LINE);
	
	char *tmp = NULL, *tmp1 = NULL, *entry = NULL;
	unsigned int n, i;
	unsigned int section_found = 0, ident_written = 0;	//ident_written: 0: the value hasn't been set, 1: the value has been set
	
	/*parameter validity check*/
	if(Section == NULL || Ident == NULL || Value == NULL || FileName == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	
	/*open the target INI File*/
	if((inifile = fopen(FileName, "r")) == NULL)
	{
		WriteLog(INFOMGMT_ERR_NOINIFILE);
		return INFOMGMT_ERR_NOINIFILE;
	}
	i = 0;
	while(fgets(buf[i], MAXNUM_PER_LINE, inifile))
	{
		if(buf[i][0] == '[')
		{
			tmp = strdup(buf[i]);
			if((tmp1 = index(tmp, ']')) == NULL)
			{
				i++;
				free(tmp);
				continue;
			}
			
			*tmp1 = '\0'; 
			if(strcmp(&tmp[1], Section))
			{
				i++;
				free(tmp);
				/*tranverse the file if the section hasn't been found yet*/
				continue;
			}
			free(tmp);
			
			/*find the specified Section*/
			section_found = 1;
			break;
		}
		i++;
	}
	
	i++;
	if(section_found)
	{
		while(fgets(buf[i], MAXNUM_PER_LINE, inifile))
		{
			/*if the value has been set, the rest still need be copied to buf*/
			if(ident_written)
			{
				i++;
				continue;
			}
			
			/*if the entry cannot be found in specified section, the entry and value will be added in.*/
			if(buf[i][0] == '[')
			{
				strcpy(buf[i + 1], buf[i]);
				snprintf(buf[i], MAXNUM_PER_LINE, "%s=%s\n", Ident, Value);
				i++; i++;
				ident_written = 1;
				continue;
			}
			
			tmp = strdup(buf[i]);
			if(!(entry = strtok(tmp, "=")))
			{
				i++;
				free(tmp);
				continue;
			}	
			if(strcmp(entry, Ident))
			{
				i++;
				free(tmp);
				continue;
			}
			free(tmp);
			
			/*find the specified entry in the specified section*/
			memset(buf[i], '\0', MAXNUM_PER_LINE);
			snprintf(buf[i], MAXNUM_PER_LINE, "%s=%s\n", Ident, Value);
			ident_written = 1;
			i++;
			continue;
		}

		/*traverse the ini file, but cannot find the entry, then add it in the last line*/
		if(!ident_written)
		{
			snprintf(buf[i], MAXNUM_PER_LINE, "%s=%s\n", Ident, Value);
			ident_written = 1;
			i++;
		}
	}
	else
	{
		/*there's no suitable Section, Add entry and section*/
		snprintf(buf[i++], MAXNUM_PER_LINE, "[%s]\n", Section);
		snprintf(buf[i++], MAXNUM_PER_LINE, "%s=%s\n", Ident, Value);
	}
	
	fclose(inifile);
	if((inifile = fopen(FileName, "w")) == NULL)
	{
		WriteLog(INFOMGMT_ERR_RWINIFILE);
		return INFOMGMT_ERR_RWINIFILE;
	}
	n = i;
	/*re-write the INI file to mimic insert action*/
	for(i = 0; i < n; i++)
	{
		fputs(buf[i], inifile);
	}
	fclose(inifile);
	return 0;

}


/* Description: Get entry value for the given Section and Entry
 * Module: INI File API
 * Parameter:	Section (specified section name)
 * 		Ident (specified Entry name)
 * 		Default (the value returned, if there's no value in INI File)
 * 		ret (the value which will be got)
 * 		FileName (INI file name)
 * Return Value: 0 represent SUCCEED, POSITIVE INTEGER represent FAIL. 
*/

int Ini_ReadString(char *Section, char *Ident, char *Default, char *ret, char *FileName)
{
	FILE *inifile = NULL;
	char buf[MAXNUM_PER_LINE];
	
	memset(buf, '\0', MAXNUM_PER_LINE);
	char *tmp = NULL, *entry = NULL, *value = NULL;
	unsigned int len, i;
	unsigned int section_found = 0, ident_found = 0;
	
	/*parameter validity check*/
	if(Section == NULL || Ident == NULL || Default == NULL || ret == NULL || FileName == NULL)
	{
		WriteLog(INFOMGMT_ERR_PARAM);
		return INFOMGMT_ERR_PARAM;
	}
	/*set Default value*/
	strcpy(ret, Default);
	
	/*open the specified INI file*/
	if((inifile = fopen(FileName, "r")) == NULL)
	{
		WriteLog(INFOMGMT_ERR_NOINIFILE);
		return INFOMGMT_ERR_NOINIFILE;
	}
	
	while(fgets(buf, MAXNUM_PER_LINE, inifile))
	{
		if(buf[0] == '[')
		{
			if((tmp = index(buf, ']')) == NULL)
				continue;
			*tmp = '\0';
			
			if(strcmp(&buf[1], Section))
			{
				continue;
			}

			/*found the specified section*/
			section_found = 1;
			break;
		}
	}

	/*if no section is found, return Default*/
	if(!section_found)
	{
		fclose(inifile);
		return 0;
	}
	
	memset(buf, '\0', MAXNUM_PER_LINE);
	while(fgets(buf, MAXNUM_PER_LINE, inifile))
	{
		/*if no entry is found, return Default*/
		if(buf[0] == '[')
		{
			fclose(inifile);
			return 0;
		}
		
		/*if comment is found, skip the comment*/
		if(buf[0] == ';')
		{
			continue;
		}

		tmp = strdup(buf);
		if(!(entry = strtok(tmp, "=")))
			continue;
		if(strcmp(entry, Ident))
			continue;
		
		/*find the entry*/
		ident_found = 1;
		value = index(buf, '=');
		if(value)
		//if(value = strtok(NULL, "="))
		{
			value++;
			if(value[0] == '\n')
			{
				fclose(inifile);
				return 0;
			}
			i = 0;
			while(value[++i])
			{
				if(value[i] == '\n')
				{
					value[i] = '\0';
					break;
				}
			}
			strcpy(ret, value);
			fclose(inifile);
			return 0;
		}
		else
		{
			fclose(inifile);
			return 0;
		}
					
	}

	fclose(inifile);
	return 0;
	
}

char tcagentconfig_path[FILEPATH_MAX_LEN];
char* get_tcagentconfig_path()
{
 	char configpath[FILEPATH_MAX_LEN ];
        getrespath(THEFTCONTROL_CONFIG, configpath);
	
	char tmp[FILEPATH_MAX_LEN ];
        strncpy(tmp,configpath, strlen(configpath));
	tmp[strlen(configpath)]='\0';
											  
	strncat(tmp,"/",1);
	strncat(tmp, INI_FILENAME, strlen(INI_FILENAME));
	strncpy(tcagentconfig_path, tmp, strlen(tmp));
	tcagentconfig_path[strlen(tmp)]='\0';
#ifdef DEBUG
	//printf("current TCAgentConfig.ini full path is: %s\n", tcagentconfig_path);
#endif
	return tcagentconfig_path;
}
