/*
 * <insert one-line description of what the program does>
 * Copyright (c) <2008-2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _TC_ENGINE_
#define _TC_ENGINE_

#include <stdio.h>
#include <time.h>
#include "EngineCmm.h"
#include "TPMCtrl/TPMCtrl.h"
#include "InfoMgmt/InfoMgmt.h"
#include "ConnMgmt/ConnMgmt.h"

#define STATUS_PERMANENT		0x20
#define STATUS_URGENCY			0x10
#define STATUS_NORMAL			0x0
#define STATUS_DISABLE 0x01
#define STATUS_NOT_APPROVED 0x02
#define STATUS_WARNING 0x04
#define STATUS_NO_CONNECTION 0x08


#define BOOTCERT_PACK_SIZE		266
#define SHAREDSECRET_PACK_SIZE	385
#define SERVERPUBKEY_HTTPS_PACK_SIZE	(1+28+256+256)
#define SERVERPUBKEY_HTTP_PACK_SIZE (284)

// download kind is normal
#define DOWNLOADKIND_NORMAL		2
// downlaod kind is shared secre or special
#define DOWNLOADKIND_SPECI		1


/// downlaod kind is shared secre or special
#define DOWNLOADKIND_PUSH  1
/// download kind is normal
#define DOWNLOADKIND_PULL  2

/// downlaod kind is shared secre or special
#define DOWNLOADKIND_PROVISION  1
/// downlaod kind is shared secre or special
#define DOWNLOADKIND_CA  2


// Year of expiration
#define PERMANENT_YEAR			2038
// Month of expiration
#define PERMANENT_MONTH			1
// Day of expiration
#define PERMANENT_DAY			1
// Boot count in cert permanent
#define PERMANENT_BOOTCOUNT		500000

#define DATE_YEAR_OFFESET       0
#define DATE_MONTH_OFFESET      5
#define DATE_DAY_OFFESET        8

#define SECONDS_FOR_ONE_DAY		(24 * 60 * 60)
#define DAYS_FOR_ONE_YEAR		365

typedef struct DownloadCertFinishEventArgs_struct
{
	int     CertKind;
	int     DownloadStatus;

} DownloadCertFinishEventArgs;

int		DownloadCertFinishEventArgs_Construct(DownloadCertFinishEventArgs *);		

typedef struct TCEngineException_struct 
{
	int Status;

} TCEngineException;

int		TCEngineException_Construct_A(TCEngineException *);		
int		TCEngineException_Construct_B(TCEngineException *, int);

typedef struct TCEngine_struct
{
	int	   m_bootCount;
	struct TPMCtrl_struct	*m_objTPMCtrl;
	struct DateTime_struct	*m_expirationDate;
	int m_ConnectionStatus;

} TCEngine;

int		TCEngine_Construct(TCEngine *);
int  	TCEngine_DownloadCert(TCEngine *, int);		
int  	TCEngine_HTTPDownload(TCEngine *, int);		
int 	TCEngine_GetStudentId(string);
int 	TCEngine_GetExpirationInfo(TCEngine *, DateTime *, int *);
int		TCEngine_GetCurrentSate(TCEngine *);
int 	TCEngine_OnDownloadCertFinish(DownloadCertFinishEventArgs *);	
static int Listened;

#endif
