/*
 * <insert one-line description of what the program does>
 * Copyright (c) <2008-2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *

File Name:          BootCert.h 

Description:

    This file describe BootCert struct
	
		This struct has following property:
		
		1.BootCount			Allow boot times for device  
		
		2.Cert				Data of cert, byte array type
		
		3.CertKind			Kind of cert, No cert, Commond cert, special cert or shared 
secret
		
		4.ExpirationDate	      The end date that device could use

 

Environment (opt):

    OS: metasys/mandriva

    SE: gcc

 

Notes (opt):

 

  =====================================================================

  Revision   Revision History                    Date

  =====================================================================

  0.1        Create                             2006-8-15 

  =====================================================================

 

****************************************************************************/

#include <time.h>

#ifndef MAXSTRLEN
#define MAXSTRLEN 600
#endif

#ifndef _BootCert_
#define _BootCert_

typedef enum CertKind_enum
{
/// <summary>
		/// No certificate
		/// </summary>
		NoCert,
		/// <summary>
		/// Intel public key
		/// </summary>
		IntelPublicKey,
		/// <summary>
		/// Server public key
		/// </summary>
		ServerPublicKey,
		/// <summary>
		/// Shared secret
		/// </summary>
		SharedSecret,
		/// <summary>
		/// Normal certificate
		/// </summary>
		NormalCert,
		/// <summary>
		/// Special certificate
		/// </summary>
		SpecialCert,
		/// <summary>
		/// Auto provision package
		/// </summary>
		AutoProvisionPackage,
		/// <summary>
		/// CA package
		/// </summary>
		CAPackage
} CertKind; // end of enum CertKind

/*
typedef enum DownloadKind_enum
		{
			// donwload index: Intel public key, Server public key, shared secret, special cert
			PushCert = 1,
			// download index: Intel public key, Server public key, shared secret, special cert, Normal cert
			PullCert = 2,
			//
			ProvisonPacket = 3,
			CACert = 4
}DownloadKind;*/
typedef struct DateTime_struct
{
	int Year;
	int Month; //1~12
	int Day;   //1~31
	int Hour;  //0~23
	int Minute;//0~59
	int Second;//0~59
} DateTime;

	/// <summary>
	/// Boot cert data, expiration date and boot count
	/// </summary>
typedef	struct BootCert_struct
{
	/// <summary>
	/// Data of boot cert
	/// </summary>
       unsigned char Cert[MAXSTRLEN];		

	/// <summary>
	/// Expiration date of the cert (the property Cert)
	/// The end date of device could used.
	/// </summary>

	//DateTime ExpirationDate; //how to define that?
	DateTime ExpirationDate;
	
	/// <summary>
	/// Boot count of the cert (the property Cert)
	/// The boot times of device
	/// </summary>
	int BootCount;

	/// <summary>
	/// The property Cert's kind
	/// </summary>
	/// <value>A member of enum CertKind</value> 
    CertKind CertKind;	
}BootCert ;// end of class BootCert

#endif
