/*
 * Copyright (C) 2007 OpenedHand Ltd
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _KOTO_PRIORITY_COMBO
#define _KOTO_PRIORITY_COMBO

#include <gtk/gtkcombobox.h>

G_BEGIN_DECLS

#define KOTO_TYPE_PRIORITY_COMBO koto_priority_combo_get_type()

#define KOTO_PRIORITY_COMBO(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  KOTO_TYPE_PRIORITY_COMBO, KotoPriorityCombo))

#define KOTO_PRIORITY_COMBO_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  KOTO_TYPE_PRIORITY_COMBO, KotoPriorityComboClass))

#define KOTO_IS_PRIORITY_COMBO(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  KOTO_TYPE_PRIORITY_COMBO))

#define KOTO_IS_PRIORITY_COMBO_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  KOTO_TYPE_PRIORITY_COMBO))

#define KOTO_PRIORITY_COMBO_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  KOTO_TYPE_PRIORITY_COMBO, KotoPriorityComboClass))

typedef struct {
  GtkComboBox parent;
} KotoPriorityCombo;

typedef struct {
  GtkComboBoxClass parent_class;
} KotoPriorityComboClass;

GType koto_priority_combo_get_type (void);

GtkWidget* koto_priority_combo_new (void);

void koto_priority_combo_set_priority (KotoPriorityCombo *combo, int priority);

int koto_priority_combo_get_priority (KotoPriorityCombo *combo);

G_END_DECLS

#endif /* _KOTO_PRIORITY_COMBO */
