//===========================================================================
// Copyright (c) 1996-2011 Synaptics Incorporated. All rights reserved.
//
// RCS Header - Do not delete or modify.
//
// $RCSfile: TouchPadService.cpp,v $
// $Source: /cvs/software/Driver/SynCom/TouchPadControl/TouchPadService.cpp,v $
//===========================================================================
#include "TouchPadService.h"
#include <stdexcept>

//---------------------------------------------------------------------------
// TouchPadService::TouchPadService
//
// PURPOSE: Constructor. pSynAPI counts the # of references to itself,
// so hold a reference to it in TouchPadService.
//---------------------------------------------------------------------------
TouchPadService::TouchPadService(shared_ptr<ISynAPI> pSynAPI)  
{
  m_pSynAPI = pSynAPI;
}

//---------------------------------------------------------------------------
// TouchPadService::GetTouchPad()
//
// PURPOSE: Create and return an abstraction to the Synaptics TouchPad device,
// using the first available device handle.
//---------------------------------------------------------------------------
ISynDevice* TouchPadService::GetTouchPad() const
{ 
  if(!m_pSynAPI) {
    return NULL;
  }

  ISynDevice* pDevice = NULL;
  m_pSynAPI->CreateDevice(GetHandleToTouchPad(), &pDevice);
  if(!pDevice) {
    throw std::runtime_error("Unable to create a Synaptics TouchPad device.");
  }

  return pDevice;
}

//---------------------------------------------------------------------------
// TouchPadService::GetHandleToTouchPad
//
// PURPOSE: Returns a handle to the first available Synaptics TouchPad
// device.
//---------------------------------------------------------------------------
LONG TouchPadService::GetHandleToTouchPad() const
{
  if(!m_pSynAPI) {
    return -1;
  }

  LONG lHandle = -1;
  m_pSynAPI->FindDevice(SE_ConnectionAny, SE_DeviceTouchPad, &lHandle);
  if(lHandle < 0) {
    throw std::runtime_error("Unable to find a Synaptics TouchPad.");
  }

  return lHandle;
}

