//===========================================================================
// Copyright (c) 1996-2011 Synaptics Incorporated. All rights reserved.
//
// RCS Header - Do not delete or modify.
//
// $RCSfile: TouchPadControl.cpp,v $
// $Source: /cvs/software/Driver/SynCom/TouchPadControl/TouchPadControl.cpp,v $
//===========================================================================
#include "TouchPadControl.h"

#define TOUCHPAD_ENABLE   0
#define TOUCHPAD_DISABLE  1

TouchPadControl::TouchPadControl(ISynDevice* pDevice)
  : m_pSynDevice(pDevice)
{
}

TouchPadControl::~TouchPadControl()
{
  delete m_pSynDevice;
}

//---------------------------------------------------------------------------
// TouchPadControl::Enable
//
// PURPOSE: SynCom SetProperty() example
//---------------------------------------------------------------------------
VOID TouchPadControl::Enable() const
{
  if(IsDisabled()) {
    m_pSynDevice->SetProperty(SP_DisableState, TOUCHPAD_ENABLE);
  }
}

//---------------------------------------------------------------------------
// TouchPadControl::Disable
//
// PURPOSE: SynCom SetProperty() example
//---------------------------------------------------------------------------
VOID TouchPadControl::Disable() const
{
  if(!IsDisabled()) {
    m_pSynDevice->SetProperty(SP_DisableState, TOUCHPAD_DISABLE);
  }
}

//---------------------------------------------------------------------------
// TouchPadControl::IsDisabled
//
// PURPOSE: SynCom GetProperty() example
//---------------------------------------------------------------------------
BOOL TouchPadControl::IsDisabled() const
{
  LONG lState = TOUCHPAD_ENABLE;
  m_pSynDevice->GetProperty(SP_DisableState, &lState);
  return (lState == TOUCHPAD_DISABLE);
}
