#!/bin/bash
# Gather hardware information

LOG_FILE="$1"

if [ "$LOG_FILE" = "" ] ;then
	echo "Missing product name (exg. P320-1) to save the log..."
	echo "  $0 LOG_FILE"
	exit 0
fi

mkdir $LOG_FILE
pushd $LOG_FILE
echo "$ lspci -n"
sudo lspci -n | cut -d' ' -f2,3 | tr -d ' :' >> lspci.list

echo "$ lspci -nn"
sudo lspci -nn >> lspci_nn.list
sudo lspci -nnvv >> lspci_nnvv.list

echo "$ sudo dmidecode"
sudo dmidecode >> dmidecode.list
echo "$ sudo lsusb"
sudo lsusb > lsusb.list
sudo lsusb -t >> lsusb.list
sudo lsusb -v >> lsusb.list

sudo cp /sys/class/dmi/id/bios_version .
sudo cp /sys/class/dmi/id/modalias .
sudo cp /sys/class/dmi/id/product_version .
popd
