/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.console;

import info.aduna.app.AppConfiguration;
import info.aduna.app.AppVersion;
import info.aduna.io.IOUtil;
import info.aduna.text.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.openrdf.console.ConfigTemplate;
import org.openrdf.http.client.HTTPClient;
import org.openrdf.http.protocol.UnauthorizedException;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.GraphImpl;
import org.openrdf.model.util.GraphUtil;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.BindingSet;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryInterruptedException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.UnsupportedQueryLanguageException;
import org.openrdf.query.parser.ParsedBooleanQuery;
import org.openrdf.query.parser.ParsedGraphQuery;
import org.openrdf.query.parser.ParsedQuery;
import org.openrdf.query.parser.ParsedTupleQuery;
import org.openrdf.query.parser.QueryParserUtil;
import org.openrdf.query.parser.serql.SeRQLUtil;
import org.openrdf.query.parser.sparql.SPARQLUtil;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryLockedException;
import org.openrdf.repository.RepositoryReadOnlyException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.config.RepositoryConfig;
import org.openrdf.repository.config.RepositoryConfigException;
import org.openrdf.repository.config.RepositoryConfigSchema;
import org.openrdf.repository.config.RepositoryConfigUtil;
import org.openrdf.repository.manager.LocalRepositoryManager;
import org.openrdf.repository.manager.RemoteRepositoryManager;
import org.openrdf.repository.manager.RepositoryInfo;
import org.openrdf.repository.manager.RepositoryManager;
import org.openrdf.rio.ParseErrorListener;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.RDFParser;
import org.openrdf.rio.Rio;
import org.openrdf.rio.UnsupportedRDFormatException;
import org.openrdf.rio.helpers.RDFHandlerBase;
import org.openrdf.rio.helpers.StatementCollector;
import org.openrdf.rio.ntriples.NTriplesUtil;
import org.openrdf.sail.LockManager;
import org.openrdf.sail.SailLockedException;
import org.openrdf.sail.helpers.DirectoryLockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Console {
    private static final AppVersion VERSION = new AppVersion(2, 2, 4);
    private static final String APP_NAME = "OpenRDF Sesame console";
    private static final String TEMPLATES_DIR = "templates";
    public static final Map<String, Level> LOG_LEVELS;
    private final AppConfiguration appConfig = new AppConfiguration("OpenRDF Sesame console", "OpenRDF Sesame console", VERSION);
    private final java.util.logging.Logger jdkRootLogger = java.util.logging.Logger.getLogger("");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RepositoryManager manager;
    private String managerID;
    private Repository repository;
    private String repositoryID;
    private BufferedReader in;
    private PrintStream out;
    private int consoleWidth = 80;
    private boolean showPrefix = true;
    private boolean queryPrefix = false;

    public static void main(String[] args) throws Exception {
        Console console = new Console();
        Options options = new Options();
        Option helpOption = new Option("h", "help", false, "print this help");
        Option versionOption = new Option("v", "version", false, "print version information");
        Option serverURLOption = new Option("s", "serverURL", true, "URL of Sesame server to connect to, e.g. http://localhost/openrdf-sesame/");
        Option dirOption = new Option("d", "dataDir", true, "Sesame data dir to 'connect' to");
        options.addOption(helpOption);
        OptionGroup connectGroup = new OptionGroup();
        connectGroup.addOption(serverURLOption);
        connectGroup.addOption(dirOption);
        options.addOptionGroup(connectGroup);
        PosixParser argsParser = new PosixParser();
        try {
            CommandLine commandLine = argsParser.parse(options, args);
            if (commandLine.hasOption(helpOption.getOpt())) {
                Console.printUsage(options);
                System.exit(0);
            }
            if (commandLine.hasOption(versionOption.getOpt())) {
                System.out.println(console.appConfig.getFullName());
                System.exit(0);
            }
            String dir = commandLine.getOptionValue(dirOption.getOpt());
            String serverURL = commandLine.getOptionValue(serverURLOption.getOpt());
            String[] otherArgs = commandLine.getArgs();
            if (otherArgs.length > 1) {
                Console.printUsage(options);
                System.exit(1);
            }
            boolean connected = false;
            connected = dir != null ? console.connectLocal(dir) : (serverURL != null ? console.connectRemote(serverURL) : console.connectDefault());
            if (!connected) {
                System.exit(2);
            }
            if (otherArgs.length > 0) {
                console.openRepository(otherArgs[0]);
            }
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        console.start();
    }

    private static void printUsage(Options options) {
        System.out.println("Sesame Console, an interactive shell based utility to communicate with Sesame repositories.");
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(80);
        formatter.printHelp("start-console [OPTION] [repositoryID]", options);
        System.out.println();
        System.out.println("For bug reports and suggestions, see http://www.openrdf.org/");
    }

    public Console() throws IOException {
        this.jdkRootLogger.setLevel(Level.WARNING);
        this.appConfig.init();
        this.in = new BufferedReader(new InputStreamReader(System.in));
        this.out = System.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        this.writeln();
        this.writeln("Commands end with '.' at the end of a line");
        this.writeln("Type 'help.' for help");
        try {
            boolean exitFlag = false;
            while (!exitFlag) {
                String command = this.readMultiLineInput();
                if (command == null) {
                    break;
                }
                exitFlag = this.executeCommand(command);
            }
        }
        finally {
            this.disconnect(false);
        }
        this.writeln("Bye");
    }

    private boolean executeCommand(String command) throws IOException {
        boolean exit = false;
        String[] tokens = this.parse(command);
        String operation = tokens[0].toLowerCase(Locale.ENGLISH);
        if ("quit".equals(operation) || "exit".equals(operation)) {
            exit = true;
        } else if ("help".equals(operation)) {
            this.printHelp(tokens);
        } else if ("info".equals(operation)) {
            this.printInfo();
        } else if ("connect".equals(operation)) {
            this.connect(tokens);
        } else if ("disconnect".equals(operation)) {
            this.disconnect(true);
        } else if ("create".equals(operation)) {
            this.createRepository(tokens);
        } else if ("drop".equals(operation)) {
            this.dropRepository(tokens);
        } else if ("open".equals(operation)) {
            this.open(tokens);
        } else if ("close".equals(operation)) {
            this.close(tokens);
        } else if ("show".equals(operation)) {
            this.show(tokens);
        } else if ("load".equals(operation)) {
            this.load(tokens);
        } else if ("verify".equals(operation)) {
            this.verify(tokens);
        } else if ("clear".equals(operation)) {
            this.clear(tokens);
        } else if ("select".equals(operation)) {
            this.evaluateQuery(QueryLanguage.SERQL, command);
        } else if ("construct".equals(operation)) {
            this.evaluateQuery(QueryLanguage.SERQL, command);
        } else if ("serql".equals(operation)) {
            this.evaluateQuery(QueryLanguage.SERQL, command.substring("serql".length()));
        } else if ("sparql".equals(operation)) {
            this.evaluateQuery(QueryLanguage.SPARQL, command.substring("sparql".length()));
        } else if ("set".equals(operation)) {
            this.setParameter(tokens);
        } else if (command.length() != 0) {
            this.writeError("Unknown command");
        }
        return exit;
    }

    private String[] parse(String command) {
        Pattern pattern = Pattern.compile("\"([^\"]*)\"|(\\S+)");
        Matcher matcher = pattern.matcher(command);
        ArrayList<String> tokens = new ArrayList<String>();
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                tokens.add(matcher.group(1));
                continue;
            }
            tokens.add(matcher.group());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private void printHelp(String[] tokens) {
        if (tokens.length < 2) {
            this.printCommandOverview();
        } else {
            String target = tokens[1].toLowerCase(Locale.ENGLISH);
            if ("connect".equals(target)) {
                this.printHelpConnect();
            } else if ("disconnect".equals(target)) {
                this.printHelpDisconnect();
            } else if ("create".equals(target)) {
                this.printHelpCreate();
            } else if ("drop".equals(target)) {
                this.printHelpDrop();
            } else if ("open".equals(target)) {
                this.printHelpOpen();
            } else if ("close".equals(target)) {
                this.printHelpClose();
            } else if ("show".equals(target)) {
                this.printHelpShow();
            } else if ("load".equals(target)) {
                this.printHelpLoad();
            } else if ("verify".equals(target)) {
                this.printHelpVerify();
            } else if ("clear".equals(target)) {
                this.printHelpClear();
            } else if ("set".equals(target)) {
                this.printHelpSet();
            } else {
                this.writeln("No info available for command " + tokens[1]);
            }
        }
    }

    private void printCommandOverview() {
        this.writeln("For more information on a specific command, try 'help <command>.'");
        this.writeln("List of all commands:");
        this.writeln("help        Displays this help message");
        this.writeln("info        Shows info about the console");
        this.writeln("connect     Connects to a (local or remote) set of repositories");
        this.writeln("disconnect  Disconnects from the current set of repositories");
        this.writeln("create      Creates a new repository");
        this.writeln("drop        Drops a repository");
        this.writeln("open        Opens a repository to work on, takes a repository ID as argument");
        this.writeln("close       Closes the current repository");
        this.writeln("show        Displays an overview of various resources");
        this.writeln("load        Loads a data file into a repository, takes a file path or URL as argument");
        this.writeln("verify      Verifies the syntax of an RDF data file, takes a file path or URL as argument");
        this.writeln("clear       Removes data from a repository");
        this.writeln("serql       Evaluates the SeRQL query, takes a query as argument");
        this.writeln("sparql      Evaluates the SPARQL query, takes a query as argument");
        this.writeln("set         Allows various console parameters to be set");
        this.writeln("exit, quit  Exit the console");
    }

    private void printInfo() {
        this.writeln(this.appConfig.getFullName());
        this.writeln("Data dir: " + this.appConfig.getDataDir());
        this.writeln("Connected to: " + (this.managerID == null ? "-" : this.managerID));
    }

    private void printHelpConnect() {
        this.writeln("Usage:");
        this.writeln("connect default           Opens the default repository set for this console");
        this.writeln("connect <dataDirectory>   Opens the repository set in the specified data dir");
        this.writeln("connect <serverURL>       Connects to a Sesame server");
    }

    private void connect(String[] tokens) {
        if (tokens.length != 2) {
            this.printHelpConnect();
            return;
        }
        String target = tokens[1];
        if ("default".equalsIgnoreCase(target)) {
            this.connectDefault();
        } else {
            try {
                new URL(target);
                this.connectRemote(target);
            }
            catch (MalformedURLException e) {
                this.connectLocal(target);
            }
        }
    }

    private boolean connectDefault() {
        return this.installNewManager(new LocalRepositoryManager(this.appConfig.getDataDir()), "default data directory");
    }

    private boolean connectLocal(String path) {
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            this.writeError("Specified path is not an (existing) directory: " + path);
            return false;
        }
        return this.installNewManager(new LocalRepositoryManager(dir), dir.toString());
    }

    private boolean connectRemote(String url) {
        try {
            HTTPClient httpClient = new HTTPClient();
            httpClient.setServerURL(url);
            httpClient.getServerProtocol();
            return this.installNewManager(new RemoteRepositoryManager(url), url);
        }
        catch (UnauthorizedException e) {
            this.writeError("Not authorized to access the server");
        }
        catch (IOException e) {
            this.writeError("Failed to access the server: " + e.getMessage());
            this.logger.warn("Failed to access the server", (Throwable)e);
        }
        catch (RepositoryException e) {
            this.writeError("Failed to access the server: " + e.getMessage());
            this.logger.warn("Failed to access the server", (Throwable)e);
        }
        return false;
    }

    private boolean installNewManager(RepositoryManager newManager, String newManagerID) {
        if (newManagerID.equals(this.managerID)) {
            this.writeln("Already connected to " + this.managerID);
            return true;
        }
        try {
            newManager.initialize();
            this.disconnect(false);
            this.manager = newManager;
            this.managerID = newManagerID;
            this.writeln("Connected to " + this.managerID);
            return true;
        }
        catch (RepositoryException e) {
            this.writeError(e.getMessage());
            this.logger.error("Failed to install new manager", (Throwable)e);
            return false;
        }
    }

    private void printHelpDisconnect() {
        this.writeln("Usage:");
        this.writeln("disconnect   Disconnects from the current set of repositories or server");
    }

    private void disconnect(boolean verbose) {
        if (this.manager != null) {
            this.closeRepository(false);
            this.writeln("Disconnecting from " + this.managerID);
            this.manager.shutDown();
            this.manager = null;
            this.managerID = null;
        } else if (verbose) {
            this.writeln("Already disconnected");
        }
    }

    private void printHelpCreate() {
        this.writeln("Usage:");
        this.writeln("create <template-name>");
        this.writeln("  <template-name>   The name of a repository configuration template");
    }

    private void createRepository(String[] tokens) throws IOException {
        if (tokens.length < 2) {
            this.printHelpCreate();
        } else {
            this.createRepository(tokens[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRepository(String templateName) throws IOException {
        block22: {
            Repository systemRepo = this.manager.getSystemRepository();
            try {
                boolean proceed;
                String template;
                InputStream templateStream;
                String templateFileName = templateName + ".ttl";
                File templatesDir = new File(this.appConfig.getDataDir(), TEMPLATES_DIR);
                File templateFile = new File(templatesDir, templateFileName);
                if (templateFile.exists()) {
                    if (!templateFile.canRead()) {
                        this.writeError("Not allowed to read template file: " + templateFile);
                        return;
                    }
                    templateStream = new FileInputStream(templateFile);
                } else {
                    templateStream = Console.class.getResourceAsStream(templateFileName);
                    if (templateStream == null) {
                        this.writeError("No template called " + templateName + " found in " + templatesDir);
                        return;
                    }
                }
                try {
                    template = IOUtil.readString(new InputStreamReader(templateStream, "UTF-8"));
                }
                finally {
                    templateStream.close();
                }
                ConfigTemplate configTemplate = new ConfigTemplate(template);
                HashMap<String, String> valueMap = new HashMap<String, String>();
                Map<String, List<String>> variableMap = configTemplate.getVariableMap();
                if (!variableMap.isEmpty()) {
                    this.writeln("Please specify values for the following variables:");
                }
                for (Map.Entry<String, List<String>> entry : variableMap.entrySet()) {
                    String var = entry.getKey();
                    List<String> values = entry.getValue();
                    this.write(var);
                    if (values.size() > 1) {
                        this.write(" (");
                        for (int i = 0; i < values.size(); ++i) {
                            if (i > 0) {
                                this.write("|");
                            }
                            this.write(values.get(i));
                        }
                        this.write(")");
                    }
                    if (!values.isEmpty()) {
                        this.write(" [" + values.get(0) + "]");
                    }
                    this.write(": ");
                    String value = this.in.readLine();
                    if (value == null) {
                        return;
                    }
                    if ((value = value.trim()).length() == 0) {
                        value = null;
                    }
                    valueMap.put(var, value);
                }
                String configString = configTemplate.render(valueMap);
                ValueFactory vf = systemRepo.getValueFactory();
                GraphImpl graph = new GraphImpl(vf);
                RDFParser rdfParser = Rio.createParser(RDFFormat.TURTLE, vf);
                rdfParser.setRDFHandler(new StatementCollector(graph));
                rdfParser.parse(new StringReader(configString), "http://www.openrdf.org/config/repository#");
                Resource repositoryNode = GraphUtil.getUniqueSubject(graph, RDF.TYPE, RepositoryConfigSchema.REPOSITORY, new Resource[0]);
                RepositoryConfig repConfig = RepositoryConfig.create(graph, repositoryNode);
                repConfig.validate();
                if (RepositoryConfigUtil.hasRepositoryConfig(systemRepo, repConfig.getID()) && !(proceed = this.askProceed("WARNING: you are about to overwrite the configuration of an existing repository!", false))) {
                    this.writeln("Create aborted");
                    return;
                }
                try {
                    RepositoryConfigUtil.updateRepositoryConfigs(systemRepo, repConfig);
                    this.writeln("Repository created");
                }
                catch (RepositoryReadOnlyException e) {
                    if (this.tryToRemoveLock(e, systemRepo)) {
                        RepositoryConfigUtil.updateRepositoryConfigs(systemRepo, repConfig);
                        this.writeln("Repository created");
                        break block22;
                    }
                    this.writeError("Failed to create repository");
                    this.logger.error("Failed to create repository", (Throwable)e);
                }
            }
            catch (Exception e) {
                this.writeError(e.getMessage());
                this.logger.error("Failed to create repository", (Throwable)e);
            }
        }
    }

    private void printHelpDrop() {
        this.writeln("Usage:");
        this.writeln("drop <repositoryID>   Drops the repository with the specified id");
    }

    private void dropRepository(String[] tokens) throws IOException {
        if (tokens.length < 2) {
            this.printHelpDrop();
            return;
        }
        String id = tokens[1];
        try {
            boolean proceed = this.askProceed("WARNING: you are about to drop repository '" + id + "'.", true);
            if (proceed) {
                boolean isRemoved;
                if (id.equals(this.repositoryID)) {
                    this.closeRepository(false);
                }
                if (isRemoved = this.manager.removeRepositoryConfig(id)) {
                    this.writeln("Dropped repository '" + id + "'");
                } else {
                    this.writeln("Unknown repository '" + id + "'");
                }
            } else {
                this.writeln("Drop aborted");
            }
        }
        catch (RepositoryConfigException e) {
            this.writeError("Unable to drop repository '" + id + "': " + e.getMessage());
            this.logger.warn("Unable to drop repository '" + id + "'", (Throwable)e);
        }
        catch (RepositoryReadOnlyException e) {
            try {
                if (this.tryToRemoveLock(e, this.manager.getSystemRepository())) {
                    this.dropRepository(tokens);
                }
                this.writeError("Failed to drop repository");
                this.logger.error("Failed to drop repository", (Throwable)e);
            }
            catch (RepositoryException e2) {
                this.writeError("Failed to restart system: " + e2.getMessage());
                this.logger.error("Failed to restart system", (Throwable)e2);
            }
        }
        catch (RepositoryException e) {
            this.writeError("Failed to update configuration in system repository: " + e.getMessage());
            this.logger.warn("Failed to update configuration in system repository", (Throwable)e);
        }
    }

    private void printHelpOpen() {
        this.writeln("Usage:");
        this.writeln("open <repositoryID>   Opens the repository with the specified ID");
    }

    private void open(String[] tokens) {
        if (tokens.length != 2) {
            this.printHelpOpen();
        } else {
            this.openRepository(tokens[1]);
        }
    }

    private void openRepository(String id) {
        try {
            Repository newRepository = this.manager.getRepository(id);
            if (newRepository != null) {
                this.closeRepository(false);
                this.repository = newRepository;
                this.repositoryID = id;
                this.writeln("Opened repository '" + id + "'");
            } else {
                this.writeError("Unknown repository: '" + id + "'");
            }
        }
        catch (RepositoryLockedException e) {
            try {
                if (this.tryToRemoveLock(e)) {
                    this.openRepository(id);
                }
                this.writeError("Failed to open repository");
                this.logger.error("Failed to open repository", (Throwable)e);
            }
            catch (IOException e1) {
                this.writeError("Unable to remove lock: " + e1.getMessage());
            }
        }
        catch (RepositoryConfigException e) {
            this.writeError(e.getMessage());
            this.logger.error("Failed to open repository", (Throwable)e);
        }
        catch (RepositoryException e) {
            this.writeError(e.getMessage());
            this.logger.error("Failed to open repository", (Throwable)e);
        }
    }

    private void printHelpClose() {
        this.writeln("Usage:");
        this.writeln("close   Closes the current repository");
    }

    private void close(String[] tokens) {
        if (tokens.length != 1) {
            this.printHelpClose();
        } else {
            this.closeRepository(true);
        }
    }

    private void closeRepository(boolean verbose) {
        if (this.repository != null) {
            this.writeln("Closing repository '" + this.repositoryID + "'...");
            this.repository = null;
            this.repositoryID = null;
        } else if (verbose) {
            this.writeln("There are no open repositories that can be closed");
        }
    }

    private void printHelpShow() {
        this.writeln("Usage:");
        this.writeln("show {r, repositories}   Shows all available repositories");
        this.writeln("show {n, namespaces}     Shows all namespaces");
        this.writeln("show {c, contexts}       Shows all context identifiers");
    }

    private void show(String[] tokens) {
        if (tokens.length != 2) {
            this.printHelpShow();
        } else {
            String target = tokens[1].toLowerCase(Locale.ENGLISH);
            if ("repositories".equals(target) || "r".equals(target)) {
                this.showRepositories();
            } else if ("namespaces".equals(target) || "n".equals(target)) {
                this.showNamespaces();
            } else if ("contexts".equals(target) || "c".equals(target)) {
                this.showContexts();
            } else {
                this.writeError("Unknown target '" + tokens[1] + "'");
            }
        }
    }

    private void showRepositories() {
        block7: {
            try {
                Set<String> repIDs = this.manager.getRepositoryIDs();
                if (repIDs.isEmpty()) {
                    this.writeln("--no repositories found--");
                    break block7;
                }
                this.writeln("+----------");
                for (String repID : repIDs) {
                    this.write("|" + repID);
                    try {
                        RepositoryInfo repInfo = this.manager.getRepositoryInfo(repID);
                        if (repInfo.getDescription() != null) {
                            this.write(" (\"" + repInfo.getDescription() + "\")");
                        }
                    }
                    catch (RepositoryException e) {
                        this.write(" [ERROR: " + e.getMessage() + "]");
                    }
                    this.writeln();
                }
                this.writeln("+----------");
            }
            catch (RepositoryException e) {
                this.writeError("Failed to get repository list: " + e.getMessage());
                this.logger.error("Failed to get repository list", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showNamespaces() {
        if (this.repository == null) {
            this.writeError("please open a repository first");
            return;
        }
        try {
            RepositoryConnection con = this.repository.getConnection();
            try {
                RepositoryResult<Namespace> namespaces = con.getNamespaces();
                try {
                    if (namespaces.hasNext()) {
                        this.writeln("+----------");
                        while (namespaces.hasNext()) {
                            Namespace ns = (Namespace)namespaces.next();
                            this.writeln("|" + ns.getPrefix() + "  " + ns.getName());
                        }
                        this.writeln("+----------");
                    } else {
                        this.writeln("--no namespaces found--");
                    }
                }
                finally {
                    namespaces.close();
                }
            }
            finally {
                con.close();
            }
        }
        catch (RepositoryException e) {
            this.writeError(e.getMessage());
            this.logger.error("Failed to show namespaces", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showContexts() {
        if (this.repository == null) {
            this.writeError("please open a repository first");
            return;
        }
        try {
            RepositoryConnection con = this.repository.getConnection();
            try {
                RepositoryResult<Resource> contexts = con.getContextIDs();
                try {
                    if (contexts.hasNext()) {
                        this.writeln("+----------");
                        while (contexts.hasNext()) {
                            Resource context = (Resource)contexts.next();
                            this.writeln("|" + context.toString());
                        }
                        this.writeln("+----------");
                    } else {
                        this.writeln("--no contexts found--");
                    }
                }
                finally {
                    contexts.close();
                }
            }
            finally {
                con.close();
            }
        }
        catch (RepositoryException e) {
            this.writeError(e.getMessage());
            this.logger.error("Failed to show contexts", (Throwable)e);
        }
    }

    private void printHelpLoad() {
        this.writeln("Usage:");
        this.writeln("load <file-or-url> [from <base-uri>] [into <context-id>]");
        this.writeln("  <file-or-url>   The path or URL identifying the data file");
        this.writeln("  <base-uri>      The base URI to use for resolving relative references, defaults to <file-or-url>");
        this.writeln("  <context-id>    The ID of the context to add the data to, e.g. foo:bar or _:n123");
        this.writeln("Loads the specified data file into the current repository");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(String[] tokens) {
        if (this.repository == null) {
            this.writeError("please open a repository first");
            return;
        }
        if (tokens.length < 2) {
            this.printHelpLoad();
            return;
        }
        String dataPath = tokens[1];
        URL dataURL = null;
        File dataFile = null;
        String baseURI = null;
        String context = null;
        int i = 2;
        if (tokens.length >= i + 2 && tokens[i].equalsIgnoreCase("from")) {
            baseURI = tokens[i + 1];
            i += 2;
        }
        if (tokens.length >= i + 2 && tokens[i].equalsIgnoreCase("into")) {
            context = tokens[tokens.length - 1];
            i += 2;
        }
        if (i < tokens.length) {
            this.printHelpLoad();
            return;
        }
        try {
            dataURL = new URL(dataPath);
        }
        catch (MalformedURLException e) {
            dataFile = new File(dataPath);
        }
        try {
            Resource[] contexts = new Resource[]{};
            if (context != null) {
                Resource contextURI = context.startsWith("_:") ? this.repository.getValueFactory().createBNode(context.substring(2)) : this.repository.getValueFactory().createURI(context);
                contexts = new Resource[]{contextURI};
            }
            RDFFormat format = Rio.getParserFormatForFileName(dataPath, RDFFormat.RDFXML);
            this.writeln("Loading data...");
            long startTime = System.nanoTime();
            RepositoryConnection con = this.repository.getConnection();
            try {
                if (dataURL != null) {
                    con.add(dataURL, baseURI, format, contexts);
                } else {
                    con.add(dataFile, baseURI, format, contexts);
                }
            }
            finally {
                con.close();
            }
            long endTime = System.nanoTime();
            this.writeln("Data has been added to the repository (" + (endTime - startTime) / 1000000L + " ms)");
        }
        catch (RepositoryReadOnlyException e) {
            try {
                if (this.tryToRemoveLock(e, this.repository)) {
                    this.load(tokens);
                }
                this.writeError("Failed to load data");
                this.logger.error("Failed to load data", (Throwable)e);
            }
            catch (RepositoryException e1) {
                this.writeError("Unable to restart repository: " + e1.getMessage());
                this.logger.error("Unable to restart repository", (Throwable)e1);
            }
            catch (IOException e1) {
                this.writeError("Unable to remove lock: " + e1.getMessage());
            }
        }
        catch (MalformedURLException e) {
            this.writeError("Malformed URL: " + dataPath);
        }
        catch (IllegalArgumentException e) {
            this.writeError(e.getMessage());
        }
        catch (IOException e) {
            this.writeError("Failed to load data: " + e.getMessage());
        }
        catch (UnsupportedRDFormatException e) {
            this.writeError("No parser available for this RDF format");
        }
        catch (RDFParseException e) {
            this.writeError("Malformed document: " + e.getMessage());
        }
        catch (RepositoryException e) {
            this.writeError("Unable to add data to repository: " + e.getMessage());
            this.logger.error("Failed to add data to repository", (Throwable)e);
        }
    }

    private void printHelpVerify() {
        this.writeln("Usage:");
        this.writeln("verify <file-or-url>");
        this.writeln("  <file-or-url>   The path or URL identifying the data file");
        this.writeln("Verifies the validity of the specified data file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verify(String[] tokens) {
        if (tokens.length != 2) {
            this.printHelpVerify();
            return;
        }
        String dataPath = tokens[1];
        try {
            new URL(dataPath);
        }
        catch (MalformedURLException e) {
            dataPath = "file:" + dataPath;
        }
        try {
            URL dataURL = new URL(dataPath);
            RDFFormat format = Rio.getParserFormatForFileName(dataPath, RDFFormat.RDFXML);
            this.writeln("RDF Format is " + format.getName());
            RDFParser parser = Rio.createParser(format);
            VerificationListener listener = new VerificationListener();
            parser.setDatatypeHandling(RDFParser.DatatypeHandling.VERIFY);
            parser.setVerifyData(true);
            parser.setParseErrorListener(listener);
            parser.setRDFHandler(listener);
            this.writeln("Verifying data...");
            InputStream in = dataURL.openStream();
            try {
                parser.parse(in, "urn://openrdf.org/RioVerifier/");
            }
            finally {
                in.close();
            }
            int warnings = listener.getWarnings();
            int errors = listener.getErrors();
            int statements = listener.getStatements();
            if (warnings + errors > 0) {
                this.writeln("Found " + warnings + " warnings and " + errors + " errors");
            } else {
                this.writeln("Data verified, no errors were found");
            }
            if (errors == 0) {
                this.writeln("File contains " + statements + " statements");
            }
        }
        catch (MalformedURLException e) {
            this.writeError("Malformed URL: " + dataPath);
        }
        catch (IOException e) {
            this.writeError("Failed to load data: " + e.getMessage());
        }
        catch (UnsupportedRDFormatException e) {
            this.writeError("No parser available for this RDF format");
        }
        catch (RDFParseException e) {
        }
        catch (RDFHandlerException e) {
            this.writeError("Unable to verify : " + e.getMessage());
            this.logger.error("Unable to verify data file", (Throwable)e);
        }
    }

    private void printHelpClear() {
        this.writeln("Usage:");
        this.writeln("clear                   Clears the entire repository");
        this.writeln("clear (<uri>|null)...   Clears the specified context(s)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(String[] tokens) {
        if (this.repository == null) {
            this.writeError("please open a repository first");
            return;
        }
        ValueFactory valueFactory = this.repository.getValueFactory();
        Resource[] contexts = new Resource[tokens.length - 1];
        for (int i = 1; i < tokens.length; ++i) {
            String contextID = tokens[i];
            if (contextID.equalsIgnoreCase("null")) {
                contexts[i - 1] = null;
                continue;
            }
            if (contextID.startsWith("_:")) {
                contexts[i - 1] = valueFactory.createBNode(contextID.substring(2));
                continue;
            }
            try {
                contexts[i - 1] = valueFactory.createURI(contextID);
                continue;
            }
            catch (IllegalArgumentException e) {
                this.writeError("illegal URI: " + contextID);
                this.printHelpClear();
                return;
            }
        }
        if (contexts.length == 0) {
            this.writeln("Clearing repository...");
        } else {
            this.writeln("Removing specified contexts...");
        }
        try {
            RepositoryConnection con = this.repository.getConnection();
            try {
                con.clear(contexts);
            }
            finally {
                con.close();
            }
        }
        catch (RepositoryReadOnlyException e) {
            try {
                if (this.tryToRemoveLock(e, this.repository)) {
                    this.clear(tokens);
                }
                this.writeError("Failed to clear repository");
                this.logger.error("Failed to clear repository", (Throwable)e);
            }
            catch (RepositoryException e1) {
                this.writeError("Unable to restart repository: " + e1.getMessage());
                this.logger.error("Unable to restart repository", (Throwable)e1);
            }
            catch (IOException e1) {
                this.writeError("Unable to remove lock: " + e1.getMessage());
            }
        }
        catch (RepositoryException e) {
            this.writeError("Failed to clear repository: " + e.getMessage());
            this.logger.error("Failed to clear repository", (Throwable)e);
        }
    }

    private void evaluateQuery(QueryLanguage ql, String queryString) {
        try {
            queryString = this.addQueryPrefixes(ql, queryString);
            ParsedQuery query = QueryParserUtil.parseQuery(ql, queryString, null);
            if (query instanceof ParsedTupleQuery) {
                this.evaluateTupleQuery(ql, queryString);
            } else if (query instanceof ParsedGraphQuery) {
                this.evaluateGraphQuery(ql, queryString);
            } else if (query instanceof ParsedBooleanQuery) {
                this.evaluateBooleanQuery(ql, queryString);
            } else {
                this.writeError("Unexpected query type");
            }
        }
        catch (UnsupportedQueryLanguageException e) {
            this.writeError("Unsupported query lanaguge: " + ql.getName());
        }
        catch (MalformedQueryException e) {
            this.writeError("Malformed query: " + e.getMessage());
        }
        catch (QueryInterruptedException e) {
            this.writeError("Query interrupted: " + e.getMessage());
            this.logger.error("Query interrupted", (Throwable)e);
        }
        catch (QueryEvaluationException e) {
            this.writeError("Query evaluation error: " + e.getMessage());
            this.logger.error("Query evaluation error", (Throwable)e);
        }
        catch (RepositoryException e) {
            this.writeError("Failed to evaluate query: " + e.getMessage());
            this.logger.error("Failed to evaluate query", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addQueryPrefixes(QueryLanguage ql, String queryString) {
        String result = queryString;
        if (this.repository != null && this.queryPrefix && (QueryLanguage.SERQL.equals(ql) && queryString.toLowerCase().indexOf("using namespace ") == -1 || QueryLanguage.SPARQL.equals(ql) && !queryString.toLowerCase().startsWith("prefix"))) {
            try {
                RepositoryConnection con = this.repository.getConnection();
                try {
                    List<Namespace> namespaces = con.getNamespaces().asList();
                    if (!namespaces.isEmpty()) {
                        StringBuilder namespaceClause = new StringBuilder(512);
                        if (QueryLanguage.SERQL.equals(ql)) {
                            namespaceClause.append(" USING NAMESPACE ");
                            for (Namespace namespace : namespaces) {
                                namespaceClause.append(namespace.getPrefix());
                                namespaceClause.append(" = ");
                                namespaceClause.append("<");
                                namespaceClause.append(SeRQLUtil.encodeString(namespace.getName()));
                                namespaceClause.append(">, ");
                            }
                            namespaceClause.setLength(namespaceClause.length() - 2);
                            result = result + namespaceClause.toString();
                        } else if (QueryLanguage.SPARQL.equals(ql)) {
                            for (Namespace namespace : namespaces) {
                                namespaceClause.append("PREFIX ");
                                namespaceClause.append(namespace.getPrefix());
                                namespaceClause.append(": ");
                                namespaceClause.append("<");
                                namespaceClause.append(SPARQLUtil.encodeString(namespace.getName()));
                                namespaceClause.append("> ");
                            }
                            result = namespaceClause.toString() + result;
                        }
                    }
                }
                finally {
                    con.close();
                }
            }
            catch (RepositoryException e) {
                this.writeError("Error connecting to repository: " + e.getMessage());
                this.logger.error("Error connecting to repository", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateTupleQuery(QueryLanguage ql, String queryString) throws UnsupportedQueryLanguageException, MalformedQueryException, QueryEvaluationException, RepositoryException {
        if (this.repository == null) {
            this.writeError("please open a repository first");
            return;
        }
        RepositoryConnection con = this.repository.getConnection();
        try {
            this.writeln("Evaluating query...");
            long startTime = System.nanoTime();
            ArrayList<Namespace> namespaces = con.getNamespaces().addTo(new ArrayList());
            TupleQueryResult tupleQueryResult = con.prepareTupleQuery(ql, queryString).evaluate();
            try {
                int resultCount = 0;
                List<String> bindingNames = tupleQueryResult.getBindingNames();
                if (bindingNames.isEmpty()) {
                    while (tupleQueryResult.hasNext()) {
                        tupleQueryResult.next();
                        ++resultCount;
                    }
                } else {
                    int columnWidth = (this.consoleWidth - 1) / bindingNames.size() - 3;
                    StringBuilder sb = new StringBuilder(this.consoleWidth);
                    for (String bindingName : bindingNames) {
                        sb.append("| ").append(bindingName);
                        StringUtil.appendN(' ', columnWidth - bindingName.length(), sb);
                    }
                    sb.append("|");
                    String header = sb.toString();
                    sb.setLength(0);
                    for (int i = bindingNames.size(); i > 0; --i) {
                        sb.append('+');
                        StringUtil.appendN('-', columnWidth + 1, sb);
                    }
                    sb.append('+');
                    String separatorLine = sb.toString();
                    this.writeln(separatorLine);
                    this.writeln(header);
                    this.writeln(separatorLine);
                    while (tupleQueryResult.hasNext()) {
                        BindingSet bindingSet = (BindingSet)tupleQueryResult.next();
                        ++resultCount;
                        sb.setLength(0);
                        for (String bindingName : bindingNames) {
                            Value value = bindingSet.getValue(bindingName);
                            String valueStr = this.getStringRepForValue(value, namespaces);
                            sb.append("| ").append(valueStr);
                            StringUtil.appendN(' ', columnWidth - valueStr.length(), sb);
                        }
                        sb.append("|");
                        this.writeln(sb.toString());
                    }
                    this.writeln(separatorLine);
                }
                long endTime = System.nanoTime();
                this.writeln(resultCount + " result(s) (" + (endTime - startTime) / 1000000L + " ms)");
            }
            finally {
                tupleQueryResult.close();
            }
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateGraphQuery(QueryLanguage ql, String queryString) throws UnsupportedQueryLanguageException, MalformedQueryException, QueryEvaluationException, RepositoryException {
        if (this.repository == null) {
            this.writeError("please open a repository first");
            return;
        }
        RepositoryConnection con = this.repository.getConnection();
        try {
            this.writeln("Evaluating query...");
            long startTime = System.nanoTime();
            ArrayList<Namespace> namespaces = con.getNamespaces().addTo(new ArrayList());
            GraphQueryResult queryResult = con.prepareGraphQuery(ql, queryString).evaluate();
            try {
                int resultCount = 0;
                while (queryResult.hasNext()) {
                    Statement st = (Statement)queryResult.next();
                    ++resultCount;
                    this.write(this.getStringRepForValue(st.getSubject(), namespaces));
                    this.write("   ");
                    this.write(this.getStringRepForValue(st.getPredicate(), namespaces));
                    this.write("   ");
                    this.write(this.getStringRepForValue(st.getObject(), namespaces));
                    this.writeln();
                }
                long endTime = System.nanoTime();
                this.writeln(resultCount + " results (" + (endTime - startTime) / 1000000L + " ms)");
            }
            finally {
                queryResult.close();
            }
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateBooleanQuery(QueryLanguage ql, String queryString) throws UnsupportedQueryLanguageException, MalformedQueryException, QueryEvaluationException, RepositoryException {
        if (this.repository == null) {
            this.writeError("please open a repository first");
            return;
        }
        RepositoryConnection con = this.repository.getConnection();
        try {
            this.writeln("Evaluating query...");
            long startTime = System.nanoTime();
            boolean booleanQueryResult = con.prepareBooleanQuery(ql, queryString).evaluate();
            this.writeln("Answer: " + booleanQueryResult);
            long endTime = System.nanoTime();
            this.writeln("Query evaluated in " + (endTime - startTime) / 1000000L + " ms");
        }
        finally {
            con.close();
        }
    }

    private String getPrefixForNamespace(String namespace, Collection<Namespace> namespaces) {
        for (Namespace ns : namespaces) {
            if (!namespace.equals(ns.getName())) continue;
            return ns.getPrefix();
        }
        return null;
    }

    private String getStringRepForValue(Value value, Collection<Namespace> namespaces) {
        if (value == null) {
            return "";
        }
        if (this.showPrefix && value instanceof URI) {
            URI uri = (URI)value;
            String prefix = this.getPrefixForNamespace(uri.getNamespace(), namespaces);
            if (prefix != null) {
                return prefix + ":" + uri.getLocalName();
            }
            return NTriplesUtil.toNTriplesString(value);
        }
        return NTriplesUtil.toNTriplesString(value);
    }

    private void printHelpSet() {
        this.writeln("Usage:");
        this.writeln("set                            Shows all parameter values");
        this.writeln("set width=<number>             Set the width for query result tables");
        this.writeln("set log=<level>                Set the logging level (none, error, warning, info or debug)");
        this.writeln("set showPrefix=<true|false>    Toggles use of prefixed names in query results");
        this.writeln("set queryPrefix=<true|false>   Toggles automatic use of known namespace prefixes in queries (warning: buggy!)");
    }

    private void setParameter(String[] tokens) {
        if (tokens.length == 1) {
            this.showParameters();
        } else if (tokens.length == 2) {
            String value;
            String key;
            String param = tokens[1];
            int eqIdx = param.indexOf(61);
            if (eqIdx == -1) {
                key = param;
                value = null;
            } else {
                key = param.substring(0, eqIdx);
                value = param.substring(eqIdx + 1);
            }
            this.setParameter(key, value);
        } else {
            this.printHelpSet();
        }
    }

    private void showParameters() {
        this.setLog(null);
        this.setWidth(null);
        this.setShowPrefix(null);
        this.setQueryPrefix(null);
    }

    private void setParameter(String key, String value) {
        if ("log".equals(key = key.toLowerCase(Locale.ENGLISH))) {
            this.setLog(value);
        } else if ("width".equals(key)) {
            this.setWidth(value);
        } else if ("showprefix".equals(key)) {
            this.setShowPrefix(value);
        } else if ("queryprefix".equals(key)) {
            this.setQueryPrefix(value);
        } else {
            this.writeError("unknown parameter: " + key);
        }
    }

    private void setWidth(String value) {
        if (value == null) {
            this.writeln("width: " + this.consoleWidth);
        } else {
            try {
                int width = Integer.parseInt(value);
                if (width > 0) {
                    this.consoleWidth = width;
                } else {
                    this.writeError("Width must be larger than 0");
                }
            }
            catch (NumberFormatException e) {
                this.writeError("Width must be a positive number");
            }
        }
    }

    private void setLog(String value) {
        if (value == null) {
            Level currentLevel = this.jdkRootLogger.getLevel();
            String levelString = currentLevel.getName();
            for (Map.Entry<String, Level> entry : LOG_LEVELS.entrySet()) {
                if (!entry.getValue().equals(currentLevel)) continue;
                levelString = entry.getKey();
                break;
            }
            this.writeln("log: " + levelString);
        } else {
            Level logLevel = LOG_LEVELS.get(value.toLowerCase());
            if (logLevel != null) {
                this.jdkRootLogger.setLevel(logLevel);
            } else {
                this.writeError("unknown logging level: " + value);
            }
        }
    }

    private void setShowPrefix(String value) {
        if (value == null) {
            this.writeln("showPrefix: " + this.showPrefix);
        } else {
            this.showPrefix = Boolean.parseBoolean(value);
        }
    }

    private void setQueryPrefix(String value) {
        if (value == null) {
            this.writeln("queryPrefix: " + this.queryPrefix);
        } else {
            this.queryPrefix = Boolean.parseBoolean(value);
        }
    }

    private boolean tryToRemoveLock(RepositoryReadOnlyException e, Repository repo) throws IOException, RepositoryException {
        boolean lockRemoved = false;
        DirectoryLockManager lockManager = new DirectoryLockManager(repo.getDataDir());
        if (lockManager.isLocked() && this.askProceed("WARNING: The lock from another process on this repository needs to be removed", true)) {
            repo.shutDown();
            lockRemoved = lockManager.revokeLock();
            repo.initialize();
        }
        return lockRemoved;
    }

    private boolean tryToRemoveLock(RepositoryLockedException e) throws IOException {
        SailLockedException sle;
        LockManager lockManager;
        boolean lockRemoved = false;
        if (e.getCause() instanceof SailLockedException && (lockManager = (sle = (SailLockedException)e.getCause()).getLockManager()) != null && lockManager.isLocked() && this.askProceed("WARNING: The lock from process '" + sle.getLockedBy() + "' on this repository needs to be removed", true)) {
            lockRemoved = lockManager.revokeLock();
        }
        return lockRemoved;
    }

    private boolean askProceed(String msg, boolean defaultValue) throws IOException {
        String reply;
        String defaultString = defaultValue ? "yes" : "no";
        do {
            this.writeln(msg);
            this.write("Proceed? (yes|no) [" + defaultString + "]: ");
            reply = this.in.readLine();
            if ("no".equalsIgnoreCase(reply) || "no.".equalsIgnoreCase(reply)) {
                return false;
            }
            if (!"yes".equalsIgnoreCase(reply) && !"yes.".equalsIgnoreCase(reply)) continue;
            return true;
        } while (reply.trim().length() != 0);
        return defaultValue;
    }

    private String readMultiLineInput() throws IOException {
        if (this.repositoryID != null) {
            this.write(this.repositoryID);
        }
        this.write("> ");
        String line = this.in.readLine();
        if (line == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(256);
        buf.append(line);
        while (line != null && !line.endsWith(".")) {
            line = this.in.readLine();
            buf.append('\n');
            buf.append(line);
        }
        buf.setLength(buf.length() - 1);
        return buf.toString().trim();
    }

    private void write(String s) {
        this.out.print(s);
    }

    private void writeln() {
        this.out.println();
    }

    private void writeln(String s) {
        this.out.println(s);
    }

    private void writeError(String errMsg) {
        this.writeln("ERROR: " + errMsg);
    }

    private void writeParseError(String prefix, int lineNo, int colNo, String msg) {
        StringBuilder sb = new StringBuilder(256);
        sb.append(prefix);
        sb.append(": ");
        sb.append(msg);
        String locationString = RDFParseException.getLocationString(lineNo, colNo);
        if (locationString.length() > 0) {
            sb.append(" ").append(locationString);
        }
        this.writeln(sb.toString());
    }

    static {
        LinkedHashMap<String, Level> logLevels = new LinkedHashMap<String, Level>();
        logLevels.put("none", Level.OFF);
        logLevels.put("error", Level.SEVERE);
        logLevels.put("warning", Level.WARNING);
        logLevels.put("info", Level.INFO);
        logLevels.put("debug", Level.FINE);
        LOG_LEVELS = Collections.unmodifiableMap(logLevels);
    }

    class VerificationListener
    extends RDFHandlerBase
    implements ParseErrorListener {
        private int warnings;
        private int errors;
        private int statements;

        VerificationListener() {
        }

        public int getWarnings() {
            return this.warnings;
        }

        public int getErrors() {
            return this.errors;
        }

        public int getStatements() {
            return this.statements;
        }

        public void handleStatement(Statement st) throws RDFHandlerException {
            ++this.statements;
        }

        public void warning(String msg, int lineNo, int colNo) {
            ++this.warnings;
            Console.this.writeParseError("WARNING", lineNo, colNo, msg);
        }

        public void error(String msg, int lineNo, int colNo) {
            ++this.errors;
            Console.this.writeParseError("ERROR", lineNo, colNo, msg);
        }

        public void fatalError(String msg, int lineNo, int colNo) {
            ++this.errors;
            Console.this.writeParseError("FATAL ERROR", lineNo, colNo, msg);
        }
    }
}

