#!/usr/bin/python
# Solfege - ear training for GNOME
# Copyright (C) 2007 Tom Cato Amundsen
# License is GPL, see file COPYING

import src.i18n
src.i18n.setup(".")
import mpd

header = """
header {
  lesson_id = "generated-hear-tones-%s"
  title = %s
  module = singanswer
  version = "3.9.2"
}
"""

def write_file_copyright(f):
    print >> f, "# Solfege - ear training for GNOME"
    print >> f, "# Copyright (C) 2007 Tom Cato Amundsen"
    print >> f, "# License is GPL, see file COPYING"
    print >> f, "# Generated by tools/generate_lessonfiles.py"

def question(f, b, c):
    low = 60
    tone_a = mpd.MusicalPitch.new_from_int(low)
    tone_b = mpd.MusicalPitch.new_from_int(low + b)
    tone_c = mpd.MusicalPitch.new_from_int(low + c)
    print >> f, 'question {'
    print >> f, '  question_text = _("Sing the three tones")'
    print >> f, '  music = voice("< %s2 %s %s >")' % (
        (tone_a.get_octave_notename(),
         tone_b.get_octave_notename(),
         tone_c.get_octave_notename()))
    print >> f, '  answer = voice("%s8 %s %s")' % (
        (tone_a.get_octave_notename(),
         tone_b.get_octave_notename(),
         tone_c.get_octave_notename()))
    print >> f, '}'

def three_tones_less_than_octave(filename):
    """3 toner innenfor en oktav
    0 1 2-12
    0 2 3-12
    0 3 4-12
    0 10 11-12
    0 11 12
    a  b  c
    """
    f = open(filename, 'w')
    write_file_copyright(f)
    f.write("""header {
  lesson_id = "80cc940b-c47b-4264-a7b5-6cbd7a997bb0"
  title = _("Triads")
  module = singanswer
  version = "3.9.2"
}
""")
    for b in range(1, 12):
        for c in range(b + 1, 13):
            question(f, b, c)
    f.close()


def three_tones_larger_than_octave(filename):
    """3 toner innenfor en oktav
    0 1  13-24      13==cis  24=c
    0 2  13-24
    0 11 13-24
    0 12 13-24    c c cis-c

   #0 12 13-24
    0 13 14-24
    0 14 15-24
    0 22 23-24
    0 23    24
    a  b  c
    """
    f = open(filename, 'w')
    write_file_copyright(f)
    f.write("""header {
  lesson_id = "3f1c7305-9978-4fe3-9bb3-8c01ff776a08"
  title = _("Triads, difficult")
  module = singanswer
  version = "3.9.2"
}
""")
    for b in range(1, 13):
        for c in range(13, 25):
            question(f, b, c)
    for b in range(13, 24):
        for c in range(b+1, 25):
            question(f, b, c)
    f.close()

three_tones_less_than_octave("lesson-files/hear-tones-triads")
three_tones_larger_than_octave("lesson-files/hear-tones-triads-difficult")
