/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*-
 *
 * Copyright (C) 2007 Novell, Inc.
 * Copyright (C) 2008 Red Hat, Inc.
 * Copyright (C) 2008 William Jon McCann <jmccann@redhat.com>
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 * Authors:
 *	Michael Terry <michael.terry@canonical.com>
 *      (with generous copying from gnome-session's gsm-manager.c)
 */

#include "config.h"
#include <devkit-power-gobject/devicekit-power.h>
#include <gtk/gtk.h>
#include "gsm-consolekit.h"
#include "gsm-logout-dialog.h"

static gboolean
do_hibernate(gpointer data)
{
        DkpClient *dkp_client;
        gboolean ret;
        GError *error = NULL;

        dkp_client = dkp_client_new ();
        ret = dkp_client_hibernate (dkp_client, &error);
        if (!ret) {
                g_warning ("Unexpected hibernate failure: %s",
                           error->message);
                g_error_free (error);
        }

        gtk_main_quit();
        return FALSE;
}

static gboolean
do_suspend(gpointer data)
{
        DkpClient *dkp_client;
        gboolean ret;
        GError *error = NULL;

        dkp_client = dkp_client_new ();
        ret = dkp_client_suspend (dkp_client, &error);
        if (!ret) {
                g_warning ("Unexpected suspend failure: %s",
                           error->message);
                g_error_free (error);
                }

        gtk_main_quit();
        return FALSE;

}

static void
logout_dialog_response (GsmLogoutDialog *logout_dialog,
                        guint            response_id,
                        gpointer         data)
{
        GError *error = NULL;
        gboolean ret;
        GsmConsolekit *consolekit;
        DkpClient *dkp_client;

        g_debug ("simple-shutdown: Logout dialog response: %d", response_id);

        if (response_id != GTK_RESPONSE_HELP)
                gtk_widget_destroy (GTK_WIDGET (logout_dialog));

        switch (response_id) {
        case GTK_RESPONSE_CANCEL:
        case GTK_RESPONSE_NONE:
        case GTK_RESPONSE_DELETE_EVENT:
                gtk_main_quit();
                break;
        case GSM_LOGOUT_RESPONSE_HIBERNATE:
                //do this as g_idle_add otherwise dialog does not
                //disappear
                g_idle_add(do_hibernate, logout_dialog);
                break;
        case GSM_LOGOUT_RESPONSE_SLEEP:
                //do this as g_idle_add otherwise dialog does not
                //disappear
                g_idle_add(do_suspend, logout_dialog);
                break;
        case GSM_LOGOUT_RESPONSE_SHUTDOWN:
                consolekit = gsm_get_consolekit ();
                gsm_consolekit_attempt_stop (consolekit);
                break;
        case GSM_LOGOUT_RESPONSE_REBOOT:
                consolekit = gsm_get_consolekit ();
                gsm_consolekit_attempt_restart (consolekit);
                break;
        case GSM_LOGOUT_RESPONSE_REBOOT_WINDOWS:
                system("sudo winboot-reboot");
                break;
        default:
                g_assert_not_reached ();
                break;
        }
}

void show_dialog()
{
        GtkWidget *dialog;

        dialog = gsm_get_shutdown_dialog(gdk_screen_get_default(),
                                         GDK_CURRENT_TIME);

        g_signal_connect(dialog,
                         "response",
                         G_CALLBACK(logout_dialog_response),
                         NULL);

        gtk_widget_show(dialog);
}

int main(int argc, char **argv)
{
#ifdef ENABLE_NLS
	gtk_set_locale();
	bindtextdomain(GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
	textdomain(GETTEXT_PACKAGE);
#endif

	gtk_init(&argc, &argv);
        show_dialog();
        gtk_main();
}
