/*
 * This file is part of signon-plugin-google
 *
 * Copyright (C) 2011 Canonical Ltd.
 *
 * Contact: Alberto Mardegan <alberto.mardegan@canonical.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef SIGNON_CLIENT_LOGIN_DATA_H
#define SIGNON_CLIENT_LOGIN_DATA_H

#include <sessiondata.h>

class GooglePluginTest;

namespace GooglePlugin {

/*!
 * @class OAuth2PluginData
 * Data container to hold values for OAuth 2.0 authentication session.
 */
class ClientLoginData: public SignOn::SessionData
{
    friend class ::GooglePluginTest;
public:
    /*!
     * Action URL. If not specified,
     * "https://www.google.com/accounts/ClientLogin" will be used.
     */
    SIGNON_SESSION_DECLARE_PROPERTY(QString, ActionUrl);

    /*!
     * Account type:
     * - GOOGLE (get authorization for a Google account only)
     * - HOSTED (get authorization for a hosted account only)
     * - HOSTED_OR_GOOGLE (get authorization first for a hosted account; if
     *   attempt fails, get authorization for a Google account)
     *
     * If not specified, "HOSTED_OR_GOOGLE" will be used.
     */
    SIGNON_SESSION_DECLARE_PROPERTY(QString, AccountType);

    /*!
     * Name of the Google service you're requesting authorization for.
     */
    SIGNON_SESSION_DECLARE_PROPERTY(QString, Service);

    /*!
     * Short string identifying your application, for logging purposes.
     * This string should take the form:
     * "companyName-applicationName-versionID".
     */
    SIGNON_SESSION_DECLARE_PROPERTY(QString, Source);

    /*!
     * Token representing the specific CAPTCHA challenge. For internal use.
     */
    SIGNON_SESSION_DECLARE_PROPERTY(QString, LoginToken);

    /*!
     * String entered by the user as an answer to a CAPTCHA challenge. For
     * internal use.
     */
    SIGNON_SESSION_DECLARE_PROPERTY(QString, LoginCaptcha);
};

class ClientLoginTokenData: public SignOn::SessionData
{
public:
    /*!
     * Authorization token (response).
     */
    SIGNON_SESSION_DECLARE_PROPERTY(QString, AuthToken);
};

} // namespace GooglePlugin

#endif // SIGNON_CLIENT_LOGIN_DATA_H
