/*
 * SearchPRGMRequ.cpp
 *
 *  Created on: 2008-9-16
 *      Author: stanley
 */

#ifdef _DEBUG
#include <list>
#include <string>
#endif

#include "SESOperator.h"
#include "StudentMgr.h"
#include "CSESLog.h"
#include "LibSESDataCommon.h"
using namespace std;
using namespace LibSESData;
CSearchPRGMRequ::CSearchPRGMRequ()
{
	//pStudentMgr = CStudentMgr::instance();
	//iCount = 0;

}

CSearchPRGMRequ::~CSearchPRGMRequ()
{
	m_SearchResult.Save2File(LibSESData::CONFIG_FILE_DIR + LibSESData::SEARCH_RESULT);
	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_PROGRAMSEARCH, "CSearchPRGMRequ::~CSearchPRGMRequ -- All finished!");
}

bool CSearchPRGMRequ::SendRequ(CIntfData& myData)
{
	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_PROGRAMSEARCH, "CSearchPRGMRequ::SendRequ >>Start!");
#ifdef _DEBUG
	string temp;
	myData.toString(temp);
	cout << "from search operator:" << temp << endl;
#endif
	//myData.GetMessage(MessageName);
	//sentMsg = new CIntfData();
	//*sentMsg = myData;
	CIntfData cIntfData;
	pStudentMgr->GetStudentList(cIntfData);
	std::list<StudentInfo_t> studentList;
	cIntfData.ParaXmlDoc.getStudentInfoList(studentList);

	if ( 0 == studentList.size() )
	{
		Disconnect("");
		return false;
	}

	myData.GetOperationID(OperationID);
	myData.ParaXmlDoc.getInt("Option", m_Option);

	if( PROGRAMSEARCH_APPEND == m_Option )
	{
		m_SearchResult.LoadFromFile(LibSESData::CONFIG_FILE_DIR + LibSESData::SEARCH_RESULT);
	}
	else
	{
		m_SearchResult.Save2File(LibSESData::CONFIG_FILE_DIR + LibSESData::SEARCH_RESULT);
	}


	list<StudentInfo_t>::iterator ir;
	list<StudentInfo_t>::iterator para_begin = studentList.begin();
	list<StudentInfo_t>::iterator para_end = studentList.end();

	for (ir = para_begin; ir != para_end; ir++)
	{
		myData.SetStudentID((ir->studentID));
		m_StudentIDList.push_back(ir->studentID);
		pStudentMgr->Send(myData);
/*		if (pStudentMgr->Send(myData))
			iCount++;
*/	}

	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_PROGRAMSEARCH, "CSearchPRGMRequ::SendRequ >>End!");
	return true;
/*	if (0 != iCount)
	{
		return true;
	}
	else
	{
		return false;
	}
*/
}

bool CSearchPRGMRequ::RecvResp(CIntfData& myData)
{
/*	int bFinished;
	myData.ParaXmlDoc.getInt("bFinished", bFinished);

	if (1 == bFinished)
	{
		iCount--;
	}else
	{
		return false;
	}*/
	std::string studentID;
	myData.GetStudentID(studentID);

	string programsXML;
	myData.ParaXmlDoc.getString("programsXML", programsXML);

	if (programsXML.size() > 0)
	{
		m_SearchResult.AddApplications(programsXML);
	}

	myData.ParaXmlDoc.clear();
	myData.ParaXmlDoc.setString("programsXML", "");

	return filter(studentID);
}

int CSearchPRGMRequ::GetOperationID()
{
	return OperationID;

}
bool CSearchPRGMRequ::filter(std::string studentID)
{
	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_PROGRAMSEARCH, "CSearchPRGMRequ::filter--Get Reply from network, StudentID = "+ studentID);
	if(true == studentID.empty())
	{
		return false;
	}
	list<std::string>::iterator ir;
	list<std::string>::iterator para_begin = m_StudentIDList.begin();
	list<std::string>::iterator para_end = m_StudentIDList.end();

	for (ir = para_begin; ir != para_end; ir++)
	{

	cout << "CSearchPRGMRequ::filter->studentID = "  << (*ir) << endl;
		if(0 == (*ir).compare(studentID)){
			m_StudentIDList.erase(ir);
			break;
		}
	}
	return m_StudentIDList.empty();

}
bool CSearchPRGMRequ::Disconnect(std::string studentID)
{
//	CIntfData* myData = new CIntfData();
//	myData->SetMessage(TEACHER_SEARCHPROGRAMCALLBACK);
//	//int id;
//	//sentMsg->GetOperationID(id);
//	//myData->SetOperationID(id);
//	//std::string str;
//	//sentMsg->GetStudentID(str);
//	myData->SetStudentID(studentID);
//	//sentMsg->ParaXmlDoc.clear();
//	myData->SetResult(SES_API_FAILURE);
	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_PROGRAMSEARCH, "Disconnect IPCTeacherDaemonAPI::SendMsg --Send Msg to Dbus >>Start!");
//	TeacherDaemonAPI->SendMsg(myData);
	TeacherDaemonAPI->SearchProgramCallBack(studentID, "", SES_API_FAILURE);
	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_PROGRAMSEARCH, "Disconnect IPCTeacherDaemonAPI::SendMsg --Send Msg to Dbus >>End!");
//	delete myData;
	return filter(studentID);
}

bool CSearchPRGMRequ::CancelOperation(int OID)
{
	for(list<string>::iterator iter = m_StudentIDList.begin();
	iter!= m_StudentIDList.end();iter++)
	{
		string strStuID = *iter;
		CIntfData data;
		data.SetStudentID(strStuID);
		data.SetOperationID(this->OperationID);
		data.SetMessage(TEACHER_CANCELOPERATION);
		this->pStudentMgr->Send(data);
	}

//	CIntfData* myData = new CIntfData();
//	myData->SetMessage(TEACHER_SEARCHPROGRAMCALLBACK);
//	myData->SetStudentID("");
//	myData->SetResult(SES_API_FAILURE);
	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_PROGRAMSEARCH, "CancelOperation IPCTeacherDaemonAPI::SendMsg --Send Msg to Dbus >>Start!");
//	TeacherDaemonAPI->SendMsg(myData);
	TeacherDaemonAPI->SearchProgramCallBack("", "", SES_API_FAILURE);
	CSESLog::WriteLine(CSESLogData::LOG_TEACHER_PROGRAMSEARCH, "CancelOperation IPCTeacherDaemonAPI::SendMsg --Send Msg to Dbus >>End!");
//	delete myData;

	return true;
}
/*bool CSearchPRGMRequ::isSameStudent(std::string studentID)
{
	list<std::string>::iterator ir;
	list<std::string>::iterator para_begin = StudentIDs.begin();
	list<std::string>::iterator para_end = StudentIDs.end();

	for (ir = para_begin; ir != para_end; ir++)
	{
		if(0 == (*ir).compare(studentID)){
			return true;
		}
	}
	return false;
}
*/
