#ifdef _CONSOLE
#include "IntfData.h"
#endif
#include <cstdio>
#include <signal.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/unistd.h>
#include <sys/select.h>
#include <libsesdata.h>
#include "TSDCommon.h"
#include <libdaemon/dfork.h>
#include <libdaemon/dsignal.h>
#include <libdaemon/dlog.h>
#include <libdaemon/dpid.h>
#include <libdaemon/dexec.h>
#include "SESPublishService.h"
#include "MainFrame.h"
#include "OperationManager.h"
#include "IPCCommonUtil.h"
#include "StudentMgr.h"
#include "NetSSLServerWrapper.h"
#include "RegMgr.h"
using namespace std;
using namespace IPCAPI;
using namespace LibSESData;

#include<unistd.h>
#include<sys/types.h>
#include <sys/stat.h>
#define MAXFILE 65535

#define RUNNING_DIR	"/tmp"
#define LOCK_FILE	"TSD.lock"
#define LOG_FILE	"TSD.log"

#define DAEMONIZE 0
COperationManager* operationManager = NULL;
#if 0
CMainFrame::CMainFrame(const char *prog_name)
{
	char buffer[1024];

	strcpy(buffer, prog_name);//jinxin review 20081005 buffer overflow bug!

	/* Set indetification string for the daemon for both syslog and PID file */
	daemon_pid_file_ident = daemon_log_ident = daemon_ident_from_argv0(buffer);
}

CMainFrame::~CMainFrame()
{
}

void CMainFrame::Usage(const char *prog_name)
{
	fprintf(stderr, "Syntax :\n");
	fprintf(stderr, "	%s start  startup the network daemon\n", prog_name);
	fprintf(stderr, "	%s stop  shutdown the network daemon\n", prog_name);
}

bool CMainFrame::Shutdown()
{
	int ret = 0 ; // jinxin reivew asssign it.

	/* Kill daemon with SIGINT */
	/* Check if the new function daemon_pid_file_kill_wait() is available, if it is, use it. */
	ret = daemon_pid_file_kill_wait(SIGUSR1, 5);
	if (ret < 0)
	{
		daemon_log(LOG_WARNING, "Failed to kill daemon");
	}

	return ret < 0 ? false : true;
}

bool CMainFrame::Startup()
{
	int ret;
	pid_t pid;

	/* Prepare for return value passing from the initialization procedure of the daemon process */
	daemon_retval_init();

	/* Do the fork */
	pid = daemon_fork();
	if (pid < 0)
	{
		/* Exit on error */
		daemon_retval_done();
		return false;
	}
	else if (pid == 0)
	{
		/* The daemon */
		Daemon();
	}

	/* The parent */

	/* Wait for 20 seconds for the return value passed from the daemon process */
	ret = daemon_retval_wait(20);
	if (ret < 0)
	{
		daemon_log(LOG_ERR,
				"Could not recieve return value from daemon process.");
		return false;
	}

	daemon_log(ret != 0 ? LOG_ERR : LOG_INFO,
			"Daemon returned %i as return value.", ret);

	return true;

}

bool CMainFrame::SetupSignal()
{
	int nret;
	/* Initialize signal handling */
	nret = daemon_signal_init(SIGHUP, SIGINT, SIGQUIT,
			//SIGILL,
			//SIGTRAP,
			//SIGABRT,
			//SIGFPE,
			//SIGKILL,
			//SIGBUS,
			//SIGSEGV,
			//SIGSYS,
			//SIGPIPE,
			//SIGALRM,
			//SIGTERM,
			SIGUSR1, SIGUSR2,
			//SIGPOLL,
			//SIGSTOP,
			//SIGTTOU,
			//SIGVTALRM,
			//SIGPROF,
			//SIGXCPU,
			//SIGCHLD,
			0);

	if (nret < 0)
	{
		daemon_log(LOG_ERR, "Could not register signal handlers (%s).",
				strerror(errno));
		return false;
	}

	return true;
}

bool CMainFrame::UnsetupSignal()
{
	daemon_signal_done();
	return true;
}

bool CMainFrame::CatchSignal()
{
	int nret;
	fd_set fds;
	struct timeval WaitTime;
	static int fd = daemon_signal_fd();

	/* Prepare for select() on the signal fd */
	FD_ZERO(&fds);
	FD_SET(fd, &fds);

	WaitTime.tv_sec = 1;
	WaitTime.tv_usec = 0;

	//nret = select(FD_SETSIZE, &fds, 0, 0, 0);
	nret = select(FD_SETSIZE, &fds, 0, 0, &WaitTime);
	if (nret <= 0)
	{
		/* If we've been interrupted by an incoming signal, continue */
		/*
		 if (errno == EINTR)
		 continue;

		 daemon_log(LOG_ERR, "select(): %s", strerror(errno));
		 break;
		 */
		return false;
	}

	/* Check if a signal has been recieved */
	if (!FD_ISSET(fd, &fds))
	return false;

	int sig;
	bool found = false;
	/* Get signal */
	sig = daemon_signal_next();
	if (sig <= 0)
	{
		daemon_log(LOG_ERR, "daemon_signal_next() failed.");
		return false;
	}

	/* Dispatch signal */
	switch (sig)
	{
		case SIGHUP:
		break;
		case SIGINT:
		break;
		case SIGQUIT:
		break;
		//case SIGILL:
		//	break;
		//case SIGTRAP:
		//	break;
		//case SIGABRT:
		//	break;
		//case SIGFPE:
		//	break;
		//case SIGKILL:
		//	break;
		/*case SIGBUS:
		 break;
		 case SIGSEGV:
		 break;*/
		//case SIGSYS:
		//	break;
		//case SIGPIPE:
		//	break;
		//case SIGALRM:
		//	break;
		//case SIGTERM:
		//	break;
		case SIGUSR1:
		found = true;
		break;
		case SIGUSR2:
		break;
		//case SIGPOLL:
		//	break;
		//case SIGSTOP:
		//	break;
		//case SIGTSTP:
		//	break;
		//case SIGTTIN:
		//	break;
		//case SIGTTOU:
		//	break;
		//case SIGVTALRM:
		//	break;
		//case SIGPROF:
		//	break;
		//case SIGXCPU:
		//	break;
		//case SIGCHLD:
		//	break;
	}

	return found;
}

bool CMainFrame::WorkInit()
{
	return true;
}

void CMainFrame::Working()
{
}

void CMainFrame::Daemon()
{
	int quit = 0;

	//add by sunxy 2008-9-17
	//initialize operationManager
	COperationManager* operationManager = new COperationManager();

	if (daemon_close_all(-1) < 0)
	{
		daemon_log(LOG_ERR, "Failed to close all file descriptors: %s",
				strerror(errno));
		goto finish;
	}

	/* Create the PID file */
	if (daemon_pid_file_create() < 0)
	{
		daemon_log(LOG_ERR, "Could not create PID file (%s).", strerror(errno));

		/* Send the error condition to the parent process */
		daemon_retval_send(1);
		goto finish;
	}

	if (SetupSignal() == false)
	{
		daemon_retval_send(2);
		goto finish;
	}

	/*... do some further init work here */
	if (WorkInit() == false)
	{
		daemon_retval_send(2);
		goto finish;
	}

	/* Send OK to parent process */
	daemon_retval_send(0);

	/*  daemon.log   syslog        */
	daemon_log(LOG_INFO, "Sucessfully started ...........");
	/*  daemon.log   syslog        */
	//daemon_log(LOG_ERR, "Sucessfully started .............");


	while (quit == 0)
	{
		if (CatchSignal() == true)
		{
			break;
		}

		operationManager->work();
		Working();
	}

	/* Do a cleanup */
	finish: delete (operationManager);
	daemon_log(LOG_INFO, "Exiting...");
	daemon_retval_send(-1);
	UnsetupSignal();
	daemon_pid_file_remove();

	exit(0);
}

bool CMainFrame::CheckConflict(const char *prog_name)
{
	char ps[512], buf[512];
	bool found = false;
	FILE *ptr;

	//strcpy(ps,"ps -ef | grep -v sh | grep -v grep |grep -v vi | grep -c tsf");
	sprintf(
			ps,
			"ps -ef | grep -v \\\\-csh | grep -v \\\\.sh | grep -v ps | grep -v grep |grep -v vi | grep -c %s",
			prog_name);
	ptr = popen(ps, "r");
	if (ptr != NULL)
	{
		while (fgets(buf, sizeof(buf), ptr) != NULL)
		{
			if (atoi(buf) >= 2)
			{
				found = true;
				break;
			}
		}
		pclose(ptr);
	}
	return found;
}

bool CMainFrame::InitInstance(int argc, char *argv[])
{
	if (argc != 2)
	{
		Usage(argv[0]);
		return false;
	}
	if (strcmp(argv[1], "start") != 0 && strcmp(argv[1], "stop") != 0)
	{
		Usage(argv[0]);
		return false;
	}

	pid_t pid;
	bool bret;

	//fprintf(stderr, "[%s]\n", daemon_pid_file_proc());
	pid = daemon_pid_file_is_running();
	bret = CheckConflict(argv[0]);

	if (strcmp(argv[1], "start") == 0)
	{
		if (pid >= 0)
		{
			daemon_log(LOG_ERR, "Daemon already running on PID file %u", pid);
			return true;
		}
		if (bret == true)
		{
			//naguipeng Review + don't use chinese
			fprintf(stderr, "system had been running\n");
			return true;
		}

		return Startup();
	}
	if (strcmp(argv[1], "stop") == 0)
	{
		if (bret == false)
		{
			// naguipeng Review + don't use chinese
			fprintf(stderr, "system havn't running\n");
			return true;
		}

		return Shutdown();
	}
	return true;
}
#endif

void signal_handler(int sig)
{
	CSESLog::WriteLine("TSD: signal:" + IPCCommonUtil::ParseInt2String(sig));
	IPCAPI::CIntfData cIntfData;
	switch (sig)
	{
	case SIGHUP:
		CSESLog::WriteLine("TSD: SIGHUP");
		operationManager->StopController(&cIntfData);
		operationManager->StartController(&cIntfData);
		break;
	case SIGTERM:
		CSESLog::WriteLine("TSD: SIGTERM");

		operationManager->StopController(&cIntfData);
		exit(0);
		break;
	}
}

void daemonize()
{
	int i, lfp;
	char str[10];
	if (getppid() == 1)
		return; /* already a daemon */
	i = fork();
	if (i < 0)
		exit(1); /* fork error */
	if (i > 0)
		exit(0); /* parent exits */
	/* child (daemon) continues */
	setsid(); /* obtain a new process group */
	for (i = getdtablesize(); i >= 0; --i)
		close(i); /* close all descriptors */
	i = open("/dev/null", O_RDWR);
	dup(i);
	dup(i); /* handle standart I/O */
	umask(027); /* set newly created file permissions */
	chdir(RUNNING_DIR); /* change running directory */
	lfp = open(LOCK_FILE, O_RDWR | O_CREAT, 0640);
	if (lfp < 0)
		exit(1); /* can not open */
	if (lockf(lfp, F_TLOCK, 0) < 0)
		exit(0); /* can not lock */
	/* first instance continues */
	sprintf(str, "%d\n", getpid());
	write(lfp, str, strlen(str)); /* record pid to lockfile */
	signal(SIGCHLD, SIG_IGN); /* ignore child */
	signal(SIGTSTP, SIG_IGN); /* ignore tty signals */
	signal(SIGTTOU, SIG_IGN);
	signal(SIGTTIN, SIG_IGN);
	signal(SIGHUP, signal_handler); /* catch hangup signal */
	signal(SIGTERM, signal_handler); /* catch kill signal */

	///signal(SIGPIPE, SIG_IGN);
}

int main(int argc, char *argv[])
{

#if 0
	CMainFrame theApp(argv[0]);
	theApp.InitInstance(argc, argv);
#endif

#ifdef RELEASE
	daemonize();
#endif

#if 0
	std::string lockPath = SES_BIN_TSD_LOCKFILE;
	if (CSESDataTools::GetLock(lockPath))
	{
#endif
	CSESLog::WriteLine("TSD main()>>Start", CSESLog::TRACE, "TSD");

	operationManager = new COperationManager();

	while (true)
	{
		//ACE_Reactor::instance()->handle_events();
		if (!operationManager->work())
		{
			usleep(100000);
		}
	}
#if 0
}
#endif
	delete operationManager;
	CSESLog::WriteLine("TSD main()<<End", CSESLog::TRACE);

	return 0;
}

//
//		IPCAPI::CIntfData cIntfData;
//		CIntfData bybCIntfData;
//		std::vector<std::string> vectorID;
//		CStudentMgr::instance()->GetStudentIDVector(vectorID);
//
//		//CTeacherInfoData InfoData;
//		//InfoData.LoadFromFile(CONFIG_FILE_DIR + TEACHER_INFO);
//		//InfoData.Save2String(teacherInfoString);
//		operationManager->Publisher->UpdateServiceInfo("1", "1", 11, 13);
//		bybCIntfData.SetMessage(BYE_BYE);
//		CStudentMgr::instance()->KickOffAllStudent(bybCIntfData);
//		//CStudentMgr::instance()->KickOffAllStudent();
//		//operationManager->ImportCertificate(NEWCAPATH, SESPATH);
//		operationManager->ImportCertificate("/home/chenwei/CA111111");
//		operationManager->Verifycertificate();
//		operationManager->Verifycertificate();
//		operationManager->VerifyPassword("111111", "");
//		operationManager->VerifyPassword("111111", "");
//		operationManager->StartController(&cIntfData);
//int iResult;
//	IPCAPI::CIntfData cIntfData;
//	CIntfData bybCIntfData;
//	std::vector<std::string> vectorID;
//	CStudentMgr::instance()->GetStudentIDVector(vectorID);
//
//	//CTeacherInfoData InfoData;
//	//InfoData.LoadFromFile(CONFIG_FILE_DIR + TEACHER_INFO);
//	//InfoData.Save2String(teacherInfoString);
//	operationManager->Publisher->UpdateServiceInfo("1", "1", 11, 13);
//	bybCIntfData.SetMessage(BYE_BYE);
//	CStudentMgr::instance()->KickOffAllStudent(bybCIntfData);
//	//CStudentMgr::instance()->KickOffAllStudent();
//	//operationManager->ImportCertificate(NEWCAPATH, SESPATH);
//	operationManager->ImportCertificate("/home/chenwei/CA111111");
//	operationManager->Verifycertificate();
//	operationManager->Verifycertificate();
//	operationManager->VerifyPassword("111111", "");
//	operationManager->Verifycertificate();
//	operationManager->StartController(&cIntfData);
//	CStudentMgr::instance()->KickOffAllStudent(bybCIntfData);
//	operationManager->Verifycertificate("/home/chenwei/workspace/ConfigFile");
//	operationManager->Verifycertificate("/home/chenwei/workspace/ConfigFile");
//	operationManager->VerifyPassword("123456",
//			"/home/chenwei/workspace/ConfigFile");
//	operationManager->ImportCertificate("/home/chenwei/workspace/ConfigFile");
//	operationManager->Verifycertificate();
//	operationManager->StartController(&cIntfData);
//
//	//These codes will cause rm /etc/SES at TSD start up.
//	/////////////////////////////////////////////
//	//	string cmd("rm -r ");
//	//	cmd.append(NEWCAPATH);
//	//	system(cmd.c_str());
//
//	//		operationManager->Verifycertificate("");
//	//		operationManager->VerifyPassword("333333", "");
//	//		operationManager->StartController(&cIntfData);
//	/////////////////////////////////////////////
//	//
//	int iBack;
//	//	while (true)
//	operationManager->ImportCertificate("/home/chenwei/CA111111");
//
//	iBack = operationManager->VerifyPassword("111111", "");
//	//		RegMgr::instance()->Accept();
//	//		RegMgr::instance()->StopAccept();
//	operationManager->StartController(&cIntfData);
//	operationManager->ImportCertificate("/home/chenwei/workspace/ConfigFile");
//
//	iBack = operationManager->VerifyPassword("123456", "");
//	operationManager->StartController(&cIntfData);
//
//	operationManager->ImportCertificate("/home/chenwei/CA111111");
//
//	iBack = operationManager->VerifyPassword("111111", "");
//	//		RegMgr::instance()->Accept();
//	//		RegMgr::instance()->StopAccept();
//	operationManager->StartController(&cIntfData);
//	operationManager->ImportCertificate("/home/chenwei/workspace/ConfigFile");
//
//	iBack = operationManager->VerifyPassword("123456", "");
//	operationManager->StartController(&cIntfData);
//	//
//	operationManager->ImportCertificate("/home/chenwei/workspace/ConfigFile");


//		RegMgr::instance()->Accept();
//		RegMgr::instance()->StopAccept();
//
//		operationManager->StartController(&cIntfData);
//		operationManager->StartController(&cIntfData);
//		operationManager->StopController(&cIntfData);
//		operationManager->StopController(&cIntfData);
//		//	iBack=operationManager->ChangePassword("222222", "111111");
//
//	}


//int pkgSize = 1;
//char* pData = new char[pkgSize];
///char* pData1 = new char[pkgSize];
//int iipkgSize = sizeof(*pData);
//int iPkgSize = strlen(pData);
//		catch
//		{
//		};
//iipkgSize = sizeof(pkgSize);
//
//	memset(pData, 0, sizeof(pkgSize));
//	printf("pData:%s\npDat1a:%s\n",pData,pData1);
//	memset(pData1, 0, sizeof(pkgSize));
//	pData[0]='1';
//	*(pData++)='2';
//	*(pData++)='3';
//
//	pData1[0]='2';
//	memset(pData, 0, sizeof(pkgSize));
//		printf("pData:%s\npDat1a:%s\n",pData,pData1);
//memset(pData1, 0, sizeof(pkgSize));
//memset(pData, '\0', sizeof(pkgSize));
//	string str("\0\0\0\0asdf\0\n");
//	string str2("\\");
//	str2.append("0");
//	str2.append("\0");
//
//	int iSize = str.size();
//	int iSize2 = str2.size();
//	int i2 = strlen(str2.c_str());
//	int i = strlen(str.c_str());
//			for (int i = 0; i < 3; i++)
//			{
//				ACE_SSL_Context *context = new ACE_SSL_Context();
//
//				if (SSL_CTX_use_certificate_file(context->context(), "/home/chenwei/cert.pem",
//						X509_FILETYPE_PEM) <= 0)
//				{
//					CSESLog::WriteLine("Verifycertificate", CSESLog::ERROR);
//					CSESLog::WriteLine(ACE_OS_String::strerror(errno), CSESLog::WARNING);
//
//				}
//
//				context->context()->default_passwd_callback_userdata = (void*) "123456";
//				if (SSL_CTX_use_PrivateKey_file(context->context(), "/home/chenwei/key.pem",
//						X509_FILETYPE_PEM) <= 0)
//				{
//					CSESLog::WriteLine("context->private_key", CSESLog::ERROR);
//					CSESLog::WriteLine(ACE_OS_String::strerror(errno), CSESLog::WARNING);
//
//				}
//				delete context;
//			}
//		operationManager->ChangePassword("222222", "111111");
//		for (int i = 0; i < 3; i++)
//		{
//			ACE_SSL_Context *context = new ACE_SSL_Context();
//
//			if (SSL_CTX_use_certificate_file(context->context(), CERTIFICATE,
//					X509_FILETYPE_PEM) <= 0)
//			{
//				CSESLog::WriteLine("Verifycertificate", CSESLog::ERROR);
//				CSESLog::WriteLine(ACE_OS_String::strerror(errno), CSESLog::WARNING);
//
//			}
//
//			context->context()->default_passwd_callback_userdata = (void*) "111111";
//			if (SSL_CTX_use_PrivateKey_file(context->context(), PRIVATE_KEY,
//					X509_FILETYPE_PEM) <= 0)
//			{
//				CSESLog::WriteLine("context->private_key", CSESLog::ERROR);
//				CSESLog::WriteLine(ACE_OS_String::strerror(errno), CSESLog::WARNING);
//
//			}
//			delete context;
//		}
//operationManager->ImportCertificate("/etc/SES/ca/");
//operationManager->ChangePassword("123456","");
//CStudentMgr::instance()->SetParameter();
//	if (!(iResult = ACE_Reactor::instance()->initialized()))
//	{
//		CSESLog::WriteLine(
//				CSESLogData::LOG_DEFAULT,
//				"Student::ThreadStart >> ACE_Reactor::instance()->initialized()",
//				"%d-%s", iResult, ACE_OS_String::strerror(errno));
//	}
//
//	CSESLog::WriteLine(iResult, " ACE_Reactor::instance()->initialized():");
//	CSESLog::WriteLine("ACE_OS_String::strerror(errno):");
//	CSESLog::WriteLine(ACE_OS_String::strerror(errno));
//	iResult = ACE_Reactor::instance()->open(MAX_NUMBER_OF_HANDLES);
//	CSESLog::WriteLine("ACE_OS_String::strerror(errno):");
//	CSESLog::WriteLine(ACE_OS_String::strerror(errno));
//	CSESLog::WriteLine(iResult, "  ACE_Reactor::instance()->open():");
//	CSESLog::WriteLine(ACE_Reactor::instance()->close(),
//			"  ACE_Reactor::instance()->close():");
//	CSESLog::WriteLine("ACE_OS_String::strerror(errno):");
//	CSESLog::WriteLine(ACE_OS_String::strerror(errno));
//	ACE_Reactor::instance()->close_singleton();
//	CSESLog::WriteLine("ACE_OS_String::strerror(errno):");
//	CSESLog::WriteLine(ACE_OS_String::strerror(errno));
//
//	if (!(iResult = ACE_Reactor::instance()->initialized()))
//	{
//		CSESLog::WriteLine(
//				CSESLogData::LOG_DEFAULT,
//				"Student::ThreadStart >> ACE_Reactor::instance()->initialized()",
//				"%d-%s", iResult, ACE_OS_String::strerror(errno));
//	}
//
//	CSESLog::WriteLine(iResult, " ACE_Reactor::instance()->initialized():");
//	CSESLog::WriteLine("ACE_OS_String::strerror(errno):");
//	CSESLog::WriteLine(ACE_OS_String::strerror(errno));
//	iResult = ACE_Reactor::instance()->open(MAX_NUMBER_OF_HANDLES);
//	CSESLog::WriteLine("ACE_OS_String::strerror(errno):");
//	CSESLog::WriteLine(ACE_OS_String::strerror(errno));
//	CSESLog::WriteLine(iResult, "  ACE_Reactor::instance()->open():");
//	CSESLog::WriteLine(ACE_Reactor::instance()->close(),
//			"  ACE_Reactor::instance()->close():");
//	CSESLog::WriteLine("ACE_OS_String::strerror(errno):");
//	CSESLog::WriteLine(ACE_OS_String::strerror(errno));
//	ACE_Reactor::instance()->close_singleton();
//	CSESLog::WriteLine("ACE_OS_String::strerror(errno):");
//	CSESLog::WriteLine(ACE_OS_String::strerror(errno));
//	if (!(iResult = ACE_Reactor::instance()->initialized()))
//	{
//		CSESLog::WriteLine(
//				CSESLogData::LOG_DEFAULT,
//				"Student::ThreadStart >> ACE_Reactor::instance()->initialized()",
//				"%d-%s", iResult, ACE_OS_String::strerror(errno));
//	}
//
//	CSESLog::WriteLine(iResult, " ACE_Reactor::instance()->initialized():");
//	CSESLog::WriteLine("ACE_OS_String::strerror(errno):");
//	CSESLog::WriteLine(ACE_OS_String::strerror(errno));
//	iResult = ACE_Reactor::instance()->open(MAX_NUMBER_OF_HANDLES);
//	CSESLog::WriteLine("ACE_OS_String::strerror(errno):");
//	CSESLog::WriteLine(ACE_OS_String::strerror(errno));
//	CSESLog::WriteLine(iResult, "  ACE_Reactor::instance()->open():");
//	ACE_Reactor::instance()->close_singleton();
//	CSESLog::WriteLine(ACE_Reactor::instance()->close(),
//			"  ACE_Reactor::instance()->close():");
//	CSESLog::WriteLine("ACE_OS_String::strerror(errno):");
//	CSESLog::WriteLine(ACE_OS_String::strerror(errno));
//	ACE_Reactor::instance()->close_singleton();
//	CSESLog::WriteLine("ACE_OS_String::strerror(errno):");
//	CSESLog::WriteLine(ACE_OS_String::strerror(errno));

//	iBack = operationManager->VerifyPassword("222222", "");
//	iBack = operationManager->VerifyPassword("111111", "");
//	iBack = operationManager->VerifyPassword("222222", "");
//	iBack = operationManager->VerifyPassword("111111", "");
//	ACE_SSL_Context *pContext =new ACE_SSL_Context();
//	operationManager->StartController(&cIntfData);
//	//CStudentMgr::instance()->Open();
//	RegMgr::instance()->setPassword("111111");
//	RegMgr::instance()->Accept();
//	iBack = operationManager->ChangePassword("111111", "222222");
//	operationManager->StopController(&cIntfData);
//	pContext->~ACE_SSL_Context();
//	//RegMgr::instance()->StopAccept();
//	//CStudentMgr::instance()->Close();
//	iBack = operationManager->VerifyPassword("111111", "");
//	iBack = operationManager->VerifyPassword("222222", "");
//	pContext =new ACE_SSL_Context();
//	operationManager->StartController(&cIntfData);
//	//CStudentMgr::instance()->Open();

//	iBack = operationManager->ChangePassword("222222", "111111");
//	operationManager->StopController(&cIntfData);
//	pContext->~ACE_SSL_Context();
//	//RegMgr::instance()->StopAccept();
//	//CStudentMgr::instance()->Close();
//
//	iBack = operationManager->VerifyPassword("111111", "");
//	iBack = operationManager->VerifyPassword("222222", "");
//	operationManager->StartController(&cIntfData);
//	operationManager->ChangePassword("111111", "222222");

//	operationManager->ChangePassword("222222", "111111");
//SSL_CTX_flush_sessions(ACE_SSL_Context::instance()->context(), 0);
//SSL_CTX_free(ACE_SSL_Context::instance()->context());
//	operationManager->Verifycertificate("");
//	operationManager->VerifyPassword("12!@asAS", "");

////////////
//		CNetSSLServerWrapper cNetSSLServerWrapper;
//		CNetSSLServerWrapper cNetSSLServerWrapper2;
//		CNetSSLClientWrapper* cNetSSLClientWrapper;
//		int nret;
//		if (!cNetSSLServerWrapper.Open() )
//		{
//			CSESLog::WriteLine(errno,ACE_OS_String::strerror(errno));
//		}
//		if (!cNetSSLServerWrapper2.Open() )
//		{
//			CSESLog::WriteLine(errno,ACE_OS_String::strerror(errno));
//			cout<<errno<<endl;
//		}
/////////
//	int iThread = 0;
//	char * pc=argv[1];
//	iThread=atoi(pc);
//memset(&iThread, argv[1], sizeof(int));

//RegMgr::instance()->iThread = iThread;
