/******************************************************************************************
 * File Name  : NetSSLClientWrapper.h                                                     *
 * Created   : 08/09/16                                                                   *
 * Author   : ChenWei                                                                     *
 * Model   : TSD                                                                          *
 * Description  :                                        								  *
 ******************************************************************************************/

#ifndef _NETSSLCLIENTWRAPPER_H_INCLUDED
#define _NETSSLCLIENTWRAPPER_H_INCLUDED

#include <string>
#include <ace/SSL/SSL_SOCK_Connector.h>
#include <ace/Recursive_Thread_Mutex.h>

class CNetSSLClientWrapper
{
public:

	CNetSSLClientWrapper();

	virtual ~CNetSSLClientWrapper();

public:
	// Public Interface
	bool Connect(const std::string &r_ip, int r_port);

	bool Disconnect();



	int Send(const std::string & content, int iTimeout = 0);

	int Send(unsigned char* pucMsg, int iSize, int iTimeout = 0);

	int Recv(std::string &buff, int iTimeout = 0,int iCompress=1);

	bool IsConnect()
	{
		return m_bIsConnect;
	}
	void SetIsConnect(bool bIsConnect)
	{
		m_bIsConnect = bIsConnect;
	}

	void GetErrInfo(std::string& errMsg);

public:

	int SetOption();

	ACE_HANDLE GetHandle(void) const;

	//void PrintfSSLInfo();

	void GetCAInfo(std::string& CAInfo);

	ACE_SSL_SOCK_STREAM* GetTcpStream() const;

	void setPassword(const std::string& password)
	{
		m_Password = password;
	}

private:

	bool Connect();

	CNetSSLClientWrapper(const CNetSSLClientWrapper& obj);

	CNetSSLClientWrapper & operator=(const CNetSSLClientWrapper & obj);

	int SendN(char* pRecvData, int iBufSize, int iTimeout = 0);

	int RecvN(char* pRecvData, int iBufSize, int iTimeout = 0);

private:

	ACE_SSL_SOCK_CONNECTOR mc_connector;

	ACE_SSL_SOCK_STREAM* mc_tcp_stream;
	// digui lock
	ACE_Recursive_Thread_Mutex m_streamLock;
	ACE_Recursive_Thread_Mutex m_streamSendLock;
	ACE_Recursive_Thread_Mutex m_streamCloseLock;
	std::string ms_remote_ip;

	int mi_remote_port;

	int mi_out_time;

	ACE_Time_Value m_Timeout;

	ACE_INET_Addr m_port_to_conn;

	std::string ms_err_info;

	bool m_bIsConnect;

	static std::string m_Password;

};

#endif // NETSSLCLIENTWRAPPER_H_INCLUDED
