/*
 * MainTreeVeiwOperation.cpp
 *
 *  Created on: 2008-12-9
 *      Author: hm
 */

#include "MainTreeVeiwOperation.h"

MainTreeVeiwOperation::MainTreeVeiwOperation(GtkWidget* treeView)
{
	if(GTK_TREE_VIEW(treeView))
	{
		m_treeView = treeView;
		g_object_ref((gpointer)m_treeView);
	}
	else
	{
		m_treeView = NULL;
	}
}

MainTreeVeiwOperation::~MainTreeVeiwOperation()
{
	if(m_treeView)
	{
		g_object_unref((gpointer)m_treeView);
		m_treeView = NULL;
	}
}

GList* MainTreeVeiwOperation::MainViewGetSelectedItems()
{
	GList* ret = NULL;

	if(m_treeView)
	{
		GtkTreeSelection* selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(m_treeView));

		if(selection)
		{
			ret = gtk_tree_selection_get_selected_rows(selection, NULL);
		}
	}

	return ret;
}

int MainTreeVeiwOperation::MainViewGetSelectedItemsCount()
{
    int ret = 0;
    GList* pList = MainViewGetSelectedItems();
    if(NULL != pList)
    {
        ret = g_list_length(pList);

        g_list_foreach (pList, (GFunc)gtk_tree_path_free, NULL);
        g_list_free (pList);
    }

    return ret;
}

GtkTreeModel* MainTreeVeiwOperation::MainViewGetModel()
{
	GtkTreeModel* ret = NULL;

	if(m_treeView)
	{
		ret = gtk_tree_view_get_model(GTK_TREE_VIEW(m_treeView));
	}

	return ret;
}

void MainTreeVeiwOperation::MainViewSelectAll()
{
	if(m_treeView)
	{
		GtkTreeSelection* selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(m_treeView));

		if(selection)
		{
			gtk_tree_selection_select_all(selection);
		}
	}
}

void MainTreeVeiwOperation::MainViewUnselectAll()
{
	if(m_treeView)
	{
		GtkTreeSelection* selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(m_treeView));

		if(selection)
		{
			gtk_tree_selection_unselect_all(selection);
		}
	}
}

void MainTreeVeiwOperation::MainViewSelectPath(GList *pathList)
{
	if(m_treeView)
	{
		GtkTreePath* treepath = NULL;

		this->MainViewUnselectAll();

		GtkTreeSelection* selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(m_treeView));

		if(selection)
		{
			for(GList* tmpGlist = g_list_first(pathList); NULL != tmpGlist; tmpGlist = g_list_next(tmpGlist))
			{
				treepath = (GtkTreePath*)(tmpGlist->data);

				if(treepath)
				{
					gtk_tree_selection_select_path(selection, treepath);
				}
			}
		}
	}
}



