/******************************************************************************
 * File Name    : LockStudentsWindow.h
 * Created      : 2008/9/10
 * Author       : lfeng@neusoft.com
 * Model        :
 * Description  : The header file of LockStudentsWindow
 ******************************************************************************/
#ifndef LOCKSTUDENTSWINDOW_H_
#define LOCKSTUDENTSWINDOW_H_
#include <gtk/gtk.h>
#include "seslib.h"
#include "libsesdata.h"
#include "libsesgui.h"
class LockStudentsWindow : public IPCAPI::CTeacherAPICallbackBase
{
public:
	LockStudentsWindow(std::list<IPCAPI::tagStudent_t>& studentlist);
	~LockStudentsWindow();
	static gint LockDialog(GtkWidget*, gpointer);
	static void SetUpperActive(GtkToggleButton*, gpointer);
	static void SetLowerActive(GtkToggleButton* toggle, gpointer data);
	static void SetCheckBtn(GtkToggleButton* toggle, gpointer data);
	static void CancelLock(GtkWidget* gtkwidget, gpointer data);
	//virtual void GetStudentStatusCallBack(std::string studentID, std::string studentStatusXML);
	int ShowModal(GtkWidget* parentWindow, GCallback cb, gpointer data);
	int Init();
	void DoLockAction(std::list<IPCAPI::tagStudent_t>& studentlist,
			          IPCAPI::IPCTeacherAPI* pTeacherAPI,
			          LibSESData::CLockScheduleData& lockScheduleData);
private:
	GtkWidget* m_gWindow;
	GtkWidget* m_gNextMinuteCombo;
	GtkWidget* m_gMinuteCombo;
	GtkWidget* m_gHourCombo;
	GtkWidget* m_gNextHourCombo;
	GtkWidget* m_gUpperRadiobtn;
	GtkWidget* m_gLowerRadiobtn;
	GtkWidget* m_gCheckbtn;

	std::list<IPCAPI::tagStudent_t> m_pstudentlist;
	LibSESData::CLockScheduleData m_LockScheduleData;
	//IPCAPI::IPCTeacherAPI* m_pTeacherAPI;

};

#endif /*LOCKSTUDENTSWINDOW_H_*/

