/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          CParaXml.h

Description:

    This file defines class CParaXml.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Stanley Sun 2008/09/08

  =====================================================================

****************************************************************************/

#ifndef PARAXML_H_
#define PARAXML_H_

#include <string>
#include <list>
#include <iostream>
#include "CommonMessage.h"
#include "tinystr.h"
#include "tinyxml.h"

namespace IPCAPI
{

class CParaXml
{

public:
	CParaXml();
	virtual ~CParaXml();

	bool setListPara(std::list<std::string> & para);
	bool getListPara(std::list<std::string> & para);

	bool setInt(const std::string& name, int value);
	bool getInt(const std::string& name, int& iReturn);
	bool setString(const std::string& name, const std::string& value);
	bool getString(const std::string& name,std::string& value);
	bool setStudentInfoList(std::list<IPCAPI::StudentInfo_t>& para);
	bool getStudentInfoList(std::list<IPCAPI::StudentInfo_t>& para);
	bool loadString(const std::string& xmlstring);
	bool toString(std::string& destString) const;
	void clear();

private:
	TiXmlDocument doc;

};

}

#endif /*PARAXML_H_*/
