/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          CommonMessage.h

Description:

    This file defines constant value.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Stanley Sun 2008/09/08

  =====================================================================

****************************************************************************/

#ifndef COMMONMESSAGE_H_
#define COMMONMESSAGE_H_

#include <string>

namespace IPCAPI
{
//---Student App functions --------
#define STUDENT_SEARCHTEACHER "SEARCHTEACHER"
#define STUDENT_MANUALLOCKLOCALSTUDENT "MANUALLOCKLOCALSTUDENT"
#define STUDENT_MANUALUNLOCKLOCALSTUDENT "MANUALUNLOCKLOCALSTUDENT"
#define STUDENT_DISCONNECTSTUDENT "DISCONNECTSTUDENT"
#define STUDENT_CONNECTTEACHER "CONNECTTEACHER"
#define STUDENT_SAVELOCALTABNAVPOLICY "SAVELOCALTABNAVPOLICY"
#define STUDENT_SAVELOCALSCHEDULEPOLICY "SAVELOCALSCHEDULEPOLICY"
#define STUDENT_SAVESTUDENTINFO "SAVESTUDENTINFO"
#define STUDENT_HARDWARECONTROL "HARDWARECONTROL"
#define STUDENT_SEARCHLOCALPROGRAM "SEARCHLOCALPROGRAM"
//add by stanley
#define STUDENT_SETSTUDENTINFO "SETSTUDENTINFO"  //syn call
#define STUDENT_GETCONNECTEDTEACHER "GETCONNECTEDTEACHER" //sync
//add by chenwei
#define TEACHER_ROOTCA "TEACHER_ROOTCA"
#define HEARTBEATMESSAGE "c"
#define STUDENT_HEARTTIMER 30
#define STUDENT_HEARTTIMEOUTTIMES 9
#define STUDENT_HEARTTIMEOUT 270
#define DISCONNECTTIMEOUT 5
//add by nagp
#define STUDENT_POSTMESSAGE "POSTMESSAGE"
#define STUDENT_VERIFYUSERPASSWORD "VERIFYUSERPASSWORD"
#define STUDENT_SWITCHTONORMALOS "STUDENT_SWITCHTONORMALOS"
#define STUDENT_SWITCHTOSES "STUDENT_SWITCHTOSES"
#define STUDENT_CANCELOPERATION "STUDENT_CANCELOPERATION"
#define STUDENT_SYSTEMOPERATION "STUDENT_SYSTEMOPERATION"
//---Student Daemon functions --------
#define STUDENT_SEARCHTEACHERCALLBACK "SEARCHTEACHERCALLBACK"
#define STUDENT_CONNECTTEACHERCALLBACK "CONNECTTEACHERCALLBACK"
#define STUDENT_NOTIFYLOCKSTATUSCHANGED "NOTIFYLOCKSTATUSCHANGED"
#define STUDENT_NOTIFYTABNAVPOLICYCHANGED "NOTIFYTABNAVPOLICYCHANGED"
#define STUDENT_NOTIFYSCHEDULEPOLICYCHANGED "NOTIFYSCHEDULEPOLICYCHANGED"
#define STUDENT_NOTIFYTEACHERSTATUSCHANGED "NOTIFYTEACHERSTATUSCHANGED"// NEED
#define STUDENT_SEARCHLOCALPROGRAMCALLBACK "SEARCHLOCALPROGRAMCALLBACK"
#define STUDENT_TEACHERNAMECHANGED "TEACHERNAMECHANGED"
#define STUDENT_POPNOTIFYSEND "POPNOFITYSEND"
//---Teacher App functions --------
#define TEACHER_STARTCONTROLLER "TEACHER_STARTCONTROLLER"//Message_Start_Controller
#define TEACHER_STOPCONTROLLER "TEACHER_STOPCONTROLLER"//Message_Stop_Controller
#define TEACHER_SEARCHPROGRAM  "TEACHER_SEARCHPROGRAM"//Message_Search_PRGM_Requ
#define TEACHER_MANUALLOCKREMOTESTUDENT  "TEACHER_MANUALLOCKREMOTESTUDENT"//Message_Manual_Lock_Requ
#define TEACHER_MANUALUNLOCKREMOTESTUDENT  "TEACHER_MANUALUNLOCKREMOTESTUDEN"//Message_Manual_Unlock_Requ
#define TEACHER_ISREMOTESTUDENTLOCKED  "TEACHER_ISREMOTESTUDENTLOCKED"//?
#define TEACHER_UPDATETEACHERINFO  "TEACHER_UPDATETEACHERINFO"//Message_Update_Teacher_Info
#define TEACHER_CONTROLNEWSTUDENTCONNECT  "TEACHER_CONTROLNEWSTUDENTCONNECT"//?
#define TEACHER_GETSTUDENTSTATUS  "TEACHER_GETSTUDENTSTATUS"
#define TEACHER_GETSTUDENTDETAILEDINFO  "TEACHER_GETSTUDENTDETAILEDINFO"
#define TEACHER_KICKOFFSTUDENT  "TEACHER_KICKOFFSTUDENT"
#define TEACHER_DEPLOYSCHEDULEPOLICY  "TEACHER_DEPLOYSCHEDULEPOLICY"
#define TEACHER_DEPLOYTABNAVPOLICY  "TEACHER_DEPLOYTABNAVPOLICY"
#define TEACHER_GETSTUDENTLIST  "TEACHER_GETSTUDENTLIST"//Message_Get_Connection_List
//add by stanley
#define TEACHER_CANCELOPERATION "TEACHER_CANCELOPERATION" //syn call
#define TEACHER_QUERYLOCKSCHEDULE "TEACHER_QUERYLOCKSCHEDULE"
//add by nagp
#define TEACHER_POSTMESSAGE "POSTMESSAGE"
#define TEACHER_SETSTUDENTTIME "TEACHER_SETSTUDENTTIME"
#define TEACHER_VERIFYCERTIFICATE "TEACHER_VERIFYCERTIFICATE"
#define TEACHER_VERIFYPASSWORD "TEACHER_VERIFYPASSWORD"
#define TEACHER_IMPORTCERTIFICATE "TEACHER_IMPORTCERTIFICATE"
#define TEACHER_CHANGEPASSWORD "TEACHER_CHANGEPASSWORD"
#define TEACHER_REQUIRELOCKSCHEDULE "TEACHER_REQUIRELOCKSCHEDULE"
#define TEACHER_GETSTUDENTLOCKPOLICY "TEACHER_GETSTUDENTLOCKPOLICY"

#define TEACHER_MANUALLOCKREMOTESTUDENTLIST  "TEACHER_MANUALLOCKREMOTESTUDENTLIST"//Message_Manual_Lock_Requ
#define TEACHER_MANUALUNLOCKREMOTESTUDENTLIST  "TEACHER_MANUALUNLOCKREMOTESTUDENLIST"//Message_Manual_Unlock_Requ
#define TEACHER_DEPLOYSCHEDULEPOLICYLIST  "TEACHER_DEPLOYSCHEDULEPOLICYLIST"
#define TEACHER_DEPLOYTABNAVPOLICYLIST  "TEACHER_DEPLOYTABNAVPOLICYLIST"
#define TEACHER_KICKOFFSTUDENTLIST "TEACHER_KICKOFFSTUDENTLIST"
#define TEACHER_KICKOFFALLSTUDENT "TEACHER_KICKOFFALLSTUDENT"

//---Teacher Daemon functions --------
#define TEACHER_SEARCHPROGRAMCALLBACK  "TEACHER_SEARCHPROGRAMCALLBACK"//Message_Search_PRGM_Resp
#define TEACHER_MANUALLOCKREMOTESTUDENTCALLBACK  "TEACHER_MANUALLOCKREMOTESTUDENTCALLBACK"//Message_Manual_Lock_Resp
#define TEACHER_MANUALUNLOCKREMOTESTUDENTCALLBACK  "TEACHER_MANUALUNLOCKREMOTESTUDENTCALLBACK"//Message_Manual_Unlock_Resp
#define TEACHER_ISREMOTESTUDENTLOCKEDCALLBACK  "TEACHER_ISREMOTESTUDENTLOCKEDCALLBACK"
#define TEACHER_GETSTUDENTSTATUSCALLBACK  "TEACHER_GETSTUDENTSTATUSCALLBACK"
#define TEACHER_GETSTUDENTDETAILEDINFOCALLBACK  "TEACHER_GETSTUDENTDETAILEDINFOCALLBACK"
#define TEACHER_KICKOFFSTUDENTCALLBACK  "TEACHER_KICKOFFSTUDENTCALLBACK"// need
#define TEACHER_NOTIFYSTUDENTSTATUSCHANGED  "TEACHER_NOTIFYSTUDENTSTATUSCHANGED"
#define TEACHER_DEPLOYTABNAVPOLICYCALLBACK  "TEACHER_DEPLOYTABNAVPOLICYCALLBACK"
#define TEACHER_DEPLOYSCHEDULEPOLICYCALLBACK  "TEACHER_DEPLOYSCHEDULEPOLICYCALLBACK"
#define TEACHER_CONTROLNEWSTUDENTCONNECTCALLBACK "TEACHER_CONTROLNEWSTUDENTCONNECTCALLBACK"
#define TEACHER_NOTIFYSTUDENTINFOCHANGED "TEACHER_NOTIFYSTUDENTINFOCHANGED"

#define TEACHER_REQUIRELOCKSCHEDULECALLBACK "TEACHER_REQUIRELOCKSCHEDULECALLBACK"

//add by stanley
#define TEACHER_QUERYLOCKSCHEDULECALLBACK "TEACHER_QUERYLOCKSCHEDULECALLBACK"
//add by chenwei
#define TEACHER_ROOTCA "TEACHER_ROOTCA"
//network only message
#define STUDENT_HEARTBEAT "STUDENT_HEARTBEAT"
#define BYE_BYE "bye_bye"
#define STUDENT_POLICYUPDATE "STUDENT_POLICYUPDATE"

#define SYNC_METHOD_SUCCESS  "SUCCESS"
#define SYNC_METHOD_FAIL "FAIL"

#define METHOD_TRUE  "TRUE"
#define METHOD_FALSE "FALSE"
#define METHOD_REPEATSTUDENTID "REPEATSTUDENTID"
#define METHOD_CONNECTION_TIMEOUT "CONNECTION_TIMEOUT"
//	#define CONNECTION_SUCCESS  2
//	#define CONNECTION_CLOSE  	1
//	#define CONNECTION_ERROR 	0

#define SESSUBJ "Simplified Education Shell"

//#define LOCALADMIN "local admin"

enum ConnectionStatus
{
	CONNECTION_NETWORKERROR = 0,
	CONNECTION_STUDENTCLOSE = 1,
	CONNECTION_CONNECTED = 2,
	CONNECTION_DISCONNECTED = 3,
	CONNECTION_DENY = 4,
	CONNECTION_REPEATSTUDENTID = 5,
	CONNECTION_TEACHERCLOSE = 6,
	CONNECTION_CAFAILED = 7,
	CONNECTION_TIMEOUT = 8,
	CONNECTION_INVALIDARG = 9,
	CONNECTION_TEACHERINFOCHANGED = 10, //not use
	CONNECTION_EMPTYSTUDENTID = 11,
	CONNECTION_NOTEXISTEDTEACHERID = 12,
	CONNECTION_REPEATTEACHERID = 13,
	CONNECTION_WAITFORTEACHERALLOW = 14
};

enum AllowStatus
{
	ALLOW = 0,
	DENY = 1,
	WAITING = 2,
	QUEUE = 3
};

enum APIResult
{
	SES_API_SUCCESS = 0,
	SES_API_FAILURE = 1,
	SES_API_INVALID_ARGS = 2,
	SES_API_TIME_OUT = 3,
	SES_API_ACCERT_ADDRESSINUSE=4,//Address alread in use : 8888 and 8889
	SES_API_NEEDRESTART=5
};

enum StudentStatus
{
	SES_STU_LOCK = 0, // DO NOT USE THIS VALUE
	SES_STU_UNLOCK = 1,// unlock status, reason unknown
	SES_STU_AUTO_LOCK = 2,
	SES_STU_AUTO_UNLOCK = 3,
	SES_STU_MANUAL_LOCK = 4,
	SES_STU_MANUAL_UNLOCK = 5,
	SES_STU_DISCONNECT = 6,
	SES_STU_CONNECT = 7,
};

enum StatusStartReturn
{
	SES_STATUS_SUCCESS = 0, // DO NOT USE THIS VALUE
	SES_STATUS_ACCERT_ADDRESSINUSE = 1,// unlock status, reason unknown

};

enum ProgramSearchOption
{
	PROGRAMSEARCH_APPEND = 0,
	PROGRAMSEARCH_OVERWRITE
};

//Add by shidp for calling system command
enum SystemCmdType
{
	SYS_CMD_SHUTDOWN	= 8000,
	SYS_CMD_RESTART	= 8001,
	SYS_CMD_STANDBY	= 8002
};

typedef struct tagStudent_t
{
	tagStudent_t()
		: start_time(0)
		, bLocked(0)
		, status(SES_STU_DISCONNECT)
		, lastUpdateTime(0)
	{};

	tagStudent_t(const tagStudent_t& other)
	{
		studentID 	= other.studentID;
		username	= other.username;
		hostname	= other.hostname;
		IP			= other.IP;

		displayName = other.displayName;
		deployerName = other.deployerName;

		start_time	= other.start_time;
		bLocked		= other.bLocked;
		status		= other.status;
		lastUpdateTime	= other.lastUpdateTime;
	};

	bool IsConnected()
	{
		if (status != SES_STU_DISCONNECT)
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	bool IsLocked()
	{
		if (0 != bLocked)
		{
			return true;
		}
		else
		{
			return false;
		}
	}

	std::string studentID;
	std::string username;
	std::string hostname;
	std::string IP;
	std::string displayName;
	std::string deployerName;
	int start_time;
	int bLocked;
	int status;
	long int lastUpdateTime;
} StudentInfo_t;

}

#endif /*COMMONMESSAGE_H_*/
