/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          CShellSettingCtrl.h

Description:

    This file defines class CShellSettingCtrl.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Jin Xin   2008/9/10

  =====================================================================

****************************************************************************/


/*
 * CShellSettingCtrl.h
 *
 *  Created on: Sep 18, 2008
 *      Author: debug
 */
/******************************************************************************
 * File Name    : CShellSettingCtrl.h
 * Created      : 2008/9/10
 * Author       : jinxin@neusoft.com
 * Model        :
 * Description  : The header file of CShellSettingCtrl
 ******************************************************************************/
#ifndef CSHELLSETTINGCTRL_H_
#define CSHELLSETTINGCTRL_H_

#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include <vector>

#include "seslib.h"
#include "libsesdata.h"

#include "CCommonDef.h"
#include "CSESWindowBase.h"
#include "CChangeIconDlg.h"
#include "CAddApplicationWindow.h"

namespace LibSESGUI
{

class CShellSettingCtrl : public CSESWindowBase
{
public:
	CShellSettingCtrl();
	virtual ~CShellSettingCtrl();

public:

	// Hook Subclass into base class
	virtual int AttachBaseClassGTKHandler(CShellSettingCtrl* pObj);
	//
	virtual int OnOK();
	//
	virtual int OnCancel();
	//
	virtual int OnDefaultBtnClicked();		// For Now, this func is common for all subclasses.
	//
	virtual int OnEditCategoryBtnClicked();
	//
	virtual int OnClose()		= 0;
	//
	virtual int OnApply()		= 0;	// For Subclass call different API.
	//
	virtual int OnAddProgram()	= 0;	// For Subclass call different API.

public:

	// GTK Handler
	static void OnOKBtnClicked(GtkWidget *widget, gpointer data);
	//
	static void OnCancelBtnClicked(GtkWidget *widget, gpointer data);
	//
	static void OnApplyBtnClicked(GtkWidget *widget, gpointer data);
	//static void OnCloseBtnClicked(GtkWidget *widget, gpointer data);
	//
	static gboolean OnCloseBtnClicked(GtkWidget *widget, GdkEvent *event, gpointer data);
	//
	static void GtkOnDefaultBtnClicked(GtkWidget *widget, gpointer data);
	//
	static void GtkEditCategory(GtkCellRendererText *, const gchar *, const gchar *, gpointer);
	//
	static void GtkOnEditCateoryBtnClicked(GtkWidget *widget, gpointer data);
	//
	static void AddCategory(GtkWidget *widget, gpointer data);
	//
	static void DeleteCategory(GtkWidget *widget, gpointer data);
	//static void EditCategory(GtkWidget *widget, gpointer data);
	//
	static void ChangeCategory(GtkTreeView *treeview, gpointer data);

	static void ChangeProgrm(GtkTreeView *treeview, gpointer data);
	//
	static void GtkAddProgramBtnClicked(GtkWidget *widget, gpointer data);

	static void GtkAddProgramButtonClicked(GtkWidget *widget, gpointer data);
	//
	static void GtkDeleteProgramBtnClicked(GtkWidget *widget, gpointer data);
	//
	static void EnableDisableProgram(GtkCellRendererToggle *cell, gchar *path_str,	gpointer data);
	//
	static void ChangeCategoryWindowDestory(gpointer data);
	//
	static void GtkOnCategoryTreeRowActivated(GtkTreeView *tree_view, GtkTreePath *path, GtkTreeViewColumn *column, gpointer user_data);
	//
	static void GtkOnApplicationTreeRowActivated(GtkTreeView *tree_view, GtkTreePath *path, GtkTreeViewColumn *column, gpointer user_data);

	static void GetDataFromIconDlgCallBack(GtkWidget *widget, gpointer data);

	static void GetDataFromEditIconDlgCallBack(GtkWidget *widget, gpointer data);

	static void GtkOnWeekLabelClicked(GtkWidget *widget, gpointer data);

	//qiand add the function for hide the USB CheckBox
	bool GTKHideUSBCheckBox();
	void GTKShowDlgCheckBox();
	void UpdateBtnStatus();
	//qiand add the function for hide the USB CheckBox End


    //static void SearchPrograms(GtkWidget* widget, gpointer data);
protected:

	virtual int LoadXMLData() = 0;	// For Subclass to load its own xml data to GUI.

	int FetchScheuleData();
	int FetchTabNavData();
	int FetchUSBData();
	int FetchTeacherPolicy();

	int ShowTabNavPolicy();
	int ShowSchedulePolicy();
	int ShowUSBPolicy();
	int ShowTeacherPolicy();

	int AddPrograms(const std::list<LibSESData::CApplicationInfo>&  appList);

	//int ShowDefaultPolicy();
	bool IsDataDirty();

//	bool IsScheduleDataDirty(const bool orgAutoLock, const std::list<LibSESData::CLockTimeSection*>* pOrgData,
//							 const bool newAutoLock, const std::list<LibSESData::CLockTimeSection*>* pNewData);

	bool IsScheduleDataDirty();
	bool IsTabNavDataDirty();
	bool IsSystemSettingDirty();

private:

	int showPrograms(LibSESData::CCategory* pCategory);
	void moveToLastCategoryRow();

	// Internal Initialize Functions
	void initWindow();
	void initShellLockSetting();
	void initProgramRegistration();
	void initSystemSetting();
	void GetDataFromIconDlg();
	void GetDataFromEditIconDlg();
	void OnChangeProgrm();

	void OnAddProgramButtonClicked();
	//
	int UpdateCategory(string name, string iconFullPath);
	//
	int UpdateApplication(string name, string iconFullPath);
	//
	int BuildNewCategoryName(string input, string& output);
	//
	void OnWeekLabelClicked(GtkWidget *widget);

	int CalculateDay(const char *gLabel);

public:
	// Common GTK Controls Here!!!
	// All Subclass Should Lists its controls here.
//	GtkWidget* m_MainWindow;
//	GtkWidget* m_gParentWnd;
	GtkWidget* m_gMainVbox;
	GtkWidget* m_gTable;
	GtkWidget* m_gNotebook;
	GtkWidget* m_gLabel;
	GtkWidget* m_gScrolledWindow;
	GtkWidget* event_box;

	GtkWidget* m_gAutoLockCheckButton;

	//Tooltip ->
//	GtkTooltips *m_tooltip;

	GtkWidget* m_gVbox;
	GtkWidget* m_gHbox;
	GtkWidget* m_gHbox1;
	GtkWidget* m_gButton;

	GtkWidget* m_gShellLockSettingsVbox;
	GtkWidget* m_gShellLockSettingsLabel;
	GtkWidget* m_gShellLockSettingsLabelHbox;
	GtkWidget* m_gShellLockSettingsOnTabLabel;
	GtkWidget* m_gShellLockSettingsHbox;
	GtkWidget* m_gEnableAutoLockCheckBox;
	GtkWidget* m_ShowAutoMaticLabel;

	GtkWidget* m_gHourLabelHbox;
	GtkWidget* m_gHourLabel;
	GtkWidget* m_gTableHbox;
	GtkWidget* m_gTempHbox;
	GtkWidget* m_gWeekLabelVbox;
	GtkWidget* m_gTableVbox;
	GtkWidget* m_gWeekLabel;
	GtkWidget* m_gShellButtonTable;
	GtkWidget* m_gShellBtn;
	GtkWidget* m_gStatusHbox;
	GdkPixbuf* m_gLockPixbuf;
	GtkWidget* m_gLockImage;
	GtkWidget* m_gUnlockShellLabel;
	GtkWidget* m_gLockShellLabel;
	GtkWidget* m_gBottomHbox;

	GtkWidget* m_gCategoryAddBtn;
	GtkWidget* m_gCategoryRemoveBtn;
	GtkWidget* m_gProgramAddBtn;
	GtkWidget* m_gEditProgramBtn;
	GtkWidget* m_gProgramRemoveBtn;
	GtkWidget* m_gEditBtn;
	GtkWidget* m_gDefaultBtn;
//	GtkWidget* m_gButton;

	// System Setting Tab
	GtkWidget* m_gUSBCheckButton;
	GtkWidget* m_gDlgCheckButton;
	GtkWidget* m_gSystemSettingsOnTabLabel;

	// Dialog Button.
	GtkWidget* m_gOkBtn;
	GtkWidget* m_gCancelBtn;
	GtkWidget* m_gApplyBtn;

	GtkTreeModel* m_gModel;
	GtkWidget*    m_gCategoryTreeview;
	GtkWidget*    m_gProgramTreeview;
	GtkWidget*    m_gHpaned;

	GdkPixbuf*          m_gPixbuf;

	// Category List
	GtkListStore*       m_gCategoryListStore;
	GtkListStore*       m_gProgramListStore;

	GtkTreeIter         m_gCurRowIter;
	GtkCellRenderer*    m_gRenderer;
	GtkCellRenderer*    m_gCategoryRenderer;

	GtkTreeViewColumn*  m_gColumn;

protected:

	//LibSESData::CTabNavigationData		m_OrgTabNavData;	// Original TabNavData;
	LibSESData::CTabNavigationData		m_TabNavData;
	std::list<LibSESData::CCategory*>*	m_pCategoryList;

	LibSESData::CLockScheduleData		m_ScheduleData;
	//std::list<LibSESData::CLockTimeSection*>* 	m_ScheduleList;
	std::vector< vector<GtkWidget*> >   		m_vvScheduleTable;

	LibSESData::CSESSystemSettingData 	m_SystemSettingData;

	LibSESData::CDefaultConfigData		m_DefaultData;
	std::list<LibSESData::CCategory*>*	m_pDefaultCategoryList;

	IPCAPI::IPCAPIBase* 	m_pAPI;
	CShellSettingCtrl* 		m_pSubClassPtr;


	std::string 						m_strCurCategoryName;
	std::string 						m_strCurCategoryIcon;

	std::string 						m_strCurApplicationName;
	std::string 						m_strCurApplicationIcon;

	//bool m_IsDataDirty;
	bool m_IsScheduleDataDirty;
	bool m_IsTabNavDataDirty;
	bool m_IsHardwareControlDataDirty;

	CAddApplicationWindow* 		m_pAddProgram;
	CChangeIconDlg* 			m_changeIconDlg;

};

}

#endif /* CSHELLSETTINGCTRL_H_ */
