/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          LockTimeSection.h

Description:

    This file defines class LockTimeSection.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Huang Miao  2008/9/16

  =====================================================================

****************************************************************************/

#ifndef __LOCKTIMESECTION_H__
#define __LOCKTIMESECTION_H__

#include <string>

namespace LibSESData
{
	typedef enum tagDayOfWeekEnum
	{
		MONDAY = 0,
		TUESDAY,
		WEDNESDAY,
		THURSDAY,
		FRIDAY,
		SATURDAY,
		SUNDAY

	} DayOfWeekEnum;

	class CLockTimeSection
	{
	public:
		CLockTimeSection();
		virtual ~CLockTimeSection();

	private:
		int m_iDayOfWeek;
		int m_iStartTime;
		int m_iEndTime;

	public:

		//Modify by lx start 20081013: move to cpp
		bool operator == (const CLockTimeSection& rhs);

		bool operator != (const CLockTimeSection& rhs);

		int GetDayOfWeek() const;

		void SetDayOfWeek(int pDayOfWeek);

		int GetStartTime() const;

		void SetStartTime(int m_iStartTime);

		int GetEndTime() const;

		void SetEndTime(int m_iEndTime);
		//Modify by lx end
	};

}

#endif /* __LOCKTIMESECTION_H__ */
