/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          DefaultConfigData.h

Description:

    This file defines class DefaultConfigData.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Huang Miao  2008/9/16

  =====================================================================

****************************************************************************/

#ifndef __DEFAULTCONFIGDATA_H__
#define __DEFAULTCONFIGDATA_H__

#include "SESDataProvider.h"
#include "Category.h"
#include "ApplicationInfo.h"
#include <list>

namespace LibSESData
{

	class CDefaultConfigData: public LibSESData::CSESDataProvider
	{
	public:
		CDefaultConfigData();
		virtual ~CDefaultConfigData();

	protected:
		int DOM2Member();
		int Member2DOM();

	private:

		std::list<CApplicationInfo*>* m_pApplicationInfoList;
		std::list<CCategory*>*  m_pCategoryInfoList;

	public:

		//Modify by lx start 20081013: move to cpp
		std::list<CApplicationInfo*> *GetPApplicationInfoList() const;

		void SetPApplicationInfoList(std::list<CApplicationInfo*> *pApplicationInfoList);

		std::list<CCategory*> *GetPCategoryInfoList() const;
		//Modify by lx end

		// Clone the internal List , caller need to release this list.
		// or assign this list to another manager class
		std::list<CCategory*>* CloneCategoryInfoList();

		//Modify by lx start 0081013: move to cpp
		void SetPCategoryInfoList(std::list<CCategory*> *pCategoryInfoList);
		//Modify by lx end

	};

}

#endif /* __DEFAULTCONFIGDATA_H__ */
